/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LoggedThread;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ScanResult {
    private final ScanSpec scanSpec;
    private final Map<File, Long> fileToTimestamp;
    private long maxLastModifiedTime = 0L;
    private final ClassGraphBuilder classGraphBuilder;

    ScanResult(ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo, Map<File, Long> fileToTimestamp, LoggedThread.ThreadLog log) {
        this.scanSpec = scanSpec;
        long graphStartTime = System.nanoTime();
        this.classGraphBuilder = new ClassGraphBuilder(classNameToClassInfo);
        if (FastClasspathScanner.verbose) {
            log.log(1, "Built class graph", System.nanoTime() - graphStartTime);
        }
        this.fileToTimestamp = fileToTimestamp;
        long currTime = System.currentTimeMillis();
        for (long timestamp : fileToTimestamp.values()) {
            if (timestamp <= this.maxLastModifiedTime || timestamp >= currTime) continue;
            this.maxLastModifiedTime = timestamp;
        }
    }

    public boolean classpathContentsModifiedSinceScan() {
        for (Map.Entry<File, Long> ent : this.fileToTimestamp.entrySet()) {
            if (ent.getKey().lastModified() == ent.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    public long classpathContentsLastModifiedTime() {
        return this.maxLastModifiedTime;
    }

    public List<String> getNamesOfAllClasses() {
        return this.classGraphBuilder.getNamesOfAllClasses();
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.classGraphBuilder.getNamesOfAllStandardClasses();
    }

    public List<String> getNamesOfSubclassesOf(String className) {
        return this.classGraphBuilder.getNamesOfSubclassesOf(className);
    }

    public List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.classGraphBuilder.getNamesOfSubclassesOf(this.scanSpec.getStandardClassName(superclass));
    }

    public List<String> getNamesOfSuperclassesOf(String className) {
        return this.classGraphBuilder.getNamesOfSuperclassesOf(className);
    }

    public List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(this.scanSpec.getStandardClassName(subclass));
    }

    public List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        this.scanSpec.checkClassIsNotBlacklisted(fieldTypeName);
        return this.classGraphBuilder.getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public List<String> getNamesOfClassesWithFieldOfType(Class<?> fieldType) {
        String fieldTypeName = fieldType.getName();
        return this.getNamesOfClassesWithFieldOfType(fieldTypeName);
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.classGraphBuilder.getNamesOfAllInterfaceClasses();
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        return this.classGraphBuilder.getNamesOfSubinterfacesOf(interfaceName);
    }

    public List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(this.scanSpec.getInterfaceName(superInterface));
    }

    public List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        return this.classGraphBuilder.getNamesOfSuperinterfacesOf(interfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(this.scanSpec.getInterfaceName(subInterface));
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        return this.classGraphBuilder.getNamesOfClassesImplementing(interfaceName);
    }

    public List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(this.scanSpec.getInterfaceName(implementedInterface));
    }

    public List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(this.scanSpec.getInterfaceNames(implementedInterfaces));
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.classGraphBuilder.getNamesOfAllAnnotationClasses();
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.classGraphBuilder.getNamesOfClassesWithAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAllOf(this.scanSpec.getAnnotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(this.scanSpec.getAnnotationNames(annotations));
    }

    public List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        return this.classGraphBuilder.getNamesOfAnnotationsOnClass(classOrInterfaceName);
    }

    public List<String> getNamesOfAnnotationsOnClass(Class<?> classOrInterface) {
        return this.getNamesOfAnnotationsOnClass(this.scanSpec.getClassOrInterfaceName(classOrInterface));
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        return this.classGraphBuilder.getNamesOfMetaAnnotationsOnAnnotation(annotationName);
    }

    public List<String> getNamesOfMetaAnnotationsOnAnnotation(Class<?> annotation) {
        return this.getNamesOfMetaAnnotationsOnAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return this.classGraphBuilder.getNamesOfAnnotationsWithMetaAnnotation(metaAnnotationName);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfAnnotationsWithMetaAnnotation(this.scanSpec.getAnnotationName(metaAnnotation));
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        return this.classGraphBuilder.generateClassGraphDotFile(sizeX, sizeY);
    }
}

