/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassGraphBuilder {
    private final Map<String, ClassInfo> classNameToClassInfo;
    private final Set<ClassInfo> allClassInfo;

    ClassGraphBuilder(Map<String, ClassInfo> classNameToClassInfo) {
        this.classNameToClassInfo = classNameToClassInfo;
        this.allClassInfo = new HashSet<ClassInfo>(classNameToClassInfo.values());
    }

    private Set<ClassInfo> getReachableClasses(String startClassName, ClassInfo.RelType relType) {
        ClassInfo startClass = this.classNameToClassInfo.get(startClassName);
        return startClass == null ? Collections.emptySet() : startClass.getReachableClasses(relType);
    }

    public List<String> getNamesOfAllClasses() {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.allClassInfo, true, ClassInfo.ClassType.ALL));
    }

    public List<String> getNamesOfAllStandardClasses() {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.allClassInfo, true, ClassInfo.ClassType.STANDARD_CLASS));
    }

    List<String> getNamesOfSubclassesOf(String className) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getReachableClasses(className, ClassInfo.RelType.SUBCLASSES), true, ClassInfo.ClassType.ALL));
    }

    List<String> getNamesOfSuperclassesOf(String className) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getReachableClasses(className, ClassInfo.RelType.SUPERCLASSES), true, ClassInfo.ClassType.ALL));
    }

    List<String> getNamesOfClassesWithFieldOfType(String fieldTypeName) {
        ArrayList<String> namesOfClassesWithFieldOfType = new ArrayList<String>();
        block0: for (ClassInfo classInfo : this.allClassInfo) {
            for (ClassInfo fieldType : classInfo.getRelatedClasses(ClassInfo.RelType.FIELD_TYPES)) {
                if (!fieldType.className.equals(fieldTypeName)) continue;
                namesOfClassesWithFieldOfType.add(classInfo.className);
                continue block0;
            }
        }
        Collections.sort(namesOfClassesWithFieldOfType);
        return namesOfClassesWithFieldOfType;
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.allClassInfo, true, ClassInfo.ClassType.IMPLEMENTED_INTERFACE));
    }

    List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getReachableClasses(interfaceName, ClassInfo.RelType.CLASSES_IMPLEMENTING), true, ClassInfo.ClassType.IMPLEMENTED_INTERFACE));
    }

    List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getReachableClasses(interfaceName, ClassInfo.RelType.IMPLEMENTED_INTERFACES), true, ClassInfo.ClassType.IMPLEMENTED_INTERFACE));
    }

    List<String> getNamesOfClassesImplementing(String interfaceName) {
        Set<ClassInfo> implementingClasses = ClassInfo.filterClassInfo(this.getReachableClasses(interfaceName, ClassInfo.RelType.CLASSES_IMPLEMENTING), true, ClassInfo.ClassType.STANDARD_CLASS);
        HashSet<ClassInfo> allImplementingClasses = new HashSet<ClassInfo>();
        for (ClassInfo implementingClass : implementingClasses) {
            allImplementingClasses.add(implementingClass);
            allImplementingClasses.addAll(implementingClass.getReachableClasses(ClassInfo.RelType.SUBCLASSES));
        }
        return ClassInfo.getClassNames(allImplementingClasses);
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.allClassInfo, true, ClassInfo.ClassType.ANNOTATION));
    }

    List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getReachableClasses(annotationName, ClassInfo.RelType.ANNOTATED_CLASSES), true, ClassInfo.ClassType.STANDARD_CLASS, ClassInfo.ClassType.IMPLEMENTED_INTERFACE));
    }

    List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceName) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getReachableClasses(classOrInterfaceName, ClassInfo.RelType.ANNOTATIONS), true, ClassInfo.ClassType.ALL));
    }

    List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        return this.getNamesOfAnnotationsOnClass(annotationName);
    }

    List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getReachableClasses(metaAnnotationName, ClassInfo.RelType.ANNOTATED_CLASSES), true, ClassInfo.ClassType.ANNOTATION));
    }

    private static String label(ClassInfo node) {
        String className = node.className;
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx < 0) {
            return className;
        }
        return className.substring(0, dotIdx + 1) + "\\n" + className.substring(dotIdx + 1);
    }

    String generateClassGraphDotFile(float sizeX, float sizeY) {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"" + sizeX + "," + sizeY + "\";\n");
        buf.append("layout=dot;\n");
        buf.append("rankdir=\"BT\";\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        Set<ClassInfo> standardClassNodes = ClassInfo.filterClassInfo(this.allClassInfo, false, ClassInfo.ClassType.STANDARD_CLASS);
        Set<ClassInfo> interfaceNodes = ClassInfo.filterClassInfo(this.allClassInfo, false, ClassInfo.ClassType.IMPLEMENTED_INTERFACE);
        Set<ClassInfo> annotationNodes = ClassInfo.filterClassInfo(this.allClassInfo, false, ClassInfo.ClassType.ANNOTATION);
        buf.append("\nnode[shape=box,style=filled,fillcolor=\"#fff2b6\"];\n");
        for (ClassInfo node : standardClassNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=diamond,style=filled,fillcolor=\"#b6e7ff\"];\n");
        for (ClassInfo node : interfaceNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\nnode[shape=oval,style=filled,fillcolor=\"#f3c9ff\"];\n");
        for (ClassInfo node : annotationNodes) {
            buf.append("  \"" + ClassGraphBuilder.label(node) + "\"\n");
        }
        buf.append("\n");
        for (ClassInfo classNode : standardClassNodes) {
            for (ClassInfo superclassNode : classNode.getRelatedClasses(ClassInfo.RelType.SUPERCLASSES)) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(superclassNode) + "\"\n");
            }
            for (ClassInfo implementedInterfaceNode : classNode.getRelatedClasses(ClassInfo.RelType.IMPLEMENTED_INTERFACES)) {
                buf.append("  \"" + ClassGraphBuilder.label(classNode) + "\" -> \"" + ClassGraphBuilder.label(implementedInterfaceNode) + "\" [arrowhead=diamond]\n");
            }
            for (ClassInfo fieldTypeNode : classNode.getRelatedClasses(ClassInfo.RelType.FIELD_TYPES)) {
                buf.append("  \"" + ClassGraphBuilder.label(fieldTypeNode) + "\" -> \"" + ClassGraphBuilder.label(classNode) + "\" [arrowtail=obox, dir=back]\n");
            }
        }
        for (ClassInfo interfaceNode : interfaceNodes) {
            for (ClassInfo superinterfaceNode : interfaceNode.getRelatedClasses(ClassInfo.RelType.IMPLEMENTED_INTERFACES)) {
                buf.append("  \"" + ClassGraphBuilder.label(interfaceNode) + "\" -> \"" + ClassGraphBuilder.label(superinterfaceNode) + "\" [arrowhead=diamond]\n");
            }
        }
        for (ClassInfo annotationNode : annotationNodes) {
            for (ClassInfo metaAnnotationNode : annotationNode.getRelatedClasses(ClassInfo.RelType.ANNOTATIONS)) {
                buf.append("  \"" + ClassGraphBuilder.label(annotationNode) + "\" -> \"" + ClassGraphBuilder.label(metaAnnotationNode) + "\" [arrowhead=dot]\n");
            }
            for (ClassInfo annotatedClassNode : annotationNode.getRelatedClasses(ClassInfo.RelType.ANNOTATIONS)) {
                buf.append("  \"" + ClassGraphBuilder.label(annotatedClassNode) + "\" -> \"" + ClassGraphBuilder.label(annotationNode) + "\" [arrowhead=dot]\n");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

