/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementDir;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementZip;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;

abstract class ClasspathElement {
    final File classpathElementFile;
    final ScanSpec scanSpec;
    private final boolean scanFiles;
    List<ClasspathRelativePath> childClasspathElts;
    boolean ioExceptionOnOpen;
    protected InterruptionChecker interruptionChecker;
    protected MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource> fileMatches;
    protected List<ClasspathResource> classfileMatches;
    protected Map<File, Long> fileToLastModified;

    ClasspathElement(ClasspathRelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanSpec = scanSpec;
        this.scanFiles = scanFiles;
        this.interruptionChecker = interruptionChecker;
        try {
            this.classpathElementFile = classpathEltPath.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.classpathElementFile.toString();
    }

    static ClasspathElement newInstance(ClasspathRelativePath classpathElt, boolean scanFiles, ScanSpec scanSpec, InterruptionChecker interruptionChecker, WorkQueue<ClasspathRelativePath> workQueue, LogNode log) throws IOException {
        ClasspathElement newInstance;
        boolean isDir;
        try {
            isDir = classpathElt.isDirectory();
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathElt.getResolvedPath(), e);
            }
            throw e;
        }
        LogNode logNode = log == null ? null : log.log(classpathElt.toString(), "Scanning " + (isDir ? "directory " : "jarfile ") + classpathElt);
        ClasspathElement classpathElement = newInstance = isDir ? new ClasspathElementDir(classpathElt, scanSpec, scanFiles, interruptionChecker, logNode) : new ClasspathElementZip(classpathElt, scanSpec, scanFiles, interruptionChecker, workQueue, logNode);
        if (logNode != null) {
            logNode.addElapsedTime();
        }
        return newInstance;
    }

    public int getNumClassfileMatches() {
        return this.classfileMatches == null ? 0 : this.classfileMatches.size();
    }

    void maskFiles(HashSet<String> classpathRelativePathsFound, LogNode log) {
        if (!this.scanFiles) {
            throw new IllegalArgumentException("scanFiles is false");
        }
        HashSet<String> allMatchingRelativePathsForThisClasspathElement = new HashSet<String>();
        for (ClasspathResource classpathResource : this.classfileMatches) {
            allMatchingRelativePathsForThisClasspathElement.add(classpathResource.relativePath);
        }
        for (Map.Entry entry : this.fileMatches.entrySet()) {
            for (ClasspathResource classpathResource : (List)entry.getValue()) {
                allMatchingRelativePathsForThisClasspathElement.add(classpathResource.relativePath);
            }
        }
        HashSet<String> maskedRelativePaths = new HashSet<String>();
        for (String string : allMatchingRelativePathsForThisClasspathElement) {
            if (!classpathRelativePathsFound.contains(string)) continue;
            maskedRelativePaths.add(string);
        }
        if (!maskedRelativePaths.isEmpty()) {
            ArrayList<ClasspathResource> arrayList = new ArrayList<ClasspathResource>();
            for (ClasspathResource classfileMatch : this.classfileMatches) {
                if (!maskedRelativePaths.contains(classfileMatch.relativePath)) {
                    arrayList.add(classfileMatch);
                    continue;
                }
                if (log == null) continue;
                log.log("Ignoring duplicate path " + classfileMatch.relativePath + " in classpath element " + classfileMatch.classpathEltFile + " -- it is masked by the same relative path occurring in an earlier classpath entry");
            }
            this.classfileMatches = arrayList;
            MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource> multiMapKeyToList = new MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource>();
            for (Map.Entry<ScanSpec.FileMatchProcessorWrapper, List<ClasspathResource>> ent : this.fileMatches.entrySet()) {
                for (ClasspathResource fileMatch : ent.getValue()) {
                    if (!maskedRelativePaths.contains(fileMatch.relativePath)) {
                        multiMapKeyToList.put(ent.getKey(), fileMatch);
                        continue;
                    }
                    if (log == null) continue;
                    log.log("Ignoring duplicate path " + fileMatch.relativePath + " in classpath element " + fileMatch.classpathEltFile + " -- it is masked by the same relative path occurring in an earlier classpath entry");
                }
            }
            this.fileMatches = multiMapKeyToList;
        }
        classpathRelativePathsFound.addAll(allMatchingRelativePathsForThisClasspathElement);
    }

    void callFileMatchProcessors(LogNode log) throws InterruptedException, ExecutionException {
        for (Map.Entry<ScanSpec.FileMatchProcessorWrapper, List<ClasspathResource>> ent : this.fileMatches.entrySet()) {
            ScanSpec.FileMatchProcessorWrapper fileMatchProcessorWrapper = ent.getKey();
            for (ClasspathResource fileMatch : ent.getValue()) {
                block5: {
                    try {
                        LogNode logNode = log == null ? null : log.log("Calling MatchProcessor for matching file " + fileMatch);
                        this.openInputStreamAndProcessFileMatch(fileMatch, fileMatchProcessorWrapper);
                        if (logNode != null) {
                            logNode.addElapsedTime();
                        }
                    }
                    catch (IOException e) {
                        if (log == null) break block5;
                        log.log("Exception while opening file " + fileMatch.classpathEltFile + (fileMatch.classpathEltFile.isFile() ? "!" : "/") + fileMatch.relativePath, e);
                    }
                }
                this.interruptionChecker.check();
            }
        }
    }

    void parseClassfiles(ClassfileBinaryParser classfileBinaryParser, int classfileStartIdx, int classfileEndIdx, ConcurrentHashMap<String, String> stringInternMap, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws InterruptedException, ExecutionException {
        for (int i = classfileStartIdx; i < classfileEndIdx; ++i) {
            block4: {
                ClasspathResource classfileResource = this.classfileMatches.get(i);
                try {
                    LogNode logNode = log == null ? null : log.log("Parsing classfile " + classfileResource);
                    this.openInputStreamAndParseClassfile(classfileResource, classfileBinaryParser, this.scanSpec, stringInternMap, classInfoUnlinked, logNode);
                    if (logNode != null) {
                        logNode.addElapsedTime();
                    }
                }
                catch (IOException e) {
                    if (log == null) break block4;
                    log.log("Exception while parsing classfile " + classfileResource, e);
                }
            }
            this.interruptionChecker.check();
        }
    }

    protected abstract void openInputStreamAndParseClassfile(ClasspathResource var1, ClassfileBinaryParser var2, ScanSpec var3, ConcurrentHashMap<String, String> var4, ConcurrentLinkedQueue<ClassInfoUnlinked> var5, LogNode var6) throws InterruptedException, IOException;

    protected abstract void openInputStreamAndProcessFileMatch(ClasspathResource var1, ScanSpec.FileMatchProcessorWrapper var2) throws IOException;

    public abstract void close();

    static class ClasspathResource {
        File classpathEltFile;
        String relativePath;

        private ClasspathResource(File classpathEltFile, String relativePath) {
            this.classpathEltFile = classpathEltFile;
            this.relativePath = relativePath;
        }

        static class ClasspathResourceInZipFile
        extends ClasspathResource {
            ZipEntry zipEntry;

            ClasspathResourceInZipFile(File classpathEltFile, String relativePath, ZipEntry zipEntry) {
                super(classpathEltFile, relativePath);
                this.zipEntry = zipEntry;
            }

            public String toString() {
                return "jar:" + this.classpathEltFile + "!" + this.relativePath;
            }
        }

        static class ClasspathResourceInDir
        extends ClasspathResource {
            File relativePathFile;

            ClasspathResourceInDir(File classpathEltFile, String relativePath, File relativePathFile) {
                super(classpathEltFile, relativePath);
                this.relativePathFile = relativePathFile;
            }

            public String toString() {
                return this.classpathEltFile + "/" + this.relativePath;
            }
        }
    }
}

