/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassInfo
implements Comparable<ClassInfo> {
    String className;
    private boolean isInterface;
    private boolean isAnnotation;
    private boolean classfileScanned;
    private boolean companionObjectClassfileScanned;
    private boolean traitMethodClassfileScanned;
    private final Map<RelType, Set<ClassInfo>> relatedTypeToClassInfoSet = new HashMap<RelType, Set<ClassInfo>>();
    Map<String, Object> fieldValues;

    private ClassInfo(String className) {
        this.className = className;
    }

    static Set<ClassInfo> filterClassInfo(Set<ClassInfo> classInfoSet, boolean removeExternalClasses, ClassType ... classTypes) {
        if (classInfoSet == null) {
            return Collections.emptySet();
        }
        boolean includeAllTypes = classTypes.length == 0;
        boolean includeStandardClasses = false;
        boolean includeImplementedInterfaces = false;
        boolean includeAnnotations = false;
        block7: for (ClassType classType : classTypes) {
            switch (classType) {
                case ALL: {
                    includeAllTypes = true;
                    continue block7;
                }
                case STANDARD_CLASS: {
                    includeStandardClasses = true;
                    continue block7;
                }
                case IMPLEMENTED_INTERFACE: {
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                case ANNOTATION: {
                    includeAnnotations = true;
                    continue block7;
                }
                case INTERFACE_OR_ANNOTATION: {
                    includeAnnotations = true;
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unknown ClassType: " + (Object)((Object)classType));
                }
            }
        }
        if (includeStandardClasses && includeImplementedInterfaces && includeAnnotations) {
            includeAllTypes = true;
        }
        boolean hasFilteredOutClass = false;
        for (ClassInfo classInfo : classInfoSet) {
            if ((!removeExternalClasses || classInfo.classfileScanned) && (includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface() || includeAnnotations && classInfo.isAnnotation())) continue;
            hasFilteredOutClass = true;
            break;
        }
        if (!hasFilteredOutClass) {
            return classInfoSet;
        }
        HashSet<ClassInfo> classInfoSetFiltered = new HashSet<ClassInfo>(classInfoSet.size());
        for (ClassInfo classInfo : classInfoSet) {
            if (removeExternalClasses && !classInfo.classfileScanned || !(includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface()) && (!includeAnnotations || !classInfo.isAnnotation())) continue;
            classInfoSetFiltered.add(classInfo);
        }
        return classInfoSetFiltered;
    }

    static List<String> getClassNames(Collection<ClassInfo> classInfoColl) {
        if (classInfoColl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>(classInfoColl.size());
        for (ClassInfo classInfo : classInfoColl) {
            classNames.add(classInfo.className);
        }
        Collections.sort(classNames);
        return classNames;
    }

    Set<ClassInfo> getRelatedClasses(RelType relType) {
        Set<ClassInfo> relatedClassClassInfo = this.relatedTypeToClassInfoSet.get((Object)relType);
        return relatedClassClassInfo == null ? Collections.emptySet() : relatedClassClassInfo;
    }

    Set<ClassInfo> getReachableClasses(RelType relType) {
        Set<ClassInfo> directlyRelatedClasses = this.getRelatedClasses(relType);
        if (directlyRelatedClasses.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ClassInfo> reachableClasses = new HashSet<ClassInfo>(directlyRelatedClasses);
        LinkedList<ClassInfo> queue = new LinkedList<ClassInfo>();
        queue.addAll(directlyRelatedClasses);
        while (!queue.isEmpty()) {
            ClassInfo head = (ClassInfo)queue.removeFirst();
            for (ClassInfo directlyReachableFromHead : head.getRelatedClasses(relType)) {
                if (!reachableClasses.add(directlyReachableFromHead)) continue;
                queue.add(directlyReachableFromHead);
            }
        }
        return reachableClasses;
    }

    private boolean addRelatedClass(RelType relType, ClassInfo classInfo) {
        Set<ClassInfo> classInfoSet = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet<ClassInfo>(4);
            this.relatedTypeToClassInfoSet.put(relType, classInfoSet);
        }
        return classInfoSet.add(classInfo);
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isImplementedInterface() {
        return !this.getRelatedClasses(RelType.CLASSES_IMPLEMENTING).isEmpty() || this.isInterface && !this.isAnnotation;
    }

    public boolean isStandardClass() {
        return !this.isAnnotation && (!this.getRelatedClasses(RelType.SUBCLASSES).isEmpty() || !this.getRelatedClasses(RelType.SUPERCLASSES).isEmpty() || !this.isImplementedInterface());
    }

    private static String scalaBaseClassName(String className) {
        if (className != null && className.endsWith("$")) {
            return className.substring(0, className.length() - 1);
        }
        if (className != null && className.endsWith("$class")) {
            return className.substring(0, className.length() - 6);
        }
        return className;
    }

    private static ClassInfo getOrCreateClassInfo(String className, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className);
            classNameToClassInfo.put(className, classInfo);
        }
        return classInfo;
    }

    void addSuperclass(String superclassName, Map<String, ClassInfo> classNameToClassInfo) {
        if (superclassName != null && !"java.lang.Object".equals(superclassName)) {
            ClassInfo superclassClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(superclassName), classNameToClassInfo);
            this.addRelatedClass(RelType.SUPERCLASSES, superclassClassInfo);
            superclassClassInfo.addRelatedClass(RelType.SUBCLASSES, this);
        }
    }

    void addAnnotation(String annotationName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(annotationName), classNameToClassInfo);
        annotationClassInfo.isAnnotation = true;
        this.addRelatedClass(RelType.ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.ANNOTATED_CLASSES, this);
    }

    void addImplementedInterface(String interfaceName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo interfaceClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(interfaceName), classNameToClassInfo);
        interfaceClassInfo.isInterface = true;
        this.addRelatedClass(RelType.IMPLEMENTED_INTERFACES, interfaceClassInfo);
        interfaceClassInfo.addRelatedClass(RelType.CLASSES_IMPLEMENTING, this);
    }

    void addFieldType(String fieldTypeName, Map<String, ClassInfo> classNameToClassInfo) {
        String fieldTypeBaseName = ClassInfo.scalaBaseClassName(fieldTypeName);
        ClassInfo fieldTypeClassInfo = ClassInfo.getOrCreateClassInfo(fieldTypeBaseName, classNameToClassInfo);
        this.addRelatedClass(RelType.FIELD_TYPES, fieldTypeClassInfo);
    }

    void addFieldConstantValue(String fieldName, Object constValue) {
        if (this.fieldValues == null) {
            this.fieldValues = new HashMap<String, Object>();
        }
        this.fieldValues.put(fieldName, constValue);
    }

    static ClassInfo addScannedClass(String className, boolean isInterface, boolean isAnnotation, Map<String, ClassInfo> classNameToClassInfo, LogNode log) {
        ClassInfo classInfo;
        boolean isCompanionObjectClass = className.endsWith("$");
        boolean isTraitMethodClass = className.endsWith("$class");
        boolean isNonAuxClass = !isCompanionObjectClass && !isTraitMethodClass;
        String classBaseName = ClassInfo.scalaBaseClassName(className);
        if (classNameToClassInfo.containsKey(classBaseName)) {
            classInfo = classNameToClassInfo.get(classBaseName);
            if ((isNonAuxClass && classInfo.classfileScanned || isCompanionObjectClass && classInfo.companionObjectClassfileScanned || isTraitMethodClass && classInfo.traitMethodClassfileScanned) && log != null) {
                log.log("Encountered class with same exact path more than once in the same jarfile: " + className + " (merging info from all copies of the classfile)");
            }
        } else {
            classInfo = new ClassInfo(classBaseName);
            classNameToClassInfo.put(classBaseName, classInfo);
        }
        if (isTraitMethodClass) {
            classInfo.traitMethodClassfileScanned = true;
        } else if (isCompanionObjectClass) {
            classInfo.companionObjectClassfileScanned = true;
        } else {
            classInfo.classfileScanned = true;
        }
        classInfo.isInterface |= isInterface;
        classInfo.isAnnotation |= isAnnotation;
        return classInfo;
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.className.compareTo(o.className);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ClassInfo other = (ClassInfo)obj;
            return this.className != null ? this.className.equals(other.className) : other.className == null;
        }
        return false;
    }

    public int hashCode() {
        return this.className != null ? this.className.hashCode() : 33;
    }

    public String toString() {
        return this.className;
    }

    static enum ClassType {
        ALL,
        STANDARD_CLASS,
        IMPLEMENTED_INTERFACE,
        ANNOTATION,
        INTERFACE_OR_ANNOTATION;

    }

    static enum RelType {
        SUPERCLASSES,
        SUBCLASSES,
        FIELD_TYPES,
        IMPLEMENTED_INTERFACES,
        CLASSES_IMPLEMENTING,
        ANNOTATIONS,
        ANNOTATED_CLASSES;

    }
}

