/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassInfo
implements Comparable<ClassInfo> {
    String className;
    private boolean isInterface;
    private boolean isAnnotation;
    private boolean classfileScanned;
    private boolean companionObjectClassfileScanned;
    private boolean traitMethodClassfileScanned;
    private final Map<RelType, Set<ClassInfo>> relatedTypeToClassInfoSet = new HashMap<RelType, Set<ClassInfo>>();
    Map<String, Object> staticFinalFieldNameToConstantInitializerValue;

    private ClassInfo(String className) {
        this.className = className;
    }

    static Set<ClassInfo> filterClassInfo(Set<ClassInfo> classInfoSet, boolean removeExternalClasses, ClassType ... classTypes) {
        if (classInfoSet == null) {
            return Collections.emptySet();
        }
        boolean includeAllTypes = classTypes.length == 0;
        boolean includeStandardClasses = false;
        boolean includeImplementedInterfaces = false;
        boolean includeAnnotations = false;
        block7: for (ClassType classType : classTypes) {
            switch (classType) {
                case ALL: {
                    includeAllTypes = true;
                    continue block7;
                }
                case STANDARD_CLASS: {
                    includeStandardClasses = true;
                    continue block7;
                }
                case IMPLEMENTED_INTERFACE: {
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                case ANNOTATION: {
                    includeAnnotations = true;
                    continue block7;
                }
                case INTERFACE_OR_ANNOTATION: {
                    includeAnnotations = true;
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unknown ClassType: " + (Object)((Object)classType));
                }
            }
        }
        if (includeStandardClasses && includeImplementedInterfaces && includeAnnotations) {
            includeAllTypes = true;
        }
        boolean hasFilteredOutClass = false;
        for (ClassInfo classInfo : classInfoSet) {
            if ((!removeExternalClasses || classInfo.classfileScanned) && (includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface() || includeAnnotations && classInfo.isAnnotation())) continue;
            hasFilteredOutClass = true;
            break;
        }
        if (!hasFilteredOutClass) {
            return classInfoSet;
        }
        HashSet<ClassInfo> classInfoSetFiltered = new HashSet<ClassInfo>(classInfoSet.size());
        for (ClassInfo classInfo : classInfoSet) {
            if (removeExternalClasses && !classInfo.classfileScanned || !(includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface()) && (!includeAnnotations || !classInfo.isAnnotation())) continue;
            classInfoSetFiltered.add(classInfo);
        }
        return classInfoSetFiltered;
    }

    public static List<String> getClassNames(Collection<ClassInfo> classInfoColl) {
        if (classInfoColl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>(classInfoColl.size());
        for (ClassInfo classInfo : classInfoColl) {
            classNames.add(classInfo.className);
        }
        Collections.sort(classNames);
        return classNames;
    }

    Set<ClassInfo> getRelatedClasses(RelType relType) {
        Set<ClassInfo> relatedClassClassInfo = this.relatedTypeToClassInfoSet.get((Object)relType);
        return relatedClassClassInfo == null ? Collections.emptySet() : relatedClassClassInfo;
    }

    Set<ClassInfo> getReachableClasses(RelType relType) {
        Set<ClassInfo> directlyRelatedClasses = this.getRelatedClasses(relType);
        if (directlyRelatedClasses.isEmpty()) {
            return directlyRelatedClasses;
        }
        HashSet<ClassInfo> reachableClasses = new HashSet<ClassInfo>(directlyRelatedClasses);
        LinkedList<ClassInfo> queue = new LinkedList<ClassInfo>();
        queue.addAll(directlyRelatedClasses);
        while (!queue.isEmpty()) {
            ClassInfo head = (ClassInfo)queue.removeFirst();
            for (ClassInfo directlyReachableFromHead : head.getRelatedClasses(relType)) {
                if (!reachableClasses.add(directlyReachableFromHead)) continue;
                queue.add(directlyReachableFromHead);
            }
        }
        return reachableClasses;
    }

    private boolean addRelatedClass(RelType relType, ClassInfo classInfo) {
        Set<ClassInfo> classInfoSet = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet<ClassInfo>(4);
            this.relatedTypeToClassInfoSet.put(relType, classInfoSet);
        }
        return classInfoSet.add(classInfo);
    }

    private static String scalaBaseClassName(String className) {
        if (className != null && className.endsWith("$")) {
            return className.substring(0, className.length() - 1);
        }
        if (className != null && className.endsWith("$class")) {
            return className.substring(0, className.length() - 6);
        }
        return className;
    }

    private static ClassInfo getOrCreateClassInfo(String className, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className);
            classNameToClassInfo.put(className, classInfo);
        }
        return classInfo;
    }

    void addSuperclass(String superclassName, Map<String, ClassInfo> classNameToClassInfo) {
        if (superclassName != null && !"java.lang.Object".equals(superclassName)) {
            ClassInfo superclassClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(superclassName), classNameToClassInfo);
            this.addRelatedClass(RelType.SUPERCLASSES, superclassClassInfo);
            superclassClassInfo.addRelatedClass(RelType.SUBCLASSES, this);
        }
    }

    void addAnnotation(String annotationName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(annotationName), classNameToClassInfo);
        annotationClassInfo.isAnnotation = true;
        this.addRelatedClass(RelType.ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.ANNOTATED_CLASSES, this);
    }

    void addImplementedInterface(String interfaceName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo interfaceClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(interfaceName), classNameToClassInfo);
        interfaceClassInfo.isInterface = true;
        this.addRelatedClass(RelType.IMPLEMENTED_INTERFACES, interfaceClassInfo);
        interfaceClassInfo.addRelatedClass(RelType.CLASSES_IMPLEMENTING, this);
    }

    void addFieldType(String fieldTypeName, Map<String, ClassInfo> classNameToClassInfo) {
        String fieldTypeBaseName = ClassInfo.scalaBaseClassName(fieldTypeName);
        ClassInfo fieldTypeClassInfo = ClassInfo.getOrCreateClassInfo(fieldTypeBaseName, classNameToClassInfo);
        this.addRelatedClass(RelType.FIELD_TYPES, fieldTypeClassInfo);
    }

    void addStaticFinalFieldConstantInitializerValue(String fieldName, Object constValue) {
        if (this.staticFinalFieldNameToConstantInitializerValue == null) {
            this.staticFinalFieldNameToConstantInitializerValue = new HashMap<String, Object>();
        }
        this.staticFinalFieldNameToConstantInitializerValue.put(fieldName, constValue);
    }

    static ClassInfo addScannedClass(String className, boolean isInterface, boolean isAnnotation, Map<String, ClassInfo> classNameToClassInfo, LogNode log) {
        ClassInfo classInfo;
        boolean isCompanionObjectClass = className.endsWith("$");
        boolean isTraitMethodClass = className.endsWith("$class");
        boolean isNonAuxClass = !isCompanionObjectClass && !isTraitMethodClass;
        String classBaseName = ClassInfo.scalaBaseClassName(className);
        if (classNameToClassInfo.containsKey(classBaseName)) {
            classInfo = classNameToClassInfo.get(classBaseName);
            if ((isNonAuxClass && classInfo.classfileScanned || isCompanionObjectClass && classInfo.companionObjectClassfileScanned || isTraitMethodClass && classInfo.traitMethodClassfileScanned) && log != null) {
                log.log("Encountered class with same exact path more than once in the same jarfile: " + className + " (merging info from all copies of the classfile)");
            }
        } else {
            classInfo = new ClassInfo(classBaseName);
            classNameToClassInfo.put(classBaseName, classInfo);
        }
        if (isTraitMethodClass) {
            classInfo.traitMethodClassfileScanned = true;
        } else if (isCompanionObjectClass) {
            classInfo.companionObjectClassfileScanned = true;
        } else {
            classInfo.classfileScanned = true;
        }
        classInfo.isInterface |= isInterface;
        classInfo.isAnnotation |= isAnnotation;
        return classInfo;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.className.compareTo(o.className);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ClassInfo other = (ClassInfo)obj;
            return this.className != null ? this.className.equals(other.className) : other.className == null;
        }
        return false;
    }

    public int hashCode() {
        return this.className != null ? this.className.hashCode() : 33;
    }

    public String toString() {
        return this.className;
    }

    public boolean isStandardClass() {
        return !this.isAnnotation && (!this.getRelatedClasses(RelType.SUBCLASSES).isEmpty() || !this.getRelatedClasses(RelType.SUPERCLASSES).isEmpty() || !this.isImplementedInterface());
    }

    public Set<ClassInfo> getSubclasses() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.SUBCLASSES), true, ClassType.ALL);
    }

    public List<String> getNamesOfSubclasses() {
        return ClassInfo.getClassNames(this.getSubclasses());
    }

    public boolean hasSubclass(String subclassName) {
        return this.getNamesOfSubclasses().contains(subclassName);
    }

    public Set<ClassInfo> getDirectSubclasses() {
        return ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.SUBCLASSES), true, ClassType.ALL);
    }

    public List<String> getNamesOfDirectSubclasses() {
        return ClassInfo.getClassNames(this.getDirectSubclasses());
    }

    public boolean hasDirectSubclass(String directSubclassName) {
        return this.getNamesOfDirectSubclasses().contains(directSubclassName);
    }

    public Set<ClassInfo> getSuperclasses() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.SUPERCLASSES), true, ClassType.ALL);
    }

    public List<String> getNamesOfSuperclasses() {
        return ClassInfo.getClassNames(this.getSuperclasses());
    }

    public boolean hasSuperclass(String superclassName) {
        return this.getNamesOfSuperclasses().contains(superclassName);
    }

    public Set<ClassInfo> getDirectSuperclasses() {
        return ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.SUPERCLASSES), true, ClassType.ALL);
    }

    public List<String> getNamesOfDirectSuperclasses() {
        return ClassInfo.getClassNames(this.getDirectSuperclasses());
    }

    public boolean hasDirectSuperclass(String directSuperclassName) {
        return this.getNamesOfDirectSuperclasses().contains(directSuperclassName);
    }

    public boolean isImplementedInterface() {
        return !this.getRelatedClasses(RelType.CLASSES_IMPLEMENTING).isEmpty() || this.isInterface && !this.isAnnotation;
    }

    public Set<ClassInfo> getSubinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_IMPLEMENTING), true, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfSubinterfaces() {
        return ClassInfo.getClassNames(this.getSubinterfaces());
    }

    public boolean hasSubinterface(String subinterfaceName) {
        return this.getNamesOfSubinterfaces().contains(subinterfaceName);
    }

    public Set<ClassInfo> getDirectSubinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.CLASSES_IMPLEMENTING), true, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfDirectSubinterfaces() {
        return ClassInfo.getClassNames(this.getDirectSubinterfaces());
    }

    public boolean hasDirectSubinterface(String directSubinterfaceName) {
        return this.getNamesOfDirectSubinterfaces().contains(directSubinterfaceName);
    }

    public Set<ClassInfo> getSuperinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.IMPLEMENTED_INTERFACES), true, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfSuperinterfaces() {
        return ClassInfo.getClassNames(this.getSuperinterfaces());
    }

    public boolean hasSuperinterface(String superinterfaceName) {
        return this.getNamesOfSuperinterfaces().contains(superinterfaceName);
    }

    public Set<ClassInfo> getDirectSuperinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.IMPLEMENTED_INTERFACES), true, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfDirectSuperinterfaces() {
        return ClassInfo.getClassNames(this.getDirectSuperinterfaces());
    }

    public boolean hasDirectSuperinterface(String directSuperinterfaceName) {
        return this.getNamesOfDirectSuperinterfaces().contains(directSuperinterfaceName);
    }

    public Set<ClassInfo> getImplementedInterfaces() {
        if (!this.isStandardClass()) {
            return Collections.emptySet();
        }
        Set<ClassInfo> superclasses = ClassInfo.filterClassInfo(this.getReachableClasses(RelType.SUPERCLASSES), true, ClassType.STANDARD_CLASS);
        HashSet<ClassInfo> allInterfaces = new HashSet<ClassInfo>();
        allInterfaces.addAll(this.getReachableClasses(RelType.IMPLEMENTED_INTERFACES));
        for (ClassInfo superClass : superclasses) {
            allInterfaces.addAll(superClass.getReachableClasses(RelType.IMPLEMENTED_INTERFACES));
        }
        return allInterfaces;
    }

    public List<String> getNamesOfImplementedInterfaces() {
        return ClassInfo.getClassNames(this.getImplementedInterfaces());
    }

    public boolean implementsInterface(String interfaceName) {
        return this.getNamesOfImplementedInterfaces().contains(interfaceName);
    }

    public Set<ClassInfo> getDirectlyImplementedInterfaces() {
        if (!this.isStandardClass()) {
            return Collections.emptySet();
        }
        Set<ClassInfo> superclasses = ClassInfo.filterClassInfo(this.getReachableClasses(RelType.SUPERCLASSES), true, ClassType.STANDARD_CLASS);
        HashSet<ClassInfo> allInterfaces = new HashSet<ClassInfo>();
        allInterfaces.addAll(this.getRelatedClasses(RelType.IMPLEMENTED_INTERFACES));
        for (ClassInfo superClass : superclasses) {
            allInterfaces.addAll(superClass.getRelatedClasses(RelType.IMPLEMENTED_INTERFACES));
        }
        return allInterfaces;
    }

    public List<String> getNamesOfDirectlyImplementedInterfaces() {
        return ClassInfo.getClassNames(this.getDirectlyImplementedInterfaces());
    }

    public boolean directlyImplementsInterface(String interfaceName) {
        return this.getNamesOfDirectlyImplementedInterfaces().contains(interfaceName);
    }

    public Set<ClassInfo> getClassesImplementing() {
        if (!this.isImplementedInterface()) {
            return Collections.emptySet();
        }
        Set<ClassInfo> implementingClasses = ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_IMPLEMENTING), true, ClassType.STANDARD_CLASS);
        HashSet<ClassInfo> allImplementingClasses = new HashSet<ClassInfo>();
        for (ClassInfo implementingClass : implementingClasses) {
            allImplementingClasses.add(implementingClass);
            allImplementingClasses.addAll(implementingClass.getReachableClasses(RelType.SUBCLASSES));
        }
        return allImplementingClasses;
    }

    public List<String> getNamesOfClassesImplementing() {
        return ClassInfo.getClassNames(this.getClassesImplementing());
    }

    public boolean isImplementedByClass(String className) {
        return this.getNamesOfClassesImplementing().contains(className);
    }

    public Set<ClassInfo> getClassesDirectlyImplementing() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.CLASSES_IMPLEMENTING), true, ClassType.STANDARD_CLASS);
    }

    public List<String> getNamesOfClassesDirectlyImplementing() {
        return ClassInfo.getClassNames(this.getClassesDirectlyImplementing());
    }

    public boolean isDirectlyImplementedByClass(String className) {
        return this.getNamesOfClassesDirectlyImplementing().contains(className);
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public Set<ClassInfo> getClassesWithAnnotation() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.ANNOTATED_CLASSES), true, ClassType.STANDARD_CLASS, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfClassesWithAnnotation() {
        return ClassInfo.getClassNames(this.getClassesWithAnnotation());
    }

    public boolean annotatesClass(String annotatedClassName) {
        return this.getNamesOfClassesWithAnnotation().contains(annotatedClassName);
    }

    public Set<ClassInfo> getDirectlyAnnotatedClasses() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.ANNOTATED_CLASSES), true, ClassType.STANDARD_CLASS, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfDirectlyAnnotatedClasses() {
        return ClassInfo.getClassNames(this.getDirectlyAnnotatedClasses());
    }

    public boolean directlyAnnotatesClass(String directlyAnnotatedClassName) {
        return this.getNamesOfDirectlyAnnotatedClasses().contains(directlyAnnotatedClassName);
    }

    public Set<ClassInfo> getAnnotations() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.ANNOTATIONS), true, ClassType.ALL);
    }

    public List<String> getNamesOfAnnotations() {
        return ClassInfo.getClassNames(this.getAnnotations());
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getNamesOfAnnotations().contains(annotationName);
    }

    public Set<ClassInfo> getMetaAnnotations() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.ANNOTATIONS), true, ClassType.ALL);
    }

    public List<String> getNamesOfMetaAnnotations() {
        return ClassInfo.getClassNames(this.getMetaAnnotations());
    }

    public boolean hasMetaAnnotation(String metaAnnotationName) {
        return this.getNamesOfMetaAnnotations().contains(metaAnnotationName);
    }

    public Set<ClassInfo> getDirectAnnotations() {
        return ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.ANNOTATIONS), true, ClassType.ALL);
    }

    public List<String> getNamesOfDirectAnnotations() {
        return ClassInfo.getClassNames(this.getDirectAnnotations());
    }

    public boolean hasDirectAnnotation(String directAnnotationName) {
        return this.getNamesOfDirectAnnotations().contains(directAnnotationName);
    }

    public Set<ClassInfo> getAnnotationsWithMetaAnnotation() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.ANNOTATED_CLASSES), true, ClassType.ANNOTATION);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation() {
        return ClassInfo.getClassNames(this.getAnnotationsWithMetaAnnotation());
    }

    public boolean metaAnnotatesAnnotation(String annotationName) {
        return this.getNamesOfAnnotationsWithMetaAnnotation().contains(annotationName);
    }

    public Set<ClassInfo> getAnnotationsWithDirectMetaAnnotation() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.ANNOTATED_CLASSES), true, ClassType.ANNOTATION);
    }

    public List<String> getNamesOfAnnotationsWithDirectMetaAnnotation() {
        return ClassInfo.getClassNames(this.getAnnotationsWithDirectMetaAnnotation());
    }

    public boolean hasDirectMetaAnnotation(String directMetaAnnotationName) {
        return this.getNamesOfAnnotationsWithDirectMetaAnnotation().contains(directMetaAnnotationName);
    }

    public List<String> getFieldTypes() {
        return !this.isStandardClass() ? Collections.emptyList() : ClassInfo.getClassNames(ClassInfo.filterClassInfo(this.getRelatedClasses(RelType.FIELD_TYPES), true, ClassType.ALL));
    }

    static enum ClassType {
        ALL,
        STANDARD_CLASS,
        IMPLEMENTED_INTERFACE,
        ANNOTATION,
        INTERFACE_OR_ANNOTATION;

    }

    static enum RelType {
        SUPERCLASSES,
        SUBCLASSES,
        FIELD_TYPES,
        IMPLEMENTED_INTERFACES,
        CLASSES_IMPLEMENTING,
        ANNOTATIONS,
        ANNOTATED_CLASSES;

    }
}

