/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.FastManifestParser;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClasspathElementZip
extends ClasspathElement {
    private Recycler<ZipFile, IOException> zipFileRecycler;
    private FastManifestParser fastManifestParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClasspathElementZip(ClasspathRelativePath classpathElt, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker, WorkQueue<ClasspathRelativePath> workQueue, LogNode log) {
        super(classpathElt, scanSpec, scanFiles, interruptionChecker, log);
        File classpathEltFile;
        try {
            classpathEltFile = classpathElt.getFile();
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathElt.getResolvedPath(), e);
            }
            this.ioExceptionOnOpen = true;
            return;
        }
        this.zipFileRecycler = new Recycler<ZipFile, IOException>(){

            @Override
            public ZipFile newInstance() throws IOException {
                return new ZipFile(classpathEltFile);
            }
        };
        ZipFile zipFile = null;
        try {
            try {
                zipFile = this.zipFileRecycler.acquire();
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception opening zipfile " + classpathEltFile, e);
                }
                this.ioExceptionOnOpen = true;
                this.zipFileRecycler.release(zipFile);
                return;
            }
            if (!scanFiles) {
                this.fastManifestParser = new FastManifestParser(zipFile, zipFile.getEntry("META-INF/MANIFEST.MF"), log);
            } else {
                int numEntries = zipFile.size();
                this.fileMatches = new MultiMapKeyToList();
                this.classfileMatches = new ArrayList(numEntries);
                this.fileToLastModified = new HashMap();
                this.scanZipFile(classpathEltFile, zipFile, log);
            }
            if (this.fastManifestParser != null && this.fastManifestParser.classPath != null) {
                if (log != null) {
                    log.log("Found Class-Path entry in manifest of " + classpathElt.getResolvedPath() + ": " + this.fastManifestParser.classPath);
                }
                String[] manifestClassPathElts = this.fastManifestParser.classPath.split(" ");
                String pathOfContainingDir = FastPathResolver.resolve(classpathEltFile.getParent());
                this.childClasspathElts = new ArrayList(manifestClassPathElts.length);
                for (int i = 0; i < manifestClassPathElts.length; ++i) {
                    String manifestClassPathElt = manifestClassPathElts[i];
                    if (manifestClassPathElt.isEmpty()) continue;
                    this.childClasspathElts.add(new ClasspathRelativePath(pathOfContainingDir, manifestClassPathElt));
                }
                workQueue.addWorkUnits(this.childClasspathElts);
            }
        }
        finally {
            this.zipFileRecycler.release(zipFile);
        }
    }

    private void scanZipFile(File zipFileFile, ZipFile zipFile, LogNode log) {
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        int entryIdx = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            boolean isDir;
            if ((entryIdx++ & 0x3FF) == 0 && this.interruptionChecker.checkAndReturn()) {
                return;
            }
            ZipEntry zipEntry = entries.nextElement();
            String relativePath = zipEntry.getName();
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (isDir = zipEntry.isDirectory()) continue;
            int lastSlashIdx = relativePath.lastIndexOf("/");
            String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || parentRelativePathChanged ? this.scanSpec.pathWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (relativePath.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                if (log != null) {
                    log.log("Found manifest file: " + relativePath);
                }
                this.fastManifestParser = new FastManifestParser(zipFile, zipEntry, log);
            }
            if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) continue;
            if (log != null) {
                log.log("Found whitelisted file in jarfile: " + relativePath);
            }
            if (ClasspathRelativePath.isClassfile(relativePath)) {
                this.classfileMatches.add(new ClasspathElement.ClasspathResource.ClasspathResourceInZipFile(zipFileFile, relativePath, zipEntry));
            }
            for (ScanSpec.FilePathTesterAndMatchProcessorWrapper fileMatcher : this.scanSpec.getFilePathTestersAndMatchProcessorWrappers()) {
                if (!fileMatcher.filePathMatches(zipFileFile, relativePath, log)) continue;
                this.fileMatches.put(fileMatcher.fileMatchProcessorWrapper, new ClasspathElement.ClasspathResource.ClasspathResourceInZipFile(zipFileFile, relativePath, zipEntry));
            }
        }
        this.fileToLastModified.put(zipFileFile, zipFileFile.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openInputStreamAndProcessFileMatch(ClasspathElement.ClasspathResource fileMatchResource, ScanSpec.FileMatchProcessorWrapper fileMatchProcessorWrapper) throws IOException {
        if (!this.ioExceptionOnOpen) {
            ZipFile zipFile = null;
            try {
                zipFile = this.zipFileRecycler.acquire();
                ZipEntry zipEntry = ((ClasspathElement.ClasspathResource.ClasspathResourceInZipFile)fileMatchResource).zipEntry;
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    fileMatchProcessorWrapper.processMatch(fileMatchResource.classpathEltFile, fileMatchResource.relativePath, inputStream, zipEntry.getSize());
                }
            }
            finally {
                this.zipFileRecycler.release(zipFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openInputStreamAndParseClassfile(ClasspathElement.ClasspathResource classfileResource, ClassfileBinaryParser classfileBinaryParser, ScanSpec scanSpec, ConcurrentHashMap<String, String> stringInternMap, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws InterruptedException, IOException {
        if (!this.ioExceptionOnOpen) {
            ZipFile zipFile = null;
            try {
                zipFile = this.zipFileRecycler.acquire();
                ZipEntry zipEntry = ((ClasspathElement.ClasspathResource.ClasspathResourceInZipFile)classfileResource).zipEntry;
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(classfileResource.relativePath, inputStream, scanSpec, stringInternMap, log);
                    if (thisClassInfoUnlinked != null) {
                        classInfoUnlinked.add(thisClassInfoUnlinked);
                        thisClassInfoUnlinked.logTo(log);
                    }
                }
            }
            finally {
                this.zipFileRecycler.release(zipFile);
            }
        }
    }

    @Override
    public void close() {
        if (this.zipFileRecycler != null) {
            this.zipFileRecycler.close();
        }
    }
}

