/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LogNode {
    private final long timeStamp = System.nanoTime();
    private final String msg;
    private String stackTrace;
    private long elapsedTimeNanos;
    private final Map<String, LogNode> children = new ConcurrentSkipListMap<String, LogNode>();
    private String sortKeyPrefix = "";
    private static AtomicInteger sortKeyUniqueSuffix = new AtomicInteger(0);
    private static final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmX");
    private static final DecimalFormat nanoFormatter = new DecimalFormat("0.000000");

    private LogNode(String sortKey, String msg, long elapsedTimeNanos, Throwable exception) {
        this.sortKeyPrefix = sortKey;
        this.msg = msg;
        this.elapsedTimeNanos = elapsedTimeNanos;
        if (exception != null) {
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            this.stackTrace = writer.toString();
        } else {
            this.stackTrace = null;
        }
    }

    public LogNode() {
        this("", "", -1L, null);
    }

    private void appendLine(String timeStampStr, int indentLevel, String line, StringBuilder buf) {
        buf.append(timeStampStr);
        buf.append('\t');
        buf.append(FastClasspathScanner.class.getSimpleName());
        buf.append('\t');
        int numDashes = 2 * (indentLevel - 1);
        for (int i = 0; i < numDashes; ++i) {
            buf.append('-');
        }
        if (numDashes > 0) {
            buf.append(' ');
        }
        buf.append(line);
        buf.append('\n');
    }

    private void toString(int indentLevel, StringBuilder buf) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.timeStamp * 1000000L);
        String timeStampStr = dateTimeFormatter.format(cal.getTime());
        String logMsg = indentLevel == 0 ? "FastClasspathScanner version " + FastClasspathScanner.getVersion() : (this.elapsedTimeNanos > 0L ? this.msg + " (took " + nanoFormatter.format((double)this.elapsedTimeNanos * 1.0E-9) + " sec)" : this.msg);
        this.appendLine(timeStampStr, indentLevel, logMsg, buf);
        if (this.stackTrace != null) {
            buf.append(" -- stacktrace:");
            String[] parts = this.stackTrace.split("\n");
            for (int i = 0; i < parts.length; ++i) {
                buf.append('\n');
                this.appendLine(timeStampStr, indentLevel, parts[i], buf);
            }
        }
        for (Map.Entry<String, LogNode> ent : this.children.entrySet()) {
            String key = ent.getKey();
            LogNode child = ent.getValue();
            child.toString(indentLevel + 1, buf);
            if (!child.children.isEmpty()) continue;
            this.children.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SimpleDateFormat simpleDateFormat = dateTimeFormatter;
        synchronized (simpleDateFormat) {
            StringBuilder buf = new StringBuilder();
            this.toString(0, buf);
            return buf.toString();
        }
    }

    public void addElapsedTime() {
        this.elapsedTimeNanos = System.nanoTime() - this.timeStamp;
    }

    private LogNode addChild(String sortKey, String msg, long elapsedTimeNanos, Throwable exception) {
        String newSortKey = this.sortKeyPrefix + String.format("-%09d", sortKeyUniqueSuffix.getAndIncrement()) + sortKey;
        LogNode newChild = new LogNode(newSortKey, msg, elapsedTimeNanos, exception);
        this.children.put(newSortKey, newChild);
        return newChild;
    }

    public LogNode log(String sortKey, String msg, long elapsedTimeNanos, Throwable e) {
        return this.addChild(sortKey, msg, elapsedTimeNanos, e);
    }

    public LogNode log(String sortKey, String msg, long elapsedTimeNanos) {
        return this.addChild(sortKey, msg, elapsedTimeNanos, null);
    }

    public LogNode log(String sortKey, String msg, Throwable e) {
        return this.addChild(sortKey, msg, -1L, e);
    }

    public LogNode log(String sortKey, String msg) {
        return this.addChild(sortKey, msg, -1L, null);
    }

    public LogNode log(String msg, long elapsedTimeNanos, Throwable e) {
        return this.addChild("", msg, elapsedTimeNanos, e);
    }

    public LogNode log(String msg, long elapsedTimeNanos) {
        return this.addChild("", msg, elapsedTimeNanos, null);
    }

    public LogNode log(String msg, Throwable e) {
        return this.addChild("", msg, -1L, e);
    }

    public LogNode log(String msg) {
        return this.addChild("", msg, -1L, null);
    }

    public void flush() {
        System.err.print(this.toString());
        System.err.flush();
    }
}

