/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

class ClasspathElementDir
extends ClasspathElement {
    ClasspathElementDir(ClasspathRelativePath classpathElt, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker, LogNode log) {
        super(classpathElt, scanSpec, scanFiles, interruptionChecker, log);
        if (scanFiles) {
            File dir;
            try {
                dir = classpathElt.getFile();
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception while trying to canonicalize path " + classpathElt.getResolvedPath(), e);
                }
                this.ioExceptionOnOpen = true;
                return;
            }
            this.fileMatches = new MultiMapKeyToList();
            this.classfileMatches = new ArrayList();
            this.fileToLastModified = new HashMap();
            HashSet<String> scannedCanonicalPaths = new HashSet<String>();
            int[] entryIdx = new int[1];
            this.scanDir(dir, dir, dir.getPath().length() + 1, false, scannedCanonicalPaths, entryIdx, log);
        }
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean inWhitelistedPath, HashSet<String> scannedCanonicalPaths, int[] entryIdx, LogNode log) {
        File[] filesInDir;
        String canonicalPath;
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir);
            }
            return;
        }
        String dirPath = dir.getPath();
        String dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.pathWhitelistMatchStatus(dirRelativePath);
        if (matchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH) {
            if (log != null) {
                log.log("Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) {
            inWhitelistedPath = true;
        }
        if ((filesInDir = dir.listFiles()) == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        LogNode dirLog = log == null ? null : log.log(canonicalPath, "Scanning directory: " + dir + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            int n = entryIdx[0];
            entryIdx[0] = n + 1;
            if ((n & 0xFF) == 0 && this.interruptionChecker.checkAndReturn()) {
                return;
            }
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDir(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath, scannedCanonicalPaths, entryIdx, dirLog);
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            if (log != null) {
                log.log("Found whitelisted file: " + fileInDirRelativePath);
            }
            this.fileToLastModified.put(fileInDir, fileInDir.lastModified());
            if (ClasspathRelativePath.isClassfile(fileInDirRelativePath)) {
                this.classfileMatches.add(new ClasspathElement.ClasspathResource.ClasspathResourceInDir(classpathElt, fileInDirRelativePath, fileInDir));
            }
            for (ScanSpec.FilePathTesterAndMatchProcessorWrapper fileMatcher : this.scanSpec.getFilePathTestersAndMatchProcessorWrappers()) {
                if (!fileMatcher.filePathMatches(classpathElt, fileInDirRelativePath, log)) continue;
                this.fileMatches.put(fileMatcher.fileMatchProcessorWrapper, new ClasspathElement.ClasspathResource.ClasspathResourceInDir(classpathElt, fileInDirRelativePath, fileInDir));
            }
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.WITHIN_WHITELISTED_PATH) {
            this.fileToLastModified.put(dir, dir.lastModified());
        }
        if (log != null) {
            log.addElapsedTime();
        }
    }

    @Override
    protected void openInputStreamAndProcessFileMatch(ClasspathElement.ClasspathResource fileMatchResource, ScanSpec.FileMatchProcessorWrapper fileMatchProcessorWrapper) throws IOException {
        if (!this.ioExceptionOnOpen) {
            File relativePathFile = ((ClasspathElement.ClasspathResource.ClasspathResourceInDir)fileMatchResource).relativePathFile;
            try (FileInputStream inputStream = new FileInputStream(relativePathFile);){
                fileMatchProcessorWrapper.processMatch(fileMatchResource.classpathEltFile, fileMatchResource.relativePath, inputStream, relativePathFile.length());
            }
        }
    }

    @Override
    protected void openInputStreamAndParseClassfile(ClasspathElement.ClasspathResource classfileResource, ClassfileBinaryParser classfileBinaryParser, ScanSpec scanSpec, ConcurrentHashMap<String, String> stringInternMap, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws InterruptedException, IOException {
        if (!this.ioExceptionOnOpen) {
            File relativePathFile = ((ClasspathElement.ClasspathResource.ClasspathResourceInDir)classfileResource).relativePathFile;
            try (FileInputStream inputStream = new FileInputStream(relativePathFile);){
                ClassInfoUnlinked thisClassInfoUnlinked = classfileBinaryParser.readClassInfoFromClassfileHeader(classfileResource.relativePath, inputStream, scanSpec, stringInternMap, log);
                if (thisClassInfoUnlinked != null) {
                    classInfoUnlinked.add(thisClassInfoUnlinked);
                    thisClassInfoUnlinked.logTo(log);
                }
            }
        }
    }

    @Override
    public void close() {
    }
}

