/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.MatchProcessorException;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePathToElementMap;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class Scanner
implements Callable<ScanResult> {
    private final ScanSpec scanSpec;
    private final ExecutorService executorService;
    private final int numParallelTasks;
    private final boolean scanFiles;
    private final InterruptionChecker interruptionChecker = new InterruptionChecker();
    private final LogNode log;
    private static final int NUM_FILES_PER_CHUNK = 200;

    public Scanner(ScanSpec scanSpec, ExecutorService executorService, int numParallelTasks, boolean enableRecursiveScanning, LogNode log) {
        this.scanSpec = scanSpec;
        this.executorService = executorService;
        this.numParallelTasks = numParallelTasks;
        this.scanFiles = enableRecursiveScanning;
        this.log = log;
    }

    private static void findClasspathOrder(ClasspathElement currSingleton, ClasspathRelativePathToElementMap classpathElementMap, HashSet<ClasspathElement> visitedClasspathElts, ArrayList<ClasspathElement> order) throws InterruptedException {
        if (visitedClasspathElts.add(currSingleton)) {
            order.add(currSingleton);
            if (currSingleton.childClasspathElts != null) {
                for (ClasspathRelativePath childClasspathElt : currSingleton.childClasspathElts) {
                    ClasspathElement childSingleton = (ClasspathElement)classpathElementMap.get(childClasspathElt);
                    if (childSingleton == null || childSingleton.ioExceptionOnOpen) continue;
                    Scanner.findClasspathOrder(childSingleton, classpathElementMap, visitedClasspathElts, order);
                }
            }
        }
    }

    private static List<ClasspathElement> findClasspathOrder(List<ClasspathRelativePath> rawClasspathElements, ClasspathRelativePathToElementMap classpathElementMap) throws InterruptedException {
        HashSet<ClasspathElement> visitedClasspathElts = new HashSet<ClasspathElement>();
        ArrayList<ClasspathElement> order = new ArrayList<ClasspathElement>();
        for (ClasspathRelativePath toplevelClasspathElt : rawClasspathElements) {
            ClasspathElement toplevelSingleton = (ClasspathElement)classpathElementMap.get(toplevelClasspathElt);
            if (toplevelSingleton == null || toplevelSingleton.ioExceptionOnOpen) continue;
            Scanner.findClasspathOrder(toplevelSingleton, classpathElementMap, visitedClasspathElts, order);
        }
        return order;
    }

    private static List<ClassfileParserChunk> getClassfileParserChunks(List<ClasspathElement> classpathOrder) {
        LinkedList chunks = new LinkedList();
        for (ClasspathElement classpathElement : classpathOrder) {
            LinkedList<ClassfileParserChunk> chunksForClasspathElt = new LinkedList<ClassfileParserChunk>();
            int n = classpathElement.getNumClassfileMatches();
            if (n > 0) {
                int numChunks = (int)Math.ceil((float)n / 200.0f);
                float filesPerChunk = (float)n / (float)numChunks;
                for (int i = 0; i < numChunks; ++i) {
                    int classfileEndIdx;
                    int classfileStartIdx = (int)((float)i * filesPerChunk);
                    int n2 = classfileEndIdx = i < numChunks - 1 ? (int)((float)(i + 1) * filesPerChunk) : n;
                    if (classfileEndIdx <= classfileStartIdx) continue;
                    chunksForClasspathElt.add(new ClassfileParserChunk(classpathElement, classfileStartIdx, classfileEndIdx));
                }
            }
            chunks.add(chunksForClasspathElt);
        }
        ArrayList<ClassfileParserChunk> interleavedChunks = new ArrayList<ClassfileParserChunk>();
        while (!chunks.isEmpty()) {
            LinkedList<LinkedList> nextChunks = new LinkedList<LinkedList>();
            for (LinkedList linkedList : chunks) {
                if (linkedList.isEmpty()) continue;
                ClassfileParserChunk head = (ClassfileParserChunk)linkedList.remove();
                interleavedChunks.add(head);
                if (linkedList.isEmpty()) continue;
                nextChunks.add(linkedList);
            }
            chunks = nextChunks;
        }
        return interleavedChunks;
    }

    /*
     * Could not resolve type clashes
     * Iterators could be improved
     * Loose catch block
     */
    @Override
    public ScanResult call() throws InterruptedException, ExecutionException {
        final LogNode classpathFinderLog = this.log == null ? null : this.log.log("Finding classpath entries");
        try {
            try (NestedJarHandler nestedJarHandler = new NestedJarHandler(this.interruptionChecker, classpathFinderLog);){
                List<Throwable> matchProcessorExceptions;
                ScanResult scanResult;
                String currentDirPath;
                long scanStart = System.nanoTime();
                try {
                    currentDirPath = FastPathResolver.resolve(Paths.get("", new String[0]).toAbsolutePath().normalize().toRealPath(LinkOption.NOFOLLOW_LINKS).toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ArrayList<File> classpathElementFilesOrdered = new ArrayList<File>();
                List<String> rawClasspathElementPathStrs = new ClasspathFinder(this.scanSpec, classpathFinderLog).getRawClasspathElements();
                ArrayList<ClasspathRelativePath> rawClasspathElements = new ArrayList<ClasspathRelativePath>();
                for (String rawClasspathElementPathStr : rawClasspathElementPathStrs) {
                    ClasspathRelativePath classpathElt = new ClasspathRelativePath(currentDirPath, rawClasspathElementPathStr, nestedJarHandler);
                    rawClasspathElements.add(classpathElt);
                }
                final ClasspathRelativePathToElementMap classpathElementMap = new ClasspathRelativePathToElementMap(this.scanFiles, this.scanSpec, nestedJarHandler, this.interruptionChecker, classpathFinderLog);
                final Set knownJREPaths = Collections.newSetFromMap(new ConcurrentHashMap());
                final Set knownNonJREPaths = Collections.newSetFromMap(new ConcurrentHashMap());
                final Set knownRtJarPaths = Collections.newSetFromMap(new ConcurrentHashMap());
                try (WorkQueue<ClasspathRelativePath> workQueue = new WorkQueue<ClasspathRelativePath>(rawClasspathElements, new WorkQueue.WorkUnitProcessor<ClasspathRelativePath>(){

                    @Override
                    public void processWorkUnit(ClasspathRelativePath rawClasspathElt) throws Exception {
                        if (classpathElementMap.get(rawClasspathElt) != null) {
                            if (classpathFinderLog != null) {
                                classpathFinderLog.log("Ignoring duplicate classpath element: " + rawClasspathElt.getResolvedPath());
                            }
                        } else if (rawClasspathElt.isValidClasspathElement(Scanner.this.scanSpec, knownJREPaths, knownNonJREPaths, knownRtJarPaths, classpathFinderLog)) {
                            try {
                                classpathElementMap.createSingleton(rawClasspathElt);
                            }
                            catch (Exception e) {
                                classpathFinderLog.log("Classpath element " + rawClasspathElt + " is not valid (" + e + ") -- skipping");
                            }
                        }
                    }
                }, this.interruptionChecker, classpathFinderLog);){
                    classpathElementMap.setWorkQueue(workQueue);
                    workQueue.startWorkers(this.executorService, this.numParallelTasks - 1, classpathFinderLog);
                    workQueue.runWorkLoop();
                }
                List<ClasspathElement> classpathOrder = Scanner.findClasspathOrder(rawClasspathElements, classpathElementMap);
                HashSet<String> classpathRelativePathsFound = new HashSet<String>();
                for (ClasspathElement singleton : classpathOrder) {
                    classpathElementFilesOrdered.add(singleton.classpathElementFile);
                }
                if (!this.scanSpec.blacklistSystemJars()) {
                    for (String rtJarPath : knownRtJarPaths) {
                        classpathOrder.add(0, ClasspathElement.newInstance(new ClasspathRelativePath(currentDirPath, rtJarPath, nestedJarHandler), this.scanFiles, this.scanSpec, nestedJarHandler, null, this.interruptionChecker, classpathFinderLog));
                    }
                }
                if (this.log != null) {
                    LogNode logNode = this.log.log("Classpath element order:");
                    for (int i = 0; i < classpathOrder.size(); ++i) {
                        ClasspathElement classpathElt = classpathOrder.get(i);
                        logNode.log(i + ": " + classpathElt);
                    }
                }
                if (this.scanFiles) {
                    for (Object classpathElement : classpathOrder) {
                        ((ClasspathElement)classpathElement).maskFiles(classpathRelativePathsFound, this.log);
                    }
                    HashMap<File, Long> fileToLastModified = new HashMap<File, Long>();
                    for (ClasspathElement classpathElement : classpathOrder) {
                        fileToLastModified.putAll(classpathElement.fileToLastModified);
                    }
                    final ConcurrentLinkedQueue classInfoUnlinked = new ConcurrentLinkedQueue();
                    final ConcurrentHashMap stringInternMap = new ConcurrentHashMap();
                    try (final Recycler<ClassfileBinaryParser, RuntimeException> classfileBinaryParserRecycler = new Recycler<ClassfileBinaryParser, RuntimeException>(){

                        @Override
                        public ClassfileBinaryParser newInstance() {
                            return new ClassfileBinaryParser();
                        }
                    };
                         WorkQueue<ClassfileParserChunk> workQueue = new WorkQueue<ClassfileParserChunk>(Scanner.getClassfileParserChunks(classpathOrder), new WorkQueue.WorkUnitProcessor<ClassfileParserChunk>(){

                        @Override
                        public void processWorkUnit(ClassfileParserChunk chunk) throws InterruptedException, ExecutionException {
                            ClassfileBinaryParser classfileBinaryParser = null;
                            try {
                                classfileBinaryParser = (ClassfileBinaryParser)classfileBinaryParserRecycler.acquire();
                                chunk.classpathElement.parseClassfiles(classfileBinaryParser, chunk.classfileStartIdx, chunk.classfileEndIdx, stringInternMap, classInfoUnlinked, Scanner.this.log);
                            }
                            finally {
                                classfileBinaryParserRecycler.release(classfileBinaryParser);
                                classfileBinaryParser = null;
                            }
                        }
                    }, this.interruptionChecker, this.log);){
                        workQueue.startWorkers(this.executorService, this.numParallelTasks - 1, this.log);
                        workQueue.runWorkLoop();
                    }
                    LogNode classGraphLog = this.log == null ? null : this.log.log("Building class graph");
                    HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
                    for (ClassInfoUnlinked c : classInfoUnlinked) {
                        c.link(this.scanSpec, classNameToClassInfo, classGraphLog);
                    }
                    ClassGraphBuilder classGraphBuilder = new ClassGraphBuilder(this.scanSpec, classNameToClassInfo);
                    if (classGraphLog != null) {
                        classGraphLog.addElapsedTime();
                    }
                    scanResult = new ScanResult(this.scanSpec, classpathElementFilesOrdered, classGraphBuilder, fileToLastModified);
                    this.scanSpec.callMatchProcessors(scanResult, classpathOrder, classNameToClassInfo, this.interruptionChecker, this.log);
                } else {
                    scanResult = new ScanResult(this.scanSpec, classpathElementFilesOrdered, null, null);
                }
                if (this.log != null) {
                    this.log.log("Completed scan", System.nanoTime() - scanStart);
                }
                if ((matchProcessorExceptions = scanResult.getMatchProcessorExceptions()).size() > 0) {
                    if (this.log != null) {
                        this.log.log("Number of exceptions raised during classloading and/or while calling MatchProcessors: " + matchProcessorExceptions.size());
                    }
                    throw MatchProcessorException.newInstance(matchProcessorExceptions);
                }
                ScanResult scanResult2 = scanResult;
                return scanResult2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    private static class ClassfileParserChunk {
        private final ClasspathElement classpathElement;
        private final int classfileStartIdx;
        private final int classfileEndIdx;

        public ClassfileParserChunk(ClasspathElement classpathElementSingleton, int classfileStartIdx, int classfileEndIdx) {
            this.classpathElement = classpathElementSingleton;
            this.classfileStartIdx = classfileStartIdx;
            this.classfileEndIdx = classfileEndIdx;
        }
    }
}

