/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;

public class ClasspathFinder {
    static final String currDirPathStr = FileUtils.getCurrDirPathStr();
    private final List<RelativePath> rawClasspathElements;
    private final ClassLoader[] envClassLoaderOrder;

    private void findClassLoaderHandlerForClassLoaderAndParents(ClassLoader classLoader, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerEntries, AdditionOrderedSet<ClassLoader> foundClassLoaders, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrderOut, ScanSpec scanSpec, LogNode log) {
        if (foundClassLoaders.add(classLoader)) {
            boolean foundMatch = false;
            for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerEntries) {
                    for (String handledClassLoaderName : classLoaderHandlerRegistryEntry.handledClassLoaderNames) {
                        ClassLoaderHandler classLoaderHandler;
                        block15: {
                            if (!handledClassLoaderName.equals(c.getName())) continue;
                            classLoaderHandler = null;
                            try {
                                classLoaderHandler = classLoaderHandlerRegistryEntry.classLoaderHandlerClass.newInstance();
                            }
                            catch (IllegalAccessException | InstantiationException e) {
                                if (log == null) break block15;
                                log.log("Could not instantiate " + classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName(), e);
                            }
                        }
                        if (classLoaderHandler != null) {
                            ClassLoaderHandler.DelegationOrder delegationOrder = classLoaderHandler.getDelegationOrder(classLoader);
                            ClassLoader parent = classLoader.getParent();
                            if (log != null && parent != null) {
                                log.log(classLoader + " delegates to parent " + parent + " with order " + (Object)((Object)delegationOrder));
                            }
                            switch (delegationOrder) {
                                case PARENT_FIRST: {
                                    if (parent != null) {
                                        this.findClassLoaderHandlerForClassLoaderAndParents(parent, allClassLoaderHandlerEntries, foundClassLoaders, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, scanSpec, log);
                                    }
                                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                                    break;
                                }
                                case PARENT_LAST: {
                                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                                    if (parent == null) break;
                                    this.findClassLoaderHandlerForClassLoaderAndParents(parent, allClassLoaderHandlerEntries, foundClassLoaders, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, scanSpec, log);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("Unknown delegation order");
                                }
                            }
                            if (log != null) {
                                log.log("ClassLoader " + classLoader + " will be handled by " + classLoaderHandler);
                            }
                        }
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) continue;
                    break;
                }
                if (foundMatch) break;
            }
            if (!foundMatch && log != null) {
                log.log("Could not find a ClassLoaderHandler that can handle " + classLoader + " -- please report this at https://github.com/lukehutch/fast-classpath-scanner/issues");
            }
        }
    }

    ClasspathFinder(ScanSpec scanSpec, NestedJarHandler nestedJarHandler, LogNode log) {
        LogNode classpathFinderLog = log == null ? null : log.log("Finding ClassLoaders");
        this.envClassLoaderOrder = ClassLoaderFinder.findEnvClassLoaders(scanSpec, classpathFinderLog);
        ClasspathOrder classpathOrder = new ClasspathOrder(nestedJarHandler);
        ClasspathOrder ignoredClasspathOrder = new ClasspathOrder(nestedJarHandler);
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders != null && classpathFinderLog != null) {
                classpathFinderLog.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = classpathFinderLog == null ? null : classpathFinderLog.log("Overriding classpath");
            classpathOrder.addClasspathElements(scanSpec.overrideClasspath, this.envClassLoaderOrder, overrideLog);
            if (overrideLog != null) {
                classpathFinderLog.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
        } else {
            String[] stringArray;
            LogNode classLoaderClasspathLog;
            ClassLoaderHandler classLoaderHandler;
            List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerEntries;
            String rtJarPath;
            if (!scanSpec.blacklistSystemJars() && (rtJarPath = JarUtils.getRtJarPath()) != null) {
                classpathOrder.addClasspathElement(rtJarPath, this.envClassLoaderOrder, classpathFinderLog);
            }
            if (scanSpec.extraClassLoaderHandlers.isEmpty()) {
                allClassLoaderHandlerEntries = ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS;
            } else {
                allClassLoaderHandlerEntries = new ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>(scanSpec.extraClassLoaderHandlers);
                allClassLoaderHandlerEntries.addAll(ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS);
            }
            if (classpathFinderLog != null) {
                LogNode classLoaderHandlerLog = classpathFinderLog.log("ClassLoaderHandlers:");
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerEntries) {
                    classLoaderHandlerLog.log(classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName());
                }
            }
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrder = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrder = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            for (ClassLoader envClassLoader : this.envClassLoaderOrder) {
                if (!scanSpec.blacklistSystemJars() || !envClassLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) {
                    this.findClassLoaderHandlerForClassLoaderAndParents(envClassLoader, allClassLoaderHandlerEntries, new AdditionOrderedSet<ClassLoader>(), classLoaderAndHandlerOrder, ignoredClassLoaderAndHandlerOrder, scanSpec, classpathFinderLog);
                    continue;
                }
                if (classpathFinderLog == null) continue;
                classpathFinderLog.log("Skipping system classloader " + envClassLoader.getClass().getName());
            }
            for (AbstractMap.SimpleEntry simpleEntry : classLoaderAndHandlerOrder) {
                ClassLoader classLoader = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Finding classpath elements in ClassLoader " + classLoader);
                try {
                    classLoaderHandler.handle(scanSpec, classLoader, classpathOrder, classLoaderClasspathLog);
                }
                catch (Throwable e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            for (AbstractMap.SimpleEntry simpleEntry : ignoredClassLoaderAndHandlerOrder) {
                ClassLoader classLoader = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Will not scan the following classpath elements from ignored ClassLoader " + classLoader);
                try {
                    classLoaderHandler.handle(scanSpec, classLoader, ignoredClasspathOrder, classLoaderClasspathLog);
                }
                catch (Throwable e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            if (scanSpec.overrideClassLoaders == null && scanSpec.overrideClasspath == null && (stringArray = JarUtils.smartPathSplit(System.getProperty("java.class.path"))).length > 0) {
                LogNode logNode = classpathFinderLog == null ? null : classpathFinderLog.log("Getting classpath entries from java.class.path");
                ClasspathOrder sysPropOrder = new ClasspathOrder(nestedJarHandler);
                for (String pathElement : stringArray) {
                    RelativePath relativePath = new RelativePath(currDirPathStr, pathElement, this.envClassLoaderOrder, nestedJarHandler);
                    boolean alreadyInClassloaderPath = classpathOrder.get().contains(relativePath);
                    boolean alreadyInIgnoredClassloaderPath = ignoredClasspathOrder.get().contains(relativePath);
                    if (!alreadyInClassloaderPath && !alreadyInIgnoredClassloaderPath) {
                        sysPropOrder.addClasspathElement(pathElement, this.envClassLoaderOrder, logNode);
                        continue;
                    }
                    if (alreadyInClassloaderPath && !alreadyInIgnoredClassloaderPath) {
                        sysPropOrder.addClasspathElement(pathElement, this.envClassLoaderOrder, logNode);
                        continue;
                    }
                    if (!alreadyInIgnoredClassloaderPath || logNode == null) continue;
                    logNode.log("Found classpath element in java.class.path that will be ignored, since it is also found in an ignored parent classloader: " + pathElement);
                }
                classpathOrder.addClasspathElements(sysPropOrder);
            }
        }
        this.rawClasspathElements = classpathOrder.get().toList();
    }

    public List<RelativePath> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    public ClassLoader[] getClassLoaderOrder() {
        return this.envClassLoaderOrder;
    }
}

