/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;

public class ClasspathOrder {
    final NestedJarHandler nestedJarHandler;
    private final AdditionOrderedSet<RelativePath> classpathOrder = new AdditionOrderedSet();

    ClasspathOrder(NestedJarHandler nestedJarHandler) {
        this.nestedJarHandler = nestedJarHandler;
    }

    public AdditionOrderedSet<RelativePath> get() {
        return this.classpathOrder;
    }

    public boolean addClasspathElement(String pathElement, ClassLoader[] classLoaders, LogNode log) {
        if (pathElement == null || pathElement.isEmpty()) {
            return false;
        }
        if (pathElement.endsWith("*")) {
            if (pathElement.length() == 1 || pathElement.length() > 2 && pathElement.charAt(pathElement.length() - 1) == '*' && pathElement.charAt(pathElement.length() - 2) == File.separatorChar) {
                try {
                    File classpathEltParentDir = new RelativePath(ClasspathFinder.currDirPathStr, pathElement.substring(0, pathElement.length() - 1), classLoaders, this.nestedJarHandler).getFile();
                    if (!classpathEltParentDir.exists()) {
                        if (log != null) {
                            log.log("Directory does not exist for wildcard classpath element: " + pathElement);
                        }
                        return false;
                    }
                    if (!classpathEltParentDir.isDirectory()) {
                        if (log != null) {
                            log.log("Wildcard classpath element is not a directory: " + pathElement);
                        }
                        return false;
                    }
                    LogNode subLog = log == null ? null : log.log("Including wildcard classpath element: " + pathElement);
                    for (File fileInDir : classpathEltParentDir.listFiles()) {
                        String name = fileInDir.getName();
                        if (name.equals(".") || name.equals("..")) continue;
                        this.addClasspathElement(fileInDir.getPath(), classLoaders, subLog);
                    }
                    return true;
                }
                catch (IOException e) {
                    if (log != null) {
                        log.log("Could not add wildcard classpath element " + pathElement + " : " + e);
                    }
                    return false;
                }
            }
            if (log != null) {
                log.log("Wildcard classpath elements can only end with \"" + File.separatorChar + "*\", can't have a partial name and then a wildcard: " + pathElement);
            }
            return false;
        }
        RelativePath classpathEltPath = new RelativePath(ClasspathFinder.currDirPathStr, pathElement, classLoaders, this.nestedJarHandler);
        if (this.classpathOrder.add(classpathEltPath)) {
            if (log != null) {
                log.log("Found classpath element: " + classpathEltPath);
            }
        } else if (log != null) {
            log.log("Ignoring duplicate classpath element: " + classpathEltPath);
        }
        return true;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader[] classLoaders, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        String[] parts = JarUtils.smartPathSplit(pathStr);
        if (parts.length == 0) {
            return false;
        }
        for (String pathElement : parts) {
            this.addClasspathElement(pathElement, classLoaders, log);
        }
        return true;
    }

    public boolean addClasspathElement(String pathElement, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElement(pathElement, new ClassLoader[]{classLoader}, log);
    }

    public boolean addClasspathElementObject(Object pathObject, ClassLoader classLoader, LogNode log) {
        boolean valid = false;
        if (pathObject != null) {
            if (pathObject instanceof String) {
                valid |= this.addClasspathElements((String)pathObject, classLoader, log);
            } else if (pathObject instanceof Iterable) {
                for (Object p : (Iterable)pathObject) {
                    if (p == null) continue;
                    valid |= this.addClasspathElements(p.toString(), classLoader, log);
                }
            } else {
                Class<?> valClass = pathObject.getClass();
                if (valClass.isArray()) {
                    int n = Array.getLength(pathObject);
                    for (int j = 0; j < n; ++j) {
                        Object elt = Array.get(pathObject, j);
                        if (elt == null) continue;
                        valid |= this.addClasspathElementObject(elt, classLoader, log);
                    }
                } else {
                    valid |= this.addClasspathElements(pathObject.toString(), classLoader, log);
                }
            }
        }
        return valid;
    }

    public boolean addClasspathElements(String pathStr, ClassLoader classLoader, LogNode log) {
        return this.addClasspathElements(pathStr, new ClassLoader[]{classLoader}, log);
    }

    boolean addClasspathElements(ClasspathOrder subsequentOrder) {
        return this.classpathOrder.addAll(subsequentOrder.classpathOrder);
    }
}

