/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.TypeParser;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MethodInfo
extends ScanResult.InfoObject
implements Comparable<MethodInfo> {
    private final String className;
    private final String methodName;
    private final int modifiers;
    private final String typeDescriptorInternal;
    private TypeParser.MethodSignature methodSignatureInternal;
    private final String typeDescriptorHumanReadable;
    private TypeParser.MethodSignature methodSignatureHumanReadable;
    private final String[] parameterNames;
    private final int[] parameterAccessFlagsInternal;
    private int[] parameterAccessFlags;
    final AnnotationInfo[][] parameterAnnotationInfo;
    final List<AnnotationInfo> annotationInfo;
    private ScanResult scanResult;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final TypeParser.TypeSignature[] EMPTY_TYPE_SIGNATURE_ARRAY = new TypeParser.TypeSignature[0];
    private static final TypeParser.TypeParameter[] EMPTY_TYPE_PARAMETER_ARRAY = new TypeParser.TypeParameter[0];
    private static final TypeParser.ClassTypeOrTypeVariableSignature[] EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY = new TypeParser.ClassTypeOrTypeVariableSignature[0];
    private static final Class<?>[] EMPTY_CLASS_REF_ARRAY = new Class[0];

    @Override
    void setScanResult(ScanResult scanResult) {
        int i;
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (i = 0; i < this.annotationInfo.size(); ++i) {
                AnnotationInfo ai = this.annotationInfo.get(i);
                ai.setScanResult(scanResult);
            }
        }
        if (this.parameterAnnotationInfo != null) {
            for (i = 0; i < this.parameterAnnotationInfo.length; ++i) {
                AnnotationInfo[] pai = this.parameterAnnotationInfo[i];
                if (pai == null) continue;
                for (AnnotationInfo ai : pai) {
                    ai.setScanResult(scanResult);
                }
            }
        }
    }

    public MethodInfo(String className, String methodName, int modifiers, String typeDescriptorInternal, String typeDescriptorHumanReadable, String[] parameterNames, int[] parameterAccessFlagsInternal, List<AnnotationInfo> methodAnnotationInfo, AnnotationInfo[][] parameterAnnotationInfo) {
        this.className = className;
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.typeDescriptorInternal = typeDescriptorInternal;
        this.typeDescriptorHumanReadable = typeDescriptorHumanReadable;
        this.parameterNames = parameterNames;
        this.parameterAccessFlagsInternal = parameterAccessFlagsInternal;
        this.parameterAnnotationInfo = parameterAnnotationInfo;
        this.annotationInfo = methodAnnotationInfo == null || methodAnnotationInfo.isEmpty() ? Collections.emptyList() : methodAnnotationInfo;
    }

    public String getModifiers() {
        return TypeParser.modifiersToString(this.getAccessFlags(), true);
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getAccessFlags() {
        return this.modifiers;
    }

    public String getTypeDescriptor() {
        return this.typeDescriptorHumanReadable;
    }

    public String getTypeDescriptorInternal() {
        return this.typeDescriptorInternal;
    }

    public TypeParser.MethodSignature getTypeSignature() {
        if (this.typeDescriptorHumanReadable == null) {
            return this.getTypeSignatureInternal();
        }
        if (this.methodSignatureHumanReadable == null) {
            this.methodSignatureHumanReadable = TypeParser.parseMethodSignature(this.typeDescriptorHumanReadable);
        }
        return this.methodSignatureHumanReadable;
    }

    public TypeParser.MethodSignature getTypeSignatureInternal() {
        if (this.methodSignatureInternal == null) {
            this.methodSignatureInternal = TypeParser.parseMethodSignature(this.typeDescriptorInternal);
        }
        return this.methodSignatureInternal;
    }

    public TypeParser.MethodSignature getTypeSignatureUnified() {
        if (this.getTypeSignature() == null) {
            return this.getTypeSignatureInternal();
        }
        if (this.getTypeSignatureInternal() == null) {
            return this.getTypeSignature();
        }
        return TypeParser.merge(this.getTypeSignature(), this.getTypeSignatureInternal(), this.getParameterAccessFlagsInternal());
    }

    public TypeParser.TypeSignature getReturnTypeSignature() {
        return this.getTypeSignature().resultType;
    }

    public String getReturnTypeStr() {
        return this.getReturnTypeSignature().toString();
    }

    public Class<?> getReturnType() throws IllegalArgumentException {
        return this.getReturnTypeSignature().instantiate(this.scanResult);
    }

    private static String[] toStringArray(List<?> list) {
        if (list.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).toString();
        }
        return stringArray;
    }

    private static Class<?>[] toClassRefs(List<? extends TypeParser.TypeSignature> typeSignatures, ScanResult scanResult) {
        if (typeSignatures.size() == 0) {
            return EMPTY_CLASS_REF_ARRAY;
        }
        Class[] classRefArray = new Class[typeSignatures.size()];
        for (int i = 0; i < typeSignatures.size(); ++i) {
            classRefArray[i] = typeSignatures.get(i).instantiate(scanResult);
        }
        return classRefArray;
    }

    private static TypeParser.TypeSignature[] toTypeSignatureArray(List<? extends TypeParser.TypeSignature> typeSignatures) {
        if (typeSignatures.size() == 0) {
            return EMPTY_TYPE_SIGNATURE_ARRAY;
        }
        return typeSignatures.toArray(new TypeParser.TypeSignature[typeSignatures.size()]);
    }

    private static TypeParser.ClassTypeOrTypeVariableSignature[] toTypeOrTypeVariableSignatureArray(List<? extends TypeParser.ClassTypeOrTypeVariableSignature> typeSignatures) {
        if (typeSignatures.size() == 0) {
            return EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY;
        }
        return typeSignatures.toArray(new TypeParser.ClassTypeOrTypeVariableSignature[typeSignatures.size()]);
    }

    private static TypeParser.TypeParameter[] toTypeParameterArray(List<? extends TypeParser.TypeParameter> typeParameters) {
        if (typeParameters.size() == 0) {
            return EMPTY_TYPE_PARAMETER_ARRAY;
        }
        return typeParameters.toArray(new TypeParser.TypeParameter[typeParameters.size()]);
    }

    public TypeParser.TypeSignature[] getParameterTypeSignatures() {
        return MethodInfo.toTypeSignatureArray(this.getTypeSignature().paramTypes);
    }

    public Class<?>[] getParameterTypes() throws IllegalArgumentException {
        return MethodInfo.toClassRefs(this.getTypeSignature().paramTypes, this.scanResult);
    }

    public String[] getParameterTypeStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().paramTypes);
    }

    public TypeParser.ClassTypeOrTypeVariableSignature[] getThrowsTypeSignatures() {
        return MethodInfo.toTypeOrTypeVariableSignatureArray(this.getTypeSignature().throwsSignatures);
    }

    public Class<?>[] getThrowsTypes() {
        return MethodInfo.toClassRefs(this.getTypeSignature().throwsSignatures, this.scanResult);
    }

    public String[] getThrowsTypeStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().throwsSignatures);
    }

    public TypeParser.TypeParameter[] getTypeParameters() {
        return MethodInfo.toTypeParameterArray(this.getTypeSignature().typeParameters);
    }

    public String[] getTypeParameterStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().typeParameters);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int[] getParameterAccessFlags() {
        if (this.parameterAccessFlagsInternal == null) {
            return null;
        }
        if (this.parameterAccessFlags == null) {
            int i;
            int numNonSyntheticParams = 0;
            for (i = 0; i < this.parameterAccessFlagsInternal.length; ++i) {
                if ((this.parameterAccessFlagsInternal[i] & 0x1000) != 0) continue;
                ++numNonSyntheticParams;
            }
            this.parameterAccessFlags = new int[numNonSyntheticParams];
            int j = 0;
            for (i = 0; i < this.parameterAccessFlagsInternal.length; ++i) {
                if ((this.parameterAccessFlagsInternal[i] & 0x1000) != 0) continue;
                this.parameterAccessFlags[j++] = this.parameterAccessFlagsInternal[i];
            }
        }
        return this.parameterAccessFlags;
    }

    public int[] getParameterAccessFlagsInternal() {
        return this.parameterAccessFlagsInternal;
    }

    public String[] getParameterModifiers() {
        if (this.parameterAccessFlagsInternal == null) {
            return null;
        }
        String[] parameterModifierStrs = new String[this.parameterAccessFlagsInternal.length];
        for (int i = 0; i < this.parameterAccessFlagsInternal.length; ++i) {
            parameterModifierStrs[i] = TypeParser.modifiersToString(this.parameterAccessFlagsInternal[i], false);
        }
        return parameterModifierStrs;
    }

    public String[][] getParameterAnnotationNames() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        String[][] parameterAnnotationNames = new String[this.parameterAnnotationInfo.length][];
        for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
            parameterAnnotationNames[i] = AnnotationInfo.getUniqueAnnotationNamesSorted(this.parameterAnnotationInfo[i]);
        }
        return parameterAnnotationNames;
    }

    public Class<?>[][] getParameterAnnotationTypes() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        String[][] parameterAnnotationNames = this.getParameterAnnotationNames();
        Class[][] parameterAnnotationTypes = new Class[parameterAnnotationNames.length][];
        for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
            parameterAnnotationTypes[i] = new Class[parameterAnnotationNames[i].length];
            for (int j = 0; j < parameterAnnotationNames[i].length; ++j) {
                parameterAnnotationTypes[i][j] = this.scanResult.classNameToClassRef(parameterAnnotationNames[i][j]);
            }
        }
        return parameterAnnotationTypes;
    }

    public AnnotationInfo[][] getParameterAnnotationInfo() {
        return this.parameterAnnotationInfo;
    }

    public List<String> getAnnotationNames() {
        return Arrays.asList(AnnotationInfo.getUniqueAnnotationNamesSorted(this.annotationInfo));
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationInfo == null || this.annotationInfo.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.getAnnotationNames()) {
            annotationClassRefs.add(this.scanResult.classNameToClassRef(annotationName));
        }
        return annotationClassRefs;
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.className.equals(other.className) && this.typeDescriptorInternal.equals(other.typeDescriptorInternal) && this.methodName.equals(other.methodName);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.typeDescriptorInternal.hashCode() * 11 + this.className.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.className.compareTo(other.className);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.methodName.compareTo(other.methodName);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptorInternal.compareTo(other.typeDescriptorInternal);
    }

    public String toString() {
        return this.getTypeSignatureUnified().toString(this.annotationInfo, this.modifiers, this.isConstructor(), this.methodName, this.isVarArgs(), this.parameterNames, this.parameterAccessFlagsInternal, this.parameterAnnotationInfo);
    }
}

