/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TypeParser {
    public static final int MODIFIER_SYNTHETIC = 4096;
    public static final int MODIFIER_MANDATED = 32768;

    public static MethodSignature merge(MethodSignature methodTypeSignature, MethodSignature methodTypeSignatureInternal, int[] parameterAccessFlags) {
        List<ClassTypeOrTypeVariableSignature> mergedThrowsSignatures;
        ArrayList<TypeSignature> mergedParamTypes;
        if (methodTypeSignature == null || methodTypeSignatureInternal == null) {
            throw new IllegalArgumentException("Signatures must be non-null");
        }
        if (!methodTypeSignatureInternal.typeParameters.isEmpty()) {
            throw new IllegalArgumentException("typeSignatureInternal.typeParameters should be empty");
        }
        if (!methodTypeSignatureInternal.resultType.equalsIgnoringTypeParams(methodTypeSignature.resultType)) {
            methodTypeSignatureInternal.resultType.equalsIgnoringTypeParams(methodTypeSignature.resultType);
            throw new IllegalArgumentException("Result types could not be reconciled: " + methodTypeSignatureInternal.resultType + " vs. " + methodTypeSignature.resultType);
        }
        if (parameterAccessFlags != null && parameterAccessFlags.length != methodTypeSignatureInternal.paramTypes.size()) {
            throw new IllegalArgumentException("Parameter arity mismatch between access flags and internal param types");
        }
        if (parameterAccessFlags == null) {
            if (methodTypeSignature.paramTypes.size() != methodTypeSignatureInternal.paramTypes.size()) {
                throw new IllegalArgumentException("Unexpected mismatch in method paramTypes arity");
            }
            mergedParamTypes = methodTypeSignature.paramTypes;
        } else {
            mergedParamTypes = new ArrayList(methodTypeSignatureInternal.paramTypes.size());
            int paramIdx = 0;
            for (int internalParamIdx = 0; internalParamIdx < methodTypeSignatureInternal.paramTypes.size(); ++internalParamIdx) {
                TypeSignature paramTypeSignatureInternal;
                TypeSignature paramTypeSignature;
                if ((parameterAccessFlags[internalParamIdx] & 0x1000) != 0) {
                    mergedParamTypes.add(methodTypeSignatureInternal.paramTypes.get(internalParamIdx));
                    continue;
                }
                if (paramIdx == methodTypeSignature.paramTypes.size()) {
                    throw new IllegalArgumentException("Ran out of parameters in programmer-visible type signature");
                }
                if (!(paramTypeSignature = methodTypeSignature.paramTypes.get(paramIdx++)).equalsIgnoringTypeParams(paramTypeSignatureInternal = methodTypeSignatureInternal.paramTypes.get(internalParamIdx))) {
                    throw new IllegalArgumentException("Corresponding type parameters in type signatures do not refer to the same bare types: " + paramTypeSignature + " [from method signature " + methodTypeSignature + "] vs. " + paramTypeSignatureInternal + " [from method signature " + methodTypeSignatureInternal + "]");
                }
                mergedParamTypes.add(paramTypeSignature);
            }
            if (paramIdx < methodTypeSignature.paramTypes.size()) {
                throw new IllegalArgumentException("Parameter arity mismatch between internal and programmer-visible type signature");
            }
        }
        if (methodTypeSignature.throwsSignatures.isEmpty()) {
            mergedThrowsSignatures = methodTypeSignatureInternal.throwsSignatures;
        } else if (methodTypeSignatureInternal.throwsSignatures.isEmpty() || methodTypeSignature.throwsSignatures.equals(methodTypeSignatureInternal.throwsSignatures)) {
            mergedThrowsSignatures = methodTypeSignature.throwsSignatures;
        } else {
            AdditionOrderedSet<ClassTypeOrTypeVariableSignature> sigSet = new AdditionOrderedSet<ClassTypeOrTypeVariableSignature>(methodTypeSignature.throwsSignatures);
            sigSet.addAll(methodTypeSignatureInternal.throwsSignatures);
            mergedThrowsSignatures = sigSet.toList();
        }
        return new MethodSignature(methodTypeSignature.typeParameters, mergedParamTypes, methodTypeSignature.resultType, mergedThrowsSignatures);
    }

    public static ClassSignature merge(ClassSignature classSignature0, ClassSignature classSignature1) {
        List<TypeParameter> allTypeParams;
        List<ClassTypeSignature> allSuperinterfaces;
        ClassTypeSignature superclassSig;
        if (classSignature0.superclassSignature.className.equals("java.lang.Object")) {
            superclassSig = classSignature1.superclassSignature;
        } else if (classSignature1.superclassSignature.className.equals("java.lang.Object")) {
            superclassSig = classSignature0.superclassSignature;
        } else {
            throw new IllegalArgumentException("A class and its auxiliary class have different superclasses: " + classSignature0 + " ; " + classSignature1);
        }
        if (classSignature0.superinterfaceSignatures.isEmpty()) {
            allSuperinterfaces = classSignature1.superinterfaceSignatures;
        } else if (classSignature1.superinterfaceSignatures.isEmpty()) {
            allSuperinterfaces = classSignature0.superinterfaceSignatures;
        } else {
            AdditionOrderedSet<ClassTypeSignature> superinterfacesUniq = new AdditionOrderedSet<ClassTypeSignature>(classSignature0.superinterfaceSignatures);
            superinterfacesUniq.addAll(classSignature1.superinterfaceSignatures);
            allSuperinterfaces = superinterfacesUniq.toList();
        }
        if (classSignature0.typeParameters.isEmpty()) {
            allTypeParams = classSignature1.typeParameters;
        } else if (classSignature1.typeParameters.isEmpty()) {
            allTypeParams = classSignature0.typeParameters;
        } else {
            AdditionOrderedSet<TypeParameter> typeParamsUniq = new AdditionOrderedSet<TypeParameter>(classSignature0.typeParameters);
            typeParamsUniq.addAll(classSignature1.typeParameters);
            allTypeParams = typeParamsUniq.toList();
        }
        return new ClassSignature(allTypeParams, superclassSig, allSuperinterfaces);
    }

    public static String modifiersToString(int modifiers, boolean isMethod) {
        StringBuilder buf = new StringBuilder();
        TypeParser.modifiersToString(modifiers, isMethod, buf);
        return buf.toString();
    }

    public static void modifiersToString(int modifiers, boolean isMethod, StringBuilder buf) {
        if ((modifiers & 1) != 0) {
            buf.append("public");
        } else if ((modifiers & 4) != 0) {
            buf.append("protected");
        } else if ((modifiers & 2) != 0) {
            buf.append("private");
        }
        if ((modifiers & 0x400) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("abstract");
        }
        if ((modifiers & 8) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("static");
        }
        if ((modifiers & 0x10) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("final");
        }
        if (!isMethod && (modifiers & 0x80) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("transient");
        } else if ((modifiers & 0x40) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (!isMethod) {
                buf.append("volatile");
            } else {
                buf.append("bridge");
            }
        }
        if (!isMethod && (modifiers & 0x1000) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synthetic");
        }
        if ((modifiers & 0x20) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synchronized");
        }
        if ((modifiers & 0x100) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("native");
        }
        if ((modifiers & 0x800) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("strictfp");
        }
    }

    public static MethodSignature parseMethodSignature(String typeDescriptor) {
        return TypeParser.parseMethodSignature(null, typeDescriptor);
    }

    public static MethodSignature parseMethodSignature(ClassInfo classInfo, String typeDescriptor) {
        ParseState parseState = new ParseState(typeDescriptor);
        try {
            List<ClassTypeOrTypeVariableSignature> throwsSignatures;
            List typeParameters = TypeParameter.parseTypeParameters(parseState);
            parseState.expect('(');
            ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>();
            while (parseState.peek() != ')') {
                if (!parseState.hasMore()) {
                    throw new ParseException();
                }
                TypeSignature paramType = TypeSignature.parseJavaTypeSignature(parseState);
                if (paramType == null) {
                    throw new ParseException();
                }
                paramTypes.add(paramType);
            }
            parseState.expect(')');
            TypeSignature resultType = TypeSignature.parseJavaTypeSignature(parseState);
            if (resultType == null) {
                throw new ParseException();
            }
            if (parseState.peek() == '^') {
                throwsSignatures = new ArrayList();
                while (parseState.peek() == '^') {
                    parseState.expect('^');
                    ClassTypeSignature classTypeSignature = ClassTypeSignature.parseClassTypeSignature(parseState);
                    if (classTypeSignature != null) {
                        throwsSignatures.add(classTypeSignature);
                        continue;
                    }
                    TypeVariableSignature typeVariableSignature = TypeVariableSignature.parseTypeVariableSignature(parseState);
                    if (typeVariableSignature != null) {
                        throwsSignatures.add(classTypeSignature);
                        continue;
                    }
                    throw new ParseException();
                }
            } else {
                throwsSignatures = Collections.emptyList();
            }
            if (parseState.hasMore()) {
                throw new IllegalArgumentException("Extra characters at end of type descriptor: " + parseState);
            }
            MethodSignature methodSignature = new MethodSignature(typeParameters, paramTypes, resultType, throwsSignatures);
            for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                typeVariableSignature.methodSignature = methodSignature;
            }
            if (classInfo != null) {
                ClassSignature classSignature = classInfo.getTypeSignature();
                for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                    typeVariableSignature.classSignature = classSignature;
                }
            }
            return methodSignature;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type signature could not be parsed: " + parseState, e);
        }
    }

    public static ClassSignature parseClassSignature(String typeDescriptor) {
        ParseState parseState = new ParseState(typeDescriptor);
        try {
            List<ClassTypeSignature> superinterfaceSignatures;
            List typeParameters = TypeParameter.parseTypeParameters(parseState);
            ClassTypeSignature superclassSignature = ClassTypeSignature.parseClassTypeSignature(parseState);
            if (parseState.hasMore()) {
                superinterfaceSignatures = new ArrayList();
                while (parseState.hasMore()) {
                    ClassTypeSignature superinterfaceSignature = ClassTypeSignature.parseClassTypeSignature(parseState);
                    if (superinterfaceSignature == null) {
                        throw new ParseException();
                    }
                    superinterfaceSignatures.add(superinterfaceSignature);
                }
            } else {
                superinterfaceSignatures = Collections.emptyList();
            }
            if (parseState.hasMore()) {
                throw new IllegalArgumentException("Extra characters at end of type descriptor: " + parseState);
            }
            ClassSignature classSignature = new ClassSignature(typeParameters, superclassSignature, superinterfaceSignatures);
            for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                typeVariableSignature.classSignature = classSignature;
            }
            return classSignature;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type signature could not be parsed: " + parseState, e);
        }
    }

    public static TypeSignature parseTypeSignature(String typeDescriptor) {
        TypeSignature typeSignature;
        ParseState parseState = new ParseState(typeDescriptor);
        try {
            typeSignature = TypeSignature.parseJavaTypeSignature(parseState);
            if (typeSignature == null) {
                throw new ParseException();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type signature could not be parsed: " + parseState, e);
        }
        if (parseState.hasMore()) {
            throw new IllegalArgumentException("Extra characters at end of type descriptor: " + parseState);
        }
        return typeSignature;
    }

    private static class ParseState {
        private final String string;
        private int position;
        private final StringBuilder token = new StringBuilder();
        private final List<TypeVariableSignature> typeVariableSignatures = new ArrayList<TypeVariableSignature>();

        public ParseState(String string) {
            this.string = string;
        }

        public void addTypeVariableSignature(TypeVariableSignature typeVariableSignature) {
            this.typeVariableSignatures.add(typeVariableSignature);
        }

        public List<TypeVariableSignature> getTypeVariableSignatures() {
            return this.typeVariableSignatures;
        }

        public char getc() {
            if (this.position >= this.string.length()) {
                return '\u0000';
            }
            return this.string.charAt(this.position++);
        }

        public char peek() {
            return this.position == this.string.length() ? (char)'\u0000' : this.string.charAt(this.position);
        }

        public boolean peekMatches(String strMatch) {
            return this.string.regionMatches(this.position, strMatch, 0, strMatch.length());
        }

        public void next() {
            ++this.position;
        }

        public void advance(int n) {
            this.position += n;
        }

        public boolean hasMore() {
            return this.position < this.string.length();
        }

        public void expect(char c) {
            char next = this.getc();
            if (next != c) {
                throw new IllegalArgumentException("Got character '" + (char)next + "', expected '" + c + "' in string: " + this);
            }
        }

        public void appendToToken(String str) {
            this.token.append(str);
        }

        public void appendToToken(char c) {
            this.token.append(c);
        }

        public String currToken() {
            String tok = this.token.toString();
            this.token.setLength(0);
            return tok;
        }

        public boolean parseIdentifier(char separator, char separatorReplace) throws ParseException {
            boolean consumedChar = false;
            while (this.hasMore()) {
                char c = this.peek();
                if (c == separator) {
                    this.appendToToken(separatorReplace);
                    this.next();
                    consumedChar = true;
                    continue;
                }
                if (c == ';' || c == '[' || c == '<' || c == '>' || c == ':' || c == '/' || c == '.') break;
                this.appendToToken(c);
                this.next();
                consumedChar = true;
            }
            return consumedChar;
        }

        public boolean parseIdentifier() throws ParseException {
            return this.parseIdentifier('\u0000', '\u0000');
        }

        public String toString() {
            return this.string + " (position: " + this.position + "; token: \"" + this.token + "\")";
        }
    }

    private static class ParseException
    extends Exception {
        private ParseException() {
        }
    }

    public static class ClassSignature {
        public final List<TypeParameter> typeParameters;
        public final ClassTypeSignature superclassSignature;
        public final List<ClassTypeSignature> superinterfaceSignatures;

        public ClassSignature(List<TypeParameter> typeParameters, ClassTypeSignature superclassSignature, List<ClassTypeSignature> superinterfaceSignatures) {
            this.typeParameters = typeParameters;
            this.superclassSignature = superclassSignature;
            this.superinterfaceSignatures = superinterfaceSignatures;
        }

        public int hashCode() {
            return this.typeParameters.hashCode() + this.superclassSignature.hashCode() * 7 + this.superinterfaceSignatures.hashCode() * 15;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassSignature)) {
                return false;
            }
            ClassSignature o = (ClassSignature)obj;
            return o.typeParameters.equals(this.typeParameters) && o.superclassSignature.equals(this.superclassSignature) && o.superinterfaceSignatures.equals(this.superinterfaceSignatures);
        }

        public String toString(int modifiers, boolean isAnnotation, boolean isInterface, String className) {
            String superSig;
            int i;
            StringBuilder buf = new StringBuilder();
            if (modifiers != 0) {
                TypeParser.modifiersToString(modifiers, false, buf);
            }
            if (!this.typeParameters.isEmpty()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append('<');
                for (i = 0; i < this.typeParameters.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.typeParameters.get(i).toString());
                }
                buf.append('>');
            }
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(isAnnotation ? "@interface" : (isInterface ? "interface" : ((modifiers & 0x4000) != 0 ? "enum" : "class")));
            if (className != null) {
                buf.append(' ');
                buf.append(className);
            }
            if (this.superclassSignature != null && !(superSig = this.superclassSignature.toString()).equals("java.lang.Object")) {
                buf.append(" extends ");
                buf.append(superSig);
            }
            if (!this.superinterfaceSignatures.isEmpty()) {
                buf.append(" implements");
                for (i = 0; i < this.superinterfaceSignatures.size(); ++i) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(' ');
                    buf.append(this.superinterfaceSignatures.get(i).toString());
                }
            }
            return buf.toString();
        }

        public String toString() {
            return this.toString(0, false, false, null);
        }
    }

    public static class MethodSignature {
        public final List<TypeParameter> typeParameters;
        public final List<TypeSignature> paramTypes;
        public final TypeSignature resultType;
        public final List<ClassTypeOrTypeVariableSignature> throwsSignatures;

        public MethodSignature(List<TypeParameter> typeParameters, List<TypeSignature> paramTypes, TypeSignature resultType, List<ClassTypeOrTypeVariableSignature> throwsSignatures) {
            this.typeParameters = typeParameters;
            this.paramTypes = paramTypes;
            this.resultType = resultType;
            this.throwsSignatures = throwsSignatures;
        }

        public int hashCode() {
            return this.typeParameters.hashCode() + this.paramTypes.hashCode() * 7 + this.resultType.hashCode() * 15 + this.throwsSignatures.hashCode() * 31;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodSignature)) {
                return false;
            }
            MethodSignature o = (MethodSignature)obj;
            return o.typeParameters.equals(this.typeParameters) && o.paramTypes.equals(this.paramTypes) && o.resultType.equals(this.resultType) && o.throwsSignatures.equals(this.throwsSignatures);
        }

        public String toString(List<AnnotationInfo> annotationInfo, int modifiers, boolean isConstructor, String methodName, boolean isVarArgs, String[] parameterNames, int[] parameterAccessFlags, AnnotationInfo[][] parameterAnnotationInfo) {
            int i;
            if (parameterNames != null && this.paramTypes.size() != parameterNames.length || parameterAccessFlags != null && this.paramTypes.size() != parameterAccessFlags.length || parameterAnnotationInfo != null && this.paramTypes.size() != parameterAnnotationInfo.length) {
                throw new RuntimeException("Parameter number mismatch");
            }
            StringBuilder buf = new StringBuilder();
            if (annotationInfo != null) {
                for (AnnotationInfo annotation : annotationInfo) {
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(annotation.toString());
                }
            }
            if (modifiers != 0) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                TypeParser.modifiersToString(modifiers, true, buf);
            }
            if (!this.typeParameters.isEmpty()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append('<');
                for (int i2 = 0; i2 < this.typeParameters.size(); ++i2) {
                    if (i2 > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.typeParameters.get(i2).toString());
                }
                buf.append(">");
            }
            if (!isConstructor) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(this.resultType.toString());
            }
            buf.append(' ');
            if (methodName != null) {
                buf.append(methodName);
            }
            buf.append('(');
            for (i = 0; i < this.paramTypes.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (parameterAnnotationInfo != null) {
                    AnnotationInfo[] annotationInfoForParameter = parameterAnnotationInfo[i];
                    for (int j = 0; j < annotationInfoForParameter.length; ++j) {
                        buf.append(annotationInfoForParameter[j].toString());
                        buf.append(' ');
                    }
                }
                if (parameterAccessFlags != null) {
                    int flag = parameterAccessFlags[i];
                    if ((flag & 0x10) != 0) {
                        buf.append("final ");
                    }
                    if ((flag & 0x1000) != 0) {
                        buf.append("synthetic ");
                    }
                    if ((flag & 0x8000) != 0) {
                        buf.append("mandated ");
                    }
                }
                TypeSignature paramType = this.paramTypes.get(i);
                if (isVarArgs && i == this.paramTypes.size() - 1) {
                    if (!(paramType instanceof ArrayTypeSignature)) {
                        throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + methodName);
                    }
                    ArrayTypeSignature arrayType = (ArrayTypeSignature)paramType;
                    if (arrayType.numArrayDims == 0) {
                        throw new IllegalArgumentException("Got a zero-dimension array type for last parameter of varargs method " + methodName);
                    }
                    buf.append(new ArrayTypeSignature(arrayType.elementTypeSignature, arrayType.numArrayDims - 1).toString());
                    buf.append("...");
                } else {
                    buf.append(paramType.toString());
                }
                if (parameterNames == null) continue;
                String paramName = parameterNames[i];
                buf.append(' ');
                buf.append(paramName == null ? "_unnamed_param_" + i : paramName);
            }
            buf.append(')');
            if (!this.throwsSignatures.isEmpty()) {
                buf.append(" throws ");
                for (i = 0; i < this.throwsSignatures.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.throwsSignatures.get(i).toString());
                }
            }
            return buf.toString();
        }

        public String toString() {
            return this.toString(null, 0, false, null, false, null, null, null);
        }
    }

    public static class TypeParameter {
        public final String identifier;
        public final ReferenceTypeSignature classBound;
        public final List<ReferenceTypeSignature> interfaceBounds;

        public TypeParameter(String identifier, ReferenceTypeSignature classBound, List<ReferenceTypeSignature> interfaceBounds) {
            this.identifier = identifier;
            this.classBound = classBound;
            this.interfaceBounds = interfaceBounds;
        }

        public int hashCode() {
            return this.identifier.hashCode() + (this.classBound == null ? 0 : this.classBound.hashCode() * 7) + this.interfaceBounds.hashCode() * 15;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeParameter)) {
                return false;
            }
            TypeParameter o = (TypeParameter)obj;
            return o.identifier.equals(this.identifier) && (o.classBound == null && this.classBound == null || o.classBound != null && o.classBound.equals(this.classBound)) && o.interfaceBounds.equals(this.interfaceBounds);
        }

        public String toString() {
            String classBoundStr;
            StringBuilder buf = new StringBuilder();
            buf.append(this.identifier);
            if (this.classBound == null) {
                classBoundStr = null;
            } else {
                classBoundStr = this.classBound.toString();
                if (classBoundStr.equals("java.lang.Object")) {
                    classBoundStr = null;
                }
            }
            if (classBoundStr != null || !this.interfaceBounds.isEmpty()) {
                buf.append(" extends");
            }
            if (classBoundStr != null) {
                buf.append(' ');
                buf.append(classBoundStr);
            }
            for (int i = 0; i < this.interfaceBounds.size(); ++i) {
                if (i > 0 || classBoundStr != null) {
                    buf.append(" &");
                }
                buf.append(' ');
                buf.append(this.interfaceBounds.get(i).toString());
            }
            return buf.toString();
        }

        private static TypeParameter parseTypeParameter(ParseState parseState) throws ParseException {
            List<ReferenceTypeSignature> interfaceBounds;
            if (!parseState.parseIdentifier()) {
                throw new ParseException();
            }
            String identifier = parseState.currToken();
            ReferenceTypeSignature classBound = ReferenceTypeSignature.parseClassBound(parseState);
            if (parseState.peek() == ':') {
                interfaceBounds = new ArrayList();
                while (parseState.peek() == ':') {
                    parseState.expect(':');
                    ReferenceTypeSignature interfaceTypeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parseState);
                    if (interfaceTypeSignature == null) {
                        throw new ParseException();
                    }
                    interfaceBounds.add(interfaceTypeSignature);
                }
            } else {
                interfaceBounds = Collections.emptyList();
            }
            return new TypeParameter(identifier, classBound, interfaceBounds);
        }

        private static List<TypeParameter> parseTypeParameters(ParseState parseState) throws ParseException {
            if (parseState.peek() != '<') {
                return Collections.emptyList();
            }
            parseState.expect('<');
            ArrayList<TypeParameter> typeParams = new ArrayList<TypeParameter>(1);
            while (parseState.peek() != '>') {
                if (!parseState.hasMore()) {
                    throw new ParseException();
                }
                typeParams.add(TypeParameter.parseTypeParameter(parseState));
            }
            parseState.expect('>');
            return typeParams;
        }
    }

    public static class ArrayTypeSignature
    extends ReferenceTypeSignature {
        public final TypeSignature elementTypeSignature;
        public final int numArrayDims;

        public ArrayTypeSignature(TypeSignature elementTypeSignature, int numArrayDims) {
            this.elementTypeSignature = elementTypeSignature;
            this.numArrayDims = numArrayDims;
        }

        private static Class<?> arrayify(Class<?> cls, int arrayDims) {
            if (arrayDims == 0) {
                return cls;
            }
            int[] zeroes = (int[])Array.newInstance(Integer.TYPE, arrayDims);
            return Array.newInstance(cls, zeroes).getClass();
        }

        @Override
        public Class<?> instantiate(ScanResult scanResult) {
            Class<?> elementClassRef = this.elementTypeSignature.instantiate(scanResult);
            return ArrayTypeSignature.arrayify(elementClassRef, this.numArrayDims);
        }

        public int hashCode() {
            return this.elementTypeSignature.hashCode() + this.numArrayDims * 15;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayTypeSignature)) {
                return false;
            }
            ArrayTypeSignature o = (ArrayTypeSignature)obj;
            return o.elementTypeSignature.equals(this.elementTypeSignature) && o.numArrayDims == this.numArrayDims;
        }

        @Override
        public boolean equalsIgnoringTypeParams(TypeSignature other) {
            if (!(other instanceof ArrayTypeSignature)) {
                return false;
            }
            ArrayTypeSignature o = (ArrayTypeSignature)other;
            return o.elementTypeSignature.equalsIgnoringTypeParams(this.elementTypeSignature) && o.numArrayDims == this.numArrayDims;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.elementTypeSignature.toString());
            for (int i = 0; i < this.numArrayDims; ++i) {
                buf.append("[]");
            }
            return buf.toString();
        }

        private static ArrayTypeSignature parseArrayTypeSignature(ParseState parseState) throws ParseException {
            int numArrayDims = 0;
            while (parseState.peek() == '[') {
                ++numArrayDims;
                parseState.next();
            }
            if (numArrayDims > 0) {
                TypeSignature elementTypeSignature = TypeSignature.parseJavaTypeSignature(parseState);
                if (elementTypeSignature == null) {
                    throw new ParseException();
                }
                return new ArrayTypeSignature(elementTypeSignature, numArrayDims);
            }
            return null;
        }
    }

    public static class TypeVariableSignature
    extends ClassTypeOrTypeVariableSignature {
        public final String typeVariableName;
        private MethodSignature methodSignature;
        private ClassSignature classSignature;

        public TypeVariableSignature(String typeVariableName) {
            this.typeVariableName = typeVariableName;
        }

        public TypeParameter getCorrespondingTypeParameter() {
            if (this.methodSignature != null && this.methodSignature.typeParameters != null && !this.methodSignature.typeParameters.isEmpty()) {
                for (TypeParameter typeParameter : this.methodSignature.typeParameters) {
                    if (!typeParameter.identifier.equals(this.typeVariableName)) continue;
                    return typeParameter;
                }
            }
            if (this.classSignature != null && this.classSignature.typeParameters != null && !this.classSignature.typeParameters.isEmpty()) {
                for (TypeParameter typeParameter : this.classSignature.typeParameters) {
                    if (!typeParameter.identifier.equals(this.typeVariableName)) continue;
                    return typeParameter;
                }
            }
            return null;
        }

        @Override
        public Class<?> instantiate(ScanResult scanResult) {
            throw new RuntimeException("Cannot instantiate a type variable");
        }

        public int hashCode() {
            return this.typeVariableName.hashCode();
        }

        @Override
        public boolean equalsIgnoringTypeParams(TypeSignature other) {
            if (other instanceof ClassTypeSignature) {
                TypeParameter typeParameter = this.getCorrespondingTypeParameter();
                if (typeParameter == null) {
                    return true;
                }
                if (typeParameter.classBound == null && (typeParameter.interfaceBounds == null || typeParameter.interfaceBounds.isEmpty())) {
                    return true;
                }
                if (typeParameter.classBound != null && typeParameter.classBound.equals(other)) {
                    return true;
                }
                for (ReferenceTypeSignature interfaceBound : typeParameter.interfaceBounds) {
                    if (!interfaceBound.equals(other)) continue;
                    return true;
                }
                return false;
            }
            return this.equals(other);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeVariableSignature)) {
                return false;
            }
            TypeVariableSignature o = (TypeVariableSignature)obj;
            return o.typeVariableName.equals(this.typeVariableName);
        }

        public String toString() {
            return this.typeVariableName;
        }

        private static TypeVariableSignature parseTypeVariableSignature(ParseState parseState) throws ParseException {
            char peek = parseState.peek();
            if (peek == 'T') {
                parseState.next();
                if (!parseState.parseIdentifier()) {
                    throw new ParseException();
                }
                parseState.expect(';');
                TypeVariableSignature typeVariableSignature = new TypeVariableSignature(parseState.currToken());
                parseState.addTypeVariableSignature(typeVariableSignature);
                return typeVariableSignature;
            }
            return null;
        }
    }

    public static class ClassTypeSignature
    extends ClassTypeOrTypeVariableSignature {
        public final String className;
        private String classNameAndSuffixesWithoutTypeArguments;
        public final List<TypeArgument> typeArguments;
        public final List<String> suffixes;
        public final List<List<TypeArgument>> suffixTypeArguments;

        public ClassTypeSignature(String className, List<TypeArgument> typeArguments, List<String> suffixes, List<List<TypeArgument>> suffixTypeArguments) {
            this.className = className;
            this.typeArguments = typeArguments;
            this.suffixes = suffixes;
            this.suffixTypeArguments = suffixTypeArguments;
        }

        @Override
        public Class<?> instantiate(ScanResult scanResult) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.className);
            for (int i = 0; i < this.suffixes.size(); ++i) {
                buf.append("$");
                buf.append(this.suffixes.get(i));
            }
            String classNameWithSuffixes = buf.toString();
            return scanResult.classNameToClassRef(classNameWithSuffixes);
        }

        private String getClassNameAndSuffixesWithoutTypeArguments() {
            if (this.classNameAndSuffixesWithoutTypeArguments == null) {
                StringBuilder buf = new StringBuilder();
                buf.append(this.className);
                for (int i = 0; i < this.suffixes.size(); ++i) {
                    buf.append('$');
                    buf.append(this.suffixes.get(i));
                }
                this.classNameAndSuffixesWithoutTypeArguments = buf.toString();
            }
            return this.classNameAndSuffixesWithoutTypeArguments;
        }

        public int hashCode() {
            return this.className.hashCode() + 7 * this.typeArguments.hashCode() + 15 * this.suffixes.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassTypeSignature)) {
                return false;
            }
            ClassTypeSignature o = (ClassTypeSignature)obj;
            return o.className.equals(this.className) && o.typeArguments.equals(this.typeArguments) && o.suffixes.equals(this.suffixes);
        }

        @Override
        public boolean equalsIgnoringTypeParams(TypeSignature other) {
            if (other instanceof TypeVariableSignature) {
                return ((TypeVariableSignature)other).equalsIgnoringTypeParams(this);
            }
            if (!(other instanceof ClassTypeSignature)) {
                return false;
            }
            ClassTypeSignature o = (ClassTypeSignature)other;
            if (o.suffixes.equals(this.suffixes)) {
                return o.className.equals(this.className);
            }
            return o.getClassNameAndSuffixesWithoutTypeArguments().equals(this.getClassNameAndSuffixesWithoutTypeArguments());
        }

        public String toString() {
            int i;
            StringBuilder buf = new StringBuilder();
            buf.append(this.className);
            if (!this.typeArguments.isEmpty()) {
                buf.append('<');
                for (i = 0; i < this.typeArguments.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.typeArguments.get(i).toString());
                }
                buf.append('>');
            }
            for (i = 0; i < this.suffixes.size(); ++i) {
                buf.append("$");
                buf.append(this.suffixes.get(i));
                List<TypeArgument> suffixTypeArgs = this.suffixTypeArguments.get(i);
                if (suffixTypeArgs.isEmpty()) continue;
                buf.append('<');
                for (int j = 0; j < suffixTypeArgs.size(); ++j) {
                    if (j > 0) {
                        buf.append(", ");
                    }
                    buf.append(suffixTypeArgs.get(j).toString());
                }
                buf.append('>');
            }
            return buf.toString();
        }

        private static ClassTypeSignature parseClassTypeSignature(ParseState parseState) throws ParseException {
            if (parseState.peek() == 'L') {
                List<List<TypeArgument>> suffixTypeArguments;
                List<String> suffixes;
                parseState.next();
                if (!parseState.parseIdentifier('/', '.')) {
                    throw new ParseException();
                }
                String className = parseState.currToken();
                List typeArguments = TypeArgument.parseTypeArguments(parseState);
                if (parseState.peek() == '.') {
                    suffixes = new ArrayList();
                    suffixTypeArguments = new ArrayList();
                    while (parseState.peek() == '.') {
                        parseState.expect('.');
                        if (!parseState.parseIdentifier('/', '.')) {
                            throw new ParseException();
                        }
                        suffixes.add(parseState.currToken());
                        suffixTypeArguments.add(TypeArgument.parseTypeArguments(parseState));
                    }
                } else {
                    suffixes = Collections.emptyList();
                    suffixTypeArguments = Collections.emptyList();
                }
                parseState.expect(';');
                return new ClassTypeSignature(className, typeArguments, suffixes, suffixTypeArguments);
            }
            return null;
        }
    }

    public static class TypeArgument {
        public final WILDCARD wildcard;
        public final ReferenceTypeSignature typeSignature;

        public TypeArgument(WILDCARD wildcard, ReferenceTypeSignature typeSignature) {
            this.wildcard = wildcard;
            this.typeSignature = typeSignature;
        }

        public int hashCode() {
            return this.typeSignature.hashCode() + 7 * this.wildcard.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypeArgument)) {
                return false;
            }
            TypeArgument o = (TypeArgument)obj;
            return o.typeSignature.equals(this.typeSignature) && o.wildcard.equals((Object)this.wildcard);
        }

        public String toString() {
            String typeSigStr = this.typeSignature == null ? null : this.typeSignature.toString();
            switch (this.wildcard) {
                case ANY: {
                    return "?";
                }
                case EXTENDS: {
                    return typeSigStr.equals("java.lang.Object") ? "?" : "? extends " + typeSigStr;
                }
                case SUPER: {
                    return "? super " + typeSigStr;
                }
                case NONE: {
                    return typeSigStr;
                }
            }
            throw new RuntimeException("Unknown wildcard type");
        }

        private static TypeArgument parseTypeArgument(ParseState parseState) throws ParseException {
            char peek = parseState.peek();
            if (peek == '*') {
                parseState.expect('*');
                return new TypeArgument(WILDCARD.ANY, null);
            }
            if (peek == '+') {
                parseState.expect('+');
                ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parseState);
                if (typeSignature == null) {
                    throw new ParseException();
                }
                return new TypeArgument(WILDCARD.EXTENDS, typeSignature);
            }
            if (peek == '-') {
                parseState.expect('-');
                ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parseState);
                if (typeSignature == null) {
                    throw new ParseException();
                }
                return new TypeArgument(WILDCARD.SUPER, typeSignature);
            }
            ReferenceTypeSignature typeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parseState);
            if (typeSignature == null) {
                throw new ParseException();
            }
            return new TypeArgument(WILDCARD.NONE, typeSignature);
        }

        private static List<TypeArgument> parseTypeArguments(ParseState parseState) throws ParseException {
            if (parseState.peek() == '<') {
                parseState.expect('<');
                ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>();
                while (parseState.peek() != '>') {
                    if (!parseState.hasMore()) {
                        throw new ParseException();
                    }
                    typeArguments.add(TypeArgument.parseTypeArgument(parseState));
                }
                parseState.expect('>');
                return typeArguments;
            }
            return Collections.emptyList();
        }

        public static enum WILDCARD {
            NONE,
            ANY,
            EXTENDS,
            SUPER;

        }
    }

    public static abstract class ClassTypeOrTypeVariableSignature
    extends ReferenceTypeSignature {
    }

    public static abstract class ReferenceTypeSignature
    extends TypeSignature {
        private static ReferenceTypeSignature parseReferenceTypeSignature(ParseState parseState) throws ParseException {
            ClassTypeSignature classTypeSignature = ClassTypeSignature.parseClassTypeSignature(parseState);
            if (classTypeSignature != null) {
                return classTypeSignature;
            }
            TypeVariableSignature typeVariableSignature = TypeVariableSignature.parseTypeVariableSignature(parseState);
            if (typeVariableSignature != null) {
                return typeVariableSignature;
            }
            ArrayTypeSignature arrayTypeSignature = ArrayTypeSignature.parseArrayTypeSignature(parseState);
            if (arrayTypeSignature != null) {
                return arrayTypeSignature;
            }
            return null;
        }

        private static ReferenceTypeSignature parseClassBound(ParseState parseState) throws ParseException {
            parseState.expect(':');
            return ReferenceTypeSignature.parseReferenceTypeSignature(parseState);
        }
    }

    public static class BaseTypeSignature
    extends TypeSignature {
        public final String baseType;

        public BaseTypeSignature(String baseType) {
            this.baseType = baseType;
        }

        @Override
        public Class<?> instantiate(ScanResult scanResult) {
            switch (this.baseType) {
                case "byte": {
                    return Byte.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            throw new RuntimeException("Unknown base type " + this.baseType);
        }

        public int hashCode() {
            return this.baseType.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof BaseTypeSignature && ((BaseTypeSignature)obj).baseType.equals(this.baseType);
        }

        @Override
        public boolean equalsIgnoringTypeParams(TypeSignature other) {
            if (!(other instanceof BaseTypeSignature)) {
                return false;
            }
            return this.baseType.equals(((BaseTypeSignature)other).baseType);
        }

        public String toString() {
            return this.baseType;
        }

        private static BaseTypeSignature parseBaseType(ParseState parseState) {
            switch (parseState.peek()) {
                case 'B': {
                    parseState.next();
                    return new BaseTypeSignature("byte");
                }
                case 'C': {
                    parseState.next();
                    return new BaseTypeSignature("char");
                }
                case 'D': {
                    parseState.next();
                    return new BaseTypeSignature("double");
                }
                case 'F': {
                    parseState.next();
                    return new BaseTypeSignature("float");
                }
                case 'I': {
                    parseState.next();
                    return new BaseTypeSignature("int");
                }
                case 'J': {
                    parseState.next();
                    return new BaseTypeSignature("long");
                }
                case 'S': {
                    parseState.next();
                    return new BaseTypeSignature("short");
                }
                case 'Z': {
                    parseState.next();
                    return new BaseTypeSignature("boolean");
                }
                case 'V': {
                    parseState.next();
                    return new BaseTypeSignature("void");
                }
            }
            return null;
        }
    }

    public static abstract class TypeSignature {
        public abstract Class<?> instantiate(ScanResult var1);

        public abstract boolean equalsIgnoringTypeParams(TypeSignature var1);

        private static TypeSignature parseJavaTypeSignature(ParseState parseState) throws ParseException {
            ReferenceTypeSignature referenceTypeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parseState);
            if (referenceTypeSignature != null) {
                return referenceTypeSignature;
            }
            BaseTypeSignature baseTypeSignature = BaseTypeSignature.parseBaseType(parseState);
            if (baseTypeSignature != null) {
                return baseTypeSignature;
            }
            return null;
        }
    }
}

