/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.MethodSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassInfo
extends ScanResult.InfoObject
implements Comparable<ClassInfo> {
    private final String className;
    private int classModifiers;
    private boolean isInterface;
    private boolean isAnnotation;
    private String typeDescriptor;
    private ClassSignature typeSignature;
    private String fullyQualifiedContainingMethodName;
    private boolean classfileScanned;
    private boolean companionObjectClassfileScanned;
    private boolean traitMethodClassfileScanned;
    private HashSet<URL> classpathElementURLs;
    private ClassLoader[] classLoaders;
    private final ScanSpec scanSpec;
    List<AnnotationInfo> annotationInfo;
    List<FieldInfo> fieldInfo;
    private Map<String, FieldInfo> fieldNameToFieldInfo;
    List<MethodInfo> methodInfo;
    private MultiMapKeyToList<String, MethodInfo> methodNameToMethodInfo;
    List<AnnotationInfo.AnnotationParamValue> annotationDefaultParamValues;
    private static final int ANNOTATION_CLASS_MODIFIER = 8192;
    private final Map<RelType, Set<ClassInfo>> relatedTypeToClassInfoSet = new HashMap<RelType, Set<ClassInfo>>();
    private Map<String, Object> staticFinalFieldNameToConstantInitializerValue;

    @Override
    void setScanResult(ScanResult scanResult) {
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
        if (this.fieldInfo != null) {
            for (FieldInfo fi : this.fieldInfo) {
                fi.setScanResult(scanResult);
            }
        }
        if (this.methodInfo != null) {
            for (MethodInfo mi : this.methodInfo) {
                mi.setScanResult(scanResult);
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public int getClassModifiers() {
        return this.classModifiers;
    }

    public String getModifiersStr() {
        return TypeUtils.modifiersToString(this.classModifiers, false);
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public ClassSignature getTypeSignature() {
        if (this.typeDescriptor == null) {
            return null;
        }
        if (this.typeSignature == null) {
            this.typeSignature = ClassSignature.parse(this.typeDescriptor);
        }
        return this.typeSignature;
    }

    public Set<URL> getClasspathElementURLs() {
        return this.classpathElementURLs;
    }

    public URL getClasspathElementURL() {
        Iterator<URL> iter = this.classpathElementURLs.iterator();
        if (!iter.hasNext()) {
            throw new IllegalArgumentException("classpathElementURLs set is empty");
        }
        URL classpathElementURL = iter.next();
        if (iter.hasNext()) {
            throw new IllegalArgumentException("Class " + this.className + " has multiple classpath URLs (need to call getClasspathElementURLs() instead): " + this.classpathElementURLs);
        }
        return classpathElementURL;
    }

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.className.compareTo(o.className);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        return this.className.equals(other.className);
    }

    public int hashCode() {
        return this.className != null ? this.className.hashCode() : 33;
    }

    public String toString() {
        ClassSignature typeSig = this.getTypeSignature();
        if (typeSig != null) {
            return typeSig.toString(this.classModifiers, this.isAnnotation, this.isInterface, this.className);
        }
        StringBuilder buf = new StringBuilder();
        TypeUtils.modifiersToString(this.classModifiers, false, buf);
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.isAnnotation ? "@interface " : (this.isInterface ? "interface " : ((this.classModifiers & 0x4000) != 0 ? "enum " : "class ")));
        buf.append(this.className);
        return buf.toString();
    }

    private ClassInfo(String className, int classModifiers, ScanSpec scanSpec) {
        this.className = className;
        this.classModifiers = classModifiers;
        this.scanSpec = scanSpec;
        if (className.endsWith(";")) {
            throw new RuntimeException("Bad class name");
        }
    }

    static Set<ClassInfo> filterClassInfo(Set<ClassInfo> classInfoSet, boolean removeExternalClassesIfStrictWhitelist, ScanSpec scanSpec, ClassType ... classTypes) {
        if (classInfoSet == null) {
            return Collections.emptySet();
        }
        boolean includeAllTypes = classTypes.length == 0;
        boolean includeStandardClasses = false;
        boolean includeImplementedInterfaces = false;
        boolean includeAnnotations = false;
        block7: for (ClassType classType : classTypes) {
            switch (classType) {
                case ALL: {
                    includeAllTypes = true;
                    continue block7;
                }
                case STANDARD_CLASS: {
                    includeStandardClasses = true;
                    continue block7;
                }
                case IMPLEMENTED_INTERFACE: {
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                case ANNOTATION: {
                    includeAnnotations = true;
                    continue block7;
                }
                case INTERFACE_OR_ANNOTATION: {
                    includeAnnotations = true;
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unknown ClassType: " + (Object)((Object)classType));
                }
            }
        }
        if (includeStandardClasses && includeImplementedInterfaces && includeAnnotations) {
            includeAllTypes = true;
        }
        HashSet<ClassInfo> classInfoSetFiltered = new HashSet<ClassInfo>(classInfoSet.size());
        for (ClassInfo classInfo : classInfoSet) {
            boolean isVisibleExternal;
            if (!(includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface()) && (!includeAnnotations || !classInfo.isAnnotation())) continue;
            boolean isExternal = !classInfo.classfileScanned;
            boolean isBlacklisted = scanSpec.classIsBlacklisted(classInfo.className);
            boolean isWhitelisted = !isExternal && !isBlacklisted;
            boolean removeExternalClasses = removeExternalClassesIfStrictWhitelist && scanSpec.strictWhitelist;
            boolean bl = isVisibleExternal = isExternal && !removeExternalClasses && !isBlacklisted;
            if (!isWhitelisted && !isVisibleExternal) continue;
            classInfoSetFiltered.add(classInfo);
        }
        return classInfoSetFiltered;
    }

    public static List<String> getClassNames(Collection<ClassInfo> classInfoColl) {
        if (classInfoColl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> classNames = new ArrayList<String>(classInfoColl.size());
        for (ClassInfo classInfo : classInfoColl) {
            classNames.add(classInfo.className);
        }
        Collections.sort(classNames);
        return classNames;
    }

    private Set<ClassInfo> getDirectlyRelatedClasses(RelType relType) {
        Set<ClassInfo> relatedClassClassInfo = this.relatedTypeToClassInfoSet.get((Object)relType);
        return relatedClassClassInfo == null ? Collections.emptySet() : relatedClassClassInfo;
    }

    private Set<ClassInfo> getReachableClasses(RelType relType) {
        Set<ClassInfo> directlyRelatedClasses = this.getDirectlyRelatedClasses(relType);
        if (directlyRelatedClasses.isEmpty()) {
            return directlyRelatedClasses;
        }
        HashSet<ClassInfo> reachableClasses = new HashSet<ClassInfo>(directlyRelatedClasses);
        if (relType == RelType.METHOD_ANNOTATIONS || relType == RelType.FIELD_ANNOTATIONS) {
            for (ClassInfo annotation : directlyRelatedClasses) {
                reachableClasses.addAll(annotation.getReachableClasses(RelType.CLASS_ANNOTATIONS));
            }
        } else if (relType == RelType.CLASSES_WITH_METHOD_ANNOTATION || relType == RelType.CLASSES_WITH_FIELD_ANNOTATION) {
            for (ClassInfo subAnnotation : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_WITH_CLASS_ANNOTATION), true, this.scanSpec, ClassType.ANNOTATION)) {
                reachableClasses.addAll(subAnnotation.getDirectlyRelatedClasses(relType));
            }
        } else {
            LinkedList<ClassInfo> queue = new LinkedList<ClassInfo>();
            queue.addAll(directlyRelatedClasses);
            while (!queue.isEmpty()) {
                ClassInfo head = (ClassInfo)queue.removeFirst();
                for (ClassInfo directlyReachableFromHead : head.getDirectlyRelatedClasses(relType)) {
                    if (!reachableClasses.add(directlyReachableFromHead)) continue;
                    queue.add(directlyReachableFromHead);
                }
            }
        }
        return reachableClasses;
    }

    private boolean addRelatedClass(RelType relType, ClassInfo classInfo) {
        Set<ClassInfo> classInfoSet = this.relatedTypeToClassInfoSet.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet<ClassInfo>(4);
            this.relatedTypeToClassInfoSet.put(relType, classInfoSet);
        }
        return classInfoSet.add(classInfo);
    }

    private static String scalaBaseClassName(String className) {
        if (className != null && className.endsWith("$")) {
            return className.substring(0, className.length() - 1);
        }
        if (className != null && className.endsWith("$class")) {
            return className.substring(0, className.length() - 6);
        }
        return className;
    }

    private static ClassInfo getOrCreateClassInfo(String className, int classModifiers, ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className, classModifiers, scanSpec);
            classNameToClassInfo.put(className, classInfo);
        }
        return classInfo;
    }

    void addSuperclass(String superclassName, Map<String, ClassInfo> classNameToClassInfo) {
        if (superclassName != null) {
            ClassInfo superclassClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(superclassName), 0, this.scanSpec, classNameToClassInfo);
            this.addRelatedClass(RelType.SUPERCLASSES, superclassClassInfo);
            superclassClassInfo.addRelatedClass(RelType.SUBCLASSES, this);
        }
    }

    void addClassAnnotation(AnnotationInfo classAnnotationInfo, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(classAnnotationInfo.annotationName), 8192, this.scanSpec, classNameToClassInfo);
        annotationClassInfo.isAnnotation = true;
        if (this.annotationInfo == null) {
            this.annotationInfo = new ArrayList<AnnotationInfo>();
        }
        this.annotationInfo.add(classAnnotationInfo);
        classAnnotationInfo.addDefaultValues(annotationClassInfo.annotationDefaultParamValues);
        this.addRelatedClass(RelType.CLASS_ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_CLASS_ANNOTATION, this);
    }

    void addMethodAnnotation(AnnotationInfo methodAnnotationInfo, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(methodAnnotationInfo.annotationName), 8192, this.scanSpec, classNameToClassInfo);
        annotationClassInfo.isAnnotation = true;
        methodAnnotationInfo.addDefaultValues(annotationClassInfo.annotationDefaultParamValues);
        this.addRelatedClass(RelType.METHOD_ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_METHOD_ANNOTATION, this);
    }

    void addFieldAnnotation(AnnotationInfo fieldAnnotationInfo, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(fieldAnnotationInfo.annotationName), 8192, this.scanSpec, classNameToClassInfo);
        annotationClassInfo.isAnnotation = true;
        fieldAnnotationInfo.addDefaultValues(annotationClassInfo.annotationDefaultParamValues);
        this.addRelatedClass(RelType.FIELD_ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_FIELD_ANNOTATION, this);
    }

    void addImplementedInterface(String interfaceName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo interfaceClassInfo = ClassInfo.getOrCreateClassInfo(ClassInfo.scalaBaseClassName(interfaceName), 512, this.scanSpec, classNameToClassInfo);
        interfaceClassInfo.isInterface = true;
        this.addRelatedClass(RelType.IMPLEMENTED_INTERFACES, interfaceClassInfo);
        interfaceClassInfo.addRelatedClass(RelType.CLASSES_IMPLEMENTING, this);
    }

    static void addClassContainment(List<AbstractMap.SimpleEntry<String, String>> classContainmentEntries, ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo) {
        for (AbstractMap.SimpleEntry<String, String> ent : classContainmentEntries) {
            String innerClassName = ent.getKey();
            ClassInfo innerClassInfo = ClassInfo.getOrCreateClassInfo(innerClassName, 0, scanSpec, classNameToClassInfo);
            String outerClassName = ent.getValue();
            ClassInfo outerClassInfo = ClassInfo.getOrCreateClassInfo(outerClassName, 0, scanSpec, classNameToClassInfo);
            innerClassInfo.addRelatedClass(RelType.CONTAINED_WITHIN_OUTER_CLASS, outerClassInfo);
            outerClassInfo.addRelatedClass(RelType.CONTAINS_INNER_CLASS, innerClassInfo);
        }
    }

    void addFullyQualifiedContainingMethodName(String fullyQualifiedContainingMethodName) {
        this.fullyQualifiedContainingMethodName = fullyQualifiedContainingMethodName;
    }

    void addStaticFinalFieldConstantInitializerValue(String fieldName, Object constValue) {
        if (this.staticFinalFieldNameToConstantInitializerValue == null) {
            this.staticFinalFieldNameToConstantInitializerValue = new HashMap<String, Object>();
        }
        this.staticFinalFieldNameToConstantInitializerValue.put(fieldName, constValue);
    }

    void addFieldInfo(List<FieldInfo> fieldInfoList, Map<String, ClassInfo> classNameToClassInfo) {
        for (FieldInfo fieldInfo : fieldInfoList) {
            List<AnnotationInfo> fieldAnnotationInfoList = fieldInfo.annotationInfo;
            if (fieldAnnotationInfoList == null) continue;
            for (AnnotationInfo fieldAnnotationInfo : fieldAnnotationInfoList) {
                ClassInfo classInfo = ClassInfo.getOrCreateClassInfo(fieldAnnotationInfo.annotationName, 8192, this.scanSpec, classNameToClassInfo);
                fieldAnnotationInfo.addDefaultValues(classInfo.annotationDefaultParamValues);
            }
        }
        if (this.fieldInfo == null) {
            this.fieldInfo = fieldInfoList;
        } else {
            this.fieldInfo.addAll(fieldInfoList);
        }
    }

    void addMethodInfo(List<MethodInfo> methodInfoList, Map<String, ClassInfo> classNameToClassInfo) {
        for (MethodInfo methodInfo : methodInfoList) {
            AnnotationInfo[][] methodParamAnnotationInfoList;
            List<AnnotationInfo> methodAnnotationInfoList = methodInfo.annotationInfo;
            if (methodAnnotationInfoList != null) {
                for (AnnotationInfo methodAnnotationInfo : methodAnnotationInfoList) {
                    methodAnnotationInfo.addDefaultValues(ClassInfo.getOrCreateClassInfo((String)methodAnnotationInfo.annotationName, (int)8192, (ScanSpec)this.scanSpec, classNameToClassInfo).annotationDefaultParamValues);
                }
            }
            if ((methodParamAnnotationInfoList = methodInfo.parameterAnnotationInfo) != null) {
                for (int i = 0; i < methodParamAnnotationInfoList.length; ++i) {
                    AnnotationInfo[] paramAnnotationInfoArr = methodParamAnnotationInfoList[i];
                    if (paramAnnotationInfoArr == null) continue;
                    for (int j = 0; j < paramAnnotationInfoArr.length; ++j) {
                        AnnotationInfo paramAnnotationInfo = paramAnnotationInfoArr[j];
                        paramAnnotationInfo.addDefaultValues(ClassInfo.getOrCreateClassInfo((String)paramAnnotationInfo.annotationName, (int)8192, (ScanSpec)this.scanSpec, classNameToClassInfo).annotationDefaultParamValues);
                    }
                }
            }
            methodInfo.classInfo = this;
        }
        if (this.methodInfo == null) {
            this.methodInfo = methodInfoList;
        } else {
            this.methodInfo.addAll(methodInfoList);
        }
    }

    void addTypeDescriptor(String typeDescriptor) {
        if (this.typeDescriptor == null) {
            this.typeDescriptor = typeDescriptor;
        } else {
            if (this.typeSignature == null) {
                this.typeSignature = ClassSignature.parse(this.typeDescriptor);
            }
            this.typeSignature = ClassSignature.merge(this.typeSignature, ClassSignature.parse(typeDescriptor));
            if (this.typeDescriptor.length() > typeDescriptor.length()) {
                this.typeDescriptor = typeDescriptor;
            }
        }
    }

    void addAnnotationParamDefaultValues(List<AnnotationInfo.AnnotationParamValue> paramNamesAndValues) {
        if (this.annotationDefaultParamValues == null) {
            this.annotationDefaultParamValues = paramNamesAndValues;
        } else {
            this.annotationDefaultParamValues.addAll(paramNamesAndValues);
        }
    }

    static ClassInfo addScannedClass(String className, int classModifiers, boolean isInterface, boolean isAnnotation, ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo, ClasspathElement classpathElement, LogNode log) {
        ClassInfo classInfo;
        boolean isCompanionObjectClass = className.endsWith("$");
        boolean isTraitMethodClass = className.endsWith("$class");
        boolean isNonAuxClass = !isCompanionObjectClass && !isTraitMethodClass;
        String classBaseName = ClassInfo.scalaBaseClassName(className);
        if (classNameToClassInfo.containsKey(classBaseName)) {
            classInfo = classNameToClassInfo.get(classBaseName);
            if ((isNonAuxClass && classInfo.classfileScanned || isCompanionObjectClass && classInfo.companionObjectClassfileScanned || isTraitMethodClass && classInfo.traitMethodClassfileScanned) && log != null) {
                log.log("Encountered class with same exact path more than once in the same jarfile: " + className + " (merging info from all copies of the classfile)");
            }
            classInfo.classModifiers |= classModifiers;
        } else {
            classInfo = new ClassInfo(classBaseName, classModifiers, scanSpec);
            classNameToClassInfo.put(classBaseName, classInfo);
        }
        if (classInfo.classpathElementURLs == null) {
            classInfo.classpathElementURLs = new HashSet();
        }
        classInfo.classpathElementURLs.add(classpathElement.getClasspathElementURL(log));
        ClassLoader[] classLoaders = classpathElement.getClassLoaders();
        if (classInfo.classLoaders == null) {
            classInfo.classLoaders = classLoaders;
        } else if (classLoaders != null && !classInfo.classLoaders.equals(classLoaders)) {
            AdditionOrderedSet<ClassLoader> allClassLoaders = new AdditionOrderedSet<ClassLoader>(classInfo.classLoaders);
            for (ClassLoader classLoader : classLoaders) {
                allClassLoaders.add(classLoader);
            }
            List<ClassLoader> classLoaderOrder = allClassLoaders.toList();
            classInfo.classLoaders = classLoaderOrder.toArray(new ClassLoader[classLoaderOrder.size()]);
        }
        if (isTraitMethodClass) {
            classInfo.traitMethodClassfileScanned = true;
        } else if (isCompanionObjectClass) {
            classInfo.companionObjectClassfileScanned = true;
        } else {
            classInfo.classfileScanned = true;
        }
        classInfo.isInterface |= isInterface;
        classInfo.isAnnotation |= isAnnotation;
        return classInfo;
    }

    public Set<String> getClassNamesReferencedInAnyTypeDescriptor() {
        ClassSignature classSig;
        HashSet<String> referencedClassNames = new HashSet<String>();
        if (this.methodInfo != null) {
            for (MethodInfo mi : this.methodInfo) {
                MethodSignature methodSig = mi.getTypeSignature();
                if (methodSig == null) continue;
                methodSig.getAllReferencedClassNames(referencedClassNames);
            }
        }
        if (this.fieldInfo != null) {
            for (FieldInfo fi : this.fieldInfo) {
                TypeSignature fieldSig = fi.getTypeSignature();
                if (fieldSig == null) continue;
                fieldSig.getAllReferencedClassNames(referencedClassNames);
            }
        }
        if ((classSig = this.getTypeSignature()) != null) {
            classSig.getAllReferencedClassNames(referencedClassNames);
        }
        referencedClassNames.remove(this.className);
        referencedClassNames.remove("java.lang.Object");
        return referencedClassNames;
    }

    public Set<String> getClassNamesReferencedInMethodTypeDescriptors() {
        HashSet<String> referencedClassNames = new HashSet<String>();
        if (this.methodInfo != null) {
            for (MethodInfo mi : this.methodInfo) {
                MethodSignature methodSig = mi.getTypeSignature();
                if (methodSig == null) continue;
                methodSig.getAllReferencedClassNames(referencedClassNames);
            }
        }
        referencedClassNames.remove("java.lang.Object");
        return referencedClassNames;
    }

    public Set<String> getClassNamesReferencedInFieldTypeDescriptors() {
        HashSet<String> referencedClassNames = new HashSet<String>();
        if (this.fieldInfo != null) {
            for (FieldInfo fi : this.fieldInfo) {
                TypeSignature fieldSig = fi.getTypeSignature();
                if (fieldSig == null) continue;
                fieldSig.getAllReferencedClassNames(referencedClassNames);
            }
        }
        referencedClassNames.remove("java.lang.Object");
        return referencedClassNames;
    }

    public Set<String> getClassNamesReferencedInClassTypeDescriptor() {
        HashSet<String> referencedClassNames = new HashSet<String>();
        ClassSignature classSig = this.getTypeSignature();
        if (classSig != null) {
            classSig.getAllReferencedClassNames(referencedClassNames);
        }
        referencedClassNames.remove(this.className);
        referencedClassNames.remove("java.lang.Object");
        return referencedClassNames;
    }

    static List<String> getNamesOfAllClasses(ScanSpec scanSpec, Set<ClassInfo> allClassInfo) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(allClassInfo, true, scanSpec, ClassType.ALL));
    }

    static List<String> getNamesOfAllStandardClasses(ScanSpec scanSpec, Set<ClassInfo> allClassInfo) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(allClassInfo, true, scanSpec, ClassType.STANDARD_CLASS));
    }

    public boolean isStandardClass() {
        return !this.isAnnotation && !this.isInterface;
    }

    public Set<ClassInfo> getSubclasses() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.SUBCLASSES), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfSubclasses() {
        return ClassInfo.getClassNames(this.getSubclasses());
    }

    public boolean hasSubclass(String subclassName) {
        return this.getNamesOfSubclasses().contains(subclassName);
    }

    public Set<ClassInfo> getDirectSubclasses() {
        return ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.SUBCLASSES), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfDirectSubclasses() {
        return ClassInfo.getClassNames(this.getDirectSubclasses());
    }

    public boolean hasDirectSubclass(String directSubclassName) {
        return this.getNamesOfDirectSubclasses().contains(directSubclassName);
    }

    public Set<ClassInfo> getSuperclasses() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.SUPERCLASSES), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfSuperclasses() {
        return ClassInfo.getClassNames(this.getSuperclasses());
    }

    public boolean hasSuperclass(String superclassName) {
        return this.getNamesOfSuperclasses().contains(superclassName);
    }

    public boolean isInnerClass() {
        return !this.getOuterClasses().isEmpty();
    }

    public Set<ClassInfo> getOuterClasses() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CONTAINED_WITHIN_OUTER_CLASS), false, this.scanSpec, ClassType.ALL);
    }

    public List<String> getOuterClassName() {
        return ClassInfo.getClassNames(this.getOuterClasses());
    }

    public boolean isOuterClass() {
        return !this.getInnerClasses().isEmpty();
    }

    public Set<ClassInfo> getInnerClasses() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CONTAINS_INNER_CLASS), false, this.scanSpec, ClassType.ALL);
    }

    public List<String> getInnerClassNames() {
        return ClassInfo.getClassNames(this.getInnerClasses());
    }

    public boolean isAnonymousInnerClass() {
        return this.fullyQualifiedContainingMethodName != null;
    }

    public String getFullyQualifiedContainingMethodName() {
        return this.fullyQualifiedContainingMethodName;
    }

    public Set<ClassInfo> getDirectSuperclasses() {
        return ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.SUPERCLASSES), true, this.scanSpec, ClassType.ALL);
    }

    public ClassInfo getDirectSuperclass() {
        Set<ClassInfo> directSuperclasses = this.getDirectSuperclasses();
        int numDirectSuperclasses = directSuperclasses.size();
        if (numDirectSuperclasses == 0) {
            return null;
        }
        if (numDirectSuperclasses > 1) {
            throw new IllegalArgumentException("Class has multiple direct superclasses: " + directSuperclasses.toString() + " -- need to call getDirectSuperclasses() instead");
        }
        return directSuperclasses.iterator().next();
    }

    public List<String> getNamesOfDirectSuperclasses() {
        return ClassInfo.getClassNames(this.getDirectSuperclasses());
    }

    public String getNameOfDirectSuperclass() {
        List<String> namesOfDirectSuperclasses = this.getNamesOfDirectSuperclasses();
        int numDirectSuperclasses = namesOfDirectSuperclasses.size();
        if (numDirectSuperclasses == 0) {
            return null;
        }
        if (numDirectSuperclasses > 1) {
            throw new IllegalArgumentException("Class has multiple direct superclasses: " + namesOfDirectSuperclasses.toString() + " -- need to call getNamesOfDirectSuperclasses() instead");
        }
        return namesOfDirectSuperclasses.get(0);
    }

    public boolean hasDirectSuperclass(String directSuperclassName) {
        List<String> namesOfDirectSuperclasses = this.getNamesOfDirectSuperclasses();
        if (directSuperclassName == null && namesOfDirectSuperclasses.isEmpty()) {
            return true;
        }
        if (directSuperclassName == null || namesOfDirectSuperclasses.isEmpty()) {
            return false;
        }
        return namesOfDirectSuperclasses.contains(directSuperclassName);
    }

    static List<String> getNamesOfAllInterfaceClasses(ScanSpec scanSpec, Set<ClassInfo> allClassInfo) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(allClassInfo, true, scanSpec, ClassType.IMPLEMENTED_INTERFACE));
    }

    public boolean isImplementedInterface() {
        return !this.getDirectlyRelatedClasses(RelType.CLASSES_IMPLEMENTING).isEmpty() || this.isInterface && !this.isAnnotation;
    }

    public Set<ClassInfo> getSubinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_IMPLEMENTING), true, this.scanSpec, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfSubinterfaces() {
        return ClassInfo.getClassNames(this.getSubinterfaces());
    }

    public boolean hasSubinterface(String subinterfaceName) {
        return this.getNamesOfSubinterfaces().contains(subinterfaceName);
    }

    public Set<ClassInfo> getDirectSubinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.CLASSES_IMPLEMENTING), true, this.scanSpec, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfDirectSubinterfaces() {
        return ClassInfo.getClassNames(this.getDirectSubinterfaces());
    }

    public boolean hasDirectSubinterface(String directSubinterfaceName) {
        return this.getNamesOfDirectSubinterfaces().contains(directSubinterfaceName);
    }

    public Set<ClassInfo> getSuperinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.IMPLEMENTED_INTERFACES), true, this.scanSpec, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfSuperinterfaces() {
        return ClassInfo.getClassNames(this.getSuperinterfaces());
    }

    public boolean hasSuperinterface(String superinterfaceName) {
        return this.getNamesOfSuperinterfaces().contains(superinterfaceName);
    }

    public Set<ClassInfo> getDirectSuperinterfaces() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.IMPLEMENTED_INTERFACES), true, this.scanSpec, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfDirectSuperinterfaces() {
        return ClassInfo.getClassNames(this.getDirectSuperinterfaces());
    }

    public boolean hasDirectSuperinterface(String directSuperinterfaceName) {
        return this.getNamesOfDirectSuperinterfaces().contains(directSuperinterfaceName);
    }

    public Set<ClassInfo> getImplementedInterfaces() {
        if (!this.isStandardClass()) {
            return Collections.emptySet();
        }
        Set<ClassInfo> superclasses = ClassInfo.filterClassInfo(this.getReachableClasses(RelType.SUPERCLASSES), true, this.scanSpec, ClassType.STANDARD_CLASS);
        HashSet<ClassInfo> allInterfaces = new HashSet<ClassInfo>();
        allInterfaces.addAll(this.getReachableClasses(RelType.IMPLEMENTED_INTERFACES));
        for (ClassInfo superClass : superclasses) {
            allInterfaces.addAll(superClass.getReachableClasses(RelType.IMPLEMENTED_INTERFACES));
        }
        return allInterfaces;
    }

    public List<String> getNamesOfImplementedInterfaces() {
        return ClassInfo.getClassNames(this.getImplementedInterfaces());
    }

    public boolean implementsInterface(String interfaceName) {
        return this.getNamesOfImplementedInterfaces().contains(interfaceName);
    }

    public Set<ClassInfo> getDirectlyImplementedInterfaces() {
        return !this.isStandardClass() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.IMPLEMENTED_INTERFACES), true, this.scanSpec, ClassType.IMPLEMENTED_INTERFACE);
    }

    public List<String> getNamesOfDirectlyImplementedInterfaces() {
        return ClassInfo.getClassNames(this.getDirectlyImplementedInterfaces());
    }

    public boolean directlyImplementsInterface(String interfaceName) {
        return this.getNamesOfDirectlyImplementedInterfaces().contains(interfaceName);
    }

    public Set<ClassInfo> getClassesImplementing() {
        if (!this.isImplementedInterface()) {
            return Collections.emptySet();
        }
        Set<ClassInfo> implementingClasses = ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_IMPLEMENTING), true, this.scanSpec, ClassType.STANDARD_CLASS);
        HashSet<ClassInfo> allImplementingClasses = new HashSet<ClassInfo>();
        for (ClassInfo implementingClass : implementingClasses) {
            allImplementingClasses.add(implementingClass);
            allImplementingClasses.addAll(implementingClass.getReachableClasses(RelType.SUBCLASSES));
        }
        return allImplementingClasses;
    }

    public List<String> getNamesOfClassesImplementing() {
        return ClassInfo.getClassNames(this.getClassesImplementing());
    }

    public boolean isImplementedByClass(String className) {
        return this.getNamesOfClassesImplementing().contains(className);
    }

    public Set<ClassInfo> getClassesDirectlyImplementing() {
        return !this.isImplementedInterface() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.CLASSES_IMPLEMENTING), true, this.scanSpec, ClassType.STANDARD_CLASS);
    }

    public List<String> getNamesOfClassesDirectlyImplementing() {
        return ClassInfo.getClassNames(this.getClassesDirectlyImplementing());
    }

    public boolean isDirectlyImplementedByClass(String className) {
        return this.getNamesOfClassesDirectlyImplementing().contains(className);
    }

    static List<String> getNamesOfAllAnnotationClasses(ScanSpec scanSpec, Set<ClassInfo> allClassInfo) {
        return ClassInfo.getClassNames(ClassInfo.filterClassInfo(allClassInfo, true, scanSpec, ClassType.ANNOTATION));
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    private Set<ClassInfo> getClassesWithAnnotation(boolean direct) {
        if (!this.isAnnotation()) {
            return Collections.emptySet();
        }
        Set<ClassInfo> classesWithAnnotation = ClassInfo.filterClassInfo(direct ? this.getDirectlyRelatedClasses(RelType.CLASSES_WITH_CLASS_ANNOTATION) : this.getReachableClasses(RelType.CLASSES_WITH_CLASS_ANNOTATION), true, this.scanSpec, ClassType.STANDARD_CLASS, ClassType.IMPLEMENTED_INTERFACE);
        boolean isInherited = false;
        for (ClassInfo metaAnnotation : this.getDirectlyRelatedClasses(RelType.CLASS_ANNOTATIONS)) {
            if (!metaAnnotation.className.equals("java.lang.annotation.Inherited")) continue;
            isInherited = true;
            break;
        }
        if (isInherited) {
            HashSet<ClassInfo> classesWithAnnotationAndTheirSubclasses = new HashSet<ClassInfo>(classesWithAnnotation);
            for (ClassInfo classWithAnnotation : classesWithAnnotation) {
                classesWithAnnotationAndTheirSubclasses.addAll(classWithAnnotation.getSubclasses());
            }
            return classesWithAnnotationAndTheirSubclasses;
        }
        return classesWithAnnotation;
    }

    public Set<ClassInfo> getClassesWithAnnotation() {
        return this.getClassesWithAnnotation(false);
    }

    public List<String> getNamesOfClassesWithAnnotation() {
        return ClassInfo.getClassNames(this.getClassesWithAnnotation());
    }

    public boolean annotatesClass(String annotatedClassName) {
        return this.getNamesOfClassesWithAnnotation().contains(annotatedClassName);
    }

    public Set<ClassInfo> getClassesWithDirectAnnotation() {
        return this.getClassesWithAnnotation(true);
    }

    public List<String> getNamesOfClassesWithDirectAnnotation() {
        return ClassInfo.getClassNames(this.getClassesWithDirectAnnotation());
    }

    public boolean directlyAnnotatesClass(String directlyAnnotatedClassName) {
        return this.getNamesOfClassesWithDirectAnnotation().contains(directlyAnnotatedClassName);
    }

    public Set<ClassInfo> getAnnotations() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASS_ANNOTATIONS), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfAnnotations() {
        return ClassInfo.getClassNames(this.getAnnotations());
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getNamesOfAnnotations().contains(annotationName);
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public List<AnnotationInfo.AnnotationParamValue> getAnnotationDefaultParamValues() {
        return this.annotationDefaultParamValues == null ? Collections.emptyList() : this.annotationDefaultParamValues;
    }

    public Set<ClassInfo> getDirectAnnotations() {
        return ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.CLASS_ANNOTATIONS), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfDirectAnnotations() {
        return ClassInfo.getClassNames(this.getDirectAnnotations());
    }

    public boolean hasDirectAnnotation(String directAnnotationName) {
        return this.getNamesOfDirectAnnotations().contains(directAnnotationName);
    }

    public Set<ClassInfo> getMetaAnnotations() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASS_ANNOTATIONS), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfMetaAnnotations() {
        return ClassInfo.getClassNames(this.getMetaAnnotations());
    }

    public boolean hasMetaAnnotation(String metaAnnotationName) {
        return this.getNamesOfMetaAnnotations().contains(metaAnnotationName);
    }

    public Set<ClassInfo> getAnnotationsWithMetaAnnotation() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_WITH_CLASS_ANNOTATION), true, this.scanSpec, ClassType.ANNOTATION);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation() {
        return ClassInfo.getClassNames(this.getAnnotationsWithMetaAnnotation());
    }

    public boolean metaAnnotatesAnnotation(String annotationName) {
        return this.getNamesOfAnnotationsWithMetaAnnotation().contains(annotationName);
    }

    public Set<ClassInfo> getAnnotationsWithDirectMetaAnnotation() {
        return !this.isAnnotation() ? Collections.emptySet() : ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.CLASSES_WITH_CLASS_ANNOTATION), true, this.scanSpec, ClassType.ANNOTATION);
    }

    public List<String> getNamesOfAnnotationsWithDirectMetaAnnotation() {
        return ClassInfo.getClassNames(this.getAnnotationsWithDirectMetaAnnotation());
    }

    public boolean hasDirectMetaAnnotation(String directMetaAnnotationName) {
        return this.getNamesOfAnnotationsWithDirectMetaAnnotation().contains(directMetaAnnotationName);
    }

    public List<MethodInfo> getMethodInfo() {
        if (!this.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Cannot get method info without calling FastClasspathScanner#enableMethodInfo() before starting the scan");
        }
        if (this.methodInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> nonConstructorMethods = new ArrayList<MethodInfo>();
        for (MethodInfo mi : this.methodInfo) {
            String methodName = mi.getMethodName();
            if (methodName.equals("<init>") || methodName.equals("<clinit>")) continue;
            nonConstructorMethods.add(mi);
        }
        return nonConstructorMethods;
    }

    public List<MethodInfo> getConstructorInfo() {
        if (!this.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Cannot get method info without calling FastClasspathScanner#enableMethodInfo() before starting the scan");
        }
        if (this.methodInfo == null) {
            return Collections.emptyList();
        }
        ArrayList<MethodInfo> nonConstructorMethods = new ArrayList<MethodInfo>();
        for (MethodInfo mi : this.methodInfo) {
            String methodName = mi.getMethodName();
            if (!methodName.equals("<init>")) continue;
            nonConstructorMethods.add(mi);
        }
        return nonConstructorMethods;
    }

    public List<MethodInfo> getMethodAndConstructorInfo() {
        if (!this.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Cannot get method info without calling FastClasspathScanner#enableMethodInfo() before starting the scan");
        }
        return this.methodInfo == null ? Collections.emptyList() : this.methodInfo;
    }

    public List<MethodInfo> getMethodInfo(String methodName) {
        List<MethodInfo> methodList;
        if (!this.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Cannot get method info without calling FastClasspathScanner#enableMethodInfo() before starting the scan");
        }
        if (this.methodInfo == null) {
            return null;
        }
        if (this.methodNameToMethodInfo == null) {
            this.methodNameToMethodInfo = new MultiMapKeyToList();
            for (MethodInfo f : this.methodInfo) {
                this.methodNameToMethodInfo.put(f.getMethodName(), f);
            }
        }
        return (methodList = this.methodNameToMethodInfo.get(methodName)) == null ? Collections.emptyList() : methodList;
    }

    public Set<ClassInfo> getMethodDirectAnnotations() {
        return ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.METHOD_ANNOTATIONS), true, this.scanSpec, ClassType.ANNOTATION);
    }

    public Set<ClassInfo> getMethodAnnotations() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.METHOD_ANNOTATIONS), true, this.scanSpec, ClassType.ANNOTATION);
    }

    public List<String> getNamesOfMethodDirectAnnotations() {
        return ClassInfo.getClassNames(this.getMethodDirectAnnotations());
    }

    public List<String> getNamesOfMethodAnnotations() {
        return ClassInfo.getClassNames(this.getMethodAnnotations());
    }

    public boolean hasMethodWithDirectAnnotation(String annotationName) {
        return this.getNamesOfMethodDirectAnnotations().contains(annotationName);
    }

    public boolean hasMethodWithAnnotation(String annotationName) {
        return this.getNamesOfMethodAnnotations().contains(annotationName);
    }

    public Set<ClassInfo> getClassesWithDirectMethodAnnotation() {
        return ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.CLASSES_WITH_METHOD_ANNOTATION), true, this.scanSpec, ClassType.ALL);
    }

    public Set<ClassInfo> getClassesWithMethodAnnotation() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_WITH_METHOD_ANNOTATION), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfClassesWithDirectMethodAnnotation() {
        return ClassInfo.getClassNames(this.getClassesWithDirectMethodAnnotation());
    }

    public List<String> getNamesOfClassesWithMethodAnnotation() {
        return ClassInfo.getClassNames(this.getClassesWithMethodAnnotation());
    }

    public boolean annotatesMethodOfClass(String className) {
        return this.getNamesOfClassesWithMethodAnnotation().contains(className);
    }

    static List<String> getNamesOfClassesWithDirectMethodAnnotation(String annotationName, Set<ClassInfo> allClassInfo) {
        ArrayList<String> namesOfClassesWithNamedMethodAnnotation = new ArrayList<String>();
        block0: for (ClassInfo classInfo : allClassInfo) {
            for (ClassInfo annotationType : classInfo.getDirectlyRelatedClasses(RelType.METHOD_ANNOTATIONS)) {
                if (!annotationType.className.equals(annotationName)) continue;
                namesOfClassesWithNamedMethodAnnotation.add(classInfo.className);
                continue block0;
            }
        }
        if (!namesOfClassesWithNamedMethodAnnotation.isEmpty()) {
            Collections.sort(namesOfClassesWithNamedMethodAnnotation);
        }
        return namesOfClassesWithNamedMethodAnnotation;
    }

    static List<String> getNamesOfClassesWithMethodAnnotation(String annotationName, Set<ClassInfo> allClassInfo) {
        ArrayList<String> namesOfClassesWithNamedMethodAnnotation = new ArrayList<String>();
        block0: for (ClassInfo classInfo : allClassInfo) {
            for (ClassInfo annotationType : classInfo.getReachableClasses(RelType.METHOD_ANNOTATIONS)) {
                if (!annotationType.className.equals(annotationName)) continue;
                namesOfClassesWithNamedMethodAnnotation.add(classInfo.className);
                continue block0;
            }
        }
        if (!namesOfClassesWithNamedMethodAnnotation.isEmpty()) {
            Collections.sort(namesOfClassesWithNamedMethodAnnotation);
        }
        return namesOfClassesWithNamedMethodAnnotation;
    }

    Object getStaticFinalFieldConstantInitializerValue(String fieldName) {
        return this.staticFinalFieldNameToConstantInitializerValue == null ? null : this.staticFinalFieldNameToConstantInitializerValue.get(fieldName);
    }

    public List<FieldInfo> getFieldInfo() {
        if (!this.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Cannot get field info without calling FastClasspathScanner#enableFieldInfo() before starting the scan");
        }
        return this.fieldInfo == null ? Collections.emptyList() : this.fieldInfo;
    }

    public FieldInfo getFieldInfo(String fieldName) {
        if (!this.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Cannot get field info without calling FastClasspathScanner#enableFieldInfo() before starting the scan");
        }
        if (this.fieldInfo == null) {
            return null;
        }
        if (this.fieldNameToFieldInfo == null) {
            this.fieldNameToFieldInfo = new HashMap<String, FieldInfo>();
            for (FieldInfo f : this.fieldInfo) {
                this.fieldNameToFieldInfo.put(f.getFieldName(), f);
            }
        }
        return this.fieldNameToFieldInfo.get(fieldName);
    }

    public Set<ClassInfo> getFieldAnnotations() {
        return ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.FIELD_ANNOTATIONS), true, this.scanSpec, ClassType.ANNOTATION);
    }

    public List<String> getNamesOfFieldAnnotations() {
        return ClassInfo.getClassNames(this.getFieldAnnotations());
    }

    public boolean hasFieldWithAnnotation(String annotationName) {
        return this.getNamesOfFieldAnnotations().contains(annotationName);
    }

    public Set<ClassInfo> getClassesWithFieldAnnotation() {
        return ClassInfo.filterClassInfo(this.getReachableClasses(RelType.CLASSES_WITH_FIELD_ANNOTATION), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfClassesWithFieldAnnotation() {
        return ClassInfo.getClassNames(this.getClassesWithFieldAnnotation());
    }

    public Set<ClassInfo> getClassesWithDirectFieldAnnotation() {
        return ClassInfo.filterClassInfo(this.getDirectlyRelatedClasses(RelType.CLASSES_WITH_FIELD_ANNOTATION), true, this.scanSpec, ClassType.ALL);
    }

    public List<String> getNamesOfClassesWithDirectFieldAnnotation() {
        return ClassInfo.getClassNames(this.getClassesWithDirectFieldAnnotation());
    }

    public boolean annotatesFieldOfClass(String className) {
        return this.getNamesOfClassesWithFieldAnnotation().contains(className);
    }

    static List<String> getNamesOfClassesWithFieldAnnotation(String annotationName, Set<ClassInfo> allClassInfo) {
        ArrayList<String> namesOfClassesWithNamedFieldAnnotation = new ArrayList<String>();
        block0: for (ClassInfo classInfo : allClassInfo) {
            for (ClassInfo annotationType : classInfo.getReachableClasses(RelType.FIELD_ANNOTATIONS)) {
                if (!annotationType.className.equals(annotationName)) continue;
                namesOfClassesWithNamedFieldAnnotation.add(classInfo.className);
                continue block0;
            }
        }
        if (!namesOfClassesWithNamedFieldAnnotation.isEmpty()) {
            Collections.sort(namesOfClassesWithNamedFieldAnnotation);
        }
        return namesOfClassesWithNamedFieldAnnotation;
    }

    static List<String> getNamesOfClassesWithDirectFieldAnnotation(String annotationName, Set<ClassInfo> allClassInfo) {
        ArrayList<String> namesOfClassesWithNamedFieldAnnotation = new ArrayList<String>();
        block0: for (ClassInfo classInfo : allClassInfo) {
            for (ClassInfo annotationType : classInfo.getDirectlyRelatedClasses(RelType.FIELD_ANNOTATIONS)) {
                if (!annotationType.className.equals(annotationName)) continue;
                namesOfClassesWithNamedFieldAnnotation.add(classInfo.className);
                continue block0;
            }
        }
        if (!namesOfClassesWithNamedFieldAnnotation.isEmpty()) {
            Collections.sort(namesOfClassesWithNamedFieldAnnotation);
        }
        return namesOfClassesWithNamedFieldAnnotation;
    }

    static enum ClassType {
        ALL,
        STANDARD_CLASS,
        IMPLEMENTED_INTERFACE,
        ANNOTATION,
        INTERFACE_OR_ANNOTATION;

    }

    private static enum RelType {
        SUPERCLASSES,
        SUBCLASSES,
        CONTAINS_INNER_CLASS,
        CONTAINED_WITHIN_OUTER_CLASS,
        IMPLEMENTED_INTERFACES,
        CLASSES_IMPLEMENTING,
        CLASS_ANNOTATIONS,
        CLASSES_WITH_CLASS_ANNOTATION,
        METHOD_ANNOTATIONS,
        CLASSES_WITH_METHOD_ANNOTATION,
        FIELD_ANNOTATIONS,
        CLASSES_WITH_FIELD_ANNOTATION;

    }
}

