/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassTypeOrTypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.MethodSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MethodInfo
extends ScanResult.InfoObject
implements Comparable<MethodInfo> {
    private final String className;
    ClassInfo classInfo;
    private final String methodName;
    private final int modifiers;
    private final String typeDescriptorInternal;
    private MethodSignature typeSignatureInternal;
    private final String typeDescriptorHumanReadable;
    private MethodSignature typeSignatureHumanReadable;
    private final String[] parameterNames;
    private final int[] parameterAccessFlagsInternal;
    private int[] parameterAccessFlags;
    final AnnotationInfo[][] parameterAnnotationInfo;
    private AnnotationInfo[][] parameterAnnotationInfoInternal;
    final List<AnnotationInfo> annotationInfo;
    private ScanResult scanResult;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final TypeSignature[] EMPTY_TYPE_SIGNATURE_ARRAY = new TypeSignature[0];
    private static final TypeParameter[] EMPTY_TYPE_PARAMETER_ARRAY = new TypeParameter[0];
    private static final ClassTypeOrTypeVariableSignature[] EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY = new ClassTypeOrTypeVariableSignature[0];
    private static final Class<?>[] EMPTY_CLASS_REF_ARRAY = new Class[0];
    private static final AnnotationInfo[] NO_ANNOTATIONS = new AnnotationInfo[0];

    @Override
    void setScanResult(ScanResult scanResult) {
        int i;
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (i = 0; i < this.annotationInfo.size(); ++i) {
                AnnotationInfo ai = this.annotationInfo.get(i);
                ai.setScanResult(scanResult);
            }
        }
        if (this.parameterAnnotationInfo != null) {
            for (i = 0; i < this.parameterAnnotationInfo.length; ++i) {
                AnnotationInfo[] pai = this.parameterAnnotationInfo[i];
                if (pai == null) continue;
                for (AnnotationInfo ai : pai) {
                    ai.setScanResult(scanResult);
                }
            }
        }
    }

    public MethodInfo(String className, String methodName, int modifiers, String typeDescriptorInternal, String typeDescriptorHumanReadable, String[] parameterNames, int[] parameterAccessFlagsInternal, List<AnnotationInfo> methodAnnotationInfo, AnnotationInfo[][] parameterAnnotationInfo) {
        this.className = className;
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.typeDescriptorInternal = typeDescriptorInternal;
        this.typeDescriptorHumanReadable = typeDescriptorHumanReadable;
        this.parameterNames = parameterNames;
        this.parameterAccessFlagsInternal = parameterAccessFlagsInternal;
        this.parameterAnnotationInfo = parameterAnnotationInfo;
        this.annotationInfo = methodAnnotationInfo == null || methodAnnotationInfo.isEmpty() ? Collections.emptyList() : methodAnnotationInfo;
    }

    public String getModifiersStr() {
        return TypeUtils.modifiersToString(this.getModifiers(), true);
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getTypeDescriptorInternal() {
        return this.typeDescriptorInternal;
    }

    public String getTypeDescriptor() {
        if (this.typeDescriptorHumanReadable == null) {
            return this.typeDescriptorInternal;
        }
        return this.typeDescriptorHumanReadable;
    }

    public MethodSignature getTypeSignatureInternal() {
        if (this.typeSignatureInternal == null) {
            this.typeSignatureInternal = MethodSignature.parse(this.classInfo, this.typeDescriptorInternal);
        }
        return this.typeSignatureInternal;
    }

    public MethodSignature getTypeSignature() {
        if (this.typeDescriptorHumanReadable == null) {
            return this.getTypeSignatureInternal();
        }
        if (this.typeSignatureHumanReadable == null) {
            this.typeSignatureHumanReadable = MethodSignature.parse(this.classInfo, this.typeDescriptorHumanReadable);
        }
        return this.typeSignatureHumanReadable;
    }

    public MethodSignature getTypeSignatureUnified() {
        if (this.getTypeSignature() == null) {
            return this.getTypeSignatureInternal();
        }
        if (this.getTypeSignatureInternal() == null) {
            return this.getTypeSignature();
        }
        return MethodSignature.merge(this.getTypeSignature(), this.getTypeSignatureInternal(), this.getParameterModifiersInternal());
    }

    public TypeSignature getResultTypeSignature() {
        return this.getTypeSignature().getResultType();
    }

    public String getResultTypeStr() {
        return this.getResultTypeSignature().toString();
    }

    public Class<?> getResultType() throws IllegalArgumentException {
        return this.getResultTypeSignature().instantiate(this.scanResult);
    }

    private static String[] toStringArray(List<?> list) {
        if (list.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).toString();
        }
        return stringArray;
    }

    private static Class<?>[] toClassRefs(List<? extends TypeSignature> typeSignatures, ScanResult scanResult) {
        if (typeSignatures.size() == 0) {
            return EMPTY_CLASS_REF_ARRAY;
        }
        Class[] classRefArray = new Class[typeSignatures.size()];
        for (int i = 0; i < typeSignatures.size(); ++i) {
            classRefArray[i] = typeSignatures.get(i).instantiate(scanResult);
        }
        return classRefArray;
    }

    private static TypeSignature[] toTypeSignatureArray(List<? extends TypeSignature> typeSignatures) {
        if (typeSignatures.size() == 0) {
            return EMPTY_TYPE_SIGNATURE_ARRAY;
        }
        return typeSignatures.toArray(new TypeSignature[typeSignatures.size()]);
    }

    private static ClassTypeOrTypeVariableSignature[] toTypeOrTypeVariableSignatureArray(List<? extends ClassTypeOrTypeVariableSignature> typeSignatures) {
        if (typeSignatures.size() == 0) {
            return EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY;
        }
        return typeSignatures.toArray(new ClassTypeOrTypeVariableSignature[typeSignatures.size()]);
    }

    private static TypeParameter[] toTypeParameterArray(List<? extends TypeParameter> typeParameters) {
        if (typeParameters.size() == 0) {
            return EMPTY_TYPE_PARAMETER_ARRAY;
        }
        return typeParameters.toArray(new TypeParameter[typeParameters.size()]);
    }

    public TypeSignature[] getParameterTypeSignatures() {
        return MethodInfo.toTypeSignatureArray(this.getTypeSignature().getParameterTypeSignatures());
    }

    public Class<?>[] getParameterTypes() throws IllegalArgumentException {
        return MethodInfo.toClassRefs(this.getTypeSignature().getParameterTypeSignatures(), this.scanResult);
    }

    public String[] getParameterTypeStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getParameterTypeSignatures());
    }

    public ClassTypeOrTypeVariableSignature[] getThrowsTypeSignatures() {
        return MethodInfo.toTypeOrTypeVariableSignatureArray(this.getTypeSignature().getThrowsSignatures());
    }

    public Class<?>[] getThrowsTypes() {
        return MethodInfo.toClassRefs(this.getTypeSignature().getThrowsSignatures(), this.scanResult);
    }

    public String[] getThrowsTypeStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getThrowsSignatures());
    }

    public TypeParameter[] getTypeParameters() {
        return MethodInfo.toTypeParameterArray(this.getTypeSignature().getTypeParameters());
    }

    public String[] getTypeParameterStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getTypeParameters());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int[] getParameterModifiers() {
        if (this.parameterAccessFlagsInternal == null) {
            return null;
        }
        if (this.parameterAccessFlags == null) {
            int i;
            int numNonSyntheticParams = 0;
            for (i = 0; i < this.parameterAccessFlagsInternal.length; ++i) {
                if ((this.parameterAccessFlagsInternal[i] & 0x1000) != 0) continue;
                ++numNonSyntheticParams;
            }
            this.parameterAccessFlags = new int[numNonSyntheticParams];
            int j = 0;
            for (i = 0; i < this.parameterAccessFlagsInternal.length; ++i) {
                if ((this.parameterAccessFlagsInternal[i] & 0x1000) != 0) continue;
                this.parameterAccessFlags[j++] = this.parameterAccessFlagsInternal[i];
            }
        }
        return this.parameterAccessFlags;
    }

    public int[] getParameterModifiersInternal() {
        return this.parameterAccessFlagsInternal;
    }

    public String[] getParameterModifierStrs() {
        if (this.parameterAccessFlagsInternal == null) {
            return null;
        }
        String[] parameterModifierStrs = new String[this.parameterAccessFlagsInternal.length];
        for (int i = 0; i < this.parameterAccessFlagsInternal.length; ++i) {
            parameterModifierStrs[i] = TypeUtils.modifiersToString(this.parameterAccessFlagsInternal[i], false);
        }
        return parameterModifierStrs;
    }

    public String[][] getParameterAnnotationNames() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        String[][] parameterAnnotationNames = new String[this.parameterAnnotationInfo.length][];
        for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
            parameterAnnotationNames[i] = AnnotationInfo.getUniqueAnnotationNamesSorted(this.parameterAnnotationInfo[i]);
        }
        return parameterAnnotationNames;
    }

    public Class<?>[][] getParameterAnnotationTypes() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        String[][] parameterAnnotationNames = this.getParameterAnnotationNames();
        Class[][] parameterAnnotationTypes = new Class[parameterAnnotationNames.length][];
        for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
            parameterAnnotationTypes[i] = new Class[parameterAnnotationNames[i].length];
            for (int j = 0; j < parameterAnnotationNames[i].length; ++j) {
                parameterAnnotationTypes[i][j] = this.scanResult.classNameToClassRef(parameterAnnotationNames[i][j]);
            }
        }
        return parameterAnnotationTypes;
    }

    public AnnotationInfo[][] getParameterAnnotationInfo() {
        return this.parameterAnnotationInfo;
    }

    private AnnotationInfo[][] getParameterAnnotationInfoInternal() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        if (this.parameterAnnotationInfoInternal == null) {
            if (this.parameterAccessFlagsInternal == null || this.parameterAccessFlagsInternal.length == this.parameterAnnotationInfo.length) {
                return this.parameterAnnotationInfo;
            }
            this.parameterAnnotationInfoInternal = new AnnotationInfo[this.parameterAccessFlagsInternal.length][];
            int j = 0;
            for (int i = 0; i < this.parameterAccessFlagsInternal.length; ++i) {
                this.parameterAnnotationInfoInternal[i] = (this.parameterAccessFlagsInternal[i] & 0x1000) == 0 ? this.parameterAnnotationInfo[j++] : NO_ANNOTATIONS;
            }
            if (j < this.parameterAnnotationInfo.length) {
                throw new IllegalArgumentException("Parameter arity mismatch in getParameterAnnotationInfoInternal()");
            }
        }
        return this.parameterAnnotationInfoInternal;
    }

    public List<String> getAnnotationNames() {
        return Arrays.asList(AnnotationInfo.getUniqueAnnotationNamesSorted(this.annotationInfo));
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationInfo == null || this.annotationInfo.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.getAnnotationNames()) {
            annotationClassRefs.add(this.scanResult.classNameToClassRef(annotationName));
        }
        return annotationClassRefs;
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.className.equals(other.className) && this.typeDescriptorInternal.equals(other.typeDescriptorInternal) && this.methodName.equals(other.methodName);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.typeDescriptorInternal.hashCode() * 11 + this.className.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.className.compareTo(other.className);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.methodName.compareTo(other.methodName);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptorInternal.compareTo(other.typeDescriptorInternal);
    }

    public String toString() {
        return this.getTypeSignatureUnified().toString(this.annotationInfo, this.modifiers, this.isConstructor(), this.methodName, this.isVarArgs(), this.parameterNames, this.parameterAccessFlagsInternal, this.getParameterAnnotationInfoInternal());
    }
}

