/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassTypeOrTypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeArgument;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeVariableSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ClassTypeSignature
extends ClassTypeOrTypeVariableSignature {
    final String className;
    private String classNameAndSuffixesWithoutTypeArguments;
    private final List<TypeArgument> typeArguments;
    private final List<String> suffixes;
    private final List<List<TypeArgument>> suffixTypeArguments;

    public ClassTypeSignature(String className, List<TypeArgument> typeArguments, List<String> suffixes, List<List<TypeArgument>> suffixTypeArguments) {
        this.className = className;
        this.typeArguments = typeArguments;
        this.suffixes = suffixes;
        this.suffixTypeArguments = suffixTypeArguments;
    }

    public String getClassName() {
        return this.className;
    }

    public List<TypeArgument> getTypeArguments() {
        return this.typeArguments;
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    public List<List<TypeArgument>> getSuffixTypeArguments() {
        return this.suffixTypeArguments;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        classNameListOut.add(this.className);
        classNameListOut.add(this.getClassNameAndSuffixesWithoutTypeArguments());
        for (TypeArgument typeArgument : this.typeArguments) {
            typeArgument.getAllReferencedClassNames(classNameListOut);
        }
    }

    @Override
    public Class<?> instantiate(ScanResult scanResult) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.className);
        for (int i = 0; i < this.suffixes.size(); ++i) {
            buf.append("$");
            buf.append(this.suffixes.get(i));
        }
        String classNameWithSuffixes = buf.toString();
        return scanResult.classNameToClassRef(classNameWithSuffixes);
    }

    public String getClassNameAndSuffixesWithoutTypeArguments() {
        if (this.classNameAndSuffixesWithoutTypeArguments == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.className);
            for (int i = 0; i < this.suffixes.size(); ++i) {
                buf.append('$');
                buf.append(this.suffixes.get(i));
            }
            this.classNameAndSuffixesWithoutTypeArguments = buf.toString();
        }
        return this.classNameAndSuffixesWithoutTypeArguments;
    }

    public int hashCode() {
        return this.className.hashCode() + 7 * this.typeArguments.hashCode() + 15 * this.suffixes.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassTypeSignature)) {
            return false;
        }
        ClassTypeSignature o = (ClassTypeSignature)obj;
        return o.className.equals(this.className) && o.typeArguments.equals(this.typeArguments) && o.suffixes.equals(this.suffixes);
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (other instanceof TypeVariableSignature) {
            return ((TypeVariableSignature)other).equalsIgnoringTypeParams(this);
        }
        if (!(other instanceof ClassTypeSignature)) {
            return false;
        }
        ClassTypeSignature o = (ClassTypeSignature)other;
        if (o.suffixes.equals(this.suffixes)) {
            return o.className.equals(this.className);
        }
        return o.getClassNameAndSuffixesWithoutTypeArguments().equals(this.getClassNameAndSuffixesWithoutTypeArguments());
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append(this.className);
        if (!this.typeArguments.isEmpty()) {
            buf.append('<');
            for (i = 0; i < this.typeArguments.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.typeArguments.get(i).toString());
            }
            buf.append('>');
        }
        for (i = 0; i < this.suffixes.size(); ++i) {
            buf.append('$');
            buf.append(this.suffixes.get(i));
            List<TypeArgument> suffixTypeArgs = this.suffixTypeArguments.get(i);
            if (suffixTypeArgs.isEmpty()) continue;
            buf.append('<');
            for (int j = 0; j < suffixTypeArgs.size(); ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(suffixTypeArgs.get(j).toString());
            }
            buf.append('>');
        }
        return buf.toString();
    }

    static ClassTypeSignature parse(TypeUtils.ParseState parseState) throws TypeUtils.ParseException {
        if (parseState.peek() == 'L') {
            List<List<TypeArgument>> suffixTypeArguments;
            List<String> suffixes;
            parseState.next();
            if (!parseState.parseIdentifier('/', '.')) {
                throw new TypeUtils.ParseException();
            }
            String className = parseState.currToken();
            List<TypeArgument> typeArguments = TypeArgument.parseList(parseState);
            if (parseState.peek() == '.') {
                suffixes = new ArrayList();
                suffixTypeArguments = new ArrayList();
                while (parseState.peek() == '.') {
                    parseState.expect('.');
                    if (!parseState.parseIdentifier('/', '.')) {
                        throw new TypeUtils.ParseException();
                    }
                    suffixes.add(parseState.currToken());
                    suffixTypeArguments.add(TypeArgument.parseList(parseState));
                }
            } else {
                suffixes = Collections.emptyList();
                suffixTypeArguments = Collections.emptyList();
            }
            parseState.expect(';');
            return new ClassTypeSignature(className, typeArguments, suffixes, suffixTypeArguments);
        }
        return null;
    }
}

