/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.typesignature.ArrayTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassTypeOrTypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MethodSignature
extends HierarchicalTypeSignature {
    final List<TypeParameter> typeParameters;
    private final List<TypeSignature> parameterTypeSignatures;
    private final TypeSignature resultType;
    private final List<ClassTypeOrTypeVariableSignature> throwsSignatures;

    public MethodSignature(List<TypeParameter> typeParameters, List<TypeSignature> paramTypes, TypeSignature resultType, List<ClassTypeOrTypeVariableSignature> throwsSignatures) {
        this.typeParameters = typeParameters;
        this.parameterTypeSignatures = paramTypes;
        this.resultType = resultType;
        this.throwsSignatures = throwsSignatures;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public List<TypeSignature> getParameterTypeSignatures() {
        return this.parameterTypeSignatures;
    }

    public TypeSignature getResultType() {
        return this.resultType;
    }

    public List<ClassTypeOrTypeVariableSignature> getThrowsSignatures() {
        return this.throwsSignatures;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        for (TypeParameter typeParameter : this.typeParameters) {
            typeParameter.getAllReferencedClassNames(classNameListOut);
        }
        for (TypeSignature typeSignature : this.parameterTypeSignatures) {
            typeSignature.getAllReferencedClassNames(classNameListOut);
        }
        this.resultType.getAllReferencedClassNames(classNameListOut);
        for (ClassTypeOrTypeVariableSignature classTypeOrTypeVariableSignature : this.throwsSignatures) {
            classTypeOrTypeVariableSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeParameters.hashCode() + this.parameterTypeSignatures.hashCode() * 7 + this.resultType.hashCode() * 15 + this.throwsSignatures.hashCode() * 31;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature o = (MethodSignature)obj;
        return o.typeParameters.equals(this.typeParameters) && o.parameterTypeSignatures.equals(this.parameterTypeSignatures) && o.resultType.equals(this.resultType) && o.throwsSignatures.equals(this.throwsSignatures);
    }

    public String toString(List<AnnotationInfo> annotationInfo, int modifiers, boolean isConstructor, String methodName, boolean isVarArgs, String[] parameterNames, int[] parameterAccessFlags, AnnotationInfo[][] parameterAnnotationInfo) {
        int i;
        if (parameterNames != null && this.parameterTypeSignatures.size() != parameterNames.length || parameterAccessFlags != null && this.parameterTypeSignatures.size() != parameterAccessFlags.length || parameterAnnotationInfo != null && this.parameterTypeSignatures.size() != parameterAnnotationInfo.length) {
            throw new RuntimeException("Parameter number mismatch");
        }
        StringBuilder buf = new StringBuilder();
        if (annotationInfo != null) {
            for (AnnotationInfo annotation : annotationInfo) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(annotation.toString());
            }
        }
        if (modifiers != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            TypeUtils.modifiersToString(modifiers, true, buf);
        }
        if (!this.typeParameters.isEmpty()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append('<');
            for (int i2 = 0; i2 < this.typeParameters.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                buf.append(this.typeParameters.get(i2).toString());
            }
            buf.append(">");
        }
        if (!isConstructor) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.resultType.toString());
        }
        buf.append(' ');
        if (methodName != null) {
            buf.append(methodName);
        }
        buf.append('(');
        for (i = 0; i < this.parameterTypeSignatures.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if (parameterAnnotationInfo != null) {
                AnnotationInfo[] annotationInfoForParameter = parameterAnnotationInfo[i];
                for (int j = 0; j < annotationInfoForParameter.length; ++j) {
                    buf.append(annotationInfoForParameter[j].toString());
                    buf.append(' ');
                }
            }
            if (parameterAccessFlags != null) {
                int flag = parameterAccessFlags[i];
                if ((flag & 0x10) != 0) {
                    buf.append("final ");
                }
                if ((flag & 0x1000) != 0) {
                    buf.append("synthetic ");
                }
                if ((flag & 0x8000) != 0) {
                    buf.append("mandated ");
                }
            }
            TypeSignature paramType = this.parameterTypeSignatures.get(i);
            if (isVarArgs && i == this.parameterTypeSignatures.size() - 1) {
                if (!(paramType instanceof ArrayTypeSignature)) {
                    throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + methodName);
                }
                ArrayTypeSignature arrayType = (ArrayTypeSignature)paramType;
                if (arrayType.numArrayDims == 0) {
                    throw new IllegalArgumentException("Got a zero-dimension array type for last parameter of varargs method " + methodName);
                }
                buf.append(new ArrayTypeSignature(arrayType.elementTypeSignature, arrayType.numArrayDims - 1).toString());
                buf.append("...");
            } else {
                buf.append(paramType.toString());
            }
            if (parameterNames == null) continue;
            String paramName = parameterNames[i];
            buf.append(' ');
            buf.append(paramName == null ? "_unnamed_param_" + i : paramName);
        }
        buf.append(')');
        if (!this.throwsSignatures.isEmpty()) {
            buf.append(" throws ");
            for (i = 0; i < this.throwsSignatures.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.throwsSignatures.get(i).toString());
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(null, 0, false, null, false, null, null, null);
    }

    public static MethodSignature merge(MethodSignature methodTypeSignature, MethodSignature methodTypeSignatureInternal, int[] parameterAccessFlagsInternal) {
        List<ClassTypeOrTypeVariableSignature> mergedThrowsSignatures;
        ArrayList<TypeSignature> mergedParamTypes;
        if (methodTypeSignature == null || methodTypeSignatureInternal == null) {
            throw new IllegalArgumentException("Signatures must be non-null");
        }
        if (!methodTypeSignatureInternal.typeParameters.isEmpty()) {
            throw new IllegalArgumentException("typeSignatureInternal.typeParameters should be empty");
        }
        if (!methodTypeSignatureInternal.resultType.equalsIgnoringTypeParams(methodTypeSignature.resultType)) {
            throw new IllegalArgumentException("Result types could not be reconciled: " + methodTypeSignatureInternal.resultType + " vs. " + methodTypeSignature.resultType);
        }
        if (parameterAccessFlagsInternal != null && parameterAccessFlagsInternal.length != methodTypeSignatureInternal.parameterTypeSignatures.size()) {
            throw new IllegalArgumentException("Parameter arity mismatch between access flags and internal param types");
        }
        if (parameterAccessFlagsInternal == null) {
            if (methodTypeSignature.parameterTypeSignatures.size() != methodTypeSignatureInternal.parameterTypeSignatures.size()) {
                throw new IllegalArgumentException("Unexpected mismatch in method paramTypes arity");
            }
            mergedParamTypes = methodTypeSignature.parameterTypeSignatures;
        } else {
            mergedParamTypes = new ArrayList(methodTypeSignatureInternal.parameterTypeSignatures.size());
            int paramIdx = 0;
            for (int internalParamIdx = 0; internalParamIdx < methodTypeSignatureInternal.parameterTypeSignatures.size(); ++internalParamIdx) {
                TypeSignature paramTypeSignatureInternal;
                TypeSignature paramTypeSignature;
                if ((parameterAccessFlagsInternal[internalParamIdx] & 0x1000) != 0) {
                    mergedParamTypes.add(methodTypeSignatureInternal.parameterTypeSignatures.get(internalParamIdx));
                    continue;
                }
                if (paramIdx == methodTypeSignature.parameterTypeSignatures.size()) {
                    throw new IllegalArgumentException("Ran out of parameters in programmer-visible type signature");
                }
                if (!(paramTypeSignature = methodTypeSignature.parameterTypeSignatures.get(paramIdx++)).equalsIgnoringTypeParams(paramTypeSignatureInternal = methodTypeSignatureInternal.parameterTypeSignatures.get(internalParamIdx))) {
                    throw new IllegalArgumentException("Corresponding type parameters in type signatures do not refer to the same bare types: " + paramTypeSignature + " [from method signature " + methodTypeSignature + "] vs. " + paramTypeSignatureInternal + " [from method signature " + methodTypeSignatureInternal + "]");
                }
                mergedParamTypes.add(paramTypeSignature);
            }
            if (paramIdx < methodTypeSignature.parameterTypeSignatures.size()) {
                throw new IllegalArgumentException("Parameter arity mismatch between internal and programmer-visible type signature");
            }
        }
        if (methodTypeSignature.throwsSignatures.isEmpty()) {
            mergedThrowsSignatures = methodTypeSignatureInternal.throwsSignatures;
        } else if (methodTypeSignatureInternal.throwsSignatures.isEmpty() || methodTypeSignature.throwsSignatures.equals(methodTypeSignatureInternal.throwsSignatures)) {
            mergedThrowsSignatures = methodTypeSignature.throwsSignatures;
        } else {
            AdditionOrderedSet<ClassTypeOrTypeVariableSignature> sigSet = new AdditionOrderedSet<ClassTypeOrTypeVariableSignature>(methodTypeSignature.throwsSignatures);
            sigSet.addAll(methodTypeSignatureInternal.throwsSignatures);
            mergedThrowsSignatures = sigSet.toList();
        }
        return new MethodSignature(methodTypeSignature.typeParameters, mergedParamTypes, methodTypeSignature.resultType, mergedThrowsSignatures);
    }

    public static MethodSignature parse(String typeDescriptor) {
        return MethodSignature.parse(null, typeDescriptor);
    }

    public static MethodSignature parse(ClassInfo classInfo, String typeDescriptor) {
        TypeUtils.ParseState parseState = new TypeUtils.ParseState(typeDescriptor);
        try {
            List<ClassTypeOrTypeVariableSignature> throwsSignatures;
            List<TypeParameter> typeParameters = TypeParameter.parseList(parseState);
            parseState.expect('(');
            ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>();
            while (parseState.peek() != ')') {
                if (!parseState.hasMore()) {
                    throw new TypeUtils.ParseException();
                }
                TypeSignature paramType = TypeSignature.parse(parseState);
                if (paramType == null) {
                    throw new TypeUtils.ParseException();
                }
                paramTypes.add(paramType);
            }
            parseState.expect(')');
            TypeSignature resultType = TypeSignature.parse(parseState);
            if (resultType == null) {
                throw new TypeUtils.ParseException();
            }
            if (parseState.peek() == '^') {
                throwsSignatures = new ArrayList();
                while (parseState.peek() == '^') {
                    parseState.expect('^');
                    ClassTypeSignature classTypeSignature = ClassTypeSignature.parse(parseState);
                    if (classTypeSignature != null) {
                        throwsSignatures.add(classTypeSignature);
                        continue;
                    }
                    TypeVariableSignature typeVariableSignature = TypeVariableSignature.parse(parseState);
                    if (typeVariableSignature != null) {
                        throwsSignatures.add(classTypeSignature);
                        continue;
                    }
                    throw new TypeUtils.ParseException();
                }
            } else {
                throwsSignatures = Collections.emptyList();
            }
            if (parseState.hasMore()) {
                throw new IllegalArgumentException("Extra characters at end of type descriptor: " + parseState);
            }
            MethodSignature methodSignature = new MethodSignature(typeParameters, paramTypes, resultType, throwsSignatures);
            for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                typeVariableSignature.containingMethodSignature = methodSignature;
            }
            if (classInfo != null) {
                ClassSignature classSignature = classInfo.getTypeSignature();
                for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                    typeVariableSignature.containingClassSignature = classSignature;
                }
            }
            return methodSignature;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type signature could not be parsed: " + parseState, e);
        }
    }
}

