/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.typesignature.TypeVariableSignature;
import java.util.ArrayList;
import java.util.List;

public class TypeUtils {
    public static final int MODIFIER_SYNTHETIC = 4096;
    public static final int MODIFIER_MANDATED = 32768;

    public static String modifiersToString(int modifiers, boolean isMethod) {
        StringBuilder buf = new StringBuilder();
        TypeUtils.modifiersToString(modifiers, isMethod, buf);
        return buf.toString();
    }

    public static void modifiersToString(int modifiers, boolean isMethod, StringBuilder buf) {
        if ((modifiers & 1) != 0) {
            buf.append("public");
        } else if ((modifiers & 4) != 0) {
            buf.append("protected");
        } else if ((modifiers & 2) != 0) {
            buf.append("private");
        }
        if ((modifiers & 0x400) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("abstract");
        }
        if ((modifiers & 8) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("static");
        }
        if ((modifiers & 0x10) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("final");
        }
        if (!isMethod && (modifiers & 0x80) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("transient");
        } else if ((modifiers & 0x40) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (!isMethod) {
                buf.append("volatile");
            } else {
                buf.append("bridge");
            }
        }
        if (!isMethod && (modifiers & 0x1000) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synthetic");
        }
        if ((modifiers & 0x20) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synchronized");
        }
        if ((modifiers & 0x100) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("native");
        }
        if ((modifiers & 0x800) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("strictfp");
        }
    }

    static class ParseState {
        private final String string;
        private int position;
        private final StringBuilder token = new StringBuilder();
        private final List<TypeVariableSignature> typeVariableSignatures = new ArrayList<TypeVariableSignature>();

        public ParseState(String string) {
            this.string = string;
        }

        public void addTypeVariableSignature(TypeVariableSignature typeVariableSignature) {
            this.typeVariableSignatures.add(typeVariableSignature);
        }

        public List<TypeVariableSignature> getTypeVariableSignatures() {
            return this.typeVariableSignatures;
        }

        public char getc() {
            if (this.position >= this.string.length()) {
                return '\u0000';
            }
            return this.string.charAt(this.position++);
        }

        public char peek() {
            return this.position == this.string.length() ? (char)'\u0000' : this.string.charAt(this.position);
        }

        public boolean peekMatches(String strMatch) {
            return this.string.regionMatches(this.position, strMatch, 0, strMatch.length());
        }

        public void next() {
            ++this.position;
        }

        public void advance(int n) {
            this.position += n;
        }

        public boolean hasMore() {
            return this.position < this.string.length();
        }

        public void expect(char c) {
            char next = this.getc();
            if (next != c) {
                throw new IllegalArgumentException("Got character '" + (char)next + "', expected '" + c + "' in string: " + this);
            }
        }

        public void appendToToken(String str) {
            this.token.append(str);
        }

        public void appendToToken(char c) {
            this.token.append(c);
        }

        public String currToken() {
            String tok = this.token.toString();
            this.token.setLength(0);
            return tok;
        }

        public boolean parseIdentifier(char separator, char separatorReplace) throws ParseException {
            boolean consumedChar = false;
            while (this.hasMore()) {
                char c = this.peek();
                if (c == separator) {
                    this.appendToToken(separatorReplace);
                    this.next();
                    consumedChar = true;
                    continue;
                }
                if (c == ';' || c == '[' || c == '<' || c == '>' || c == ':' || c == '/' || c == '.') break;
                this.appendToToken(c);
                this.next();
                consumedChar = true;
            }
            return consumedChar;
        }

        public boolean parseIdentifier() throws ParseException {
            return this.parseIdentifier('\u0000', '\u0000');
        }

        public String toString() {
            return this.string + " (position: " + this.position + "; token: \"" + this.token + "\")";
        }
    }

    static class ParseException
    extends Exception {
        static final long serialVersionUID = 1L;

        ParseException() {
        }
    }
}

