/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.MatchProcessorException;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FieldAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.matchers.ClassMatchProcessorWrapper;
import io.github.lukehutch.fastclasspathscanner.scanner.matchers.FileMatchProcessorAny;
import io.github.lukehutch.fastclasspathscanner.scanner.matchers.FileMatchProcessorWrapper;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToSet;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

public class ScanSpec {
    public final List<String> whitelistedPathPrefixes = new ArrayList<String>();
    public final List<String> whitelistedPathsNonRecursive = new ArrayList<String>();
    public final List<String> blacklistedPathPrefixes = new ArrayList<String>();
    public final List<String> blacklistedPackagePrefixes = new ArrayList<String>();
    public final Set<String> specificallyWhitelistedClassRelativePaths = new HashSet<String>();
    public final Set<String> specificallyWhitelistedClassParentRelativePaths = new HashSet<String>();
    public final Set<String> specificallyBlacklistedClassRelativePaths = new HashSet<String>();
    public final Set<String> specificallyBlacklistedClassNames = new HashSet<String>();
    public final Set<String> whitelistedJars = new HashSet<String>();
    public final Set<String> blacklistedJars = new HashSet<String>();
    public final List<Pattern> whitelistedJarPatterns = new ArrayList<Pattern>();
    public final List<Pattern> blacklistedJarPatterns = new ArrayList<Pattern>();
    public boolean scanJars = true;
    public boolean scanDirs = true;
    public boolean enableMethodAnnotationIndexing;
    public boolean enableFieldAnnotationIndexing;
    public boolean enableFieldInfo;
    public boolean enableMethodInfo;
    public boolean strictWhitelist;
    public boolean blacklistSystemJars = true;
    public boolean blacklistSystemPackages = true;
    public boolean ignoreFieldVisibility = false;
    public boolean ignoreMethodVisibility = false;
    public RetentionPolicy annotationVisibility = RetentionPolicy.CLASS;
    public boolean disableRecursiveScanning = false;
    public boolean suppressMatchProcessorExceptions = false;
    private MultiMapKeyToList<String, StaticFinalFieldMatchProcessor> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    private MultiMapKeyToSet<String, String> classNameToStaticFinalFieldsToMatch;
    private ArrayList<ClassMatchProcessorWrapper> classMatchers;
    private final List<FileMatchProcessorWrapper> fileMatchProcessorWrappers = new ArrayList<FileMatchProcessorWrapper>();
    public List<ClassLoader> addedClassLoaders;
    public List<ClassLoader> overrideClassLoaders;
    public ClassLoaderFinder classLoaderFinder;
    public String overrideClasspath;
    public final ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> extraClassLoaderHandlers = new ArrayList();
    public boolean initializeLoadedClasses = false;
    public boolean removeTemporaryFilesAfterScan = true;
    public boolean ignoreParentClassLoaders = false;

    public MultiMapKeyToSet<String, String> getClassNameToStaticFinalFieldsToMatch() {
        return this.classNameToStaticFinalFieldsToMatch;
    }

    public ScanSpec(String[] scanSpec, LogNode log) {
        HashSet<String> uniqueWhitelistedPathPrefixes = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPathPrefixes = new HashSet<String>();
        String[] stringArray = scanSpec;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String scanSpecEntry;
            String spec = scanSpecEntry = stringArray[i];
            if ("!".equals(scanSpecEntry)) {
                this.blacklistSystemPackages = false;
                continue;
            }
            if ("!!".equals(scanSpecEntry)) {
                this.blacklistSystemJars = false;
                this.blacklistSystemPackages = false;
                continue;
            }
            boolean blacklisted = spec.startsWith("-");
            if (blacklisted) {
                spec = spec.substring(1);
            }
            if (spec.startsWith("jar:")) {
                if ((spec = spec.substring(4)).indexOf(47) >= 0) {
                    if (log == null) continue;
                    log.log("Only a leaf filename may be used with a \"jar:\" entry in the scan spec, got \"" + spec + "\" -- ignoring");
                    continue;
                }
                if (spec.isEmpty()) {
                    if (blacklisted) {
                        this.scanJars = false;
                        continue;
                    }
                    if (log == null) continue;
                    log.log("Ignoring scan spec entry with no effect: \"" + scanSpecEntry + "\"");
                    continue;
                }
                if (blacklisted) {
                    if (spec.contains("*")) {
                        this.blacklistedJarPatterns.add(ScanSpec.specToPattern(spec));
                        continue;
                    }
                    this.blacklistedJars.add(spec);
                    continue;
                }
                if (spec.contains("*")) {
                    this.whitelistedJarPatterns.add(ScanSpec.specToPattern(spec));
                    continue;
                }
                this.whitelistedJars.add(spec);
                continue;
            }
            if (spec.startsWith("dir:")) {
                if (!(spec = spec.substring(4)).isEmpty() && log != null) {
                    log.log("Ignoring extra text after \"dir:\" in scan spec entry: " + scanSpecEntry);
                }
                if (blacklisted) {
                    this.scanDirs = false;
                    continue;
                }
                if (log == null) continue;
                log.log("Ignoring scan spec entry with no effect: \"" + scanSpecEntry + "\"");
                continue;
            }
            String specPath = spec.replace('.', '/');
            if (spec.startsWith("/")) {
                spec = spec.substring(1);
            }
            boolean isClassName = false;
            int lastSlashIdx = specPath.lastIndexOf(47);
            if (lastSlashIdx < specPath.length() - 1) {
                boolean bl = isClassName = Character.isUpperCase(specPath.charAt(lastSlashIdx + 1)) && !specPath.substring(lastSlashIdx + 1).equals("META-INF");
            }
            if (isClassName) {
                if (blacklisted) {
                    this.specificallyBlacklistedClassNames.add(spec);
                    this.specificallyBlacklistedClassRelativePaths.add(specPath + ".class");
                    continue;
                }
                this.specificallyWhitelistedClassRelativePaths.add(specPath + ".class");
                continue;
            }
            if (blacklisted) {
                uniqueBlacklistedPathPrefixes.add(specPath + "/");
                continue;
            }
            uniqueWhitelistedPathPrefixes.add(specPath + "/");
        }
        if (this.blacklistSystemPackages) {
            uniqueBlacklistedPathPrefixes.add("java/");
            uniqueBlacklistedPathPrefixes.add("javax/");
            uniqueBlacklistedPathPrefixes.add("sun/");
        }
        this.blacklistedPathPrefixes.addAll(uniqueBlacklistedPathPrefixes);
        if (uniqueBlacklistedPathPrefixes.contains("/")) {
            if (log != null) {
                log.log("Ignoring blacklist of root package, it would prevent all scanning");
            }
            uniqueBlacklistedPathPrefixes.remove("/");
        }
        for (String prefix : this.blacklistedPathPrefixes) {
            this.blacklistedPackagePrefixes.add(prefix.replace('/', '.'));
        }
        this.specificallyWhitelistedClassRelativePaths.removeAll(this.specificallyBlacklistedClassRelativePaths);
        for (String whitelistedClass : this.specificallyWhitelistedClassRelativePaths) {
            int lastSlashIdx = whitelistedClass.lastIndexOf(47);
            this.specificallyWhitelistedClassParentRelativePaths.add(whitelistedClass.substring(0, lastSlashIdx + 1));
        }
        uniqueWhitelistedPathPrefixes.removeAll(uniqueBlacklistedPathPrefixes);
        this.whitelistedPathPrefixes.addAll(uniqueWhitelistedPathPrefixes);
        if (this.whitelistedPathPrefixes.isEmpty() && this.whitelistedPathsNonRecursive.isEmpty() && this.specificallyWhitelistedClassRelativePaths.isEmpty()) {
            this.whitelistedPathPrefixes.add("/");
        }
        if (this.whitelistedPathPrefixes.contains("/")) {
            this.whitelistedPathPrefixes.add("");
        }
        this.whitelistedJars.removeAll(this.blacklistedJars);
        if (!this.scanJars && !this.scanDirs) {
            if (log != null) {
                log.log("Scanning of jars and dirs are both disabled -- re-enabling scanning of dirs");
            }
            this.scanDirs = true;
        }
        Collections.sort(this.whitelistedPathPrefixes);
        Collections.sort(this.whitelistedPathsNonRecursive);
        Collections.sort(this.blacklistedPathPrefixes);
        Collections.sort(this.blacklistedPackagePrefixes);
        if (log != null) {
            if (!this.blacklistedPathPrefixes.isEmpty()) {
                log.log("Blacklisted relative path prefixes:  " + this.blacklistedPathPrefixes);
            }
            if (!this.blacklistedJars.isEmpty()) {
                log.log("Blacklisted jars:  " + this.blacklistedJars);
            }
            if (!this.blacklistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.blacklistedJarPatterns);
            }
            if (!this.specificallyBlacklistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-blacklisted classfiles: " + this.specificallyBlacklistedClassRelativePaths);
            }
            if (!this.whitelistedPathPrefixes.isEmpty()) {
                log.log("Whitelisted relative path prefixes:  " + this.whitelistedPathPrefixes);
            }
            if (!this.whitelistedPathsNonRecursive.isEmpty()) {
                log.log("Whitelisted paths (non-recursive):  " + this.whitelistedPathsNonRecursive);
            }
            if (!this.whitelistedJars.isEmpty()) {
                log.log("Whitelisted jars:  " + this.whitelistedJars);
            }
            if (!this.whitelistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.whitelistedJarPatterns);
            }
            if (!this.specificallyWhitelistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-whitelisted classfiles: " + this.specificallyWhitelistedClassRelativePaths);
            }
            if (!this.scanJars) {
                log.log("Scanning of jarfiles is disabled");
            }
            if (!this.scanDirs) {
                log.log("Scanning of directories (i.e. non-jarfiles) is disabled");
            }
        }
    }

    public void registerClassLoaderHandler(Class<? extends ClassLoaderHandler> classLoaderHandler) {
        this.extraClassLoaderHandlers.add(new ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry(classLoaderHandler));
    }

    public void overrideClasspath(String overrideClasspath) {
        this.overrideClasspath = overrideClasspath;
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (this.addedClassLoaders == null) {
            this.addedClassLoaders = new ArrayList<ClassLoader>();
        }
        if (classLoader != null) {
            this.addedClassLoaders.add(classLoader);
        }
    }

    public void overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.addedClassLoaders = null;
        this.overrideClassLoaders = new ArrayList<ClassLoader>();
        for (ClassLoader classLoader : overrideClassLoaders) {
            if (classLoader == null) continue;
            this.overrideClassLoaders.add(classLoader);
        }
        if (this.overrideClassLoaders.isEmpty()) {
            this.overrideClassLoaders = null;
        } else {
            this.addedClassLoaders = null;
        }
    }

    public void ignoreParentClassLoaders(boolean ignoreParentClassloaders) {
        this.ignoreParentClassLoaders = ignoreParentClassloaders;
    }

    public boolean hasMatchProcessors() {
        return this.fileMatchProcessorWrappers != null && this.fileMatchProcessorWrappers.size() > 0 || this.classMatchers != null && this.classMatchers.size() > 0 || this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors != null && !this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.isEmpty();
    }

    public void callMatchProcessors(ScanResult scanResult) {
        LogNode log = scanResult.log;
        try {
            for (ClasspathElement classpathElement : scanResult.classpathOrder) {
                classpathElement.callFileMatchProcessors(scanResult, log);
            }
            scanResult.interruptionChecker.check();
            if (this.classMatchers != null) {
                LogNode subLog = log == null ? null : log.log("Calling ClassMatchProcessors");
                for (ClassMatchProcessorWrapper classMatcher : this.classMatchers) {
                    classMatcher.lookForMatches(scanResult, subLog);
                }
            }
            if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors != null) {
                for (Map.Entry entry : this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.getRawMap().entrySet()) {
                    int dotIdx;
                    String fullyQualifiedFieldName = (String)entry.getKey();
                    String className = fullyQualifiedFieldName.substring(0, dotIdx = fullyQualifiedFieldName.lastIndexOf(46));
                    ClassInfo classInfo = scanResult.classGraphBuilder.classNameToClassInfo.get(className);
                    if (classInfo != null) {
                        String fieldName = fullyQualifiedFieldName.substring(dotIdx + 1);
                        Object constValue = classInfo.getStaticFinalFieldConstantInitializerValue(fieldName);
                        if (constValue == null) {
                            if (log == null) continue;
                            log.log("No constant initializer value found for field " + className + "." + fieldName);
                            continue;
                        }
                        List staticFinalFieldMatchProcessors = (List)entry.getValue();
                        if (log != null) {
                            log.log("Calling MatchProcessor" + (staticFinalFieldMatchProcessors.size() == 1 ? "" : "s") + " for static final field " + className + "." + fieldName + " = " + (constValue instanceof Character ? '\'' + constValue.toString().replace("'", "\\'") + '\'' : (constValue instanceof String ? '\"' + constValue.toString().replace("\"", "\\\"") + '\"' : constValue.toString())));
                        }
                        for (StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor : (List)entry.getValue()) {
                            try {
                                staticFinalFieldMatchProcessor.processMatch(className, fieldName, constValue);
                            }
                            catch (Throwable e) {
                                if (log != null) {
                                    log.log("Exception while calling StaticFinalFieldMatchProcessor: " + e);
                                }
                                scanResult.addMatchProcessorException(e);
                            }
                        }
                        continue;
                    }
                    if (log == null) continue;
                    log.log("No matching class found in scan results for static final field " + fullyQualifiedFieldName);
                }
            }
            List<Throwable> matchProcessorExceptions = scanResult.getMatchProcessorExceptions();
            if (!this.suppressMatchProcessorExceptions && matchProcessorExceptions.size() > 0) {
                if (log != null) {
                    log.log("Number of exceptions raised during classloading and/or while calling MatchProcessors: " + matchProcessorExceptions.size());
                }
                throw MatchProcessorException.newInstance(matchProcessorExceptions);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (log != null) {
                log.log("Exception while calling MatchProcessors", e);
            }
            throw MatchProcessorException.newInstance(e);
        }
    }

    private static Pattern specToPattern(String spec) {
        return Pattern.compile("^" + spec.replace(".", "\\.").replace("*", ".*") + "$");
    }

    ScanSpecPathMatch dirWhitelistMatchStatus(String relativePath) {
        for (String blacklistedPath : this.blacklistedPathPrefixes) {
            if (!relativePath.startsWith(blacklistedPath)) continue;
            return ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX;
        }
        if (this.specificallyWhitelistedClassParentRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE;
        }
        if (this.whitelistedPathPrefixes.contains(relativePath) || this.whitelistedPathsNonRecursive.contains(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_PATH;
        }
        if (relativePath.equals("/")) {
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        for (String whitelistedPathPrefix : this.whitelistedPathPrefixes) {
            if (!whitelistedPathPrefix.startsWith(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        for (String whitelistedPathNonRecursive : this.whitelistedPathsNonRecursive) {
            if (!whitelistedPathNonRecursive.startsWith(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        for (String whitelistedClassPathPrefix : this.specificallyWhitelistedClassParentRelativePaths) {
            if (!whitelistedClassPathPrefix.startsWith(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (!this.disableRecursiveScanning) {
            for (String whitelistedPathPrefix : this.whitelistedPathPrefixes) {
                if (!relativePath.startsWith(whitelistedPathPrefix)) continue;
                return ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX;
            }
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    boolean isSpecificallyWhitelistedClass(String relativePath) {
        return this.specificallyWhitelistedClassRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath);
    }

    boolean classIsBlacklisted(String className) {
        boolean classIsBlacklisted = false;
        if (this.specificallyBlacklistedClassNames.contains(className)) {
            classIsBlacklisted = true;
        } else {
            for (String blacklistedPackagePrefix : this.blacklistedPackagePrefixes) {
                if (!className.startsWith(blacklistedPackagePrefix)) continue;
                classIsBlacklisted = true;
                break;
            }
        }
        return classIsBlacklisted;
    }

    void checkClassIsNotBlacklisted(String className) {
        if (this.strictWhitelist && this.classIsBlacklisted(className)) {
            boolean isSystemPackage = className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.");
            throw new IllegalArgumentException("Can't scan for " + className + ", it is in a blacklisted " + (!isSystemPackage ? "package" : "system package") + ", and and strictWhitelist() was called before scan()." + (!isSystemPackage ? "" : "You can override this by adding \"!\" or \"!!\" to the scan spec to disable system package blacklisting or system jar blacklisting respectively (see the docs)"));
        }
    }

    private static boolean containsJarName(Set<String> jarNames, List<Pattern> jarNamePatterns, String jarName) {
        String jarLeafName = JarUtils.leafName(jarName);
        if (jarNames.contains(jarLeafName)) {
            return true;
        }
        for (Pattern jarNamePattern : jarNamePatterns) {
            if (!jarNamePattern.matcher(jarLeafName).matches()) continue;
            return true;
        }
        return false;
    }

    boolean jarIsWhitelisted(String jarName) {
        String jarLeafName = JarUtils.leafName(jarName);
        return (this.whitelistedJars.isEmpty() && this.whitelistedJarPatterns.isEmpty() || ScanSpec.containsJarName(this.whitelistedJars, this.whitelistedJarPatterns, jarLeafName)) && !ScanSpec.containsJarName(this.blacklistedJars, this.blacklistedJarPatterns, jarLeafName);
    }

    boolean blacklistSystemJars() {
        return this.blacklistSystemJars;
    }

    private Class<?> loadClassForMatchProcessor(String className, ScanResult scanResult, LogNode log) throws MatchProcessorException {
        try {
            return scanResult.loadClass(className, true, log);
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw MatchProcessorException.newInstance(cause);
        }
    }

    String getAnnotationName(Class<?> annotation) {
        String annotationName = annotation.getName();
        this.checkClassIsNotBlacklisted(annotationName);
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException(annotationName + " is not an annotation");
        }
        return annotation.getName();
    }

    String[] getAnnotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = this.getAnnotationName(annotations[i]);
        }
        return annotationNames;
    }

    String getInterfaceName(Class<?> iface) {
        String ifaceName = iface.getName();
        this.checkClassIsNotBlacklisted(ifaceName);
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(ifaceName + " is not an interface");
        }
        return iface.getName();
    }

    String[] getInterfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = this.getInterfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    String getClassOrInterfaceName(Class<?> classOrInterface) {
        String classOrIfaceName = classOrInterface.getName();
        this.checkClassIsNotBlacklisted(classOrIfaceName);
        if (classOrInterface.isAnnotation()) {
            throw new IllegalArgumentException(classOrIfaceName + " is an annotation, not a regular class or interface");
        }
        return classOrInterface.getName();
    }

    String getStandardClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassIsNotBlacklisted(className);
        if (cls.isAnnotation()) {
            throw new IllegalArgumentException(className + " is an annotation, not a standard class");
        }
        if (cls.isInterface()) {
            throw new IllegalArgumentException(cls.getName() + " is an interface, not a standard class");
        }
        return className;
    }

    private void addClassMatcher(ClassMatchProcessorWrapper classMatcher) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(classMatcher);
    }

    public void matchAllClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        if (cls == null) continue;
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchAllStandardClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllStandardClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched standard class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        if (cls == null) continue;
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchAllInterfaceClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllInterfaceClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched interface class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        if (cls == null) continue;
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchAllAnnotationClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllAnnotationClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched annotation class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        if (cls == null) continue;
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public <T> void matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String superclassName = ScanSpec.this.getStandardClassName(superclass);
                for (String subclassName : scanResult.getNamesOfSubclassesOf(superclassName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched subclass of " + superclassName + ": " + subclassName);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(subclassName, scanResult, log);
                        if (cls == null) continue;
                        subclassMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + subclassName, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public <T> void matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String superinterfaceName = ScanSpec.this.getInterfaceName(superinterface);
                for (String subinterfaceName : scanResult.getNamesOfSubinterfacesOf(superinterfaceName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(subinterfaceName, scanResult, log);
                        if (cls == null) continue;
                        subinterfaceMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + subinterfaceName, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public <T> void matchClassesImplementing(final Class<T> implementedInterface, final ImplementingClassMatchProcessor<T> implementingClassMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String implementedInterfaceName = ScanSpec.this.getInterfaceName(implementedInterface);
                for (String implementingClassName : scanResult.getNamesOfClassesImplementing(implementedInterfaceName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched class implementing interface " + implementedInterfaceName + ": " + implementingClassName);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(implementingClassName, scanResult, log);
                        if (cls == null) continue;
                        implementingClassMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + implementingClassName, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithAnnotation : scanResult.getNamesOfClassesWithAnnotation(annotationName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(classWithAnnotation, scanResult, log);
                        if (cls == null) continue;
                        classAnnotationMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + classWithAnnotation, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchClassesWithMethodAnnotation(final Class<? extends Annotation> annotation, final MethodAnnotationMatchProcessor methodAnnotationMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithMethodAnnotation : scanResult.getNamesOfClassesWithMethodAnnotation(annotationName)) {
                    LogNode subLog;
                    Class cls = null;
                    try {
                        cls = ScanSpec.this.loadClassForMatchProcessor(classWithMethodAnnotation, scanResult, log);
                    }
                    catch (Throwable e) {
                        if (log != null) {
                            log.log("Exception while loading class " + classWithMethodAnnotation, e);
                        }
                        scanResult.addMatchProcessorException(e);
                        return;
                    }
                    if (cls == null) continue;
                    for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                        if (!ScanSpec.this.ignoreMethodVisibility && (constructor.getModifiers() & 1) == 0 || !constructor.isAnnotationPresent(annotation)) continue;
                        subLog = null;
                        if (log != null) {
                            subLog = log.log("Constructor matched method annotation " + annotationName + ": " + constructor);
                        }
                        try {
                            methodAnnotationMatchProcessor.processMatch(cls, constructor);
                        }
                        catch (Throwable e) {
                            if (subLog != null) {
                                subLog.log("Exception while processing match for class " + classWithMethodAnnotation, e);
                            }
                            scanResult.addMatchProcessorException(e);
                        }
                    }
                    for (Executable executable : cls.getDeclaredMethods()) {
                        if (!ScanSpec.this.ignoreMethodVisibility && (((Method)executable).getModifiers() & 1) == 0 || !executable.isAnnotationPresent(annotation)) continue;
                        subLog = null;
                        if (log != null) {
                            subLog = log.log("Matched method annotation " + annotationName + ": " + executable);
                        }
                        try {
                            methodAnnotationMatchProcessor.processMatch(cls, executable);
                        }
                        catch (Throwable e) {
                            if (subLog != null) {
                                subLog.log("Exception while processing match for class " + classWithMethodAnnotation, e);
                            }
                            scanResult.addMatchProcessorException(e);
                        }
                    }
                }
            }
        });
    }

    public void matchClassesWithFieldAnnotation(final Class<? extends Annotation> annotation, final FieldAnnotationMatchProcessor fieldAnnotationMatchProcessor) {
        this.addClassMatcher(new ClassMatchProcessorWrapper(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithFieldAnnotation : scanResult.getNamesOfClassesWithFieldAnnotation(annotationName)) {
                    Class cls = null;
                    try {
                        cls = ScanSpec.this.loadClassForMatchProcessor(classWithFieldAnnotation, scanResult, log);
                    }
                    catch (Throwable e) {
                        if (log != null) {
                            log.log("Exception while loading class " + classWithFieldAnnotation, e);
                        }
                        scanResult.addMatchProcessorException(e);
                        return;
                    }
                    if (cls == null) continue;
                    for (Field field : ScanSpec.this.ignoreFieldVisibility ? cls.getDeclaredFields() : cls.getFields()) {
                        if (!field.isAnnotationPresent(annotation)) continue;
                        LogNode subLog = null;
                        if (log != null) {
                            subLog = log.log("Matched field annotation " + annotationName + ": " + field);
                        }
                        try {
                            fieldAnnotationMatchProcessor.processMatch(cls, field);
                        }
                        catch (Throwable e) {
                            if (subLog != null) {
                                subLog.log("Exception while processing match for class " + classWithFieldAnnotation, e);
                            }
                            scanResult.addMatchProcessorException(e);
                        }
                    }
                }
            }
        });
    }

    private void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        String fullyQualifiedFieldName = className + "." + fieldName;
        if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors == null) {
            this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors = new MultiMapKeyToList();
            this.classNameToStaticFinalFieldsToMatch = new MultiMapKeyToSet();
        }
        this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.put(fullyQualifiedFieldName, staticFinalFieldMatchProcessor);
        this.classNameToStaticFinalFieldsToMatch.put(className, fieldName);
    }

    public void matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
    }

    public void matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public void matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    List<FileMatchProcessorWrapper> getFileMatchProcessorWrappers() {
        return this.fileMatchProcessorWrappers;
    }

    public void matchFilenamePattern(final String pathRegexp, FileMatchProcessorAny fileMatchProcessor) {
        this.fileMatchProcessorWrappers.add(new FileMatchProcessorWrapper(new FileMatchProcessorWrapper.FilePathTester(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                boolean matched = this.pattern.matcher(relativePathStr).matches();
                if (matched && log != null) {
                    log.log("File " + relativePathStr + " matched filename pattern " + pathRegexp);
                }
                return matched;
            }
        }, fileMatchProcessor));
    }

    public void matchFilenamePath(final String relativePathToMatch, FileMatchProcessorAny fileMatchProcessor) {
        this.fileMatchProcessorWrappers.add(new FileMatchProcessorWrapper(new FileMatchProcessorWrapper.FilePathTester(){

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                boolean matched = relativePathStr.equals(relativePathToMatch);
                if (matched && log != null) {
                    log.log("Matched filename path " + relativePathToMatch);
                }
                return matched;
            }
        }, fileMatchProcessor));
    }

    public void matchFilenamePathLeaf(final String pathLeafToMatch, FileMatchProcessorAny fileMatchProcessor) {
        this.fileMatchProcessorWrappers.add(new FileMatchProcessorWrapper(new FileMatchProcessorWrapper.FilePathTester(){
            private final String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                String relativePathLeaf = relativePathStr.substring(relativePathStr.lastIndexOf(47) + 1);
                boolean matched = relativePathLeaf.equals(this.leafToMatch);
                if (matched && log != null) {
                    log.log("File " + relativePathStr + " matched path leaf " + pathLeafToMatch);
                }
                return matched;
            }
        }, fileMatchProcessor));
    }

    public void matchFilenameExtension(final String extensionToMatch, FileMatchProcessorAny fileMatchProcessor) {
        this.fileMatchProcessorWrappers.add(new FileMatchProcessorWrapper(new FileMatchProcessorWrapper.FilePathTester(){
            final int extLen;
            {
                this.extLen = extensionToMatch.length();
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath, LogNode log) {
                boolean matched;
                int relativePathLen = relativePath.length();
                int extIdx = relativePathLen - this.extLen;
                boolean bl = matched = relativePathLen > this.extLen + 1 && relativePath.charAt(extIdx - 1) == '.' && relativePath.regionMatches(true, extIdx, extensionToMatch, 0, this.extLen);
                if (matched && log != null) {
                    log.log("File " + relativePath + " matched extension ." + extensionToMatch);
                }
                return matched;
            }
        }, fileMatchProcessor));
    }

    List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> getAllClassLoaderHandlerRegistryEntries() {
        List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerRegistryEntries;
        if (this.extraClassLoaderHandlers.isEmpty()) {
            allClassLoaderHandlerRegistryEntries = ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS;
        } else {
            allClassLoaderHandlerRegistryEntries = new ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>(this.extraClassLoaderHandlers);
            allClassLoaderHandlerRegistryEntries.addAll(ClassLoaderHandlerRegistry.DEFAULT_CLASS_LOADER_HANDLERS);
        }
        return allClassLoaderHandlerRegistryEntries;
    }

    static enum ScanSpecPathMatch {
        HAS_BLACKLISTED_PATH_PREFIX,
        HAS_WHITELISTED_PATH_PREFIX,
        AT_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        AT_WHITELISTED_CLASS_PACKAGE,
        NOT_WITHIN_WHITELISTED_PATH;

    }
}

