/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefOrTypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MethodTypeSignature
extends HierarchicalTypeSignature {
    final List<TypeParameter> typeParameters;
    private final List<TypeSignature> parameterTypeSignatures;
    private final TypeSignature resultType;
    private final List<ClassRefOrTypeVariableSignature> throwsSignatures;

    public MethodTypeSignature(List<TypeParameter> typeParameters, List<TypeSignature> paramTypes, TypeSignature resultType, List<ClassRefOrTypeVariableSignature> throwsSignatures) {
        this.typeParameters = typeParameters;
        this.parameterTypeSignatures = paramTypes;
        this.resultType = resultType;
        this.throwsSignatures = throwsSignatures;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public List<TypeSignature> getParameterTypeSignatures() {
        return this.parameterTypeSignatures;
    }

    public TypeSignature getResultType() {
        return this.resultType;
    }

    public List<ClassRefOrTypeVariableSignature> getThrowsSignatures() {
        return this.throwsSignatures;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        for (TypeParameter typeParameter : this.typeParameters) {
            if (typeParameter == null) continue;
            typeParameter.getAllReferencedClassNames(classNameListOut);
        }
        for (TypeSignature typeSignature : this.parameterTypeSignatures) {
            if (typeSignature == null) continue;
            typeSignature.getAllReferencedClassNames(classNameListOut);
        }
        this.resultType.getAllReferencedClassNames(classNameListOut);
        for (ClassRefOrTypeVariableSignature classRefOrTypeVariableSignature : this.throwsSignatures) {
            if (classRefOrTypeVariableSignature == null) continue;
            classRefOrTypeVariableSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeParameters.hashCode() + this.parameterTypeSignatures.hashCode() * 7 + this.resultType.hashCode() * 15 + this.throwsSignatures.hashCode() * 31;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodTypeSignature)) {
            return false;
        }
        MethodTypeSignature o = (MethodTypeSignature)obj;
        return o.typeParameters.equals(this.typeParameters) && o.parameterTypeSignatures.equals(this.parameterTypeSignatures) && o.resultType.equals(this.resultType) && o.throwsSignatures.equals(this.throwsSignatures);
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        if (!this.typeParameters.isEmpty()) {
            buf.append('<');
            for (i = 0; i < this.typeParameters.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                String typeParamStr = this.typeParameters.get(i).toString();
                buf.append(typeParamStr);
            }
            buf.append('>');
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.resultType.toString());
        buf.append(" (");
        for (i = 0; i < this.parameterTypeSignatures.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.parameterTypeSignatures.get(i).toString());
        }
        buf.append(')');
        if (!this.throwsSignatures.isEmpty()) {
            buf.append(" throws ");
            for (i = 0; i < this.throwsSignatures.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.throwsSignatures.get(i).toString());
            }
        }
        return buf.toString();
    }

    public static MethodTypeSignature merge(MethodTypeSignature methodTypeSignature, MethodTypeSignature methodTypeSignatureInternal, int[] parameterAccessFlagsInternal) {
        List<ClassRefOrTypeVariableSignature> mergedThrowsSignatures;
        ArrayList<TypeSignature> mergedParamTypes;
        if (methodTypeSignature == null || methodTypeSignatureInternal == null) {
            throw new IllegalArgumentException("Signatures must be non-null");
        }
        if (!methodTypeSignatureInternal.typeParameters.isEmpty()) {
            throw new IllegalArgumentException("typeSignatureInternal.typeParameters should be empty");
        }
        if (!methodTypeSignatureInternal.resultType.equalsIgnoringTypeParams(methodTypeSignature.resultType)) {
            throw new IllegalArgumentException("Result types could not be reconciled: " + methodTypeSignatureInternal.resultType + " vs. " + methodTypeSignature.resultType);
        }
        if (parameterAccessFlagsInternal != null && parameterAccessFlagsInternal.length != methodTypeSignatureInternal.parameterTypeSignatures.size()) {
            throw new IllegalArgumentException("Parameter arity mismatch between access flags and internal param types");
        }
        if (parameterAccessFlagsInternal == null) {
            if (methodTypeSignature.parameterTypeSignatures.size() != methodTypeSignatureInternal.parameterTypeSignatures.size()) {
                throw new IllegalArgumentException("Unexpected mismatch in method paramTypes arity");
            }
            mergedParamTypes = methodTypeSignature.parameterTypeSignatures;
        } else {
            mergedParamTypes = new ArrayList(methodTypeSignatureInternal.parameterTypeSignatures.size());
            int paramIdx = 0;
            for (int internalParamIdx = 0; internalParamIdx < methodTypeSignatureInternal.parameterTypeSignatures.size(); ++internalParamIdx) {
                TypeSignature paramTypeSignatureInternal;
                TypeSignature paramTypeSignature;
                if ((parameterAccessFlagsInternal[internalParamIdx] & 0x9000) != 0) {
                    mergedParamTypes.add(methodTypeSignatureInternal.parameterTypeSignatures.get(internalParamIdx));
                    continue;
                }
                if (paramIdx == methodTypeSignature.parameterTypeSignatures.size()) {
                    throw new IllegalArgumentException("Ran out of parameters in programmer-visible type signature");
                }
                if (!(paramTypeSignature = methodTypeSignature.parameterTypeSignatures.get(paramIdx++)).equalsIgnoringTypeParams(paramTypeSignatureInternal = methodTypeSignatureInternal.parameterTypeSignatures.get(internalParamIdx))) {
                    throw new IllegalArgumentException("Corresponding type parameters in type signatures do not refer to the same bare types: " + paramTypeSignature + " [from method signature " + methodTypeSignature + "] vs. " + paramTypeSignatureInternal + " [from method signature " + methodTypeSignatureInternal + "]");
                }
                mergedParamTypes.add(paramTypeSignature);
            }
            if (paramIdx < methodTypeSignature.parameterTypeSignatures.size()) {
                throw new IllegalArgumentException("Parameter arity mismatch between internal and programmer-visible type signature");
            }
        }
        if (methodTypeSignature.throwsSignatures.isEmpty()) {
            mergedThrowsSignatures = methodTypeSignatureInternal.throwsSignatures;
        } else if (methodTypeSignatureInternal.throwsSignatures.isEmpty() || methodTypeSignature.throwsSignatures.equals(methodTypeSignatureInternal.throwsSignatures)) {
            mergedThrowsSignatures = methodTypeSignature.throwsSignatures;
        } else {
            AdditionOrderedSet<ClassRefOrTypeVariableSignature> sigSet = new AdditionOrderedSet<ClassRefOrTypeVariableSignature>(methodTypeSignature.throwsSignatures);
            sigSet.addAll(methodTypeSignatureInternal.throwsSignatures);
            mergedThrowsSignatures = sigSet.toList();
        }
        return new MethodTypeSignature(methodTypeSignature.typeParameters, mergedParamTypes, methodTypeSignature.resultType, mergedThrowsSignatures);
    }

    public static MethodTypeSignature parse(String typeDescriptor) {
        return MethodTypeSignature.parse(null, typeDescriptor);
    }

    public static MethodTypeSignature parse(ClassInfo classInfo, String typeDescriptor) {
        TypeUtils.ParseState parseState = new TypeUtils.ParseState(typeDescriptor);
        try {
            List<ClassRefOrTypeVariableSignature> throwsSignatures;
            List<TypeParameter> typeParameters = TypeParameter.parseList(parseState);
            parseState.expect('(');
            ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>();
            while (parseState.peek() != ')') {
                if (!parseState.hasMore()) {
                    throw new TypeUtils.ParseException();
                }
                TypeSignature paramType = TypeSignature.parse(parseState);
                if (paramType == null) {
                    throw new TypeUtils.ParseException();
                }
                paramTypes.add(paramType);
            }
            parseState.expect(')');
            TypeSignature resultType = TypeSignature.parse(parseState);
            if (resultType == null) {
                throw new TypeUtils.ParseException();
            }
            if (parseState.peek() == '^') {
                throwsSignatures = new ArrayList();
                while (parseState.peek() == '^') {
                    parseState.expect('^');
                    ClassRefTypeSignature classTypeSignature = ClassRefTypeSignature.parse(parseState);
                    if (classTypeSignature != null) {
                        throwsSignatures.add(classTypeSignature);
                        continue;
                    }
                    TypeVariableSignature typeVariableSignature = TypeVariableSignature.parse(parseState);
                    if (typeVariableSignature != null) {
                        throwsSignatures.add(typeVariableSignature);
                        continue;
                    }
                    throw new TypeUtils.ParseException();
                }
            } else {
                throwsSignatures = Collections.emptyList();
            }
            if (parseState.hasMore()) {
                throw new IllegalArgumentException("Extra characters at end of type descriptor: " + parseState);
            }
            MethodTypeSignature methodSignature = new MethodTypeSignature(typeParameters, paramTypes, resultType, throwsSignatures);
            for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                typeVariableSignature.containingMethodSignature = methodSignature;
            }
            if (classInfo != null) {
                ClassTypeSignature classSignature = classInfo.getTypeSignature();
                for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                    typeVariableSignature.containingClassSignature = classSignature;
                }
            }
            return methodSignature;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type signature could not be parsed: " + parseState, e);
        }
    }
}

