/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Map;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        boolean handled = false;
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.jboss.modules.ModuleClassLoader".equals(c.getName())) continue;
            Object module = ReflectionUtils.invokeMethod(classloader, "getModule");
            Object serviceLoader = ReflectionUtils.invokeMethod(module, "getCallerModuleLoader");
            Map moduleMap = (Map)ReflectionUtils.getFieldVal(serviceLoader, "moduleMap");
            for (Object key : moduleMap.keySet()) {
                Object futureModule = moduleMap.get(key);
                Object realModule = ReflectionUtils.invokeMethod(futureModule, "getModule");
                Object moduleLoader = ReflectionUtils.invokeMethod(realModule, "getClassLoader");
                Object vfsResourceLoaders = ReflectionUtils.invokeMethod(moduleLoader, "getResourceLoaders");
                if (vfsResourceLoaders == null) continue;
                int n = Array.getLength(vfsResourceLoaders);
                for (int i = 0; i < n; ++i) {
                    String path = null;
                    Object resourceLoader = Array.get(vfsResourceLoaders, i);
                    if (resourceLoader != null) {
                        Object root = ReflectionUtils.getFieldVal(resourceLoader, "root");
                        File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile");
                        if (physicalFile != null) {
                            File file;
                            String name = (String)ReflectionUtils.invokeMethod(root, "getName");
                            path = name != null ? (ClasspathUtils.canRead(file = new File(physicalFile.getParentFile(), name)) ? file.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
                        } else {
                            path = (String)ReflectionUtils.invokeMethod(root, "getPathName");
                            if (path == null) {
                                Object file = root;
                                if (file == null) {
                                    file = ReflectionUtils.getFieldVal(resourceLoader, "fileOfJar");
                                }
                                path = (String)ReflectionUtils.invokeMethod(file, "getAbsolutePath");
                            }
                        }
                    }
                    handled |= classpathFinder.addClasspathElement(path, (ClassLoader)moduleLoader, log);
                }
            }
        }
        return handled;
    }
}

