/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FelixClassLoaderHandler
implements ClassLoaderHandler {
    final Set<Object> bundles = new HashSet<Object>();

    @Override
    public boolean handle(ClassLoader classLoader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        List<ClassLoader> classLoaders = Arrays.asList(classLoader);
        for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.apache.felix.framework.BundleWiringImpl$BundleClassLoaderJava5".equals(c.getName()) && !"org.apache.felix.framework.BundleWiringImpl$BundleClassLoader".equals(c.getName())) continue;
            Object bundleWiring = ReflectionUtils.getFieldVal(classLoader, "m_wiring");
            this.addBundle(bundleWiring, classLoaders, classpathFinder, log);
            List requiredWires = (List)ReflectionUtils.invokeMethod(bundleWiring, "getRequiredWires", String.class, null);
            if (requiredWires != null) {
                for (Object wire : requiredWires) {
                    Object provider = ReflectionUtils.invokeMethod(wire, "getProviderWiring");
                    if (this.bundles.contains(provider)) continue;
                    this.addBundle(provider, classLoaders, classpathFinder, log);
                }
            }
            return true;
        }
        return false;
    }

    private void addBundle(Object bundleWiring, List<ClassLoader> classLoaders, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        String location;
        this.bundles.add(bundleWiring);
        Object revision = ReflectionUtils.invokeMethod(bundleWiring, "getRevision");
        Object content = ReflectionUtils.invokeMethod(revision, "getContent");
        String string = location = content != null ? this.getContentLocation(content) : null;
        if (location != null) {
            classpathFinder.addClasspathElement(location, classLoaders, log);
            List embeddedContent = (List)ReflectionUtils.invokeMethod(revision, "getContentPath");
            if (embeddedContent != null) {
                for (Object embedded : embeddedContent) {
                    String embeddedLocation;
                    if (embedded == content || (embeddedLocation = embedded != null ? this.getContentLocation(embedded) : null) == null) continue;
                    classpathFinder.addClasspathElement(embeddedLocation, classLoaders, log);
                }
            }
        }
    }

    private String getContentLocation(Object content) throws Exception {
        File file = (File)ReflectionUtils.invokeMethod(content, "getFile");
        return file != null ? file.toURI().toString() : null;
    }
}

