/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;

public class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classloader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        for (Class<?> c = classloader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader".equals(c.getName())) continue;
            Object classpathManager = ReflectionUtils.invokeMethod(classloader, "getClasspathManager");
            Object[] entries = (Object[])ReflectionUtils.getFieldVal(classpathManager, "entries");
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    Object bundleFile = ReflectionUtils.invokeMethod(entries[i], "getBundleFile");
                    File baseFile = (File)ReflectionUtils.invokeMethod(bundleFile, "getBaseFile");
                    if (baseFile == null) continue;
                    classpathFinder.addClasspathElement(baseFile.getPath(), classloader, log);
                }
            }
            return true;
        }
        return false;
    }
}

