/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileUtils {
    public static String getCurrDirPathStr() {
        String currDirPathStr = "";
        try {
            Path currDirPath = Paths.get("", new String[0]).toAbsolutePath();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.normalize();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            currDirPathStr = currDirPath.toString();
            currDirPathStr = FastPathResolver.resolve(currDirPathStr);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not resolve current directory: " + currDirPathStr, e);
        }
        return currDirPathStr;
    }

    public static byte[] readAllBytes(InputStream inputStream, long fileSize) throws IOException {
        int bytesRead;
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException("File larger that 2GB, cannot read contents into a Java array");
        }
        int len = (int)fileSize;
        if ((long)len != fileSize) {
            throw new RuntimeException("File is too long to decompress");
        }
        byte[] bytes = new byte[len];
        int totBytesRead = 0;
        while ((bytesRead = inputStream.read(bytes, totBytesRead, len - totBytesRead)) > 0) {
            totBytesRead += bytesRead;
        }
        if ((long)totBytesRead < fileSize) {
            throw new IOException("Could not read whole file: expected " + fileSize + " bytes, got " + totBytesRead + " bytes");
        }
        return bytes;
    }

    public static boolean isClassfile(String path) {
        int len = path.length();
        return len > 6 && path.regionMatches(true, len - 6, ".class", 0, 6);
    }
}

