/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MethodInfo
implements Comparable<MethodInfo> {
    private final String className;
    private final String methodName;
    private final int modifiers;
    private final String typeDescriptor;
    private List<String> typeStrs;
    private final String[] parameterNames;
    private final int[] parameterAccessFlags;
    private final String[][] parameterAnnotations;
    private final List<String> annotationNames;
    ScanResult scanResult;

    public MethodInfo(String className, String methodName, int modifiers, String typeDescriptor, String[] parameterNames, int[] parameterAccessFlags, List<String> annotationNames, String[][] parameterAnnotations) {
        this.className = className;
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.typeDescriptor = typeDescriptor;
        this.parameterNames = parameterNames;
        this.parameterAccessFlags = parameterAccessFlags;
        this.parameterAnnotations = parameterAnnotations;
        this.annotationNames = annotationNames.isEmpty() ? Collections.emptyList() : annotationNames;
    }

    public String getModifiers() {
        return ReflectionUtils.modifiersToString(this.modifiers, true);
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getAccessFlags() {
        return this.modifiers;
    }

    private List<String> getTypeStrs() {
        if (this.typeStrs == null) {
            this.typeStrs = ReflectionUtils.parseTypeDescriptor(this.typeDescriptor);
            if (this.typeStrs.size() < 1) {
                throw new IllegalArgumentException("Invalid type descriptor for method: " + this.typeDescriptor);
            }
            return this.typeStrs;
        }
        return this.typeStrs;
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public String getReturnTypeStr() {
        List<String> typeStrsList = this.getTypeStrs();
        return typeStrsList.get(typeStrsList.size() - 1);
    }

    public Class<?> getReturnType() throws IllegalArgumentException {
        return ReflectionUtils.typeStrToClass(this.getReturnTypeStr(), this.scanResult);
    }

    public List<String> getParameterTypeStrs() {
        List<String> typeStrsList = this.getTypeStrs();
        return typeStrsList.subList(0, typeStrsList.size() - 1);
    }

    public List<Class<?>> getParameterTypes() throws IllegalArgumentException {
        ArrayList parameterClassRefs = new ArrayList();
        for (String parameterTypeStr : this.getParameterTypeStrs()) {
            parameterClassRefs.add(ReflectionUtils.typeStrToClass(parameterTypeStr, this.scanResult));
        }
        return parameterClassRefs;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public List<String> getParameterNames() {
        return this.parameterNames == null ? null : Arrays.asList(this.parameterNames);
    }

    public List<Integer> getParameterAccessFlags() {
        if (this.parameterAccessFlags == null) {
            return null;
        }
        ArrayList<Integer> flags = new ArrayList<Integer>(this.parameterAccessFlags.length);
        for (int flag : this.parameterAccessFlags) {
            flags.add(flag);
        }
        return flags;
    }

    public List<String[]> getParameterAnnotations() {
        return this.parameterAnnotations == null ? null : Arrays.asList(this.parameterAnnotations);
    }

    public List<String> getAnnotationNames() {
        return this.annotationNames;
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.annotationNames) {
            annotationClassRefs.add(ReflectionUtils.typeStrToClass(annotationName, this.scanResult));
        }
        return annotationClassRefs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.className.equals(other.className) && this.typeDescriptor.equals(other.typeDescriptor) && this.methodName.equals(other.methodName);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.typeDescriptor.hashCode() * 11 + this.className.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.className.compareTo(other.className);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.methodName.compareTo(other.methodName);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptor.compareTo(other.typeDescriptor);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.annotationNames.isEmpty()) {
            for (String annotationName : this.annotationNames) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append("@" + annotationName);
            }
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getModifiers());
        boolean isConstructor = this.isConstructor();
        if (!isConstructor) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.getReturnTypeStr());
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.methodName);
        buf.append('(');
        List<String> paramTypes = this.getParameterTypeStrs();
        if (this.parameterNames != null && paramTypes.size() != this.parameterNames.length || this.parameterAccessFlags != null && paramTypes.size() != this.parameterAccessFlags.length || this.parameterAnnotations != null && paramTypes.size() != this.parameterAnnotations.length) {
            throw new RuntimeException("parameter number mismatch");
        }
        boolean isVarargs = this.isVarArgs();
        for (int i = 0; i < paramTypes.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if (this.parameterAnnotations != null) {
                for (String annotation : this.parameterAnnotations[i]) {
                    buf.append("@" + annotation + " ");
                }
            }
            if (this.parameterAccessFlags != null) {
                int flag = this.parameterAccessFlags[i];
                if ((flag & 0x10) != 0) {
                    buf.append("final ");
                }
                if ((flag & 0x1000) != 0) {
                    buf.append("synthetic ");
                }
                if ((flag & 0x8000) != 0) {
                    buf.append("mandated ");
                }
            }
            String paramType = paramTypes.get(i);
            if (isVarargs && i == paramTypes.size() - 1) {
                if (!paramType.endsWith("[]")) {
                    throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + this.methodName);
                }
                buf.append(paramType.substring(0, paramType.length() - 2));
                buf.append("...");
            } else {
                buf.append(paramType);
            }
            if (this.parameterNames == null) continue;
            String paramName = this.parameterNames[i];
            buf.append(' ');
            buf.append(paramName == null ? "_unnamed_param_" + i : paramName);
        }
        buf.append(')');
        return buf.toString();
    }
}

