/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MethodInfo
extends ScanResult.InfoObject
implements Comparable<MethodInfo> {
    private final String className;
    private final String methodName;
    private final int modifiers;
    private final String typeDescriptor;
    private List<String> typeStrs;
    private final String[] parameterNames;
    private final int[] parameterAccessFlags;
    final AnnotationInfo[][] parameterAnnotationInfo;
    final List<AnnotationInfo> annotationInfo;
    private ScanResult scanResult;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    @Override
    void setScanResult(ScanResult scanResult) {
        int i;
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (i = 0; i < this.annotationInfo.size(); ++i) {
                AnnotationInfo ai = this.annotationInfo.get(i);
                ai.setScanResult(scanResult);
            }
        }
        if (this.parameterAnnotationInfo != null) {
            for (i = 0; i < this.parameterAnnotationInfo.length; ++i) {
                AnnotationInfo[] pai = this.parameterAnnotationInfo[i];
                if (pai == null) continue;
                for (AnnotationInfo ai : pai) {
                    ai.setScanResult(scanResult);
                }
            }
        }
    }

    public MethodInfo(String className, String methodName, int modifiers, String typeDescriptor, String[] parameterNames, int[] parameterAccessFlags, List<AnnotationInfo> methodAnnotationInfo, AnnotationInfo[][] parameterAnnotationInfo) {
        this.className = className;
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.typeDescriptor = typeDescriptor;
        this.parameterNames = parameterNames;
        this.parameterAccessFlags = parameterAccessFlags;
        this.parameterAnnotationInfo = parameterAnnotationInfo;
        this.annotationInfo = methodAnnotationInfo == null || methodAnnotationInfo.isEmpty() ? Collections.emptyList() : methodAnnotationInfo;
    }

    public String getModifiers() {
        return ReflectionUtils.modifiersToString(this.modifiers, true);
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getAccessFlags() {
        return this.modifiers;
    }

    private List<String> getTypeStrs() {
        if (this.typeStrs == null) {
            this.typeStrs = ReflectionUtils.parseComplexTypeDescriptor(this.typeDescriptor);
            if (this.typeStrs.size() < 1) {
                throw new IllegalArgumentException("Invalid type descriptor for method: " + this.typeDescriptor);
            }
            return this.typeStrs;
        }
        return this.typeStrs;
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public String getReturnTypeStr() {
        List<String> typeStrsList = this.getTypeStrs();
        return typeStrsList.get(typeStrsList.size() - 1);
    }

    public Class<?> getReturnType() throws IllegalArgumentException {
        return ReflectionUtils.typeStrToClass(this.getReturnTypeStr(), this.scanResult);
    }

    public String[] getParameterTypeStrs() {
        List<String> typeStrsList = this.getTypeStrs();
        if (typeStrsList.size() == 1) {
            return EMPTY_STRING_ARRAY;
        }
        List<String> paramsOnly = typeStrsList.subList(0, typeStrsList.size() - 1);
        return paramsOnly.toArray(new String[paramsOnly.size()]);
    }

    public Class<?>[] getParameterTypes() throws IllegalArgumentException {
        String[] parameterTypeStrs = this.getParameterTypeStrs();
        if (parameterTypeStrs.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] parameterClassRefs = new Class[parameterTypeStrs.length];
        for (int i = 0; i < parameterTypeStrs.length; ++i) {
            parameterClassRefs[i] = ReflectionUtils.typeStrToClass(parameterTypeStrs[i], this.scanResult);
        }
        return parameterClassRefs;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int[] getParameterAccessFlags() {
        return this.parameterAccessFlags;
    }

    public String[][] getParameterAnnotationNames() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        String[][] parameterAnnotationNames = new String[this.parameterAnnotationInfo.length][];
        for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
            parameterAnnotationNames[i] = AnnotationInfo.getUniqueAnnotationNamesSorted(this.parameterAnnotationInfo[i]);
        }
        return parameterAnnotationNames;
    }

    public Class<?>[][] getParameterAnnotationTypes() {
        if (this.parameterAnnotationInfo == null) {
            return null;
        }
        String[][] parameterAnnotationNames = this.getParameterAnnotationNames();
        Class[][] parameterAnnotationTypes = new Class[parameterAnnotationNames.length][];
        for (int i = 0; i < this.parameterAnnotationInfo.length; ++i) {
            parameterAnnotationTypes[i] = new Class[parameterAnnotationNames[i].length];
            for (int j = 0; j < parameterAnnotationNames[i].length; ++j) {
                parameterAnnotationTypes[i][j] = ReflectionUtils.typeStrToClass(parameterAnnotationNames[i][j], this.scanResult);
            }
        }
        return parameterAnnotationTypes;
    }

    public AnnotationInfo[][] getParameterAnnotationInfo() {
        return this.parameterAnnotationInfo;
    }

    public List<String> getAnnotationNames() {
        return Arrays.asList(AnnotationInfo.getUniqueAnnotationNamesSorted(this.annotationInfo));
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationInfo == null || this.annotationInfo.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.getAnnotationNames()) {
            annotationClassRefs.add(ReflectionUtils.typeStrToClass(annotationName, this.scanResult));
        }
        return annotationClassRefs;
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.className.equals(other.className) && this.typeDescriptor.equals(other.typeDescriptor) && this.methodName.equals(other.methodName);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.typeDescriptor.hashCode() * 11 + this.className.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.className.compareTo(other.className);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.methodName.compareTo(other.methodName);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptor.compareTo(other.typeDescriptor);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.annotationInfo != null) {
            for (AnnotationInfo annotation : this.annotationInfo) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(annotation.toString());
            }
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getModifiers());
        boolean isConstructor = this.isConstructor();
        if (!isConstructor) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.getReturnTypeStr());
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.methodName);
        buf.append('(');
        String[] paramTypes = this.getParameterTypeStrs();
        if (this.parameterNames != null && paramTypes.length != this.parameterNames.length || this.parameterAccessFlags != null && paramTypes.length != this.parameterAccessFlags.length || this.parameterAnnotationInfo != null && paramTypes.length != this.parameterAnnotationInfo.length) {
            throw new RuntimeException("parameter number mismatch");
        }
        boolean isVarargs = this.isVarArgs();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if (this.parameterAnnotationInfo != null) {
                AnnotationInfo[] annotationInfoForParameter = this.parameterAnnotationInfo[i];
                for (int j = 0; j < annotationInfoForParameter.length; ++j) {
                    buf.append(annotationInfoForParameter[j].toString());
                    buf.append(' ');
                }
            }
            if (this.parameterAccessFlags != null) {
                int flag = this.parameterAccessFlags[i];
                if ((flag & 0x10) != 0) {
                    buf.append("final ");
                }
                if ((flag & 0x1000) != 0) {
                    buf.append("synthetic ");
                }
                if ((flag & 0x8000) != 0) {
                    buf.append("mandated ");
                }
            }
            String paramType = paramTypes[i];
            if (isVarargs && i == paramTypes.length - 1) {
                if (!paramType.endsWith("[]")) {
                    throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + this.methodName);
                }
                buf.append(paramType.substring(0, paramType.length() - 2));
                buf.append("...");
            } else {
                buf.append(paramType);
            }
            if (this.parameterNames == null) continue;
            String paramName = this.parameterNames[i];
            buf.append(' ');
            buf.append(paramName == null ? "_unnamed_param_" + i : paramName);
        }
        buf.append(')');
        return buf.toString();
    }
}

