/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JarUtils {
    private static final List<String> JRE_PATHS;
    private static String RT_JAR_PATH;

    private static String getProperty(String propName) {
        try {
            return System.getProperty(propName);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static void addJREPath(File dir, Set<String> jrePathsSet) {
        if (ClasspathUtils.canRead(dir) && dir.isDirectory()) {
            String jrePath;
            String path = dir.getPath();
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!(jrePath = FastPathResolver.resolve("", path)).isEmpty()) {
                jrePathsSet.add(jrePath);
            }
            try {
                String jreCanonicalPath;
                String canonicalPath = dir.getCanonicalPath();
                if (!canonicalPath.endsWith(File.separator)) {
                    canonicalPath = canonicalPath + File.separator;
                }
                if (!(jreCanonicalPath = FastPathResolver.resolve("", canonicalPath)).equals(jrePath) && !jreCanonicalPath.isEmpty()) {
                    jrePathsSet.add(jreCanonicalPath);
                }
            }
            catch (IOException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static String[] smartPathSplit(String pathStr) {
        if (File.pathSeparatorChar == ':') {
            HashSet<Integer> splitPoints = new HashSet<Integer>();
            splitPoints.add(-1);
            splitPoints.add(pathStr.length());
            int i = pathStr.indexOf(File.pathSeparator);
            while (i >= 0) {
                splitPoints.add(i);
                i = pathStr.indexOf(File.pathSeparator, i + 1);
            }
            String pathStrLower = pathStr.toLowerCase();
            int i2 = pathStrLower.indexOf("http://");
            while (i2 >= 0) {
                splitPoints.remove(i2 + 4);
                i2 = pathStrLower.indexOf("http://", i2 + 7);
            }
            i2 = pathStrLower.indexOf("https://");
            while (i2 >= 0) {
                splitPoints.remove(i2 + 5);
                i2 = pathStrLower.indexOf("https://", i2 + 8);
            }
            i2 = pathStrLower.indexOf("\\:");
            while (i2 >= 0) {
                splitPoints.remove(i2 + 1);
                i2 = pathStrLower.indexOf("\\:", i2 + 2);
            }
            ArrayList splitPointsSorted = new ArrayList(splitPoints);
            Collections.sort(splitPointsSorted);
            ArrayList<String> parts = new ArrayList<String>();
            for (int i3 = 1; i3 < splitPointsSorted.size(); ++i3) {
                int idx0 = (Integer)splitPointsSorted.get(i3 - 1);
                int idx1 = (Integer)splitPointsSorted.get(i3);
                String part = pathStr.substring(idx0 + 1, idx1).trim();
                if ((part = part.replaceAll("\\\\:", ":")).isEmpty()) continue;
                parts.add(part);
            }
            return parts.toArray(new String[parts.size()]);
        }
        ArrayList<String> partsFiltered = new ArrayList<String>();
        for (String part : pathStr.split(File.pathSeparator)) {
            String partFiltered = part.trim();
            if (partFiltered.isEmpty()) continue;
            partsFiltered.add(partFiltered);
        }
        return partsFiltered.toArray(new String[partsFiltered.size()]);
    }

    public static String getRtJarPath() {
        return RT_JAR_PATH;
    }

    public static void logJavaInfo(LogNode log) {
        if (log != null) {
            log.log("Operating system: " + JarUtils.getProperty("os.name") + " " + JarUtils.getProperty("os.version") + " " + JarUtils.getProperty("os.arch"));
            log.log("Java version: " + JarUtils.getProperty("java.version") + " (" + JarUtils.getProperty("java.vendor") + ")");
            LogNode javaLog = log.log("JRE paths:");
            for (String jrePath : JRE_PATHS) {
                javaLog.log(jrePath);
            }
            if (RT_JAR_PATH != null) {
                javaLog.log(RT_JAR_PATH);
            }
        }
    }

    public static boolean isJREJar(String filePath, LogNode log) {
        for (String jrePathPrefix : JRE_PATHS) {
            if (!filePath.startsWith(jrePathPrefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJar(String path) {
        int urlParamIdx;
        boolean isJar;
        int len = path.length();
        boolean bl = isJar = path.regionMatches(true, len - 4, ".jar", 0, 4) || path.regionMatches(true, len - 4, ".zip", 0, 4) || path.regionMatches(true, len - 4, ".war", 0, 4) || path.regionMatches(true, len - 4, ".car", 0, 4) || path.regionMatches(true, len - 4, ".ear", 0, 4) || path.regionMatches(true, len - 4, ".sar", 0, 4) || path.regionMatches(true, len - 4, ".har", 0, 4) || path.regionMatches(true, len - 4, ".par", 0, 4) || path.regionMatches(true, len - 6, ".wsjar", 0, 6);
        if (!isJar && (urlParamIdx = path.indexOf(63)) > 0) {
            return JarUtils.isJar(path.substring(0, urlParamIdx));
        }
        return isJar;
    }

    public static String leafName(String path) {
        int bangIdx = path.indexOf("!");
        int endIdx = bangIdx >= 0 ? bangIdx : path.length();
        int leafStartIdx = 1 + (File.separatorChar == '/' ? path.lastIndexOf(47, endIdx) : Math.max(path.lastIndexOf(47, endIdx), path.lastIndexOf(File.separatorChar, endIdx)));
        int sepIdx = path.indexOf("---");
        if (sepIdx >= 0) {
            sepIdx += "---".length();
        }
        leafStartIdx = Math.max(leafStartIdx, sepIdx);
        leafStartIdx = Math.min(leafStartIdx, endIdx);
        return path.substring(leafStartIdx, endIdx);
    }

    static {
        String javaExtDirs;
        JRE_PATHS = new ArrayList<String>();
        RT_JAR_PATH = null;
        HashSet<String> jrePathsSet = new HashSet<String>();
        String javaHome = JarUtils.getProperty("java.home");
        if (javaHome != null && !javaHome.isEmpty()) {
            File parent;
            File javaHomeFile = new File(javaHome);
            JarUtils.addJREPath(javaHomeFile, jrePathsSet);
            File libFile = new File(javaHomeFile, "lib");
            JarUtils.addJREPath(libFile, jrePathsSet);
            File extFile = new File(libFile, "ext");
            JarUtils.addJREPath(extFile, jrePathsSet);
            File rtJarFile = new File(libFile, "rt.jar");
            if (ClasspathUtils.canRead(rtJarFile)) {
                RT_JAR_PATH = rtJarFile.getPath();
            }
            if (javaHomeFile.getName().equals("jre") && (parent = javaHomeFile.getParentFile()) != null) {
                File parentLibFile = new File(parent, "lib");
                JarUtils.addJREPath(parentLibFile, jrePathsSet);
            }
        }
        if ((javaExtDirs = JarUtils.getProperty("java.ext.dirs")) != null) {
            for (String javaExtDir : JarUtils.smartPathSplit(javaExtDirs)) {
                if (javaExtDir.isEmpty()) continue;
                File javaExtDirFile = new File(javaExtDir);
                JarUtils.addJREPath(javaExtDirFile, jrePathsSet);
            }
        }
        JarUtils.addJREPath(new File("/System/Library/Java"), jrePathsSet);
        JRE_PATHS.addAll(jrePathsSet);
        Collections.sort(JRE_PATHS);
    }
}

