/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Map;

public class JBossClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"org.jboss.modules.ModuleClassLoader"};

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ClassLoader classLoader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) {
        Object module = ReflectionUtils.invokeMethod(classLoader, "getModule", false);
        Object serviceLoader = ReflectionUtils.invokeMethod(module, "getCallerModuleLoader", false);
        Map moduleMap = (Map)ReflectionUtils.getFieldVal(serviceLoader, "moduleMap", false);
        for (Object key : moduleMap.keySet()) {
            Object futureModule = moduleMap.get(key);
            Object realModule = ReflectionUtils.invokeMethod(futureModule, "getModule", false);
            Object moduleLoader = ReflectionUtils.invokeMethod(realModule, "getClassLoader", false);
            Object vfsResourceLoaders = ReflectionUtils.invokeMethod(moduleLoader, "getResourceLoaders", false);
            if (vfsResourceLoaders == null) continue;
            int n = Array.getLength(vfsResourceLoaders);
            for (int i = 0; i < n; ++i) {
                String path = null;
                Object resourceLoader = Array.get(vfsResourceLoaders, i);
                if (resourceLoader != null) {
                    Object root = ReflectionUtils.getFieldVal(resourceLoader, "root", false);
                    File physicalFile = (File)ReflectionUtils.invokeMethod(root, "getPhysicalFile", false);
                    if (physicalFile != null) {
                        File file;
                        String name = (String)ReflectionUtils.invokeMethod(root, "getName", false);
                        path = name != null ? (ClasspathUtils.canRead(file = new File(physicalFile.getParentFile(), name)) ? file.getAbsolutePath() : physicalFile.getAbsolutePath()) : physicalFile.getAbsolutePath();
                    } else {
                        path = (String)ReflectionUtils.invokeMethod(root, "getPathName", false);
                        if (path == null) {
                            Object file = root instanceof Path ? ((Path)root).toFile() : root;
                            if (file == null) {
                                file = ReflectionUtils.getFieldVal(resourceLoader, "fileOfJar", false);
                            }
                            path = (String)ReflectionUtils.invokeMethod(file, "getAbsolutePath", false);
                        }
                    }
                }
                classpathFinder.addClasspathElement(path, (ClassLoader)moduleLoader, log);
            }
        }
    }
}

