/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ModuleRef;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassLoaderFinder {
    private static CallerResolver CALLER_RESOLVER;

    /*
     * WARNING - void declaration
     */
    public static EnvClassLoadersAndModules findEnvClassLoaders(ScanSpec scanSpec, LogNode log) {
        AdditionOrderedSet<Object> classLoadersUnique;
        LogNode classLoadersFoundLog = null;
        ArrayList<ModuleRef> systemModules = null;
        ArrayList<ModuleRef> nonSystemModules = null;
        if (scanSpec.overrideClassLoaders == null) {
            ClassLoader classLoader;
            Set<ModuleRef> set;
            classLoadersUnique = new AdditionOrderedSet();
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader != null) {
                classLoadersUnique.add(systemClassLoader);
            }
            List<ModuleRef> allModuleRefsList = null;
            if (CALLER_RESOLVER == null) {
                if (log != null) {
                    log.log(ClassLoaderFinder.class.getSimpleName() + " could not create " + CallerResolver.class.getSimpleName() + ", current SecurityManager does not grant RuntimePermission(\"createSecurityManager\")");
                }
            } else {
                Class<?>[] classArray = CALLER_RESOLVER.getClassContext();
                if (classArray == null) {
                    if (log != null) {
                        log.log(ClassLoaderFinder.class.getSimpleName() + ": " + CallerResolver.class.getSimpleName() + "#getClassContext() returned null");
                    }
                } else {
                    void var9_19;
                    int n = classArray.length - 1;
                    while (var9_19 >= 0) {
                        ClassLoader callerClassLoader = classArray[var9_19].getClassLoader();
                        if (callerClassLoader != null) {
                            classLoadersUnique.add(callerClassLoader);
                        }
                        --var9_19;
                    }
                    allModuleRefsList = ModuleRef.findModuleRefs(classArray);
                }
            }
            if ((set = ModuleRef.findSystemModuleRefs()) == null) {
                if (!allModuleRefsList.isEmpty()) {
                    throw new RuntimeException("Failed to find system modules, but found modules through CallerResolver");
                }
            } else {
                systemModules = new ArrayList<ModuleRef>(set);
                nonSystemModules = new ArrayList<ModuleRef>();
                for (ModuleRef moduleRef : allModuleRefsList) {
                    if (set.contains(moduleRef)) continue;
                    if (JarUtils.isSystemModule(moduleRef.getModuleName())) {
                        set.add(moduleRef);
                        continue;
                    }
                    nonSystemModules.add(moduleRef);
                }
                systemModules = new ArrayList<ModuleRef>(set);
                Collections.sort(systemModules);
            }
            if ((classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                classLoadersUnique.add(classLoader);
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new AdditionOrderedSet<ClassLoader>(scanSpec.overrideClassLoaders);
            classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        HashSet<void> ancestralClassLoaders = new HashSet<void>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            void var9_24;
            ClassLoader classLoader2 = classLoader.getParent();
            while (var9_24 != null) {
                ancestralClassLoaders.add(var9_24);
                ClassLoader classLoader3 = var9_24.getParent();
            }
        }
        ArrayList<ClassLoader> classLoaderFinalOrder = new ArrayList<ClassLoader>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            if (ancestralClassLoaders.contains(classLoader)) continue;
            classLoaderFinalOrder.add(classLoader);
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoaderFinalOrder) {
                classLoadersFoundLog.log("" + classLoader);
            }
        }
        if (log != null) {
            if (systemModules != null) {
                LogNode logNode = log.log("Found system modules:");
                for (ModuleRef moduleRef : systemModules) {
                    logNode.log(moduleRef.toString());
                }
            }
            if (nonSystemModules != null && !nonSystemModules.isEmpty()) {
                LogNode logNode = log.log("Found non-system modules:");
                for (ModuleRef moduleRef : nonSystemModules) {
                    logNode.log(moduleRef.toString());
                }
            }
        }
        return new EnvClassLoadersAndModules(classLoaderFinalOrder.toArray(new ClassLoader[classLoaderFinalOrder.size()]), systemModules, nonSystemModules);
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static class EnvClassLoadersAndModules {
        public final ClassLoader[] classLoaders;
        public final List<ModuleRef> systemModuleRefs;
        public final List<ModuleRef> nonSystemModuleRefs;

        public EnvClassLoadersAndModules(ClassLoader[] classLoaders, List<ModuleRef> systemModuleRefs, List<ModuleRef> nonSystemModuleRefs) {
            this.classLoaders = classLoaders;
            this.systemModuleRefs = systemModuleRefs;
            this.nonSystemModuleRefs = nonSystemModuleRefs;
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

