/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.scanner.ModuleRef;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.scanner.matchers.FileMatchProcessorWrapper;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ClasspathElementModule
extends ClasspathElement {
    private final ModuleRef moduleRef;
    private Recycler<ModuleRef.ModuleReaderProxy, IOException> moduleReaderProxyRecycler;

    ClasspathElementModule(RelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, NestedJarHandler nestedJarHandler, InterruptionChecker interruptionChecker, LogNode log) {
        super(classpathEltPath, scanSpec, scanFiles, interruptionChecker);
        this.moduleRef = classpathEltPath.getModuleRef();
        if (this.moduleRef == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.moduleReaderProxyRecycler = nestedJarHandler.getModuleReaderProxyRecycler(this.moduleRef, log);
        }
        catch (Exception e) {
            if (log != null) {
                log.log("Exception while creating zipfile recycler for " + this.moduleRef.getModuleName() + " : " + e);
            }
            this.ioExceptionOnOpen = true;
            return;
        }
        if (scanFiles) {
            this.fileMatches = new MultiMapKeyToList();
            this.classfileMatches = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanPaths(LogNode log) {
        String moduleLocationStr = this.moduleRef.getModuleLocationStr();
        LogNode logNode = log == null ? null : log.log(moduleLocationStr, "Scanning module classpath entry " + this.classpathEltPath);
        ModuleRef.ModuleReaderProxy moduleReaderProxy = null;
        try {
            try {
                moduleReaderProxy = this.moduleReaderProxyRecycler.acquire();
            }
            catch (IOException e) {
                if (logNode != null) {
                    logNode.log("Exception opening module " + this.classpathEltPath, e);
                }
                this.ioExceptionOnOpen = true;
                this.moduleReaderProxyRecycler.release(moduleReaderProxy);
                return;
            }
            this.scanModule(moduleReaderProxy, logNode);
        }
        finally {
            this.moduleReaderProxyRecycler.release(moduleReaderProxy);
        }
        if (logNode != null) {
            logNode.addElapsedTime();
        }
    }

    private ClasspathResource newClasspathResource(final String moduleResourcePath) {
        return new ClasspathResource(null, this.moduleRef, moduleResourcePath, moduleResourcePath){
            private ModuleRef.ModuleReaderProxy moduleReaderProxy;
            private InputStream inputStream;
            private ByteBuffer byteBuffer;
            {
                super(classpathEltFile, moduleRef, pathRelativeToClasspathElt, pathRelativeToClasspathPrefix);
                this.moduleReaderProxy = null;
                this.inputStream = null;
                this.byteBuffer = null;
            }

            @Override
            public InputStream open() throws IOException {
                if (ClasspathElementModule.this.ioExceptionOnOpen) {
                    throw new IOException("Module could not be opened");
                }
                try {
                    if (this.moduleReaderProxy != null || this.inputStream != null) {
                        throw new RuntimeException("Tried to open classpath resource twice");
                    }
                    this.moduleReaderProxy = (ModuleRef.ModuleReaderProxy)ClasspathElementModule.this.moduleReaderProxyRecycler.acquire();
                    this.byteBuffer = this.moduleReaderProxy.read(moduleResourcePath);
                    this.inputStream = new FileUtils.ByteBufferBackedInputStream(this.byteBuffer);
                    this.inputStreamLength = this.byteBuffer.remaining();
                    return this.inputStream;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.inputStream = null;
                }
                if (this.byteBuffer != null) {
                    try {
                        this.moduleReaderProxy.release(this.byteBuffer);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.byteBuffer = null;
                }
                if (this.moduleReaderProxy != null) {
                    ClasspathElementModule.this.moduleReaderProxyRecycler.release(this.moduleReaderProxy);
                    this.moduleReaderProxy = null;
                }
            }
        };
    }

    private void scanModule(ModuleRef.ModuleReaderProxy moduleReaderProxy, LogNode log) {
        boolean hasWhitelistedPackage = this.scanSpec.whitelistedPathsNonRecursive.contains("");
        if (!hasWhitelistedPackage) {
            List<String> packages = this.moduleRef.getModulePackages();
            for (String pkg : packages) {
                String pkgPath = pkg.replace('.', '/') + "/";
                ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.dirWhitelistMatchStatus(pkgPath);
                if (matchStatus != ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX && matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH && matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE) continue;
                hasWhitelistedPackage = true;
                break;
            }
        }
        if (hasWhitelistedPackage) {
            List<String> resourceRelativePaths;
            try {
                resourceRelativePaths = moduleReaderProxy.list();
            }
            catch (Exception e) {
                if (log != null) {
                    log.log("Could not get resource list for module " + this.moduleRef.getModuleName(), e);
                }
                return;
            }
            String prevParentRelativePath = null;
            ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
            for (String relativePath : resourceRelativePaths) {
                LogNode subLog;
                if (relativePath.endsWith("/")) continue;
                int lastSlashIdx = relativePath.lastIndexOf("/");
                String parentRelativePath = lastSlashIdx < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
                boolean parentRelativePathChanged = !parentRelativePath.equals(prevParentRelativePath);
                ScanSpec.ScanSpecPathMatch parentMatchStatus = prevParentRelativePath == null || parentRelativePathChanged ? this.scanSpec.dirWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
                prevParentRelativePath = parentRelativePath;
                prevParentMatchStatus = parentMatchStatus;
                if (parentMatchStatus != ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX && parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH && (parentMatchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(relativePath))) continue;
                LogNode logNode = subLog = log == null ? null : log.log(relativePath, "Found whitelisted file: " + relativePath);
                if (FileUtils.isClassfile(relativePath)) {
                    this.classfileMatches.add(this.newClasspathResource(relativePath));
                }
                for (FileMatchProcessorWrapper fileMatchProcessorWrapper : this.scanSpec.getFileMatchProcessorWrappers()) {
                    if (!fileMatchProcessorWrapper.filePathMatches(relativePath, subLog)) continue;
                    this.fileMatches.put(fileMatchProcessorWrapper, this.newClasspathResource(relativePath));
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.moduleReaderProxyRecycler != null) {
            this.moduleReaderProxyRecycler.close();
        }
        this.moduleReaderProxyRecycler = null;
    }
}

