/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModuleRef
implements Comparable<ModuleRef> {
    private final String moduleName;
    private final Object moduleReference;
    private final Object moduleLayer;
    private final Object moduleDescriptor;
    private final List<String> modulePackages;
    private final URI moduleLocation;
    private File moduleLocationFile;
    private String moduleLocationStr;
    private final ClassLoader classLoader;

    public ModuleRef(Object moduleReference, Object moduleLayer) {
        if (moduleReference == null) {
            throw new IllegalArgumentException("moduleReference cannot be null");
        }
        if (moduleLayer == null) {
            throw new IllegalArgumentException("moduleLayer cannot be null");
        }
        this.moduleReference = moduleReference;
        this.moduleLayer = moduleLayer;
        this.moduleDescriptor = ReflectionUtils.invokeMethod(moduleReference, "descriptor", true);
        if (this.moduleDescriptor == null) {
            throw new IllegalArgumentException("moduleReference.descriptor() should not return null");
        }
        this.moduleName = (String)ReflectionUtils.invokeMethod(this.moduleDescriptor, "name", true);
        if (this.moduleName == null) {
            throw new IllegalArgumentException("moduleReference.descriptor().name() should not return null");
        }
        Set pkgs = (Set)ReflectionUtils.invokeMethod(this.moduleDescriptor, "packages", true);
        if (pkgs == null) {
            throw new IllegalArgumentException("moduleReference.descriptor().packages() should not return null");
        }
        this.modulePackages = new ArrayList<String>(pkgs);
        Collections.sort(this.modulePackages);
        Object moduleLocationOptional = ReflectionUtils.invokeMethod(moduleReference, "location", true);
        if (moduleLocationOptional == null) {
            throw new IllegalArgumentException("moduleReference.location() should not return null");
        }
        Object moduleLocationIsPresent = ReflectionUtils.invokeMethod(moduleLocationOptional, "isPresent", true);
        if (moduleLocationIsPresent == null) {
            throw new IllegalArgumentException("moduleReference.location().isPresent() should not return null");
        }
        if (((Boolean)moduleLocationIsPresent).booleanValue()) {
            this.moduleLocation = (URI)ReflectionUtils.invokeMethod(moduleLocationOptional, "get", true);
            if (this.moduleLocation == null) {
                throw new IllegalArgumentException("moduleReference.location().get() should not return null");
            }
        } else {
            this.moduleLocation = null;
        }
        this.classLoader = (ClassLoader)ReflectionUtils.invokeMethod(moduleLayer, "findLoader", String.class, this.moduleName, true);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Object getModuleReference() {
        return this.moduleReference;
    }

    public Object getModuleLayer() {
        return this.moduleLayer;
    }

    public Object getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public List<String> getModulePackages() {
        return this.modulePackages;
    }

    public URI getModuleLocation() {
        return this.moduleLocation;
    }

    public boolean isSystemModule() {
        if (this.moduleLocation == null) {
            return true;
        }
        String scheme = this.moduleLocation.getScheme();
        if (scheme == null) {
            return false;
        }
        return !scheme.equalsIgnoreCase("file");
    }

    public String getModuleLocationStr() {
        if (this.moduleLocationStr == null && this.moduleLocation != null) {
            this.moduleLocationStr = this.moduleLocation.toString();
        }
        return this.moduleLocationStr;
    }

    public File getModuleLocationFile() {
        if (this.moduleLocationFile == null && this.moduleLocation != null) {
            if (!this.isSystemModule()) {
                this.moduleLocationFile = new File(this.moduleLocation);
            } else {
                return null;
            }
        }
        return this.moduleLocationFile;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleRef)) {
            return false;
        }
        ModuleRef mr = (ModuleRef)obj;
        return this.moduleReference.equals(this.moduleReference) && mr.moduleLayer.equals(this.moduleLayer);
    }

    public int hashCode() {
        return this.moduleReference.hashCode() * this.moduleLayer.hashCode();
    }

    public String toString() {
        return this.moduleReference.toString() + "; ClassLoader " + this.classLoader;
    }

    @Override
    public int compareTo(ModuleRef o) {
        int diff = this.moduleName.compareTo(o.moduleName);
        return diff != 0 ? diff : this.hashCode() - o.hashCode();
    }

    public ModuleReaderProxy open() throws IOException {
        return new ModuleReaderProxy(this);
    }

    private static List<Object> getAllModuleLayers(Class<?> cls) {
        Object clsLayer;
        Object module = ReflectionUtils.invokeMethod(cls, "getModule", false);
        if (module != null && (clsLayer = ReflectionUtils.invokeMethod(module, "getLayer", true)) != null) {
            ArrayList<Object> allLayers = new ArrayList<Object>();
            HashSet<Object> visited = new HashSet<Object>();
            ArrayDeque<Object> stack = new ArrayDeque<Object>();
            visited.add(clsLayer);
            stack.push(clsLayer);
            while (!stack.isEmpty()) {
                Object layer = stack.pop();
                allLayers.add(layer);
                List parents = (List)ReflectionUtils.invokeMethod(layer, "parents", true);
                for (int i = parents.size() - 1; i >= 0; --i) {
                    Object parent = parents.get(i);
                    if (visited.contains(parent)) continue;
                    visited.add(parent);
                    stack.push(parent);
                }
            }
            return allLayers;
        }
        return Collections.emptyList();
    }

    private static void findModuleRefs(Class<?> cls, AdditionOrderedSet<ModuleRef> moduleReferences) {
        for (Object layer : ModuleRef.getAllModuleLayers(cls)) {
            Set modules;
            Object cfg = ReflectionUtils.invokeMethod(layer, "configuration", true);
            if (cfg == null || (modules = (Set)ReflectionUtils.invokeMethod(cfg, "modules", true)) == null) continue;
            ArrayList<ModuleRef> modulesInLayer = new ArrayList<ModuleRef>();
            for (Object module : modules) {
                Object ref = ReflectionUtils.invokeMethod(module, "reference", true);
                modulesInLayer.add(new ModuleRef(ref, layer));
            }
            Collections.sort(modulesInLayer);
            moduleReferences.addAll(modulesInLayer);
        }
    }

    public static List<ModuleRef> findModuleRefs(Class<?> cls) {
        AdditionOrderedSet<ModuleRef> moduleReferences = new AdditionOrderedSet<ModuleRef>();
        ModuleRef.findModuleRefs(cls, moduleReferences);
        return moduleReferences.toList();
    }

    public static List<ModuleRef> findModuleRefs(Class<?>[] callStack) {
        AdditionOrderedSet<ModuleRef> moduleReferences = new AdditionOrderedSet<ModuleRef>();
        for (int i = callStack.length - 1; i >= 0; --i) {
            ModuleRef.findModuleRefs(callStack[i], moduleReferences);
        }
        return moduleReferences.toList();
    }

    public static Set<ModuleRef> findSystemModuleRefs() {
        HashSet<ModuleRef> systemModules = null;
        try {
            Set systemModuleRefs;
            Object systemModuleFinder;
            Class<?> moduleFinderClass;
            Object bootLayer;
            Class<?> moduleLayerClass = ReflectionUtils.classForNameOrNull("java.lang.ModuleLayer");
            if (moduleLayerClass != null && (bootLayer = ReflectionUtils.invokeStaticMethod(moduleLayerClass, "boot", false)) != null && (moduleFinderClass = ReflectionUtils.classForNameOrNull("java.lang.module.ModuleFinder")) != null && (systemModuleFinder = ReflectionUtils.invokeStaticMethod(moduleFinderClass, "ofSystem", false)) != null && (systemModuleRefs = (Set)ReflectionUtils.invokeMethod(systemModuleFinder, "findAll", true)) != null) {
                systemModules = new HashSet<ModuleRef>();
                for (Object ref : systemModuleRefs) {
                    systemModules.add(new ModuleRef(ref, bootLayer));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return systemModules;
    }

    public static class ModuleReaderProxy
    implements AutoCloseable {
        private final AutoCloseable moduleReader;
        private static Class<?> collectorClass = ReflectionUtils.classForNameOrNull("java.util.stream.Collector");
        private static Object collectorsToList;

        ModuleReaderProxy(ModuleRef moduleRef) throws IOException {
            try {
                this.moduleReader = (AutoCloseable)ReflectionUtils.invokeMethod(moduleRef.getModuleReference(), "open", true);
                if (this.moduleReader == null) {
                    throw new IllegalArgumentException("moduleReference.open() should not return null");
                }
            }
            catch (SecurityException e) {
                throw new IOException("Could not open module " + moduleRef.getModuleName(), e);
            }
        }

        @Override
        public void close() throws Exception {
            this.moduleReader.close();
        }

        public List<String> list() throws Exception {
            if (collectorsToList == null) {
                throw new IllegalArgumentException("Could not call Collectors.toList()");
            }
            Object resourcesStream = ReflectionUtils.invokeMethod(this.moduleReader, "list", true);
            if (resourcesStream == null) {
                throw new IllegalArgumentException("Could not call moduleReader.list()");
            }
            Object resourcesList = ReflectionUtils.invokeMethod(resourcesStream, "collect", collectorClass, collectorsToList, true);
            if (resourcesList == null) {
                throw new IllegalArgumentException("Could not call moduleReader.list().collect(Collectors.toList())");
            }
            List resourcesListTyped = (List)resourcesList;
            return resourcesListTyped;
        }

        public InputStream open(String name) throws Exception {
            Object optionalInputStream = ReflectionUtils.invokeMethod(this.moduleReader, "open", String.class, name, true);
            if (optionalInputStream == null) {
                throw new IllegalArgumentException("Could not call moduleReader.open(name)");
            }
            Object inputStream = ReflectionUtils.invokeMethod(optionalInputStream, "get", true);
            if (inputStream == null) {
                throw new IllegalArgumentException("Could not call moduleReader.open(name).get()");
            }
            return (InputStream)inputStream;
        }

        public ByteBuffer read(String name) throws Exception, OutOfMemoryError {
            Object optionalByteBuffer = ReflectionUtils.invokeMethod(this.moduleReader, "read", String.class, name, true);
            if (optionalByteBuffer == null) {
                throw new IllegalArgumentException("Could not call moduleReader.open(name)");
            }
            Object byteBuffer = ReflectionUtils.invokeMethod(optionalByteBuffer, "get", true);
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Could not call moduleReader.read(name).get()");
            }
            return (ByteBuffer)byteBuffer;
        }

        public void release(ByteBuffer byteBuffer) {
            ReflectionUtils.invokeMethod(this.moduleReader, "release", ByteBuffer.class, byteBuffer, true);
        }

        static {
            Class<?> collectorsClass = ReflectionUtils.classForNameOrNull("java.util.stream.Collectors");
            if (collectorsClass != null) {
                collectorsToList = ReflectionUtils.invokeStaticMethod(collectorsClass, "toList", true);
            }
        }
    }
}

