/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.FieldInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodParameterInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.GraphvizUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassGraphBuilder {
    final Map<String, ClassInfo> classNameToClassInfo;
    private final ScanSpec scanSpec;
    private final Set<ClassInfo> allClassInfo;
    private final Map<String, ClassLoader[]> classNameToClassLoaders = new HashMap<String, ClassLoader[]>();
    private static final int PARAM_WRAP_WIDTH = 40;

    ClassGraphBuilder(ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo) {
        this.scanSpec = scanSpec;
        this.classNameToClassInfo = classNameToClassInfo;
        this.allClassInfo = new HashSet<ClassInfo>(classNameToClassInfo.values());
        for (ClassInfo classInfo : this.allClassInfo) {
            ClassLoader[] classLoaders = classInfo.getClassLoaders();
            if (classLoaders == null) continue;
            this.classNameToClassLoaders.put(classInfo.getClassName(), classLoaders);
        }
    }

    Map<String, ClassInfo> getClassNameToClassInfo() {
        if (this.scanSpec.enableExternalClasses) {
            return this.classNameToClassInfo;
        }
        HashMap<String, ClassInfo> classNameToClassInfoFiltered = new HashMap<String, ClassInfo>();
        for (Map.Entry<String, ClassInfo> e : this.classNameToClassInfo.entrySet()) {
            String className = e.getKey();
            ClassInfo classInfo = e.getValue();
            boolean isExternal = !classInfo.classfileScanned;
            if (isExternal) continue;
            classNameToClassInfoFiltered.put(className, classInfo);
        }
        return classNameToClassInfoFiltered;
    }

    public Map<String, ClassLoader[]> getClassNameToClassLoaders() {
        return this.classNameToClassLoaders;
    }

    List<String> getNamesOfAllClasses() {
        return ClassInfo.getNamesOfAllClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfAllStandardClasses() {
        return ClassInfo.getNamesOfAllStandardClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfSubclassesOf(String className) {
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSubclasses();
    }

    List<String> getNamesOfSuperclassesOf(String className) {
        ClassInfo classInfo = this.classNameToClassInfo.get(className);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSuperclasses();
    }

    List<String> getNamesOfClassesWithMethodAnnotation(String annotationName) {
        return ClassInfo.getNamesOfClassesWithMethodAnnotation(annotationName, this.allClassInfo);
    }

    List<String> getNamesOfClassesWithFieldAnnotation(String annotationName) {
        return ClassInfo.getNamesOfClassesWithFieldAnnotation(annotationName, this.allClassInfo);
    }

    List<String> getNamesOfAllInterfaceClasses() {
        return ClassInfo.getNamesOfAllInterfaceClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSubinterfaces();
    }

    List<String> getNamesOfSuperinterfacesOf(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfSuperinterfaces();
    }

    List<String> getNamesOfClassesImplementing(String interfaceName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(interfaceName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfClassesImplementing();
    }

    List<String> getNamesOfAllAnnotationClasses() {
        return ClassInfo.getNamesOfAllAnnotationClasses(this.scanSpec, this.allClassInfo);
    }

    List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfClassesWithAnnotation();
    }

    List<String> getNamesOfAnnotationsOnClass(String classOrInterfaceOrAnnotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(classOrInterfaceOrAnnotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfAnnotations();
    }

    List<String> getNamesOfMetaAnnotationsOnAnnotation(String annotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(annotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfMetaAnnotations();
    }

    List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        ClassInfo classInfo = this.classNameToClassInfo.get(metaAnnotationName);
        if (classInfo == null) {
            return Collections.emptyList();
        }
        return classInfo.getNamesOfAnnotationsWithMetaAnnotation();
    }

    private void labelClassNodeHTML(ClassInfo ci, String shape, String boxBgColor, boolean showFields, boolean showMethods, StringBuilder buf) {
        buf.append("[shape=" + shape + ",style=filled,fillcolor=\"#" + boxBgColor + "\",label=");
        buf.append("<");
        buf.append("<table border='0' cellborder='0' cellspacing='1'>");
        buf.append("<tr><td>" + ci.getModifiersStr() + " " + (ci.isEnum() ? "enum" : (ci.isAnnotation() ? "@interface" : (ci.isInterface() ? "interface" : "class"))) + "</td></tr>");
        String className = ci.getClassName();
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx > 0) {
            buf.append("<tr><td><b>");
            GraphvizUtils.htmlEncode(className.substring(0, dotIdx + 1), buf);
            buf.append("</b></td></tr>");
        }
        buf.append("<tr><td><font point-size='24'><b>");
        GraphvizUtils.htmlEncode(className.substring(dotIdx + 1), buf);
        buf.append("</b></font></td></tr>");
        float darkness = 0.8f;
        int r = (int)((float)Integer.parseInt(boxBgColor.substring(0, 2), 16) * 0.8f);
        int g = (int)((float)Integer.parseInt(boxBgColor.substring(2, 4), 16) * 0.8f);
        int b = (int)((float)Integer.parseInt(boxBgColor.substring(4, 6), 16) * 0.8f);
        String darkerColor = String.format("#%s%s%s%s%s%s", Integer.toString(r >> 4, 16), Integer.toString(r & 0xF, 16), Integer.toString(g >> 4, 16), Integer.toString(g & 0xF, 16), Integer.toString(b >> 4, 16), Integer.toString(b & 0xF, 16));
        if (ci.annotationInfo != null && ci.annotationInfo.size() > 0) {
            buf.append("<tr><td colspan='3' bgcolor='" + darkerColor + "'><font point-size='12'><b>ANNOTATIONS</b></font></td></tr>");
            ArrayList<AnnotationInfo> annotationInfoSorted = new ArrayList<AnnotationInfo>(ci.annotationInfo);
            Collections.sort(annotationInfoSorted, new Comparator<AnnotationInfo>(){

                @Override
                public int compare(AnnotationInfo a1, AnnotationInfo a2) {
                    return a1.getAnnotationName().compareTo(a2.getAnnotationName());
                }
            });
            for (AnnotationInfo ai : annotationInfoSorted) {
                buf.append("<tr>");
                buf.append("<td align='center' valign='top'>");
                GraphvizUtils.htmlEncode(ai.toString(), buf);
                buf.append("</td></tr>");
            }
        }
        if (showFields && ci.fieldInfo != null && ci.fieldInfo.size() > 0) {
            buf.append("<tr><td colspan='3' bgcolor='" + darkerColor + "'><font point-size='12'><b>" + (this.scanSpec.ignoreFieldVisibility ? "" : "PUBLIC ") + "FIELDS</b></font></td></tr>");
            buf.append("<tr><td cellpadding='0'>");
            buf.append("<table border='0' cellborder='0'>");
            ArrayList<FieldInfo> fieldInfoSorted = new ArrayList<FieldInfo>(ci.fieldInfo);
            Collections.sort(fieldInfoSorted, new Comparator<FieldInfo>(){

                @Override
                public int compare(FieldInfo f1, FieldInfo f2) {
                    return f1.getFieldName().compareTo(f2.getFieldName());
                }
            });
            for (FieldInfo fi : fieldInfoSorted) {
                buf.append("<tr>");
                buf.append("<td align='right' valign='top'>");
                for (AnnotationInfo ai : fi.getAnnotationInfo()) {
                    if (buf.charAt(buf.length() - 1) != ' ') {
                        buf.append(' ');
                    }
                    GraphvizUtils.htmlEncode(ai.toString(), buf);
                }
                if (this.scanSpec.ignoreFieldVisibility) {
                    if (buf.charAt(buf.length() - 1) != ' ') {
                        buf.append(' ');
                    }
                    buf.append(fi.getModifierStr());
                }
                if (buf.charAt(buf.length() - 1) != ' ') {
                    buf.append(' ');
                }
                GraphvizUtils.htmlEncode(fi.getTypeSignatureOrTypeDescriptor().toString(), buf);
                buf.append("</td>");
                buf.append("<td align='left' valign='top'><b>");
                GraphvizUtils.htmlEncode(fi.getFieldName(), buf);
                buf.append("</b></td></tr>");
            }
            buf.append("</table>");
            buf.append("</td></tr>");
        }
        if (showMethods && ci.methodInfo != null && ci.methodInfo.size() > 0) {
            buf.append("<tr><td cellpadding='0'>");
            buf.append("<table border='0' cellborder='0'>");
            buf.append("<tr><td colspan='3' bgcolor='" + darkerColor + "'><font point-size='12'><b>" + (this.scanSpec.ignoreMethodVisibility ? "" : "PUBLIC ") + "METHODS</b></font></td></tr>");
            ArrayList<MethodInfo> methodInfoSorted = new ArrayList<MethodInfo>(ci.methodInfo);
            Collections.sort(methodInfoSorted, new Comparator<MethodInfo>(){

                @Override
                public int compare(MethodInfo f1, MethodInfo f2) {
                    return f1.getMethodName().compareTo(f2.getMethodName());
                }
            });
            for (MethodInfo mi : methodInfoSorted) {
                if (mi.getMethodName().equals("<clinit>")) continue;
                buf.append("<tr>");
                buf.append("<td align='right' valign='top'>");
                for (AnnotationInfo ai : mi.getAnnotationInfo()) {
                    if (buf.charAt(buf.length() - 1) != ' ') {
                        buf.append(' ');
                    }
                    GraphvizUtils.htmlEncode(ai.toString(), buf);
                }
                if (this.scanSpec.ignoreMethodVisibility) {
                    if (buf.charAt(buf.length() - 1) != ' ') {
                        buf.append(' ');
                    }
                    buf.append(mi.getModifiersStr());
                }
                if (buf.charAt(buf.length() - 1) != ' ') {
                    buf.append(' ');
                }
                if (!mi.getMethodName().equals("<init>")) {
                    GraphvizUtils.htmlEncode(mi.getResultType().toString(), buf);
                } else {
                    buf.append("<b>&lt;constructor&gt;</b>");
                }
                buf.append("</td>");
                buf.append("<td align='left' valign='top'>");
                buf.append("<b>");
                if (mi.getMethodName().equals("<init>")) {
                    GraphvizUtils.htmlEncode(mi.getClassName().substring(mi.getClassName().lastIndexOf(46) + 1), buf);
                } else {
                    GraphvizUtils.htmlEncode(mi.getMethodName(), buf);
                }
                buf.append("</b>&nbsp;");
                buf.append("</td>");
                buf.append("<td align='left' valign='top'>");
                buf.append('(');
                if (mi.getNumParameters() != 0) {
                    MethodParameterInfo[] paramInfo = mi.getParameterInfo();
                    int wrapPos = 0;
                    for (int i = 0; i < paramInfo.length; ++i) {
                        AnnotationInfo[] paramAnnotationInfo;
                        if (i > 0) {
                            buf.append(", ");
                            wrapPos += 2;
                        }
                        if (wrapPos > 40) {
                            buf.append("</td></tr><tr><td></td><td></td><td align='left' valign='top'>");
                            wrapPos = 0;
                        }
                        if ((paramAnnotationInfo = paramInfo[i].getAnnotationInfo()) != null) {
                            for (AnnotationInfo ai : paramAnnotationInfo) {
                                String ais = ai.toString();
                                if (ais.isEmpty()) continue;
                                if (buf.charAt(buf.length() - 1) != ' ') {
                                    buf.append(' ');
                                }
                                GraphvizUtils.htmlEncode(ais, buf);
                                if ((wrapPos += 1 + ais.length()) <= 40) continue;
                                buf.append("</td></tr><tr><td></td><td></td><td align='left' valign='top'>");
                                wrapPos = 0;
                            }
                        }
                        String paramTypeStr = paramInfo[i].getTypeSignatureOrTypeDescriptor().toString();
                        GraphvizUtils.htmlEncode(paramTypeStr, buf);
                        wrapPos += paramTypeStr.length();
                        String paramName = paramInfo[i].getName();
                        if (paramName == null) continue;
                        buf.append(" <B>");
                        GraphvizUtils.htmlEncode(paramName, buf);
                        wrapPos += 1 + paramName.length();
                        buf.append("</B>");
                    }
                }
                buf.append(')');
                buf.append("</td></tr>");
            }
            buf.append("</table>");
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        buf.append(">]");
    }

    private List<ClassInfo> lookup(Set<String> classNames) {
        ArrayList<ClassInfo> classInfoNodes = new ArrayList<ClassInfo>();
        for (String className : classNames) {
            ClassInfo classInfo = this.classNameToClassInfo.get(className);
            if (classInfo == null) continue;
            classInfoNodes.add(classInfo);
        }
        return classInfoNodes;
    }

    String generateClassGraphDotFile(float sizeX, float sizeY, boolean showFields, boolean showMethods) {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"" + sizeX + "," + sizeY + "\";\n");
        buf.append("layout=dot;\n");
        buf.append("rankdir=\"BT\";\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        buf.append("graph [fontname = \"Courier, Regular\"]\n");
        buf.append("node [fontname = \"Courier, Regular\"]\n");
        buf.append("edge [fontname = \"Courier, Regular\"]\n");
        Set<ClassInfo> standardClassNodes = ClassInfo.filterClassInfo(this.allClassInfo, true, this.scanSpec, ClassInfo.ClassType.STANDARD_CLASS);
        ClassInfo objectClass = this.classNameToClassInfo.get("java.lang.Object");
        if (objectClass != null) {
            standardClassNodes.remove(objectClass);
        }
        Set<ClassInfo> interfaceNodes = ClassInfo.filterClassInfo(this.allClassInfo, true, this.scanSpec, ClassInfo.ClassType.IMPLEMENTED_INTERFACE);
        Set<ClassInfo> annotationNodes = ClassInfo.filterClassInfo(this.allClassInfo, true, this.scanSpec, ClassInfo.ClassType.ANNOTATION);
        for (ClassInfo node : standardClassNodes) {
            buf.append("\"").append(node.getClassName()).append("\"");
            this.labelClassNodeHTML(node, "box", "fff2b6", showFields, showMethods, buf);
            buf.append(";\n");
        }
        for (ClassInfo node : interfaceNodes) {
            buf.append("\"").append(node.getClassName()).append("\"");
            this.labelClassNodeHTML(node, "diamond", "b6e7ff", showFields, showMethods, buf);
            buf.append(";\n");
        }
        for (ClassInfo node : annotationNodes) {
            buf.append("\"").append(node.getClassName()).append("\"");
            this.labelClassNodeHTML(node, "oval", "f3c9ff", showFields, showMethods, buf);
            buf.append(";\n");
        }
        HashSet<ClassInfo> allVisibleNodes = new HashSet<ClassInfo>();
        allVisibleNodes.addAll(standardClassNodes);
        allVisibleNodes.addAll(interfaceNodes);
        allVisibleNodes.addAll(annotationNodes);
        buf.append("\n");
        for (ClassInfo classNode : standardClassNodes) {
            ClassInfo directSuperclassNode = classNode.getDirectSuperclass();
            if (directSuperclassNode != null && allVisibleNodes.contains(directSuperclassNode)) {
                buf.append("  \"" + classNode.getClassName() + "\" -> \"" + directSuperclassNode.getClassName() + "\" [arrowsize=2.5]\n");
            }
            for (ClassInfo implementedInterfaceNode : classNode.getDirectlyImplementedInterfaces()) {
                if (!allVisibleNodes.contains(implementedInterfaceNode)) continue;
                buf.append("  \"" + classNode.getClassName() + "\" -> \"" + implementedInterfaceNode.getClassName() + "\" [arrowhead=diamond, arrowsize=2.5]\n");
            }
            for (ClassInfo fieldTypeNode : this.lookup(classNode.getClassNamesReferencedInFieldTypeDescriptors())) {
                if (!allVisibleNodes.contains(fieldTypeNode)) continue;
                buf.append("  \"" + fieldTypeNode.getClassName() + "\" -> \"" + classNode.getClassName() + "\" [arrowtail=obox, arrowsize=2.5, dir=back]\n");
            }
            for (ClassInfo fieldTypeNode : this.lookup(classNode.getClassNamesReferencedInMethodTypeDescriptors())) {
                if (!allVisibleNodes.contains(fieldTypeNode)) continue;
                buf.append("  \"" + fieldTypeNode.getClassName() + "\" -> \"" + classNode.getClassName() + "\" [arrowtail=box, arrowsize=2.5, dir=back]\n");
            }
        }
        for (ClassInfo interfaceNode : interfaceNodes) {
            for (ClassInfo superinterfaceNode : interfaceNode.getDirectSuperinterfaces()) {
                if (!allVisibleNodes.contains(superinterfaceNode)) continue;
                buf.append("  \"" + interfaceNode.getClassName() + "\" -> \"" + superinterfaceNode.getClassName() + "\" [arrowhead=diamond, arrowsize=2.5]\n");
            }
        }
        for (ClassInfo annotationNode : annotationNodes) {
            for (ClassInfo annotatedClassNode : annotationNode.getClassesWithDirectAnnotation()) {
                if (!allVisibleNodes.contains(annotatedClassNode)) continue;
                buf.append("  \"" + annotatedClassNode.getClassName() + "\" -> \"" + annotationNode.getClassName() + "\" [arrowhead=dot, arrowsize=2.5]\n");
            }
            for (ClassInfo annotatedClassNode : annotationNode.getAnnotationsWithDirectMetaAnnotation()) {
                if (!allVisibleNodes.contains(annotatedClassNode)) continue;
                buf.append("  \"" + annotatedClassNode.getClassName() + "\" -> \"" + annotationNode.getClassName() + "\" [arrowhead=dot, arrowsize=2.5]\n");
            }
            for (ClassInfo classWithMethodAnnotationNode : annotationNode.getClassesWithDirectMethodAnnotation()) {
                if (!allVisibleNodes.contains(classWithMethodAnnotationNode)) continue;
                buf.append("  \"" + classWithMethodAnnotationNode.getClassName() + "\" -> \"" + annotationNode.getClassName() + "\" [arrowhead=odot, arrowsize=2.5]\n");
            }
            for (ClassInfo classWithMethodAnnotationNode : annotationNode.getClassesWithFieldAnnotation()) {
                if (!allVisibleNodes.contains(classWithMethodAnnotationNode)) continue;
                buf.append("  \"" + classWithMethodAnnotationNode.getClassName() + "\" -> \"" + annotationNode.getClassName() + "\" [arrowhead=odot, arrowsize=2.5]\n");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

