/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ReflectionUtils {
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final boolean JAVA_VERSION_IS_8;
    public static final boolean JAVA_VERSION_IS_9_PLUS;

    public static Object getFieldVal(Object obj, String fieldName, boolean throwException) throws IllegalArgumentException, NullPointerException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Field field = classOrSuperclass.getDeclaredField(fieldName);
                    try {
                        field.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return field.get(obj);
                }
                catch (NoSuchFieldException field) {
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Could not get value of field \"" + fieldName + "\"", e);
                }
            }
            if (throwException) {
                throw new IllegalArgumentException("Field \"" + fieldName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null object");
        }
        return null;
    }

    public static Object getStaticFieldVal(Class<?> cls, String fieldName, boolean throwException) throws IllegalArgumentException, NullPointerException {
        if (cls != null) {
            for (Class<?> classOrSuperclass = cls; classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Field field = classOrSuperclass.getDeclaredField(fieldName);
                    try {
                        field.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return field.get(null);
                }
                catch (NoSuchFieldException field) {
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Could not get value of field \"" + fieldName + "\"", e);
                }
            }
            if (throwException) {
                throw new IllegalArgumentException("Field \"" + fieldName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't get field value for null class reference");
        }
        return null;
    }

    private static List<Class<?>> getReverseMethodAttemptOrder(Class<?> cls) {
        ArrayList reverseAttemptOrder = new ArrayList();
        for (Class<?> c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
            reverseAttemptOrder.add(c);
        }
        HashSet addedIfaces = new HashSet();
        LinkedList ifaceQueue = new LinkedList();
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            if (c.isInterface() && addedIfaces.add(c)) {
                ifaceQueue.add(c);
            }
            for (Class<?> iface : c.getInterfaces()) {
                if (!addedIfaces.add(iface)) continue;
                ifaceQueue.add(iface);
            }
        }
        while (!ifaceQueue.isEmpty()) {
            Class iface = (Class)ifaceQueue.remove();
            reverseAttemptOrder.add(iface);
            Class<?>[] superIfaces = iface.getInterfaces();
            if (superIfaces.length <= 0) continue;
            for (Class<?> superIface : superIfaces) {
                if (!addedIfaces.add(superIface)) continue;
                ifaceQueue.add(superIface);
            }
        }
        return reverseAttemptOrder;
    }

    public static Object invokeMethod(Object obj, String methodName, boolean throwException) throws IllegalArgumentException, NullPointerException {
        if (obj != null) {
            Class<?> cls = obj.getClass();
            List<Class<?>> reverseAttemptOrder = ReflectionUtils.getReverseMethodAttemptOrder(cls);
            IllegalAccessException illegalAccessException = null;
            for (int i = reverseAttemptOrder.size() - 1; i >= 0; --i) {
                Class<?> iface = reverseAttemptOrder.get(i);
                try {
                    Method method = iface.getDeclaredMethod(methodName, new Class[0]);
                    try {
                        method.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return method.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException method) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    illegalAccessException = e;
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Exception while invoking method \"" + methodName + "\"", e);
                }
            }
            if (throwException) {
                if (illegalAccessException != null) {
                    throw new IllegalArgumentException("Method \"" + methodName + "\" is not accessible", illegalAccessException);
                }
                throw new IllegalArgumentException("Method \"" + methodName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't invoke method on null object");
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object arg, boolean throwException) throws IllegalArgumentException, NullPointerException {
        if (obj != null) {
            Class<?> cls = obj.getClass();
            List<Class<?>> reverseAttemptOrder = ReflectionUtils.getReverseMethodAttemptOrder(cls);
            IllegalAccessException illegalAccessException = null;
            for (int i = reverseAttemptOrder.size() - 1; i >= 0; --i) {
                Class<?> iface = reverseAttemptOrder.get(i);
                try {
                    Method method = iface.getDeclaredMethod(methodName, argType);
                    try {
                        method.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return method.invoke(obj, arg);
                }
                catch (NoSuchMethodException method) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    illegalAccessException = e;
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Exception while invoking method \"" + methodName + "\"", e);
                }
            }
            if (throwException) {
                if (illegalAccessException != null) {
                    throw new IllegalArgumentException("Method \"" + methodName + "\" is not accessible", illegalAccessException);
                }
                throw new IllegalArgumentException("Method \"" + methodName + "\" doesn't exist");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't invoke method on null object");
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, boolean throwException) throws IllegalArgumentException, NullPointerException {
        block7: {
            if (cls != null) {
                try {
                    Method method = cls.getDeclaredMethod(methodName, new Class[0]);
                    try {
                        method.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return method.invoke(null, new Object[0]);
                }
                catch (Throwable e) {
                    if (throwException) {
                        throw new IllegalArgumentException("Could not invoke method \"" + methodName + "\"", e);
                    }
                    break block7;
                }
            }
            if (throwException) {
                throw new NullPointerException("Can't invoke static method on null class reference");
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object arg, boolean throwException) throws IllegalArgumentException, NullPointerException {
        block7: {
            if (cls != null) {
                try {
                    Method method = cls.getDeclaredMethod(methodName, argType);
                    try {
                        method.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return method.invoke(null, arg);
                }
                catch (Throwable e) {
                    if (throwException) {
                        throw new IllegalArgumentException("Could not invoke method \"" + methodName + "\"", e);
                    }
                    break block7;
                }
            }
            if (throwException) {
                throw new NullPointerException("Can't invoke static method on null class reference");
            }
        }
        return null;
    }

    private static Object tryInvokeDefaultMethod(final Class<?> cls, final String methodName, final Class<?> returnType, ClassLoader classLoader, boolean throwException) throws Exception {
        Object proxyInstance = Proxy.newProxyInstance(classLoader, new Class[]{cls}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (JAVA_VERSION_IS_8) {
                    Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                    constructor.setAccessible(true);
                    ((MethodHandles.Lookup)constructor.newInstance(cls)).in(cls).unreflectSpecial(method, cls).bindTo(proxy).invokeWithArguments(new Object[0]);
                } else {
                    MethodHandles.lookup().findSpecial(cls, methodName, MethodType.methodType(returnType, new Class[0]), cls).bindTo(proxy).invokeWithArguments(new Object[0]);
                }
                return null;
            }
        });
        Method method = proxyInstance.getClass().getDeclaredMethod(methodName, new Class[0]);
        return method.invoke(proxyInstance, new Object[0]);
    }

    public static Object invokeDefaultMethod(Class<?> cls, String methodName, Class<?> returnType, ClassLoader classLoader, boolean throwException) throws IllegalArgumentException, NullPointerException {
        if (cls != null) {
            if (!JAVA_VERSION_IS_8 && !JAVA_VERSION_IS_9_PLUS && throwException) {
                throw new NullPointerException("Can't invoke default method on JDK 1.7");
            }
            List<Class<?>> reverseAttemptOrder = ReflectionUtils.getReverseMethodAttemptOrder(cls);
            IllegalAccessException illegalAccessException = null;
            for (int i = reverseAttemptOrder.size() - 1; i >= 0; --i) {
                Class<?> iface = reverseAttemptOrder.get(i);
                try {
                    return ReflectionUtils.tryInvokeDefaultMethod(iface, methodName, returnType, classLoader, throwException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    illegalAccessException = e;
                    continue;
                }
                catch (Throwable e) {
                    if (!throwException) continue;
                    throw new IllegalArgumentException("Exception while invoking method \"" + methodName + "\"", e);
                }
            }
            if (throwException) {
                throw new IllegalArgumentException("Default method \"" + methodName + "\" not found");
            }
        } else if (throwException) {
            throw new NullPointerException("Can't invoke default method \"" + methodName + "\" on null class reference");
        }
        return null;
    }

    public static Class<?> classForNameOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        boolean bl = JAVA_VERSION_IS_8 = JAVA_VERSION != null && (JAVA_VERSION.equals("8") || JAVA_VERSION.equals("1.8") || JAVA_VERSION.startsWith("1.8."));
        JAVA_VERSION_IS_9_PLUS = JAVA_VERSION != null && Integer.parseInt(JAVA_VERSION.indexOf(46) < 0 ? JAVA_VERSION : JAVA_VERSION.substring(0, JAVA_VERSION.indexOf(46))) >= 9;
    }
}

