/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.json;

import io.github.lukehutch.fastclasspathscanner.json.ClassFields;
import io.github.lukehutch.fastclasspathscanner.json.FieldTypeInfo;
import io.github.lukehutch.fastclasspathscanner.json.JSONUtils;
import io.github.lukehutch.fastclasspathscanner.json.TypeResolutions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;

public class ClassFieldCache {
    final Map<Class<?>, ClassFields> classToClassFields = new HashMap();
    final boolean resolveTypes;
    final boolean onlySerializePublicFields;
    final Map<Class<?>, Constructor<?>> defaultConstructorForConcreteType = new HashMap();
    final Map<Class<?>, Constructor<?>> constructorForConcreteTypeWithSizeHint = new HashMap();
    private static final Constructor<?> NO_CONSTRUCTOR;

    public ClassFieldCache(boolean forDeserialization, boolean onlySerializePublicFields) {
        this.resolveTypes = forDeserialization;
        this.onlySerializePublicFields = !forDeserialization && onlySerializePublicFields;
    }

    void print() {
        for (Map.Entry<Class<?>, ClassFields> ent : this.classToClassFields.entrySet()) {
            System.out.println(ent.getKey().getName());
            ClassFields fields = ent.getValue();
            for (int i = 0; i < fields.fieldOrder.size(); ++i) {
                FieldTypeInfo fieldInfo = fields.fieldOrder.get(i);
                Field f = fieldInfo.field;
                System.out.println("  FIELD: " + f);
                System.out.println("    TYPE: " + f.getType());
                if (fieldInfo.typeResolutionsToFieldTypeFullyResolved == null) continue;
                for (Map.Entry<TypeResolutions, Type> ent2 : fieldInfo.typeResolutionsToFieldTypeFullyResolved.entrySet()) {
                    System.out.println("      RESOLVED TYPE: " + ent2.getKey() + " " + ent2.getValue());
                }
            }
        }
    }

    ClassFields get(Class<?> cls) {
        ClassFields classFields = this.classToClassFields.get(cls);
        if (classFields == null) {
            classFields = new ClassFields(cls, this.resolveTypes, this.onlySerializePublicFields, this);
            this.classToClassFields.put(cls, classFields);
        }
        return classFields;
    }

    static Class<?> getConcreteType(Class<?> rawType, boolean returnNullIfNotMapOrCollection) {
        if (rawType == Map.class || rawType == AbstractMap.class) {
            return HashMap.class;
        }
        if (rawType == ConcurrentMap.class) {
            return ConcurrentHashMap.class;
        }
        if (rawType == SortedMap.class || rawType == NavigableMap.class) {
            return TreeMap.class;
        }
        if (rawType == ConcurrentNavigableMap.class) {
            return ConcurrentSkipListMap.class;
        }
        if (rawType == List.class || rawType == AbstractList.class) {
            return ArrayList.class;
        }
        if (rawType == AbstractSequentialList.class) {
            return LinkedList.class;
        }
        if (rawType == Set.class || rawType == AbstractSet.class) {
            return HashSet.class;
        }
        if (rawType == SortedSet.class) {
            return TreeSet.class;
        }
        if (rawType == Queue.class || rawType == AbstractQueue.class || rawType == Deque.class) {
            return ArrayDeque.class;
        }
        if (rawType == BlockingQueue.class) {
            return LinkedBlockingQueue.class;
        }
        if (rawType == BlockingDeque.class) {
            return LinkedBlockingDeque.class;
        }
        if (rawType == TransferQueue.class) {
            return LinkedTransferQueue.class;
        }
        return rawType;
    }

    Constructor<?> getDefaultConstructorForConcreteTypeOf(Class<?> cls) {
        Class<?> concreteType;
        Constructor<?> constructor = this.defaultConstructorForConcreteType.get(cls);
        if (constructor != null) {
            return constructor;
        }
        for (Class<?> c = concreteType = ClassFieldCache.getConcreteType(cls, false); c != null && (c != Object.class || cls == Object.class); c = c.getSuperclass()) {
            try {
                Constructor<?> defaultConstructor = c.getDeclaredConstructor(new Class[0]);
                JSONUtils.isAccessibleOrMakeAccessible(defaultConstructor);
                this.defaultConstructorForConcreteType.put(cls, defaultConstructor);
                return defaultConstructor;
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new IllegalArgumentException("Class " + cls.getName() + " does not have an accessible default (no-arg) constructor");
    }

    Constructor<?> getConstructorWithSizeHintForConcreteTypeOf(Class<?> cls) {
        Constructor<?> constructor = this.constructorForConcreteTypeWithSizeHint.get(cls);
        if (constructor != null && constructor != NO_CONSTRUCTOR) {
            return constructor;
        }
        Class<?> concreteType = ClassFieldCache.getConcreteType(cls, true);
        if (concreteType != null) {
            for (Class<?> c = concreteType; c != null && (c != Object.class || cls == Object.class); c = c.getSuperclass()) {
                try {
                    Constructor<?> constructorWithSizeHint = c.getDeclaredConstructor(Integer.TYPE);
                    JSONUtils.isAccessibleOrMakeAccessible(constructorWithSizeHint);
                    this.constructorForConcreteTypeWithSizeHint.put(cls, constructorWithSizeHint);
                    return constructorWithSizeHint;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        this.constructorForConcreteTypeWithSizeHint.put(cls, NO_CONSTRUCTOR);
        return null;
    }

    static {
        try {
            NO_CONSTRUCTOR = NoConstructor.class.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NoConstructor {
    }
}

