/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathResource;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.scanner.matchers.FileMatchProcessorWrapper;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

class ClasspathElementDir
extends ClasspathElement {
    private File dir;

    ClasspathElementDir(RelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker, LogNode log) {
        super(classpathEltPath, scanSpec, scanFiles, interruptionChecker);
        if (scanFiles) {
            try {
                this.dir = classpathEltPath.getFile(log);
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception while trying to canonicalize path " + classpathEltPath.getResolvedPath(), e);
                }
                this.ioExceptionOnOpen = true;
                return;
            }
            this.fileMatches = new MultiMapKeyToList();
            this.classfileMatches = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    @Override
    public void scanPaths(LogNode log) {
        String path;
        String canonicalPath = path = this.classpathEltPath.getResolvedPath();
        try {
            canonicalPath = this.classpathEltPath.getCanonicalPath(log);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LogNode logNode = log == null ? null : log.log(canonicalPath, "Scanning directory classpath entry " + this.classpathEltPath + (path.equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        HashSet<String> scannedCanonicalPaths = new HashSet<String>();
        this.scanDir(this.dir, this.dir, this.dir.getPath().length() + 1, false, scannedCanonicalPaths, logNode);
        if (logNode != null) {
            logNode.addElapsedTime();
        }
    }

    private ClasspathResource newClasspathResource(File classpathEltFile, String pathRelativeToClasspathElt, String pathRelativeToClasspathPrefix, final File relativePathFile) {
        return new ClasspathResource(classpathEltFile, null, pathRelativeToClasspathElt, pathRelativeToClasspathPrefix){
            InputStream inputStream;
            {
                super(classpathEltFile, moduleRef, pathRelativeToClasspathElt, pathRelativeToClasspathPrefix);
                this.inputStream = null;
            }

            @Override
            public InputStream open() throws IOException {
                if (ClasspathElementDir.this.ioExceptionOnOpen) {
                    throw new IOException("Parent directory could not be opened");
                }
                try {
                    if (this.inputStream != null) {
                        throw new RuntimeException("Tried to open classpath resource twice");
                    }
                    this.inputStream = new FileInputStream(relativePathFile);
                    this.inputStreamLength = relativePathFile.length();
                    return this.inputStream;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.inputStream = null;
                }
            }
        };
    }

    private void scanDir(File classpathElt, File dir, int ignorePrefixLen, boolean prevInWhitelistedPath, HashSet<String> scannedCanonicalPaths, LogNode log) {
        String canonicalPath;
        boolean inWhitelistedPath = prevInWhitelistedPath;
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir, e);
            }
            return;
        }
        String dirPath = dir.getPath();
        String dirRelativePath = ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        ScanSpec.ScanSpecPathMatch matchStatus = this.scanSpec.dirWhitelistMatchStatus(dirRelativePath);
        if (matchStatus == ScanSpec.ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
            if (log != null) {
                log.log("Reached non-whitelisted (or blacklisted) directory: " + dirRelativePath);
            }
            return;
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH || matchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX) {
            inWhitelistedPath = true;
        }
        if (this.nestedClasspathRoots != null && this.nestedClasspathRoots.contains(dirRelativePath)) {
            if (log != null) {
                log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + dirRelativePath);
            }
            return;
        }
        File[] filesInDir = dir.listFiles();
        if (filesInDir == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        LogNode dirLog = log == null ? null : log.log(canonicalPath, "Scanning subdirectory path: " + dirRelativePath + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        for (File fileInDir : filesInDir) {
            String fileInDirRelativePath;
            if (fileInDir.isDirectory()) {
                if (!inWhitelistedPath && matchStatus != ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) continue;
                this.scanDir(classpathElt, fileInDir, ignorePrefixLen, inWhitelistedPath, scannedCanonicalPaths, dirLog);
                if (dirLog == null) continue;
                dirLog.addElapsedTime();
                continue;
            }
            if (!fileInDir.isFile()) continue;
            String string = fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? fileInDir.getName() : dirRelativePath + fileInDir.getName();
            if (!inWhitelistedPath && (matchStatus != ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE || !this.scanSpec.isSpecificallyWhitelistedClass(fileInDirRelativePath))) continue;
            LogNode subLog = dirLog == null ? null : dirLog.log(fileInDirRelativePath, "Found whitelisted file: " + fileInDirRelativePath);
            this.fileToLastModified.put(fileInDir, fileInDir.lastModified());
            if (FileUtils.isClassfile(fileInDirRelativePath)) {
                this.classfileMatches.add(this.newClasspathResource(classpathElt, fileInDirRelativePath, fileInDirRelativePath, fileInDir));
            }
            for (FileMatchProcessorWrapper fileMatchProcessorWrapper : this.scanSpec.getFileMatchProcessorWrappers()) {
                if (!fileMatchProcessorWrapper.filePathMatches(fileInDirRelativePath, subLog)) continue;
                this.fileMatches.put(fileMatchProcessorWrapper, this.newClasspathResource(classpathElt, fileInDirRelativePath, fileInDirRelativePath, fileInDir));
            }
        }
        if (matchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX || matchStatus == ScanSpec.ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH) {
            this.fileToLastModified.put(dir, dir.lastModified());
        }
    }

    @Override
    public void close() {
    }
}

