/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandlerRegistry;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderAndModuleFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathOrder;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ClasspathFinder {
    static final String currDirPathStr = FileUtils.getCurrDirPathStr();
    private final List<RelativePath> rawClasspathElements;
    private final ClassLoaderAndModuleFinder classLoaderAndModuleFinder;

    private boolean addClassLoaderHandler(ScanSpec scanSpec, ClassLoader classLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry, LinkedHashSet<ClassLoader> foundClassLoaders, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerRegistryEntries, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrderOut, LogNode log) {
        ClassLoaderHandler classLoaderHandler = classLoaderHandlerRegistryEntry.instantiate(log);
        if (classLoaderHandler != null) {
            if (log != null) {
                log.log("ClassLoader " + classLoader + " will be handled by " + classLoaderHandler);
            }
            ClassLoaderHandler.DelegationOrder delegationOrder = classLoaderHandler.getDelegationOrder(classLoader);
            ClassLoader parent = classLoader.getParent();
            if (log != null && parent != null) {
                log.log(classLoader + " delegates to parent " + parent + " with order " + (Object)((Object)delegationOrder));
            }
            switch (delegationOrder) {
                case PARENT_FIRST: {
                    if (parent != null) {
                        this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, parent, foundClassLoaders, allClassLoaderHandlerRegistryEntries, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
                    }
                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                    return true;
                }
                case PARENT_LAST: {
                    classLoaderAndHandlerOrderOut.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>(classLoader, classLoaderHandler));
                    if (parent != null) {
                        this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, parent, foundClassLoaders, allClassLoaderHandlerRegistryEntries, scanSpec.ignoreParentClassLoaders ? ignoredClassLoaderAndHandlerOrderOut : classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
                    }
                    return true;
                }
            }
            throw new RuntimeException("Unknown delegation order");
        }
        return false;
    }

    private void findClassLoaderHandlerForClassLoaderAndParents(ScanSpec scanSpec, ClassLoader classLoader, LinkedHashSet<ClassLoader> foundClassLoaders, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerRegistryEntries, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrderOut, List<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> ignoredClassLoaderAndHandlerOrderOut, LogNode log) {
        if (foundClassLoaders.add(classLoader)) {
            boolean foundMatch = false;
            for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerRegistryEntries) {
                    for (String handledClassLoaderName : classLoaderHandlerRegistryEntry.handledClassLoaderNames) {
                        if (!handledClassLoaderName.equals(c.getName())) continue;
                        if (!this.addClassLoaderHandler(scanSpec, classLoader, classLoaderHandlerRegistryEntry, foundClassLoaders, allClassLoaderHandlerRegistryEntries, classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log)) break;
                        foundMatch = true;
                        break;
                    }
                    if (!foundMatch) continue;
                    break;
                }
                if (foundMatch) break;
            }
            if (!foundMatch) {
                if (log != null) {
                    log.log("Could not find a ClassLoaderHandler that can handle " + classLoader + " , trying " + ClassLoaderHandlerRegistry.FALLBACK_CLASS_LOADER_HANDLER.classLoaderHandlerClass.getName() + " instead. Please report this at: https://github.com/lukehutch/fast-classpath-scanner/issues");
                }
                this.addClassLoaderHandler(scanSpec, classLoader, ClassLoaderHandlerRegistry.FALLBACK_CLASS_LOADER_HANDLER, foundClassLoaders, allClassLoaderHandlerRegistryEntries, classLoaderAndHandlerOrderOut, ignoredClassLoaderAndHandlerOrderOut, log);
            }
        }
    }

    public static ClassLoaderHandler findClassLoaderHandlerForClassLoader(ScanSpec scanSpec, ClassLoader classLoader, LogNode log) {
        for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
            List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerRegistryEntries = scanSpec.getAllClassLoaderHandlerRegistryEntries();
            for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerRegistryEntries) {
                for (String handledClassLoaderName : classLoaderHandlerRegistryEntry.handledClassLoaderNames) {
                    if (!handledClassLoaderName.equals(c.getName())) continue;
                    return classLoaderHandlerRegistryEntry.instantiate(log);
                }
            }
        }
        return ClassLoaderHandlerRegistry.FALLBACK_CLASS_LOADER_HANDLER.instantiate(log);
    }

    ClasspathFinder(ScanSpec scanSpec, NestedJarHandler nestedJarHandler, LogNode log) {
        LogNode classpathFinderLog = log == null ? null : log.log("Finding ClassLoaders");
        this.classLoaderAndModuleFinder = new ClassLoaderAndModuleFinder(scanSpec, classpathFinderLog);
        ClasspathOrder classpathOrder = new ClasspathOrder(scanSpec, nestedJarHandler);
        ClasspathOrder ignoredClasspathOrder = new ClasspathOrder(scanSpec, nestedJarHandler);
        ClassLoader[] classLoaders = this.classLoaderAndModuleFinder.getClassLoaders();
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders != null && classpathFinderLog != null) {
                classpathFinderLog.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = classpathFinderLog == null ? null : classpathFinderLog.log("Overriding classpath with: " + scanSpec.overrideClasspath);
            classpathOrder.addClasspathElements(scanSpec.overrideClasspath, classLoaders, overrideLog);
            if (overrideLog != null) {
                classpathFinderLog.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
        } else {
            String[] stringArray;
            LogNode classLoaderClasspathLog;
            ClassLoaderHandler classLoaderHandler;
            if (!scanSpec.blacklistSystemJars() || !scanSpec.whitelistedLibOrExtJarPaths.isEmpty()) {
                List<String> jreJarPaths = JarUtils.getJreJarPaths();
                if (log != null) {
                    log.log("Adding JRE/JDK jars to classpath:").log(jreJarPaths);
                }
                for (String string : jreJarPaths) {
                    classpathOrder.addClasspathElement(string, classLoaders, scanSpec, classpathFinderLog);
                }
            }
            List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> allClassLoaderHandlerRegistryEntries = scanSpec.getAllClassLoaderHandlerRegistryEntries();
            if (classpathFinderLog != null) {
                LogNode classLoaderHandlerLog = classpathFinderLog.log("ClassLoaderHandlers:");
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry : allClassLoaderHandlerRegistryEntries) {
                    classLoaderHandlerLog.log(classLoaderHandlerRegistryEntry.classLoaderHandlerClass.getName());
                }
            }
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> classLoaderAndHandlerOrder = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>> arrayList = new ArrayList<AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandler>>();
            for (ClassLoader envClassLoader : classLoaders) {
                if (!scanSpec.blacklistSystemJars() || !envClassLoader.getClass().getName().startsWith("sun.misc.Launcher$ExtClassLoader")) {
                    this.findClassLoaderHandlerForClassLoaderAndParents(scanSpec, envClassLoader, new LinkedHashSet<ClassLoader>(), allClassLoaderHandlerRegistryEntries, classLoaderAndHandlerOrder, arrayList, classpathFinderLog);
                    continue;
                }
                if (classpathFinderLog == null) continue;
                classpathFinderLog.log("Skipping system classloader " + envClassLoader.getClass().getName());
            }
            for (AbstractMap.SimpleEntry simpleEntry : classLoaderAndHandlerOrder) {
                ClassLoader classLoader = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Finding classpath elements in ClassLoader " + classLoader);
                try {
                    classLoaderHandler.handle(scanSpec, classLoader, classpathOrder, classLoaderClasspathLog);
                }
                catch (Throwable e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            for (AbstractMap.SimpleEntry simpleEntry : arrayList) {
                ClassLoader classLoader = (ClassLoader)simpleEntry.getKey();
                classLoaderHandler = (ClassLoaderHandler)simpleEntry.getValue();
                classLoaderClasspathLog = classpathFinderLog == null ? null : classpathFinderLog.log("Will not scan the following classpath elements from ignored ClassLoader " + classLoader);
                try {
                    classLoaderHandler.handle(scanSpec, classLoader, ignoredClasspathOrder, classLoaderClasspathLog);
                }
                catch (Throwable e) {
                    if (classLoaderClasspathLog == null) continue;
                    classLoaderClasspathLog.log("Exception in ClassLoaderHandler", e);
                }
            }
            if (scanSpec.overrideClassLoaders == null && scanSpec.overrideClasspath == null && (stringArray = JarUtils.smartPathSplit(System.getProperty("java.class.path"))).length > 0) {
                LogNode logNode = classpathFinderLog == null ? null : classpathFinderLog.log("Getting classpath entries from java.class.path");
                for (String pathElement : stringArray) {
                    if (!ignoredClasspathOrder.get().contains(new RelativePath(currDirPathStr, pathElement, classLoaders, nestedJarHandler, scanSpec, log))) {
                        classpathOrder.addClasspathElement(pathElement, classLoaders, scanSpec, logNode);
                        continue;
                    }
                    if (logNode == null) continue;
                    logNode.log("Found classpath element in java.class.path that will be ignored, since it is also found in an ignored parent classloader: " + pathElement);
                }
            }
        }
        this.rawClasspathElements = new ArrayList<RelativePath>(classpathOrder.get());
    }

    public List<RelativePath> getRawClasspathElements() {
        return this.rawClasspathElements;
    }

    public ClassLoaderAndModuleFinder getClassLoaderAndModuleFinder() {
        return this.classLoaderAndModuleFinder;
    }
}

