/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ModuleRef;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.FileUtils;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

class RelativePath {
    ClassLoader[] classLoaders;
    private final String pathToResolveAgainst;
    private final String relativePath;
    private String jarfilePackageRoot = "";
    private final NestedJarHandler nestedJarHandler;
    private String resolvedPathCached;
    private boolean resolvedPathIsCached;
    private boolean isHttpURL;
    private boolean isHttpURLIsCached;
    private boolean isJrtURL;
    private boolean isJrtURLIsCached;
    private ModuleRef moduleRef;
    private File fileCached;
    private boolean fileIsCached;
    private String canonicalPathCached;
    private boolean canonicalPathIsCached;
    private boolean isFileCached;
    private boolean isFileIsCached;
    private boolean isDirectoryCached;
    private boolean isDirectoryIsCached;
    private boolean existsCached;
    private boolean existsIsCached;
    private ScanSpec scanSpec;
    private final LogNode log;

    public RelativePath(String pathToResolveAgainst, String relativePath, ClassLoader[] classLoaders, NestedJarHandler nestedJarHandler, ScanSpec scanSpec, LogNode log) {
        this.classLoaders = classLoaders;
        this.pathToResolveAgainst = pathToResolveAgainst;
        this.nestedJarHandler = nestedJarHandler;
        this.scanSpec = scanSpec;
        this.log = log;
        this.relativePath = relativePath.endsWith("!") ? relativePath.substring(0, relativePath.length() - 1) : (relativePath.endsWith("!/") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!/") ? relativePath.substring(0, relativePath.length() - 3) : relativePath)));
    }

    public RelativePath(ModuleRef moduleRef, NestedJarHandler nestedJarHandler, LogNode log) {
        ClassLoader[] classLoaderArray;
        if (moduleRef == null) {
            throw new IllegalArgumentException("moduleRef cannot be null");
        }
        this.moduleRef = moduleRef;
        ClassLoader classLoader = moduleRef.getClassLoader();
        if (classLoader == null) {
            classLoaderArray = null;
        } else {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = classLoader;
        }
        this.classLoaders = classLoaderArray;
        this.pathToResolveAgainst = "";
        this.nestedJarHandler = nestedJarHandler;
        this.relativePath = moduleRef.getModuleLocationStr();
        this.log = log;
    }

    public int hashCode() {
        return this.relativePath.hashCode() + 31 * this.jarfilePackageRoot.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RelativePath)) {
            return false;
        }
        RelativePath other = (RelativePath)o;
        try {
            String thisCp = this.getCanonicalPath(this.log);
            String otherCp = other.getCanonicalPath(this.log);
            if (thisCp == null || otherCp == null) {
                return false;
            }
            if (!thisCp.equals(otherCp)) {
                return false;
            }
            return this.getJarfilePackageRoot().equals(other.getJarfilePackageRoot());
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        if (this.jarfilePackageRoot.isEmpty()) {
            return this.getResolvedPath();
        }
        try {
            return this.getFile(null) + "!" + this.jarfilePackageRoot;
        }
        catch (Exception e) {
            return this.getResolvedPath();
        }
    }

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public String getResolvedPath() {
        if (!this.resolvedPathIsCached) {
            String resolvedPath = FastPathResolver.resolve(this.pathToResolveAgainst, this.relativePath);
            this.resolvedPathCached = resolvedPath.endsWith("!") ? resolvedPath.substring(0, resolvedPath.length() - 1) : (resolvedPath.endsWith("!/") ? resolvedPath.substring(0, resolvedPath.length() - 2) : resolvedPath);
            this.resolvedPathIsCached = true;
        }
        return this.resolvedPathCached;
    }

    public boolean isHttpURL() {
        if (!this.isHttpURLIsCached) {
            String resolvedPath = this.getResolvedPath();
            this.isHttpURL = resolvedPath.regionMatches(true, 0, "http://", 0, 7) || resolvedPath.regionMatches(true, 0, "https://", 0, 8);
            this.isHttpURLIsCached = true;
        }
        return this.isHttpURL;
    }

    public boolean isJrtURL() {
        if (!this.isJrtURLIsCached) {
            String resolvedPath = this.getResolvedPath();
            this.isJrtURL = resolvedPath.regionMatches(true, 0, "jrt:/", 0, 5);
            this.isJrtURLIsCached = true;
        }
        return this.isJrtURL;
    }

    public ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    public File getFile(LogNode log) throws IOException {
        if (!this.fileIsCached) {
            String path = this.getResolvedPath();
            if (path == null) {
                throw new IOException("Path " + this.relativePath + " could not be resolved relative to " + this.pathToResolveAgainst);
            }
            if (this.isJrtURL) {
                throw new IOException("Cannot use jrt:/ URL for non-module classpath entry " + this.relativePath);
            }
            File pathFile = new File(path);
            if (pathFile.exists() && pathFile.isDirectory()) {
                this.fileCached = pathFile;
            } else {
                int plingIdx = path.lastIndexOf(33);
                try {
                    Map.Entry<File, Set<String>> innermostJarAndRootRelativePaths = this.nestedJarHandler.getInnermostNestedJar(path, log);
                    if (innermostJarAndRootRelativePaths != null) {
                        File innermostJar = innermostJarAndRootRelativePaths.getKey();
                        Set<String> rootRelativePaths = innermostJarAndRootRelativePaths.getValue();
                        if (rootRelativePaths.isEmpty()) {
                            this.fileCached = innermostJar;
                        } else {
                            String packageRoot;
                            String string = path.length() == plingIdx + 1 || plingIdx == -1 ? "" : (packageRoot = path.charAt(plingIdx + 1) == '/' ? path.substring(plingIdx + 2) : path.substring(plingIdx + 1));
                            if (rootRelativePaths.contains(packageRoot)) {
                                if (this.scanSpec.createClassLoaderForMatchingClasses) {
                                    this.fileCached = this.nestedJarHandler.unzipToTempDir(innermostJar, packageRoot, log);
                                } else {
                                    this.fileCached = innermostJar;
                                    this.jarfilePackageRoot = packageRoot;
                                }
                            } else {
                                if (log != null) {
                                    log.log("Zipfile suffix is not a valid package root: !" + packageRoot);
                                }
                                this.fileCached = innermostJar;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException("Exception while locating jarfile " + this.relativePath, e);
                }
            }
            if (this.fileCached == null || !ClasspathUtils.canRead(this.fileCached)) {
                throw new IOException("Could not locate jarfile " + this.relativePath + (this.relativePath.equals(path) ? "" : " -- resolved to: " + path));
            }
            try {
                this.fileCached = this.fileCached.getCanonicalFile();
            }
            catch (IOException e) {
                throw new IOException("Could not canonicalize path " + path + " : " + e);
            }
            catch (SecurityException e) {
                throw new IOException("Could not canonicalize path " + path + " : " + e);
            }
            this.fileIsCached = true;
        }
        return this.fileCached;
    }

    public String getJarfilePackageRoot() {
        return this.jarfilePackageRoot;
    }

    public String getCanonicalPath(LogNode log) throws IOException {
        if (!this.canonicalPathIsCached) {
            File file = this.getFile(log);
            this.canonicalPathCached = FastPathResolver.resolve(file.getPath());
            this.canonicalPathIsCached = true;
        }
        return this.canonicalPathCached;
    }

    public boolean isFile(LogNode log) throws IOException {
        if (!this.isFileIsCached) {
            this.isFileCached = this.getFile(log).isFile();
            this.isFileIsCached = true;
        }
        return this.isFileCached;
    }

    public boolean isDirectory(LogNode log) throws IOException {
        if (!this.isDirectoryIsCached) {
            this.isDirectoryCached = this.getFile(log).isDirectory();
            this.isDirectoryIsCached = true;
        }
        return this.isDirectoryCached;
    }

    public boolean isClassfile() {
        return FileUtils.isClassfile(this.getResolvedPath());
    }

    private boolean exists(LogNode log) throws IOException {
        if (!this.existsIsCached) {
            this.existsCached = ClasspathUtils.canRead(this.getFile(log));
            this.existsIsCached = true;
        }
        return this.existsCached;
    }

    public boolean isValidClasspathElement(ScanSpec scanSpec, LogNode log) throws InterruptedException {
        String path = this.getResolvedPath();
        if (this.isJrtURL || this.moduleRef != null) {
            return true;
        }
        try {
            boolean isDirectory;
            if (!this.exists(log)) {
                if (log != null) {
                    log.log("Classpath element does not exist: " + path);
                }
                return false;
            }
            boolean isFile = this.isFile(log);
            if (isFile != !(isDirectory = this.isDirectory(log))) {
                if (log != null) {
                    log.log("Ignoring invalid classpath element: " + path);
                }
                return false;
            }
            if (isFile) {
                String canonicalPath = this.getCanonicalPath(log);
                if (scanSpec.blacklistSystemJars() && JarUtils.isJREJar(canonicalPath, scanSpec.whitelistedLibOrExtJarPaths, scanSpec.blacklistedLibOrExtJarPaths, log)) {
                    if (log != null) {
                        log.log("Ignoring JRE jar: " + path);
                    }
                    return false;
                }
            }
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Could not canonicalize path " + path + " : " + e);
            }
            return false;
        }
        return true;
    }
}

