/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderAndModuleFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.FailureHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ModuleRef;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.RelativePathToElementMap;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResultProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class Scanner
implements Callable<ScanResult> {
    private final ScanSpec scanSpec;
    private final ExecutorService executorService;
    private final int numParallelTasks;
    private final boolean enableRecursiveScanning;
    private final InterruptionChecker interruptionChecker = new InterruptionChecker();
    private final ScanResultProcessor scanResultProcessor;
    private final FailureHandler failureHandler;
    private final LogNode log;
    private NestedJarHandler nestedJarHandler;
    private static final int NUM_FILES_PER_CHUNK = 200;

    public Scanner(ScanSpec scanSpec, ExecutorService executorService, int numParallelTasks, boolean enableRecursiveScanning, ScanResultProcessor scannResultProcessor, FailureHandler failureHandler, LogNode log) {
        this.scanSpec = scanSpec;
        this.executorService = executorService;
        this.numParallelTasks = numParallelTasks;
        this.enableRecursiveScanning = enableRecursiveScanning;
        this.scanResultProcessor = scannResultProcessor;
        this.failureHandler = failureHandler;
        this.log = log;
    }

    private static void findClasspathOrder(ClasspathElement currSingleton, RelativePathToElementMap classpathElementMap, HashSet<ClasspathElement> visitedClasspathElts, ArrayList<ClasspathElement> order) throws InterruptedException {
        if (visitedClasspathElts.add(currSingleton)) {
            order.add(currSingleton);
            if (currSingleton.childClasspathElts != null) {
                for (RelativePath childClasspathElt : currSingleton.childClasspathElts) {
                    ClasspathElement childSingleton = (ClasspathElement)classpathElementMap.get(childClasspathElt);
                    if (childSingleton == null || childSingleton.ioExceptionOnOpen) continue;
                    Scanner.findClasspathOrder(childSingleton, classpathElementMap, visitedClasspathElts, order);
                }
            }
        }
    }

    private static List<ClasspathElement> findClasspathOrder(List<RelativePath> rawClasspathElements, RelativePathToElementMap classpathElementMap) throws InterruptedException {
        HashSet<ClasspathElement> visitedClasspathElts = new HashSet<ClasspathElement>();
        ArrayList<ClasspathElement> order = new ArrayList<ClasspathElement>();
        for (RelativePath toplevelClasspathElt : rawClasspathElements) {
            ClasspathElement toplevelSingleton = (ClasspathElement)classpathElementMap.get(toplevelClasspathElt);
            if (toplevelSingleton == null || toplevelSingleton.ioExceptionOnOpen) continue;
            Scanner.findClasspathOrder(toplevelSingleton, classpathElementMap, visitedClasspathElts, order);
        }
        return order;
    }

    private static List<ClassfileParserChunk> getClassfileParserChunks(List<ClasspathElement> classpathOrder) {
        LinkedList chunks = new LinkedList();
        for (ClasspathElement classpathElement : classpathOrder) {
            LinkedList<ClassfileParserChunk> chunksForClasspathElt = new LinkedList<ClassfileParserChunk>();
            int n = classpathElement.getNumClassfileMatches();
            if (n > 0) {
                int numChunks = (int)Math.ceil((float)n / 200.0f);
                float filesPerChunk = (float)n / (float)numChunks;
                for (int i = 0; i < numChunks; ++i) {
                    int classfileEndIdx;
                    int classfileStartIdx = (int)((float)i * filesPerChunk);
                    int n2 = classfileEndIdx = i < numChunks - 1 ? (int)((float)(i + 1) * filesPerChunk) : n;
                    if (classfileEndIdx <= classfileStartIdx) continue;
                    chunksForClasspathElt.add(new ClassfileParserChunk(classpathElement, classfileStartIdx, classfileEndIdx));
                }
            }
            chunks.add(chunksForClasspathElt);
        }
        ArrayList<ClassfileParserChunk> interleavedChunks = new ArrayList<ClassfileParserChunk>();
        while (!chunks.isEmpty()) {
            LinkedList<LinkedList> nextChunks = new LinkedList<LinkedList>();
            for (LinkedList linkedList : chunks) {
                if (linkedList.isEmpty()) continue;
                ClassfileParserChunk head = (ClassfileParserChunk)linkedList.remove();
                interleavedChunks.add(head);
                if (linkedList.isEmpty()) continue;
                nextChunks.add(linkedList);
            }
            chunks = nextChunks;
        }
        return interleavedChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult call() throws InterruptedException, ExecutionException {
        LogNode classpathFinderLog = this.log == null ? null : this.log.log("Finding classpath entries");
        this.nestedJarHandler = new NestedJarHandler(this.scanSpec.stripSFXHeader, this.interruptionChecker, classpathFinderLog);
        try {
            ScanResult scanResult;
            long scanStart = System.nanoTime();
            LogNode getRawElementsLog = classpathFinderLog == null ? null : classpathFinderLog.log("Getting raw classpath elements");
            ClasspathFinder classpathFinder = new ClasspathFinder(this.scanSpec, this.nestedJarHandler, getRawElementsLog);
            ClassLoaderAndModuleFinder classLoaderAndModuleFinder = classpathFinder.getClassLoaderAndModuleFinder();
            ClassLoader[] classLoaderOrder = classLoaderAndModuleFinder.getClassLoaders();
            ArrayList<RelativePath> rawClasspathEltOrder = new ArrayList<RelativePath>();
            if (this.scanSpec.overrideClasspath == null && this.scanSpec.overrideClassLoaders == null) {
                List<ModuleRef> nonSystemModules;
                List<ModuleRef> systemModules = classLoaderAndModuleFinder.getSystemModuleRefs();
                if (systemModules != null) {
                    for (ModuleRef moduleRef : systemModules) {
                        String moduleName = moduleRef.getModuleName();
                        if ((!this.scanSpec.blacklistSystemJars && this.scanSpec.whitelistedModules.isEmpty() || this.scanSpec.whitelistedModules.contains(moduleName)) && !this.scanSpec.blacklistedModules.contains(moduleName)) {
                            rawClasspathEltOrder.add(new RelativePath(moduleRef, this.nestedJarHandler, getRawElementsLog));
                            continue;
                        }
                        if (this.log == null) continue;
                        this.log.log("Skipping blacklisted/non-whitelisted system module: " + moduleName);
                    }
                }
                if ((nonSystemModules = classLoaderAndModuleFinder.getNonSystemModuleRefs()) != null) {
                    for (ModuleRef nonSystemModule : nonSystemModules) {
                        String moduleName = nonSystemModule.getModuleName();
                        if ((this.scanSpec.whitelistedModules.isEmpty() || this.scanSpec.whitelistedModules.contains(moduleName)) && !this.scanSpec.blacklistedModules.contains(moduleName)) {
                            rawClasspathEltOrder.add(new RelativePath(nonSystemModule, this.nestedJarHandler, getRawElementsLog));
                            continue;
                        }
                        if (this.log == null) continue;
                        this.log.log("Skipping blacklisted/non-whitelisted module: " + moduleName);
                    }
                }
            }
            if ((this.scanSpec.whitelistedModules.isEmpty() || this.scanSpec.whitelistedModules.contains("")) && !this.scanSpec.blacklistedModules.contains("")) {
                rawClasspathEltOrder.addAll(classpathFinder.getRawClasspathElements());
            } else if (this.log != null) {
                this.log.log("Skipping non-module classpath entries, since the unnamed module (\"\") is not whitelisted, or is blacklisted");
            }
            final LogNode preScanLog = classpathFinderLog == null ? null : classpathFinderLog.log("Searching for \"Class-Path:\" entries within manifest files");
            final RelativePathToElementMap classpathElementMap = new RelativePathToElementMap(this.enableRecursiveScanning, this.scanSpec, this.nestedJarHandler, this.interruptionChecker);
            WorkQueue.runWorkQueue(rawClasspathEltOrder, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<RelativePath>(){

                @Override
                public void processWorkUnit(RelativePath rawClasspathEltPath) throws Exception {
                    block17: {
                        if (classpathElementMap.get(rawClasspathEltPath) != null) {
                            if (preScanLog != null) {
                                preScanLog.log("Ignoring duplicate classpath element: " + rawClasspathEltPath);
                            }
                        } else if (rawClasspathEltPath.isValidClasspathElement(Scanner.this.scanSpec, preScanLog)) {
                            try {
                                boolean isDir;
                                boolean isModule = rawClasspathEltPath.getModuleRef() != null;
                                boolean isFile = !isModule && rawClasspathEltPath.isFile(preScanLog);
                                boolean bl = isDir = !isModule && rawClasspathEltPath.isDirectory(preScanLog);
                                if (isModule) {
                                    classpathElementMap.createSingleton(rawClasspathEltPath, preScanLog);
                                } else if (isFile && !((Scanner)Scanner.this).scanSpec.scanJars) {
                                    if (preScanLog != null) {
                                        preScanLog.log("Ignoring because jar scanning has been disabled: " + rawClasspathEltPath);
                                    }
                                } else if (isFile && !Scanner.this.scanSpec.jarIsWhitelisted(rawClasspathEltPath.getCanonicalPath(preScanLog))) {
                                    if (preScanLog != null) {
                                        preScanLog.log("Ignoring jarfile that is blacklisted or not whitelisted: " + rawClasspathEltPath);
                                    }
                                } else if (isDir && !((Scanner)Scanner.this).scanSpec.scanDirs) {
                                    if (preScanLog != null) {
                                        preScanLog.log("Ignoring because directory scanning has been disabled: " + rawClasspathEltPath);
                                    }
                                } else {
                                    classpathElementMap.createSingleton(rawClasspathEltPath, preScanLog);
                                }
                            }
                            catch (Exception e) {
                                if (preScanLog == null) break block17;
                                preScanLog.log("Classpath element " + rawClasspathEltPath + " is not valid (" + e + ") -- skipping");
                            }
                        }
                    }
                }
            }, new WorkQueue.WorkQueuePreStartHook<RelativePath>(){

                @Override
                public void processWorkQueueRef(WorkQueue<RelativePath> workQueue) {
                    classpathElementMap.setWorkQueue(workQueue);
                }
            }, this.interruptionChecker, preScanLog);
            List<ClasspathElement> list = Scanner.findClasspathOrder(rawClasspathEltOrder, classpathElementMap);
            if (classpathFinderLog != null) {
                LogNode logNode = classpathFinderLog.log("Final classpath element order:");
                for (int i = 0; i < list.size(); ++i) {
                    ClasspathElement classpathElt = list.get(i);
                    logNode.log(i + ": " + classpathElt);
                }
            }
            if (this.enableRecursiveScanning) {
                ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathEltResolvedPathToElement = new ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>>();
                for (int i = 0; i < list.size(); ++i) {
                    ClasspathElement classpathElement = list.get(i);
                    classpathEltResolvedPathToElement.add(new AbstractMap.SimpleEntry<String, ClasspathElement>(classpathElement.classpathEltPath.getResolvedPath(), classpathElement));
                }
                Collections.sort(classpathEltResolvedPathToElement, new Comparator<AbstractMap.SimpleEntry<String, ClasspathElement>>(){

                    @Override
                    public int compare(AbstractMap.SimpleEntry<String, ClasspathElement> o1, AbstractMap.SimpleEntry<String, ClasspathElement> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                LogNode nestedClasspathRootNode = null;
                block18: for (int i = 0; i < classpathEltResolvedPathToElement.size(); ++i) {
                    AbstractMap.SimpleEntry ei = (AbstractMap.SimpleEntry)classpathEltResolvedPathToElement.get(i);
                    String basePath = (String)ei.getKey();
                    int basePathLen = basePath.length();
                    for (int j = i + 1; j < classpathEltResolvedPathToElement.size(); ++j) {
                        String nestedClasspathRelativePath;
                        char nextChar;
                        AbstractMap.SimpleEntry ej = (AbstractMap.SimpleEntry)classpathEltResolvedPathToElement.get(j);
                        String comparePath = (String)ej.getKey();
                        int comparePathLen = comparePath.length();
                        boolean foundNestedClasspathRoot = false;
                        if (comparePath.startsWith(basePath) && comparePathLen > basePathLen && ((nextChar = comparePath.charAt(basePathLen)) == '/' || nextChar == '!') && (nestedClasspathRelativePath = comparePath.substring(basePathLen + 1)).indexOf(33) < 0) {
                            foundNestedClasspathRoot = true;
                            ClasspathElement baseElement = (ClasspathElement)ei.getValue();
                            if (baseElement.nestedClasspathRoots == null) {
                                baseElement.nestedClasspathRoots = new HashSet<String>();
                            }
                            baseElement.nestedClasspathRoots.add(nestedClasspathRelativePath + "/");
                            if (classpathFinderLog != null) {
                                if (nestedClasspathRootNode == null) {
                                    nestedClasspathRootNode = classpathFinderLog.log("Found nested classpath elements");
                                }
                                nestedClasspathRootNode.log(basePath + " is a prefix of the nested element " + comparePath);
                            }
                        }
                        if (!foundNestedClasspathRoot) continue block18;
                    }
                }
                final LogNode pathScanLog = classpathFinderLog == null ? null : classpathFinderLog.log("Scanning filenames within classpath elements");
                WorkQueue.runWorkQueue(list, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<ClasspathElement>(){

                    @Override
                    public void processWorkUnit(ClasspathElement classpathElement) throws Exception {
                        classpathElement.scanPaths(pathScanLog);
                    }
                }, this.interruptionChecker, pathScanLog);
                LogNode maskLog = this.log == null ? null : this.log.log("Masking classpath files");
                HashSet<String> classpathRelativePathsFound = new HashSet<String>();
                for (int classpathIdx = 0; classpathIdx < list.size(); ++classpathIdx) {
                    ClasspathElement classpathElement = list.get(classpathIdx);
                    classpathElement.maskFiles(classpathIdx, classpathRelativePathsFound, maskLog);
                }
                HashMap<File, Long> fileToLastModified = new HashMap<File, Long>();
                for (ClasspathElement classpathElement : list) {
                    fileToLastModified.putAll(classpathElement.fileToLastModified);
                }
                final ConcurrentLinkedQueue classInfoUnlinked = new ConcurrentLinkedQueue();
                final LogNode classfileScanLog = this.log == null ? null : this.log.log("Scanning classfile binary headers");
                try (final Recycler<ClassfileBinaryParser, RuntimeException> classfileBinaryParserRecycler = new Recycler<ClassfileBinaryParser, RuntimeException>(){

                    @Override
                    public ClassfileBinaryParser newInstance() {
                        return new ClassfileBinaryParser();
                    }
                };){
                    Iterator classfileParserChunks = Scanner.getClassfileParserChunks(list);
                    WorkQueue.runWorkQueue(classfileParserChunks, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<ClassfileParserChunk>(){

                        @Override
                        public void processWorkUnit(ClassfileParserChunk chunk) throws Exception {
                            ClassfileBinaryParser classfileBinaryParser = null;
                            try {
                                classfileBinaryParser = (ClassfileBinaryParser)classfileBinaryParserRecycler.acquire();
                                chunk.classpathElement.parseClassfiles(classfileBinaryParser, chunk.classfileStartIdx, chunk.classfileEndIdx, classInfoUnlinked, classfileScanLog);
                            }
                            finally {
                                classfileBinaryParserRecycler.release(classfileBinaryParser);
                                classfileBinaryParser = null;
                            }
                        }
                    }, this.interruptionChecker, classfileScanLog);
                }
                if (classfileScanLog != null) {
                    classfileScanLog.addElapsedTime();
                }
                LogNode classGraphLog = this.log == null ? null : this.log.log("Building class graph");
                HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
                for (ClassInfoUnlinked c : classInfoUnlinked) {
                    if (c.annotationParamDefaultValues == null) continue;
                    c.link(this.scanSpec, classNameToClassInfo, classGraphLog);
                }
                for (ClassInfoUnlinked c : classInfoUnlinked) {
                    if (c.annotationParamDefaultValues != null) continue;
                    c.link(this.scanSpec, classNameToClassInfo, classGraphLog);
                }
                ClassGraphBuilder classGraphBuilder = new ClassGraphBuilder(this.scanSpec, classNameToClassInfo);
                if (classGraphLog != null) {
                    classGraphLog.addElapsedTime();
                }
                scanResult = new ScanResult(this.scanSpec, list, classLoaderOrder, classGraphBuilder, fileToLastModified, this.nestedJarHandler, this.interruptionChecker, this.log);
                if (this.scanResultProcessor != null) {
                    this.scanResultProcessor.processScanResult(scanResult);
                }
            } else {
                scanResult = new ScanResult(this.scanSpec, list, classLoaderOrder, null, null, this.nestedJarHandler, this.interruptionChecker, this.log);
            }
            if (this.log != null) {
                this.log.log("Completed scan", System.nanoTime() - scanStart);
            }
            ScanResult scanResult2 = scanResult;
            return scanResult2;
        }
        catch (Throwable e) {
            if (this.nestedJarHandler != null) {
                this.nestedJarHandler.close(this.log);
            }
            if (this.log != null) {
                this.log.log(e);
            }
            if (this.failureHandler == null) {
                throw e;
            }
            this.failureHandler.onFailure(e);
            ScanResult scanResult = null;
            return scanResult;
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    private static class ClassfileParserChunk {
        private final ClasspathElement classpathElement;
        private final int classfileStartIdx;
        private final int classfileEndIdx;

        public ClassfileParserChunk(ClasspathElement classpathElementSingleton, int classfileStartIdx, int classfileEndIdx) {
            this.classpathElement = classpathElementSingleton;
            this.classfileStartIdx = classfileStartIdx;
            this.classfileEndIdx = classfileEndIdx;
        }
    }
}

