/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.utils.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ClassTypeSignature
extends HierarchicalTypeSignature {
    final List<TypeParameter> typeParameters;
    private final ClassRefTypeSignature superclassSignature;
    private final List<ClassRefTypeSignature> superinterfaceSignatures;

    public ClassTypeSignature(List<TypeParameter> typeParameters, ClassRefTypeSignature superclassSignature, List<ClassRefTypeSignature> superinterfaceSignatures) {
        this.typeParameters = typeParameters;
        this.superclassSignature = superclassSignature;
        this.superinterfaceSignatures = superinterfaceSignatures;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public ClassRefTypeSignature getSuperclassSignature() {
        return this.superclassSignature;
    }

    public List<ClassRefTypeSignature> getSuperinterfaceSignatures() {
        return this.superinterfaceSignatures;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        for (TypeParameter typeParameter : this.typeParameters) {
            typeParameter.getAllReferencedClassNames(classNameListOut);
        }
        if (this.superclassSignature != null) {
            this.superclassSignature.getAllReferencedClassNames(classNameListOut);
        }
        for (ClassRefTypeSignature typeSignature : this.superinterfaceSignatures) {
            typeSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeParameters.hashCode() + this.superclassSignature.hashCode() * 7 + this.superinterfaceSignatures.hashCode() * 15;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassTypeSignature)) {
            return false;
        }
        ClassTypeSignature o = (ClassTypeSignature)obj;
        return o.typeParameters.equals(this.typeParameters) && o.superclassSignature.equals(this.superclassSignature) && o.superinterfaceSignatures.equals(this.superinterfaceSignatures);
    }

    public String toString(int modifiers, boolean isAnnotation, boolean isInterface, String className) {
        String superSig;
        int i;
        StringBuilder buf = new StringBuilder();
        if (modifiers != 0) {
            TypeUtils.modifiersToString(modifiers, false, buf);
        }
        if (!this.typeParameters.isEmpty()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append('<');
            for (i = 0; i < this.typeParameters.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.typeParameters.get(i).toString());
            }
            buf.append('>');
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(isAnnotation ? "@interface" : (isInterface ? "interface" : ((modifiers & 0x4000) != 0 ? "enum" : "class")));
        if (className != null) {
            buf.append(' ');
            buf.append(className);
        }
        if (this.superclassSignature != null && !(superSig = this.superclassSignature.toString()).equals("java.lang.Object")) {
            buf.append(" extends ");
            buf.append(superSig);
        }
        if (!this.superinterfaceSignatures.isEmpty()) {
            buf.append(" implements");
            for (i = 0; i < this.superinterfaceSignatures.size(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(' ');
                buf.append(this.superinterfaceSignatures.get(i).toString());
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(0, false, false, null);
    }

    public static ClassTypeSignature parse(String typeDescriptor) throws Parser.ParseException {
        List<ClassRefTypeSignature> superinterfaceSignatures;
        Parser parser = new Parser(typeDescriptor);
        List<TypeParameter> typeParameters = TypeParameter.parseList(parser);
        ClassRefTypeSignature superclassSignature = ClassRefTypeSignature.parse(parser);
        if (parser.hasMore()) {
            superinterfaceSignatures = new ArrayList();
            while (parser.hasMore()) {
                ClassRefTypeSignature superinterfaceSignature = ClassRefTypeSignature.parse(parser);
                if (superinterfaceSignature == null) {
                    throw new Parser.ParseException(parser, "Could not parse superinterface signature");
                }
                superinterfaceSignatures.add(superinterfaceSignature);
            }
        } else {
            superinterfaceSignatures = Collections.emptyList();
        }
        if (parser.hasMore()) {
            throw new Parser.ParseException(parser, "Extra characters at end of type descriptor");
        }
        ClassTypeSignature classSignature = new ClassTypeSignature(typeParameters, superclassSignature, superinterfaceSignatures);
        List typeVariableSignatures = (List)parser.getState();
        if (typeVariableSignatures != null) {
            for (TypeVariableSignature typeVariableSignature : typeVariableSignatures) {
                typeVariableSignature.containingClassSignature = classSignature;
            }
        }
        return classSignature;
    }
}

