/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.MatchProcessorException;
import io.github.lukehutch.fastclasspathscanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FieldAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FilenameMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderAndModuleFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.FailureHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResultProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.scanner.Scanner;
import io.github.lukehutch.fastclasspathscanner.utils.AutoCloseableExecutorService;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.VersionFinder;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class FastClasspathScanner {
    private final String[] scanSpecArgs;
    private ScanSpec scanSpec;
    private List<File> classpathElts;
    private List<URL> classpathEltURLs;
    private static String version;
    private static final int DEFAULT_NUM_WORKER_THREADS = 6;
    private LogNode log;

    public FastClasspathScanner(String ... scanSpec) {
        this.scanSpecArgs = scanSpec;
    }

    public static final String getVersion() {
        if (version == null) {
            version = VersionFinder.getVersion();
        }
        return version;
    }

    private synchronized ScanSpec getScanSpec() {
        if (this.scanSpec == null) {
            this.scanSpec = new ScanSpec(this.scanSpecArgs, this.log == null ? null : this.log.log("Parsing scan spec"));
        }
        return this.scanSpec;
    }

    public FastClasspathScanner verbose(boolean verbose) {
        if (verbose) {
            if (this.log == null) {
                this.log = new LogNode();
            }
        } else {
            this.log = null;
        }
        return this;
    }

    public FastClasspathScanner verbose() {
        this.verbose(true);
        return this;
    }

    public FastClasspathScanner ignoreFieldVisibility(boolean ignoreFieldVisibility) {
        this.getScanSpec().ignoreFieldVisibility = ignoreFieldVisibility;
        return this;
    }

    public FastClasspathScanner ignoreFieldVisibility() {
        this.ignoreFieldVisibility(true);
        return this;
    }

    public FastClasspathScanner ignoreMethodVisibility(boolean ignoreMethodVisibility) {
        this.getScanSpec().ignoreMethodVisibility = ignoreMethodVisibility;
        return this;
    }

    public FastClasspathScanner ignoreMethodVisibility() {
        this.ignoreMethodVisibility(true);
        return this;
    }

    public FastClasspathScanner enableMethodAnnotationIndexing(boolean enableMethodAnnotationIndexing) {
        this.getScanSpec().enableMethodAnnotationIndexing = enableMethodAnnotationIndexing;
        return this;
    }

    public FastClasspathScanner enableMethodAnnotationIndexing() {
        this.enableMethodAnnotationIndexing(true);
        return this;
    }

    public FastClasspathScanner enableFieldAnnotationIndexing(boolean enableFieldAnnotationIndexing) {
        this.getScanSpec().enableFieldAnnotationIndexing = enableFieldAnnotationIndexing;
        return this;
    }

    public FastClasspathScanner enableFieldAnnotationIndexing() {
        this.enableFieldAnnotationIndexing(true);
        return this;
    }

    public FastClasspathScanner enableFieldInfo(boolean enableFieldInfo) {
        this.getScanSpec().enableFieldInfo = enableFieldInfo;
        return this;
    }

    public FastClasspathScanner enableFieldInfo() {
        return this.enableFieldInfo(true);
    }

    public FastClasspathScanner enableMethodInfo(boolean enableMethodInfo) {
        this.getScanSpec().enableMethodInfo = enableMethodInfo;
        return this;
    }

    public FastClasspathScanner enableMethodInfo() {
        return this.enableMethodInfo(true);
    }

    public FastClasspathScanner alwaysScanClasspathElementRoot(boolean alwaysScanClasspathElementRoot) {
        if (alwaysScanClasspathElementRoot) {
            this.getScanSpec().whitelistedPathsNonRecursive.add("");
            this.getScanSpec().whitelistedPathsNonRecursive.add("/");
        } else {
            this.getScanSpec().whitelistedPathsNonRecursive.remove("");
            this.getScanSpec().whitelistedPathsNonRecursive.remove("/");
        }
        return this;
    }

    public FastClasspathScanner alwaysScanClasspathElementRoot() {
        return this.alwaysScanClasspathElementRoot(true);
    }

    @Deprecated
    public FastClasspathScanner strictWhitelist(boolean strictWhitelist) {
        return this;
    }

    @Deprecated
    public FastClasspathScanner strictWhitelist() {
        return this;
    }

    public FastClasspathScanner enableExternalClasses(boolean enableExternalClasses) {
        this.getScanSpec().enableExternalClasses = enableExternalClasses;
        return this;
    }

    public FastClasspathScanner enableExternalClasses() {
        this.enableExternalClasses(true);
        return this;
    }

    public FastClasspathScanner initializeLoadedClasses(boolean initializeLoadedClasses) {
        this.getScanSpec().initializeLoadedClasses = initializeLoadedClasses;
        return this;
    }

    public FastClasspathScanner removeTemporaryFilesAfterScan(boolean removeTemporaryFilesAfterScan) {
        this.getScanSpec().removeTemporaryFilesAfterScan = removeTemporaryFilesAfterScan;
        return this;
    }

    public FastClasspathScanner disableRecursiveScanning() {
        return this.disableRecursiveScanning(true);
    }

    public FastClasspathScanner disableRecursiveScanning(boolean disableRecursiveScanning) {
        this.getScanSpec().disableRecursiveScanning = disableRecursiveScanning;
        return this;
    }

    public FastClasspathScanner stripZipSFXHeaders() {
        this.getScanSpec().stripSFXHeader = true;
        return this;
    }

    public FastClasspathScanner registerClassLoaderHandler(Class<? extends ClassLoaderHandler> classLoaderHandlerClass) {
        this.getScanSpec().registerClassLoaderHandler(classLoaderHandlerClass);
        return this;
    }

    public FastClasspathScanner overrideClasspath(String overrideClasspath) {
        this.getScanSpec().overrideClasspath(overrideClasspath);
        return this;
    }

    public FastClasspathScanner overrideClasspath(Iterable<?> overrideClasspathElements) {
        String overrideClasspath = JarUtils.pathElementsToPathStr(overrideClasspathElements);
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public FastClasspathScanner overrideClasspath(Object ... overrideClasspathElements) {
        String overrideClasspath = JarUtils.pathElementsToPathStr(overrideClasspathElements);
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public FastClasspathScanner filterClasspathElements(ClasspathElementFilter classpathElementFilter) {
        this.getScanSpec().filterClasspathElements(classpathElementFilter);
        return this;
    }

    public FastClasspathScanner addClassLoader(ClassLoader classLoader) {
        this.getScanSpec().addClassLoader(classLoader);
        return this;
    }

    public FastClasspathScanner overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.getScanSpec().overrideClassLoaders(overrideClassLoaders);
        return this;
    }

    public FastClasspathScanner ignoreParentClassLoaders(boolean ignoreParentClassLoaders) {
        this.getScanSpec().ignoreParentClassLoaders = ignoreParentClassLoaders;
        return this;
    }

    public FastClasspathScanner ignoreParentClassLoaders() {
        this.getScanSpec().ignoreParentClassLoaders = true;
        return this;
    }

    public FastClasspathScanner suppressMatchProcessorExceptions() {
        this.suppressMatchProcessorExceptions(true);
        return this;
    }

    public FastClasspathScanner suppressMatchProcessorExceptions(boolean suppressMatchProcessorExceptions) {
        this.getScanSpec().suppressMatchProcessorExceptions = suppressMatchProcessorExceptions;
        return this;
    }

    public ClassLoader[] findBestClassLoader() {
        return new ClassLoaderAndModuleFinder(this.getScanSpec(), this.log).getClassLoaders();
    }

    public FastClasspathScanner matchAllClasses(ClassMatchProcessor classMatchProcessor) {
        this.getScanSpec().matchAllClasses(classMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchAllStandardClasses(ClassMatchProcessor standardClassMatchProcessor) {
        this.getScanSpec().matchAllStandardClasses(standardClassMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchAllInterfaceClasses(ClassMatchProcessor interfaceClassMatchProcessor) {
        this.getScanSpec().matchAllInterfaceClasses(interfaceClassMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchAllAnnotationClasses(ClassMatchProcessor annotationClassMatchProcessor) {
        this.getScanSpec().matchAllAnnotationClasses(annotationClassMatchProcessor);
        return this;
    }

    public <T> FastClasspathScanner matchSubclassesOf(Class<T> superclass, SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.getScanSpec().matchSubclassesOf(superclass, subclassMatchProcessor);
        return this;
    }

    public <T> FastClasspathScanner matchSubinterfacesOf(Class<T> superinterface, SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.getScanSpec().matchSubinterfacesOf(superinterface, subinterfaceMatchProcessor);
        return this;
    }

    public <T> FastClasspathScanner matchClassesImplementing(Class<T> implementedInterface, ImplementingClassMatchProcessor<T> interfaceMatchProcessor) {
        this.getScanSpec().matchClassesImplementing(implementedInterface, interfaceMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchClassesWithAnnotation(Class<?> annotation, ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.getScanSpec().matchClassesWithAnnotation(annotation, classAnnotationMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchClassesWithMethodAnnotation(Class<? extends Annotation> annotation, MethodAnnotationMatchProcessor methodAnnotationMatchProcessor) {
        this.enableMethodAnnotationIndexing();
        this.getScanSpec().matchClassesWithMethodAnnotation(annotation, methodAnnotationMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchClassesWithFieldAnnotation(Class<? extends Annotation> annotation, FieldAnnotationMatchProcessor fieldAnnotationMatchProcessor) {
        this.enableFieldAnnotationIndexing();
        this.getScanSpec().matchClassesWithFieldAnnotation(annotation, fieldAnnotationMatchProcessor);
        return this;
    }

    public FastClasspathScanner setAnnotationVisibility(RetentionPolicy annotationVisibility) {
        if (annotationVisibility == RetentionPolicy.SOURCE) {
            throw new IllegalArgumentException("RetentionPolicy.SOURCE annotations are not retained in classfiles");
        }
        this.getScanSpec().annotationVisibility = annotationVisibility;
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldName, staticFinalFieldMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FilenameMatchProcessor filenameMatchProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, filenameMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FilenameMatchProcessor filenameMatchProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, filenameMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FilenameMatchProcessor filenameMatchProcessor) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, filenameMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FilenameMatchProcessor filenameMatchProcessor) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, filenameMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    private Future<ScanResult> launchAsyncScan(ExecutorService executorService, int numParallelTasks, boolean isAsyncScan, ScanResultProcessor scanResultProcessor, FailureHandler failureHandler) {
        ScanSpec scanSpec = this.getScanSpec();
        if (isAsyncScan && scanSpec.hasMatchProcessors()) {
            try {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    StackTraceElement[] elts;
                    for (StackTraceElement elt : elts = e.getStackTrace()) {
                        if (!"<clinit>".equals(elt.getMethodName())) continue;
                        throw new RuntimeException("Cannot use MatchProcessors while launching a scan from a class initialization block (for class " + elt.getClassName() + "), as this can lead to a class initializer deadlock. See: https://github.com/lukehutch/fast-classpath-scanner/issues/103");
                    }
                }
            }
            catch (RuntimeException e) {
                if (failureHandler == null) {
                    throw e;
                }
                if (this.log != null) {
                    this.log.log(e);
                    this.log.flush();
                }
                failureHandler.onFailure(e);
                return executorService.submit(new Callable<ScanResult>(){

                    @Override
                    public ScanResult call() throws Exception {
                        return null;
                    }
                });
            }
        }
        return executorService.submit(new Scanner(scanSpec, executorService, numParallelTasks, true, scanResultProcessor, failureHandler, this.log));
    }

    public void scanAsync(ExecutorService executorService, int numParallelTasks, final ScanResultProcessor scanResultProcessor, FailureHandler failureHandler) {
        if (scanResultProcessor == null) {
            throw new IllegalArgumentException("scanResultProcessor cannot be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("failureHandler cannot be null");
        }
        this.launchAsyncScan(executorService, numParallelTasks, true, new ScanResultProcessor(){

            @Override
            public void processScanResult(ScanResult scanResult) {
                FastClasspathScanner.this.getScanSpec().callMatchProcessors(scanResult);
                scanResultProcessor.processScanResult(scanResult);
                if (((FastClasspathScanner)FastClasspathScanner.this).scanSpec.removeTemporaryFilesAfterScan) {
                    scanResult.freeTempFiles(FastClasspathScanner.this.log);
                }
            }
        }, failureHandler);
    }

    private Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks, boolean isAsyncScan, boolean runMatchProcessorsOnWorkerThread) {
        return this.launchAsyncScan(executorService, numParallelTasks, isAsyncScan, runMatchProcessorsOnWorkerThread ? new ScanResultProcessor(){

            @Override
            public void processScanResult(ScanResult scanResult) {
                FastClasspathScanner.this.getScanSpec().callMatchProcessors(scanResult);
                if (((FastClasspathScanner)FastClasspathScanner.this).scanSpec.removeTemporaryFilesAfterScan) {
                    scanResult.freeTempFiles(FastClasspathScanner.this.log);
                }
            }
        } : null, null);
    }

    public Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks) {
        return this.scanAsync(executorService, numParallelTasks, true, true);
    }

    public ScanResult scan(ExecutorService executorService, int numParallelTasks) {
        try {
            ScanResult scanResult = this.scanAsync(executorService, numParallelTasks, false, false).get();
            this.getScanSpec().callMatchProcessors(scanResult);
            if (this.scanSpec.removeTemporaryFilesAfterScan) {
                scanResult.freeTempFiles(this.log);
            }
            ScanResult scanResult2 = scanResult;
            return scanResult2;
        }
        catch (InterruptedException e) {
            if (this.log != null) {
                this.log.log("Scan interrupted");
            }
            throw new ScanInterruptedException();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof InterruptedException) {
                if (this.log != null) {
                    this.log.log("Scan interrupted");
                }
                throw new ScanInterruptedException();
            }
            if (cause instanceof MatchProcessorException) {
                if (this.log != null) {
                    this.log.log("Exception during scan", e);
                }
                throw (MatchProcessorException)cause;
            }
            if (this.log != null) {
                this.log.log("Unexpected exception during scan", e);
            }
            throw new RuntimeException(cause);
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public ScanResult scan(int numThreads) {
        try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(numThreads);){
            ScanResult scanResult = this.scan(executorService, numThreads);
            return scanResult;
        }
    }

    public ScanResult scan() {
        return this.scan(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<File>> getUniqueClasspathElementsAsync(ExecutorService executorService, int numParallelTasks) {
        Future<List<File>> classpathElementsFuture;
        try {
            final Future<ScanResult> scanResultFuture = executorService.submit(new Scanner(this.getScanSpec(), executorService, numParallelTasks, false, null, null, this.log == null ? null : this.log.log("Getting unique classpath elements")));
            classpathElementsFuture = executorService.submit(new Callable<List<File>>(){

                @Override
                public List<File> call() throws Exception {
                    ScanResult scanResult = (ScanResult)scanResultFuture.get();
                    List<File> uniqueClasspathElements = scanResult.getUniqueClasspathElements();
                    return uniqueClasspathElements;
                }
            });
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
        return classpathElementsFuture;
    }

    public List<File> getUniqueClasspathElements(ExecutorService executorService, int numParallelTasks) {
        if (this.classpathElts == null) {
            try {
                this.classpathElts = this.getUniqueClasspathElementsAsync(executorService, numParallelTasks).get();
            }
            catch (InterruptedException e) {
                if (this.log != null) {
                    this.log.log("Thread interrupted while getting classpath elements");
                }
                throw new ScanInterruptedException();
            }
            catch (ExecutionException e) {
                Throwable cause;
                if (this.log != null) {
                    this.log.log("Exception while getting classpath elements", e);
                }
                throw new RuntimeException((cause = e.getCause()) == null ? e : cause);
            }
            finally {
                if (this.log != null) {
                    this.log.flush();
                }
            }
        }
        return this.classpathElts;
    }

    public List<File> getUniqueClasspathElements() {
        if (this.classpathElts == null) {
            try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(6);){
                List<File> list = this.getUniqueClasspathElements(executorService, 6);
                return list;
            }
        }
        return this.classpathElts;
    }

    public String getUniqueClasspathElementsAsPathStr() {
        return JarUtils.pathElementsToPathStr(this.getUniqueClasspathElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<List<URL>> getUniqueClasspathElementURLsAsync(ExecutorService executorService, int numParallelTasks) {
        Future<List<URL>> classpathElementsFuture;
        try {
            final Future<ScanResult> scanResultFuture = executorService.submit(new Scanner(this.getScanSpec(), executorService, numParallelTasks, false, null, null, this.log == null ? null : this.log.log("Getting unique classpath elements")));
            classpathElementsFuture = executorService.submit(new Callable<List<URL>>(){

                @Override
                public List<URL> call() throws Exception {
                    ScanResult scanResult = (ScanResult)scanResultFuture.get();
                    List<URL> uniqueClasspathElementURLs = scanResult.getUniqueClasspathElementURLs();
                    return uniqueClasspathElementURLs;
                }
            });
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
        return classpathElementsFuture;
    }

    public List<URL> getUniqueClasspathElementURLs(ExecutorService executorService, int numParallelTasks) {
        if (this.classpathEltURLs == null) {
            try {
                this.classpathEltURLs = this.getUniqueClasspathElementURLsAsync(executorService, numParallelTasks).get();
            }
            catch (InterruptedException e) {
                if (this.log != null) {
                    this.log.log("Thread interrupted while getting classpath elements");
                }
                throw new ScanInterruptedException();
            }
            catch (ExecutionException e) {
                Throwable cause;
                if (this.log != null) {
                    this.log.log("Exception while getting classpath elements", e);
                }
                throw new RuntimeException((cause = e.getCause()) == null ? e : cause);
            }
            finally {
                if (this.log != null) {
                    this.log.flush();
                }
            }
        }
        return this.classpathEltURLs;
    }

    public List<URL> getUniqueClasspathElementURLs() {
        if (this.classpathEltURLs == null) {
            try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(6);){
                List<URL> list = this.getUniqueClasspathElementURLs(executorService, 6);
                return list;
            }
        }
        return this.classpathEltURLs;
    }

    @FunctionalInterface
    public static interface ClasspathElementFilter {
        public boolean includeClasspathElement(String var1);
    }
}

