/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.AnnotationInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.MethodParameterInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.typesignature.ArrayTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefOrTypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.MethodTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.utils.Parser;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MethodInfo
extends ScanResult.InfoObject
implements Comparable<MethodInfo> {
    transient String className;
    transient ClassInfo classInfo;
    String methodName;
    int modifiers;
    List<AnnotationInfo> annotationInfo;
    String typeDescriptorStr;
    transient MethodTypeSignature typeDescriptor;
    String typeSignatureStr;
    transient MethodTypeSignature typeSignature;
    String[] parameterNames;
    int[] parameterModifiers;
    AnnotationInfo[][] parameterAnnotationInfo;
    transient MethodParameterInfo[] methodParameterInfo;
    transient ScanResult scanResult;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final TypeParameter[] EMPTY_TYPE_PARAMETER_ARRAY = new TypeParameter[0];
    private static final ClassRefOrTypeVariableSignature[] EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY = new ClassRefOrTypeVariableSignature[0];
    private static final Class<?>[] EMPTY_CLASS_REF_ARRAY = new Class[0];
    private static final AnnotationInfo[] EMPTY_ANNOTATION_INFO_ARRAY = new AnnotationInfo[0];

    MethodInfo() {
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        int i;
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (i = 0; i < this.annotationInfo.size(); ++i) {
                AnnotationInfo ai = this.annotationInfo.get(i);
                ai.setScanResult(scanResult);
            }
        }
        if (this.parameterAnnotationInfo != null) {
            for (i = 0; i < this.parameterAnnotationInfo.length; ++i) {
                AnnotationInfo[] pai = this.parameterAnnotationInfo[i];
                if (pai == null) continue;
                for (AnnotationInfo ai : pai) {
                    ai.setScanResult(scanResult);
                }
            }
        }
    }

    public MethodInfo(String className, String methodName, List<AnnotationInfo> methodAnnotationInfo, int modifiers, String typeDescriptorStr, String typeSignatureStr, String[] parameterNames, int[] parameterModifiers, AnnotationInfo[][] parameterAnnotationInfo) {
        this.className = className;
        this.methodName = methodName;
        this.modifiers = modifiers;
        this.typeDescriptorStr = typeDescriptorStr;
        this.typeSignatureStr = typeSignatureStr;
        this.parameterNames = parameterNames;
        this.parameterModifiers = parameterModifiers;
        this.parameterAnnotationInfo = parameterAnnotationInfo;
        this.annotationInfo = methodAnnotationInfo == null || methodAnnotationInfo.isEmpty() ? null : methodAnnotationInfo;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersStr() {
        return TypeUtils.modifiersToString(this.getModifiers(), true);
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getTypeDescriptorStr() {
        return this.typeDescriptorStr;
    }

    public String getTypeSignatureStr() {
        return this.typeSignatureStr;
    }

    public MethodTypeSignature getTypeDescriptor() {
        if (this.typeDescriptor == null) {
            try {
                this.typeDescriptor = MethodTypeSignature.parse(this.classInfo, this.typeDescriptorStr);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeDescriptor;
    }

    public MethodTypeSignature getTypeSignature() {
        if (this.typeSignature == null && this.typeSignatureStr != null) {
            try {
                this.typeSignature = MethodTypeSignature.parse(this.classInfo, this.typeSignatureStr);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeSignature;
    }

    public MethodTypeSignature getTypeSignatureOrTypeDescriptor() {
        MethodTypeSignature typeSig = this.getTypeSignature();
        if (typeSig != null) {
            return typeSig;
        }
        return this.getTypeDescriptor();
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    private static String[] toStringArray(List<?> list) {
        if (list.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).toString();
        }
        return stringArray;
    }

    private static Class<?>[] toClassRefs(List<? extends TypeSignature> typeDescriptors, ScanResult scanResult) {
        if (typeDescriptors.size() == 0) {
            return EMPTY_CLASS_REF_ARRAY;
        }
        Class[] classRefArray = new Class[typeDescriptors.size()];
        for (int i = 0; i < typeDescriptors.size(); ++i) {
            classRefArray[i] = typeDescriptors.get(i).instantiate(scanResult);
        }
        return classRefArray;
    }

    private static Class<?>[] toClassRefs(TypeSignature[] typeDescriptors, ScanResult scanResult) {
        if (typeDescriptors.length == 0) {
            return EMPTY_CLASS_REF_ARRAY;
        }
        Class[] classRefArray = new Class[typeDescriptors.length];
        for (int i = 0; i < typeDescriptors.length; ++i) {
            classRefArray[i] = typeDescriptors[i].instantiate(scanResult);
        }
        return classRefArray;
    }

    private static ClassRefOrTypeVariableSignature[] toTypeOrTypeVariableSignatureArray(List<? extends ClassRefOrTypeVariableSignature> typeSignatures) {
        if (typeSignatures.size() == 0) {
            return EMPTY_CLASS_TYPE_OR_TYPE_VARIABLE_SIGNATURE_ARRAY;
        }
        return typeSignatures.toArray(new ClassRefOrTypeVariableSignature[typeSignatures.size()]);
    }

    private static TypeParameter[] toTypeParameterArray(List<? extends TypeParameter> typeParameters) {
        if (typeParameters.size() == 0) {
            return EMPTY_TYPE_PARAMETER_ARRAY;
        }
        return typeParameters.toArray(new TypeParameter[typeParameters.size()]);
    }

    public MethodParameterInfo[] getParameterInfo() {
        if (this.methodParameterInfo == null) {
            int i;
            List<TypeSignature> paramTypeDescriptors = this.getTypeDescriptor().getParameterTypeSignatures();
            List<TypeSignature> paramTypeSignatures = this.getTypeSignature() != null ? this.getTypeSignature().getParameterTypeSignatures() : null;
            int numParams = paramTypeDescriptors.size();
            if (paramTypeSignatures != null && paramTypeSignatures.size() > paramTypeDescriptors.size()) {
                throw new RuntimeException("typeSignatureParamTypes.size() > typeDescriptorParamTypes.size() for method " + this.className + "." + this.methodName);
            }
            int otherParamMax = Math.max(this.parameterNames == null ? 0 : this.parameterNames.length, Math.max(this.parameterModifiers == null ? 0 : this.parameterModifiers.length, this.parameterAnnotationInfo == null ? 0 : this.parameterAnnotationInfo.length));
            if (otherParamMax > numParams) {
                throw new RuntimeException("Type descriptor for method " + this.className + "." + this.methodName + " has insufficient parameters");
            }
            String[] paramNamesAligned = null;
            if (this.parameterNames != null && numParams > 0) {
                if (this.parameterNames.length == numParams) {
                    paramNamesAligned = this.parameterNames;
                } else {
                    paramNamesAligned = new String[numParams];
                    int lenDiff = numParams - this.parameterNames.length;
                    for (int i2 = 0; i2 < this.parameterNames.length; ++i2) {
                        paramNamesAligned[lenDiff + i2] = this.parameterNames[i2];
                    }
                }
            }
            int[] paramModifiersAligned = null;
            if (this.parameterModifiers != null && numParams > 0) {
                if (this.parameterModifiers.length == numParams) {
                    paramModifiersAligned = this.parameterModifiers;
                } else {
                    paramModifiersAligned = new int[numParams];
                    int lenDiff = numParams - this.parameterModifiers.length;
                    for (int i3 = 0; i3 < this.parameterModifiers.length; ++i3) {
                        paramModifiersAligned[lenDiff + i3] = this.parameterModifiers[i3];
                    }
                }
            }
            AnnotationInfo[][] paramAnnotationInfoAligned = null;
            if (this.parameterAnnotationInfo != null && numParams > 0) {
                if (this.parameterAnnotationInfo.length == numParams) {
                    paramAnnotationInfoAligned = this.parameterAnnotationInfo;
                } else {
                    paramAnnotationInfoAligned = new AnnotationInfo[numParams][];
                    int lenDiff = numParams - this.parameterAnnotationInfo.length;
                    for (int i4 = 0; i4 < this.parameterAnnotationInfo.length; ++i4) {
                        paramAnnotationInfoAligned[lenDiff + i4] = this.parameterAnnotationInfo[i4];
                    }
                }
            }
            List<TypeSignature> paramTypeSignaturesAligned = null;
            if (paramTypeSignatures != null && numParams > 0) {
                if (paramTypeSignatures.size() == paramTypeDescriptors.size()) {
                    paramTypeSignaturesAligned = paramTypeSignatures;
                } else {
                    paramTypeSignaturesAligned = new ArrayList<TypeSignature>(numParams);
                    int n = numParams - paramTypeSignatures.size();
                    for (i = 0; i < n; ++i) {
                        paramTypeSignaturesAligned.add(null);
                    }
                    paramTypeSignaturesAligned.addAll(paramTypeSignatures);
                }
            }
            this.methodParameterInfo = new MethodParameterInfo[numParams];
            for (i = 0; i < numParams; ++i) {
                this.methodParameterInfo[i] = new MethodParameterInfo(paramAnnotationInfoAligned == null ? null : paramAnnotationInfoAligned[i], paramModifiersAligned == null ? 0 : paramModifiersAligned[i], paramTypeDescriptors.get(i), paramTypeSignaturesAligned == null ? null : paramTypeSignaturesAligned.get(i), paramNamesAligned == null ? null : paramNamesAligned[i]);
            }
        }
        return this.methodParameterInfo;
    }

    public int getNumParameters() {
        return this.getParameterInfo().length;
    }

    public Class<?>[] getParameterTypes() throws IllegalArgumentException {
        MethodParameterInfo[] parameterInfo = this.getParameterInfo();
        TypeSignature[] paramTypeDescriptors = new TypeSignature[parameterInfo.length];
        for (int i = 0; i < parameterInfo.length; ++i) {
            TypeSignature typeDesc;
            MethodParameterInfo paramInfo = parameterInfo[i];
            paramTypeDescriptors[i] = typeDesc = paramInfo.getTypeDescriptor();
        }
        return MethodInfo.toClassRefs(paramTypeDescriptors, this.scanResult);
    }

    public TypeSignature[] getParameterTypeSignatures() {
        MethodParameterInfo[] parameterInfo = this.getParameterInfo();
        TypeSignature[] paramTypeSignaturesOrTypeDescriptors = new TypeSignature[parameterInfo.length];
        for (int i = 0; i < parameterInfo.length; ++i) {
            MethodParameterInfo paramInfo = parameterInfo[i];
            TypeSignature typeSig = paramInfo.getTypeSignature();
            paramTypeSignaturesOrTypeDescriptors[i] = typeSig == null ? paramInfo.getTypeDescriptor() : typeSig;
        }
        return paramTypeSignaturesOrTypeDescriptors;
    }

    public String[] getParameterNames() {
        MethodParameterInfo[] parameterInfo = this.getParameterInfo();
        boolean hasNames = false;
        for (int i = 0; i < parameterInfo.length; ++i) {
            if (parameterInfo[i].getName() == null) continue;
            hasNames = true;
            break;
        }
        if (!hasNames) {
            return null;
        }
        String[] paramNames = new String[parameterInfo.length];
        for (int i = 0; i < parameterInfo.length; ++i) {
            paramNames[i] = parameterInfo[i].getName();
        }
        return paramNames;
    }

    public int[] getParameterModifiers() {
        MethodParameterInfo[] parameterInfo = this.getParameterInfo();
        boolean hasNames = false;
        for (int i = 0; i < parameterInfo.length; ++i) {
            if (parameterInfo[i].getName() == null) continue;
            hasNames = true;
            break;
        }
        if (!hasNames) {
            return null;
        }
        int[] paramMods = new int[parameterInfo.length];
        for (int i = 0; i < parameterInfo.length; ++i) {
            paramMods[i] = parameterInfo[i].getModifiers();
        }
        return paramMods;
    }

    public String[] getParameterModifierStrs() {
        int[] paramModifiers = this.getParameterModifiers();
        if (paramModifiers == null) {
            return null;
        }
        String[] paramModifierStrs = new String[paramModifiers.length];
        for (int i = 0; i < paramModifiers.length; ++i) {
            paramModifierStrs[i] = TypeUtils.modifiersToString(paramModifiers[i], false);
        }
        return paramModifierStrs;
    }

    public AnnotationInfo[][] getParameterAnnotationInfo() {
        MethodParameterInfo[] parameterInfo = this.getParameterInfo();
        boolean hasAnnotations = false;
        for (int i = 0; i < parameterInfo.length; ++i) {
            AnnotationInfo[] annInfo = parameterInfo[i].getAnnotationInfo();
            if (annInfo == null || annInfo.length <= 0) continue;
            hasAnnotations = true;
            break;
        }
        if (!hasAnnotations) {
            return null;
        }
        AnnotationInfo[][] annotationInfo = new AnnotationInfo[parameterInfo.length][];
        for (int i = 0; i < parameterInfo.length; ++i) {
            annotationInfo[i] = parameterInfo[i].getAnnotationInfo();
            if (annotationInfo[i] != null) continue;
            annotationInfo[i] = EMPTY_ANNOTATION_INFO_ARRAY;
        }
        return annotationInfo;
    }

    public String[][] getParameterAnnotationNames() {
        AnnotationInfo[][] paramAnnotationInfo = this.getParameterAnnotationInfo();
        if (paramAnnotationInfo == null) {
            return null;
        }
        String[][] paramAnnotationNames = new String[paramAnnotationInfo.length][];
        for (int i = 0; i < paramAnnotationInfo.length; ++i) {
            paramAnnotationNames[i] = AnnotationInfo.getUniqueAnnotationNamesSorted(paramAnnotationInfo[i]);
        }
        return paramAnnotationNames;
    }

    public Class<?>[][] getParameterAnnotationTypes() {
        String[][] paramAnnotationNames = this.getParameterAnnotationNames();
        if (paramAnnotationNames == null) {
            return null;
        }
        Class[][] parameterAnnotationTypes = new Class[paramAnnotationNames.length][];
        for (int i = 0; i < paramAnnotationNames.length; ++i) {
            parameterAnnotationTypes[i] = new Class[paramAnnotationNames[i].length];
            for (int j = 0; j < paramAnnotationNames[i].length; ++j) {
                parameterAnnotationTypes[i][j] = this.scanResult.classNameToClassRef(paramAnnotationNames[i][j]);
            }
        }
        return parameterAnnotationTypes;
    }

    public TypeSignature getResultTypeSignature() {
        MethodTypeSignature ts = this.getTypeSignature();
        if (ts == null) {
            return null;
        }
        return ts.getResultType();
    }

    public TypeSignature getResultTypeDescriptor() {
        return this.getTypeDescriptor().getResultType();
    }

    public Class<?> getResultType() throws IllegalArgumentException {
        return this.getResultTypeDescriptor().instantiate(this.scanResult);
    }

    public ClassRefOrTypeVariableSignature[] getThrowsTypeSignatures() {
        return MethodInfo.toTypeOrTypeVariableSignatureArray(this.getTypeSignature().getThrowsSignatures());
    }

    public Class<?>[] getThrowsTypes() {
        return MethodInfo.toClassRefs(this.getTypeSignature().getThrowsSignatures(), this.scanResult);
    }

    public String[] getThrowsTypeStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getThrowsSignatures());
    }

    public TypeParameter[] getTypeParameters() {
        return MethodInfo.toTypeParameterArray(this.getTypeSignature().getTypeParameters());
    }

    public String[] getTypeParameterStrs() {
        return MethodInfo.toStringArray(this.getTypeSignature().getTypeParameters());
    }

    public List<String> getAnnotationNames() {
        return this.annotationInfo == null ? Collections.emptyList() : Arrays.asList(AnnotationInfo.getUniqueAnnotationNamesSorted(this.annotationInfo));
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationInfo == null || this.annotationInfo.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.getAnnotationNames()) {
            annotationClassRefs.add(this.scanResult.classNameToClassRef(annotationName));
        }
        return annotationClassRefs;
    }

    public List<AnnotationInfo> getAnnotationInfo() {
        return this.annotationInfo == null ? Collections.emptyList() : this.annotationInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.className.equals(other.className) && this.typeDescriptorStr.equals(other.typeDescriptorStr) && this.methodName.equals(other.methodName);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.typeDescriptorStr.hashCode() * 11 + this.className.hashCode() * 57;
    }

    @Override
    public int compareTo(MethodInfo other) {
        int diff0 = this.className.compareTo(other.className);
        if (diff0 != 0) {
            return diff0;
        }
        int diff1 = this.methodName.compareTo(other.methodName);
        if (diff1 != 0) {
            return diff1;
        }
        return this.typeDescriptorStr.compareTo(other.typeDescriptorStr);
    }

    public String toString() {
        int i;
        List<TypeParameter> typeParameters;
        MethodTypeSignature methodType = this.getTypeSignatureOrTypeDescriptor();
        StringBuilder buf = new StringBuilder();
        if (this.annotationInfo != null) {
            for (AnnotationInfo annotation : this.annotationInfo) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                annotation.toString(buf);
            }
        }
        if (this.modifiers != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            TypeUtils.modifiersToString(this.modifiers, true, buf);
        }
        if (!(typeParameters = methodType.getTypeParameters()).isEmpty()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append('<');
            for (int i2 = 0; i2 < typeParameters.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                String typeParamStr = typeParameters.get(i2).toString();
                buf.append(typeParamStr);
            }
            buf.append('>');
        }
        if (!this.isConstructor()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(methodType.getResultType().toString());
        }
        buf.append(' ');
        if (this.methodName != null) {
            buf.append(this.methodName);
        }
        MethodParameterInfo[] allParamInfo = this.getParameterInfo();
        boolean hasParamNames = false;
        int numParams = allParamInfo.length;
        for (i = 0; i < numParams; ++i) {
            if (allParamInfo[i].getName() == null) continue;
            hasParamNames = true;
            break;
        }
        buf.append('(');
        numParams = allParamInfo.length;
        for (i = 0; i < numParams; ++i) {
            String paramName;
            int flag;
            AnnotationInfo[] annInfo;
            MethodParameterInfo paramInfo = allParamInfo[i];
            if (i > 0) {
                buf.append(", ");
            }
            if ((annInfo = paramInfo.getAnnotationInfo()) != null) {
                for (int j = 0; j < annInfo.length; ++j) {
                    annInfo[j].toString(buf);
                    buf.append(' ');
                }
            }
            if (((flag = paramInfo.getModifiers()) & 0x10) != 0) {
                buf.append("final ");
            }
            if ((flag & 0x1000) != 0) {
                buf.append("synthetic ");
            }
            if ((flag & 0x8000) != 0) {
                buf.append("mandated ");
            }
            TypeSignature paramType = paramInfo.getTypeSignatureOrTypeDescriptor();
            if (this.isVarArgs() && i == numParams - 1) {
                if (!(paramType instanceof ArrayTypeSignature)) {
                    throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + this.methodName);
                }
                ArrayTypeSignature arrayType = (ArrayTypeSignature)paramType;
                if (arrayType.getNumArrayDims() == 0) {
                    throw new IllegalArgumentException("Got a zero-dimension array type for last parameter of varargs method " + this.methodName);
                }
                buf.append(new ArrayTypeSignature(arrayType.getElementTypeSignature(), arrayType.getNumArrayDims() - 1).toString());
                buf.append("...");
            } else {
                buf.append(paramType.toString());
            }
            if (!hasParamNames || (paramName = paramInfo.getName()) == null) continue;
            buf.append(' ');
            buf.append(paramName == null ? "_unnamed_param_" + i : paramName);
        }
        buf.append(')');
        if (!methodType.getThrowsSignatures().isEmpty()) {
            buf.append(" throws ");
            for (i = 0; i < methodType.getThrowsSignatures().size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(methodType.getThrowsSignatures().get(i).toString());
            }
        }
        return buf.toString();
    }
}

