/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.json.JSONDeserializer;
import io.github.lukehutch.fastclasspathscanner.json.JSONSerializer;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassGraphBuilder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderAndModuleFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ModuleRef;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScanResult {
    transient ScanSpec scanSpec;
    transient List<ClasspathElement> classpathOrder;
    private transient ClassLoader[] envClassLoaderOrder;
    private transient NestedJarHandler nestedJarHandler;
    private transient Map<File, Long> fileToLastModified;
    ClassGraphBuilder classGraphBuilder;
    private transient List<Throwable> matchProcessorExceptions = new ArrayList<Throwable>();
    transient InterruptionChecker interruptionChecker;
    transient LogNode log;
    private static final String CURRENT_SERIALIZATION_FORMAT = "3";

    ScanResult(ScanSpec scanSpec, List<ClasspathElement> classpathOrder, ClassLoader[] envClassLoaderOrder, ClassGraphBuilder classGraphBuilder, Map<File, Long> fileToLastModified, NestedJarHandler nestedJarHandler, InterruptionChecker interruptionChecker, LogNode log) {
        this.scanSpec = scanSpec;
        this.classpathOrder = classpathOrder;
        this.envClassLoaderOrder = envClassLoaderOrder;
        this.fileToLastModified = fileToLastModified;
        this.classGraphBuilder = classGraphBuilder;
        this.nestedJarHandler = nestedJarHandler;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
        if (classGraphBuilder != null && classGraphBuilder.getClassNameToClassInfo() != null) {
            for (ClassInfo ci : classGraphBuilder.getClassNameToClassInfo().values()) {
                ci.setScanResult(this);
            }
        }
    }

    public ClassLoader[] getClassLoadersForClass(String className) {
        ClassLoader[] classLoaders;
        Map<String, ClassLoader[]> classNameToClassLoaders = this.classGraphBuilder.getClassNameToClassLoaders();
        if (classNameToClassLoaders != null && (classLoaders = classNameToClassLoaders.get(className)) != null) {
            return classLoaders;
        }
        return this.envClassLoaderOrder;
    }

    void addMatchProcessorException(Throwable e) {
        this.matchProcessorExceptions.add(e);
    }

    public List<Throwable> getMatchProcessorExceptions() {
        return this.matchProcessorExceptions;
    }

    public List<File> getUniqueClasspathElements() {
        ArrayList<File> classpathElementOrderFiles = new ArrayList<File>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            ModuleRef modRef = classpathElement.getClasspathElementModuleRef();
            if (modRef != null) {
                if (modRef.isSystemModule()) continue;
                classpathElementOrderFiles.add(modRef.getModuleLocationFile());
                continue;
            }
            classpathElementOrderFiles.add(classpathElement.getClasspathElementFile(this.log));
        }
        return classpathElementOrderFiles;
    }

    public String getUniqueClasspathElementsAsPathStr() {
        return JarUtils.pathElementsToPathStr(this.getUniqueClasspathElements());
    }

    public List<URL> getUniqueClasspathElementURLs() {
        ArrayList<URL> classpathElementOrderURLs = new ArrayList<URL>();
        for (ClasspathElement classpathElement : this.classpathOrder) {
            ModuleRef modRef = classpathElement.getClasspathElementModuleRef();
            if (modRef != null) {
                try {
                    classpathElementOrderURLs.add(modRef.getModuleLocation().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            try {
                classpathElementOrderURLs.add(classpathElement.getClasspathElementFile(this.log).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return classpathElementOrderURLs;
    }

    public boolean classpathContentsModifiedSinceScan() {
        if (this.fileToLastModified == null) {
            return true;
        }
        for (Map.Entry<File, Long> ent : this.fileToLastModified.entrySet()) {
            if (ent.getKey().lastModified() == ent.getValue().longValue()) continue;
            return true;
        }
        return false;
    }

    public long classpathContentsLastModifiedTime() {
        long maxLastModifiedTime = 0L;
        if (this.fileToLastModified != null) {
            long currTime = System.currentTimeMillis();
            for (long timestamp : this.fileToLastModified.values()) {
                if (timestamp <= maxLastModifiedTime || timestamp >= currTime) continue;
                maxLastModifiedTime = timestamp;
            }
        }
        return maxLastModifiedTime;
    }

    public Map<String, ClassInfo> getClassNameToClassInfo() {
        return this.classGraphBuilder.getClassNameToClassInfo();
    }

    public List<String> getNamesOfAllClasses() {
        return this.classGraphBuilder.getNamesOfAllClasses();
    }

    public List<String> getNamesOfAllStandardClasses() {
        return this.classGraphBuilder.getNamesOfAllStandardClasses();
    }

    public List<String> getNamesOfSubclassesOf(String superclassName) {
        return this.classGraphBuilder.getNamesOfSubclassesOf(superclassName);
    }

    public List<String> getNamesOfSubclassesOf(Class<?> superclass) {
        return this.classGraphBuilder.getNamesOfSubclassesOf(this.scanSpec.getStandardClassName(superclass));
    }

    public List<String> getNamesOfSuperclassesOf(String subclassName) {
        return this.classGraphBuilder.getNamesOfSuperclassesOf(subclassName);
    }

    public List<String> getNamesOfSuperclassesOf(Class<?> subclass) {
        return this.getNamesOfSuperclassesOf(this.scanSpec.getStandardClassName(subclass));
    }

    public List<String> getNamesOfClassesWithMethodAnnotation(String annotationName) {
        if (!this.scanSpec.enableMethodAnnotationIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableMethodAnnotationIndexing() before calling scan() -- method annotation indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithMethodAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithMethodAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithMethodAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfClassesWithFieldAnnotation(String annotationName) {
        if (!this.scanSpec.enableFieldAnnotationIndexing) {
            throw new IllegalArgumentException("Please call FastClasspathScanner#enableFieldAnnotationIndexing() before calling scan() -- field annotation indexing is disabled by default for efficiency");
        }
        return this.classGraphBuilder.getNamesOfClassesWithFieldAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithFieldAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithFieldAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfAllInterfaceClasses() {
        return this.classGraphBuilder.getNamesOfAllInterfaceClasses();
    }

    public List<String> getNamesOfSubinterfacesOf(String interfaceName) {
        return this.classGraphBuilder.getNamesOfSubinterfacesOf(interfaceName);
    }

    public List<String> getNamesOfSubinterfacesOf(Class<?> superInterface) {
        return this.getNamesOfSubinterfacesOf(this.scanSpec.getInterfaceName(superInterface));
    }

    public List<String> getNamesOfSuperinterfacesOf(String subInterfaceName) {
        return this.classGraphBuilder.getNamesOfSuperinterfacesOf(subInterfaceName);
    }

    public List<String> getNamesOfSuperinterfacesOf(Class<?> subInterface) {
        return this.getNamesOfSuperinterfacesOf(this.scanSpec.getInterfaceName(subInterface));
    }

    public List<String> getNamesOfClassesImplementing(String interfaceName) {
        return this.classGraphBuilder.getNamesOfClassesImplementing(interfaceName);
    }

    public List<String> getNamesOfClassesImplementing(Class<?> implementedInterface) {
        return this.getNamesOfClassesImplementing(this.scanSpec.getInterfaceName(implementedInterface));
    }

    public List<String> getNamesOfClassesImplementingAllOf(String ... implementedInterfaceNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < implementedInterfaceNames.length; ++i) {
            String implementedInterfaceName = implementedInterfaceNames[i];
            List<String> namesOfImplementingClasses = this.getNamesOfClassesImplementing(implementedInterfaceName);
            if (i == 0) {
                classNames.addAll(namesOfImplementingClasses);
                continue;
            }
            classNames.retainAll(namesOfImplementingClasses);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesImplementingAllOf(Class<?> ... implementedInterfaces) {
        return this.getNamesOfClassesImplementingAllOf(this.scanSpec.getInterfaceNames(implementedInterfaces));
    }

    public List<String> getNamesOfAllAnnotationClasses() {
        return this.classGraphBuilder.getNamesOfAllAnnotationClasses();
    }

    public List<String> getNamesOfClassesWithAnnotation(String annotationName) {
        return this.classGraphBuilder.getNamesOfClassesWithAnnotation(annotationName);
    }

    public List<String> getNamesOfClassesWithAnnotation(Class<?> annotation) {
        return this.getNamesOfClassesWithAnnotation(this.scanSpec.getAnnotationName(annotation));
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (int i = 0; i < annotationNames.length; ++i) {
            String annotationName = annotationNames[i];
            List<String> namesOfClassesWithMetaAnnotation = this.getNamesOfClassesWithAnnotation(annotationName);
            if (i == 0) {
                classNames.addAll(namesOfClassesWithMetaAnnotation);
                continue;
            }
            classNames.retainAll(namesOfClassesWithMetaAnnotation);
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAllOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAllOf(this.scanSpec.getAnnotationNames(annotations));
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(String ... annotationNames) {
        HashSet<String> classNames = new HashSet<String>();
        for (String annotationName : annotationNames) {
            classNames.addAll(this.getNamesOfClassesWithAnnotation(annotationName));
        }
        return new ArrayList<String>(classNames);
    }

    public List<String> getNamesOfClassesWithAnnotationsAnyOf(Class<?> ... annotations) {
        return this.getNamesOfClassesWithAnnotationsAnyOf(this.scanSpec.getAnnotationNames(annotations));
    }

    public List<String> getNamesOfAnnotationsOnClass(String className) {
        return this.classGraphBuilder.getNamesOfAnnotationsOnClass(className);
    }

    public List<String> getNamesOfAnnotationsOnClass(Class<?> klass) {
        return this.getNamesOfAnnotationsOnClass(this.scanSpec.getClassOrInterfaceName(klass));
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(String metaAnnotationName) {
        return this.classGraphBuilder.getNamesOfAnnotationsWithMetaAnnotation(metaAnnotationName);
    }

    public List<String> getNamesOfAnnotationsWithMetaAnnotation(Class<?> metaAnnotation) {
        return this.getNamesOfAnnotationsWithMetaAnnotation(this.scanSpec.getAnnotationName(metaAnnotation));
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY, boolean showFields, boolean showMethods) {
        return this.classGraphBuilder.generateClassGraphDotFile(sizeX, sizeY, showFields, showMethods);
    }

    public String generateClassGraphDotFile(float sizeX, float sizeY) {
        return this.classGraphBuilder.generateClassGraphDotFile(sizeX, sizeY, true, true);
    }

    public String generateClassGraphDotFile() {
        return this.classGraphBuilder.generateClassGraphDotFile(10.5f, 8.0f, true, true);
    }

    private Class<?> loadClass(String className, ClassLoader classLoader, LogNode log) throws IllegalArgumentException {
        try {
            return Class.forName(className, this.scanSpec.initializeLoadedClasses, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Exception while loading class " + className, e);
        }
    }

    Class<?> loadClass(String className, boolean returnNullIfClassNotFound, LogNode log) throws IllegalArgumentException {
        Class<?> classRef;
        if (this.scanSpec.overrideClasspath != null) {
            throw new IllegalArgumentException("Cannot load classes from custom classpath, defined using .overrideClasspath(), since system classloaders may search a different classpath, and/or may have already loaded and cached a class (which can lead to a class being loaded twice, if a new classloader is defined using the custom classpath). If you want to load classes from a custom classpath at runtime, you need to define your own ClassLoader (e.g. using new URLClassLoader()), and then use .overrideClassLoaders() instead");
        }
        if (className == null || className.isEmpty()) {
            throw new IllegalArgumentException("Cannot load class -- class names cannot be null or empty");
        }
        ClassLoader[] classLoadersForClass = this.getClassLoadersForClass(className);
        if (classLoadersForClass == null) {
            classLoadersForClass = this.envClassLoaderOrder;
        }
        if (classLoadersForClass != null) {
            for (ClassLoader classLoader : classLoadersForClass) {
                Class<?> classRef2 = this.loadClass(className, classLoader, log);
                if (classRef2 == null) continue;
                return classRef2;
            }
        }
        if ((classRef = this.loadClass(className, null, log)) != null) {
            return classRef;
        }
        if (!returnNullIfClassNotFound) {
            throw new IllegalArgumentException("No classloader was able to load class " + className);
        }
        if (log != null) {
            log.log("No classloader was able to load class " + className);
        }
        return null;
    }

    public List<Class<?>> classNamesToClassRefs(List<String> classNames, boolean ignoreExceptions) throws IllegalArgumentException {
        if (classNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList classRefs = new ArrayList();
        for (String className : classNames) {
            Class<?> classRef = this.classNameToClassRef(className, ignoreExceptions);
            if (classRef == null) continue;
            classRefs.add(classRef);
        }
        return classRefs.isEmpty() ? Collections.emptyList() : classRefs;
    }

    public List<Class<?>> classNamesToClassRefs(List<String> classNames) throws IllegalArgumentException {
        return this.classNamesToClassRefs(classNames, false);
    }

    public Class<?> classNameToClassRef(String className, boolean ignoreExceptions) throws IllegalArgumentException {
        try {
            Class<?> clazz = this.loadClass(className, ignoreExceptions, this.log);
            return clazz;
        }
        catch (Throwable e) {
            if (ignoreExceptions) {
                Class<?> clazz = null;
                return clazz;
            }
            throw e;
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public Class<?> classNameToClassRef(String className) throws IllegalArgumentException {
        return this.classNameToClassRef(className, false);
    }

    public static ScanResult fromJSON(String json) {
        Matcher matcher = Pattern.compile("\\{[\\n\\r ]*\"serializationFormat\"[ ]?:[ ]?\"([^\"]+)\"").matcher(json);
        if (!matcher.find()) {
            throw new IllegalArgumentException("JSON is not in correct format");
        }
        if (!CURRENT_SERIALIZATION_FORMAT.equals(matcher.group(1))) {
            throw new IllegalArgumentException("JSON was serialized in a different format from the format used by the current version of FastClasspathScanner -- please serialize and deserialize your ScanResult using the same version of FastClasspathScanner");
        }
        SerializationFormat deserialized = JSONDeserializer.deserializeObject(SerializationFormat.class, json);
        if (!deserialized.serializationFormat.equals(CURRENT_SERIALIZATION_FORMAT)) {
            throw new IllegalArgumentException("JSON was serialized by newer version of FastClasspathScanner");
        }
        ClassLoader[] envClassLoaderOrder = new ClassLoaderAndModuleFinder(deserialized.scanSpec, null).getClassLoaders();
        HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
        for (ClassInfo ci : deserialized.allClassInfo) {
            classNameToClassInfo.put(ci.getClassName(), ci);
        }
        ClassGraphBuilder classGraphBuilder = new ClassGraphBuilder(deserialized.scanSpec, classNameToClassInfo);
        ScanResult scanResult = new ScanResult(deserialized.scanSpec, Collections.emptyList(), envClassLoaderOrder, classGraphBuilder, null, null, null, null);
        classGraphBuilder.setFields(deserialized.scanSpec, scanResult);
        return scanResult;
    }

    public String toJSON(int indentWidth) {
        return JSONSerializer.serializeObject(new SerializationFormat(CURRENT_SERIALIZATION_FORMAT, this.scanSpec, this.classGraphBuilder), indentWidth, false);
    }

    public String toJSON() {
        return this.toJSON(0);
    }

    public void freeTempFiles(LogNode log) {
        if (this.nestedJarHandler != null) {
            this.nestedJarHandler.close(log);
        }
    }

    protected void finalize() throws Throwable {
        this.freeTempFiles(null);
    }

    private static class SerializationFormat {
        public String serializationFormat;
        public ScanSpec scanSpec;
        public List<ClassInfo> allClassInfo;

        public SerializationFormat() {
        }

        public SerializationFormat(String serializationFormat, ScanSpec scanSpec, ClassGraphBuilder classGraphBuilder) {
            this.serializationFormat = serializationFormat;
            this.scanSpec = scanSpec;
            this.allClassInfo = new ArrayList<ClassInfo>(classGraphBuilder.classNameToClassInfo.values());
        }
    }

    static abstract class InfoObject {
        InfoObject() {
        }

        abstract void setScanResult(ScanResult var1);
    }
}

