/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefOrTypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ClassTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeVariableSignature;
import io.github.lukehutch.fastclasspathscanner.utils.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MethodTypeSignature
extends HierarchicalTypeSignature {
    final List<TypeParameter> typeParameters;
    private final List<TypeSignature> parameterTypeSignatures;
    private final TypeSignature resultType;
    private final List<ClassRefOrTypeVariableSignature> throwsSignatures;

    public MethodTypeSignature(List<TypeParameter> typeParameters, List<TypeSignature> paramTypes, TypeSignature resultType, List<ClassRefOrTypeVariableSignature> throwsSignatures) {
        this.typeParameters = typeParameters;
        this.parameterTypeSignatures = paramTypes;
        this.resultType = resultType;
        this.throwsSignatures = throwsSignatures;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public List<TypeSignature> getParameterTypeSignatures() {
        return this.parameterTypeSignatures;
    }

    public TypeSignature getResultType() {
        return this.resultType;
    }

    public List<ClassRefOrTypeVariableSignature> getThrowsSignatures() {
        return this.throwsSignatures;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        for (TypeParameter typeParameter : this.typeParameters) {
            if (typeParameter == null) continue;
            typeParameter.getAllReferencedClassNames(classNameListOut);
        }
        for (TypeSignature typeSignature : this.parameterTypeSignatures) {
            if (typeSignature == null) continue;
            typeSignature.getAllReferencedClassNames(classNameListOut);
        }
        this.resultType.getAllReferencedClassNames(classNameListOut);
        for (ClassRefOrTypeVariableSignature classRefOrTypeVariableSignature : this.throwsSignatures) {
            if (classRefOrTypeVariableSignature == null) continue;
            classRefOrTypeVariableSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeParameters.hashCode() + this.parameterTypeSignatures.hashCode() * 7 + this.resultType.hashCode() * 15 + this.throwsSignatures.hashCode() * 31;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodTypeSignature)) {
            return false;
        }
        MethodTypeSignature o = (MethodTypeSignature)obj;
        return o.typeParameters.equals(this.typeParameters) && o.parameterTypeSignatures.equals(this.parameterTypeSignatures) && o.resultType.equals(this.resultType) && o.throwsSignatures.equals(this.throwsSignatures);
    }

    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        if (!this.typeParameters.isEmpty()) {
            buf.append('<');
            for (i = 0; i < this.typeParameters.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                String typeParamStr = this.typeParameters.get(i).toString();
                buf.append(typeParamStr);
            }
            buf.append('>');
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.resultType.toString());
        buf.append(" (");
        for (i = 0; i < this.parameterTypeSignatures.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.parameterTypeSignatures.get(i).toString());
        }
        buf.append(')');
        if (!this.throwsSignatures.isEmpty()) {
            buf.append(" throws ");
            for (i = 0; i < this.throwsSignatures.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.throwsSignatures.get(i).toString());
            }
        }
        return buf.toString();
    }

    public static MethodTypeSignature parse(String typeDescriptor) throws Parser.ParseException {
        return MethodTypeSignature.parse(null, typeDescriptor);
    }

    public static MethodTypeSignature parse(ClassInfo classInfo, String typeDescriptor) throws Parser.ParseException {
        List<ClassRefOrTypeVariableSignature> throwsSignatures;
        Parser parser = new Parser(typeDescriptor);
        List<TypeParameter> typeParameters = TypeParameter.parseList(parser);
        parser.expect('(');
        ArrayList<TypeSignature> paramTypes = new ArrayList<TypeSignature>();
        while (parser.peek() != ')') {
            if (!parser.hasMore()) {
                throw new Parser.ParseException(parser, "Ran out of input while parsing method signature");
            }
            TypeSignature paramType = TypeSignature.parse(parser);
            if (paramType == null) {
                throw new Parser.ParseException(parser, "Missing method parameter type signature");
            }
            paramTypes.add(paramType);
        }
        parser.expect(')');
        TypeSignature resultType = TypeSignature.parse(parser);
        if (resultType == null) {
            throw new Parser.ParseException(parser, "Missing method result type signature");
        }
        if (parser.peek() == '^') {
            throwsSignatures = new ArrayList();
            while (parser.peek() == '^') {
                parser.expect('^');
                ClassRefTypeSignature classTypeSignature = ClassRefTypeSignature.parse(parser);
                if (classTypeSignature != null) {
                    throwsSignatures.add(classTypeSignature);
                    continue;
                }
                TypeVariableSignature typeVariableSignature = TypeVariableSignature.parse(parser);
                if (typeVariableSignature != null) {
                    throwsSignatures.add(typeVariableSignature);
                    continue;
                }
                throw new Parser.ParseException(parser, "Missing type variable signature");
            }
        } else {
            throwsSignatures = Collections.emptyList();
        }
        if (parser.hasMore()) {
            throw new Parser.ParseException(parser, "Extra characters at end of type descriptor");
        }
        MethodTypeSignature methodSignature = new MethodTypeSignature(typeParameters, paramTypes, resultType, throwsSignatures);
        List typeVariableSignatures = (List)parser.getState();
        if (typeVariableSignatures != null) {
            for (TypeVariableSignature typeVariableSignature : typeVariableSignatures) {
                typeVariableSignature.containingMethodSignature = methodSignature;
            }
            if (classInfo != null) {
                ClassTypeSignature classSignature = classInfo.getTypeSignature();
                for (TypeVariableSignature typeVariableSignature : typeVariableSignatures) {
                    typeVariableSignature.containingClassSignature = classSignature;
                }
            }
        }
        return methodSignature;
    }
}

