/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.typesignature;

import io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.ReferenceTypeSignature;
import io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import io.github.lukehutch.fastclasspathscanner.utils.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TypeParameter
extends HierarchicalTypeSignature {
    final String identifier;
    final ReferenceTypeSignature classBound;
    final List<ReferenceTypeSignature> interfaceBounds;

    public TypeParameter(String identifier, ReferenceTypeSignature classBound, List<ReferenceTypeSignature> interfaceBounds) {
        this.identifier = identifier;
        this.classBound = classBound;
        this.interfaceBounds = interfaceBounds;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ReferenceTypeSignature getClassBound() {
        return this.classBound;
    }

    public List<ReferenceTypeSignature> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        if (this.classBound != null) {
            this.classBound.getAllReferencedClassNames(classNameListOut);
        }
        for (ReferenceTypeSignature typeSignature : this.interfaceBounds) {
            typeSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.identifier.hashCode() + (this.classBound == null ? 0 : this.classBound.hashCode() * 7) + this.interfaceBounds.hashCode() * 15;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeParameter)) {
            return false;
        }
        TypeParameter o = (TypeParameter)obj;
        return o.identifier.equals(this.identifier) && (o.classBound == null && this.classBound == null || o.classBound != null && o.classBound.equals(this.classBound)) && o.interfaceBounds.equals(this.interfaceBounds);
    }

    public String toString() {
        String classBoundStr;
        StringBuilder buf = new StringBuilder();
        buf.append(this.identifier);
        if (this.classBound == null) {
            classBoundStr = null;
        } else {
            classBoundStr = this.classBound.toString();
            if (classBoundStr.equals("java.lang.Object")) {
                classBoundStr = null;
            }
        }
        if (classBoundStr != null || !this.interfaceBounds.isEmpty()) {
            buf.append(" extends");
        }
        if (classBoundStr != null) {
            buf.append(' ');
            buf.append(classBoundStr);
        }
        for (int i = 0; i < this.interfaceBounds.size(); ++i) {
            if (i > 0 || classBoundStr != null) {
                buf.append(" &");
            }
            buf.append(' ');
            buf.append(this.interfaceBounds.get(i).toString());
        }
        return buf.toString();
    }

    private static TypeParameter parse(Parser parser) throws Parser.ParseException {
        List<ReferenceTypeSignature> interfaceBounds;
        if (!TypeUtils.getIdentifierToken(parser)) {
            throw new Parser.ParseException(parser, "Could not parse identifier token");
        }
        String identifier = parser.currToken();
        ReferenceTypeSignature classBound = ReferenceTypeSignature.parseClassBound(parser);
        if (parser.peek() == ':') {
            interfaceBounds = new ArrayList();
            while (parser.peek() == ':') {
                parser.expect(':');
                ReferenceTypeSignature interfaceTypeSignature = ReferenceTypeSignature.parseReferenceTypeSignature(parser);
                if (interfaceTypeSignature == null) {
                    throw new Parser.ParseException(parser, "Missing interface type signature");
                }
                interfaceBounds.add(interfaceTypeSignature);
            }
        } else {
            interfaceBounds = Collections.emptyList();
        }
        return new TypeParameter(identifier, classBound, interfaceBounds);
    }

    static List<TypeParameter> parseList(Parser parser) throws Parser.ParseException {
        if (parser.peek() != '<') {
            return Collections.emptyList();
        }
        parser.expect('<');
        ArrayList<TypeParameter> typeParams = new ArrayList<TypeParameter>(1);
        while (parser.peek() != '>') {
            if (!parser.hasMore()) {
                throw new Parser.ParseException(parser, "Missing '>'");
            }
            typeParams.add(TypeParameter.parse(parser));
        }
        parser.expect('>');
        return typeParams;
    }
}

