/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.scanner.ModuleRef;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.FastPathResolver;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.JarfileMetadataReader;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.SingletonMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NestedJarHandler {
    private final ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    private final SingletonMap<String, Map.Entry<File, Set<String>>> nestedPathToJarfileAndRootRelativePathsMap;
    private final SingletonMap<File, Recycler<ZipFile, IOException>> zipFileToRecyclerMap;
    private final ConcurrentHashMap<File, File> innerJarToOuterJarMap;
    private final SingletonMap<File, JarfileMetadataReader> zipFileToJarfileMetadataReaderMap;
    private final SingletonMap<ModuleRef, Recycler<ModuleRef.ModuleReaderProxy, IOException>> moduleReaderProxyToModuleReaderRecyclerMap;
    private final InterruptionChecker interruptionChecker;
    public static final String TEMP_FILENAME_LEAF_SEPARATOR = "---";

    public NestedJarHandler(final ScanSpec scanSpec, InterruptionChecker interruptionChecker, LogNode log) {
        this.interruptionChecker = interruptionChecker;
        this.zipFileToRecyclerMap = new SingletonMap<File, Recycler<ZipFile, IOException>>(){

            @Override
            public Recycler<ZipFile, IOException> newInstance(final File zipFile, LogNode log) throws Exception {
                return new Recycler<ZipFile, IOException>(){

                    @Override
                    public ZipFile newInstance() throws IOException {
                        return new ZipFile(zipFile.getPath());
                    }
                };
            }
        };
        this.zipFileToJarfileMetadataReaderMap = new SingletonMap<File, JarfileMetadataReader>(){

            @Override
            public JarfileMetadataReader newInstance(File canonicalFile, LogNode log) throws Exception {
                return new JarfileMetadataReader(canonicalFile, log);
            }
        };
        this.innerJarToOuterJarMap = new ConcurrentHashMap();
        this.moduleReaderProxyToModuleReaderRecyclerMap = new SingletonMap<ModuleRef, Recycler<ModuleRef.ModuleReaderProxy, IOException>>(){

            @Override
            public Recycler<ModuleRef.ModuleReaderProxy, IOException> newInstance(final ModuleRef moduleRef, LogNode log) throws Exception {
                return new Recycler<ModuleRef.ModuleReaderProxy, IOException>(){

                    @Override
                    public ModuleRef.ModuleReaderProxy newInstance() throws IOException {
                        return moduleRef.open();
                    }
                };
            }
        };
        this.nestedPathToJarfileAndRootRelativePathsMap = new SingletonMap<String, Map.Entry<File, Set<String>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map.Entry<File, Set<String>> newInstance(String nestedJarPath, LogNode log) throws Exception {
                Map.Entry parentJarfileAndRootRelativePaths;
                File parentJarFile;
                int lastPlingIdx = nestedJarPath.lastIndexOf(33);
                if (lastPlingIdx < 0) {
                    File canonicalFile;
                    File pathFile;
                    boolean isRemote = nestedJarPath.startsWith("http://") || nestedJarPath.startsWith("https://");
                    File file = pathFile = isRemote ? NestedJarHandler.this.downloadTempFile(nestedJarPath, log) : new File(nestedJarPath);
                    if (isRemote && pathFile == null) {
                        if (log != null) {
                            log.log(nestedJarPath, "Could not download jarfile " + nestedJarPath);
                        }
                        return null;
                    }
                    try {
                        canonicalFile = pathFile.getCanonicalFile();
                    }
                    catch (IOException | SecurityException e) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + " could not be canonicalized: " + e);
                        }
                        return null;
                    }
                    if (!ClasspathUtils.canRead(canonicalFile)) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + " does not exist");
                        }
                        return null;
                    }
                    if (!canonicalFile.isFile()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component " + nestedJarPath + "  is not a file (expected a jarfile)");
                        }
                        return null;
                    }
                    File bareJarfile = scanSpec.stripSFXHeader ? NestedJarHandler.this.stripSFXHeader(canonicalFile, log) : canonicalFile;
                    HashSet rootRelativePaths = new HashSet();
                    return new AbstractMap.SimpleEntry<File, Set<String>>(bareJarfile, rootRelativePaths);
                }
                String parentPath = nestedJarPath.substring(0, lastPlingIdx);
                String childPath = nestedJarPath.substring(lastPlingIdx + 1);
                if (childPath.startsWith("/")) {
                    childPath = childPath.substring(1);
                }
                if ((parentJarFile = (File)(parentJarfileAndRootRelativePaths = (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentPath, log)).getKey()) == null) {
                    return null;
                }
                String parentJarFilePath = FastPathResolver.resolve(parentJarFile.getPath());
                if (!parentJarFilePath.equals(parentPath)) {
                    return (Map.Entry)NestedJarHandler.this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(parentJarFilePath + "!" + childPath, log);
                }
                Recycler parentJarRecycler = (Recycler)NestedJarHandler.this.zipFileToRecyclerMap.getOrCreateSingleton(parentJarFile.getCanonicalFile(), log);
                ZipFile parentZipFile = null;
                try {
                    ZipEntry childZipEntry;
                    parentZipFile = (ZipFile)parentJarRecycler.acquire();
                    if (childPath.endsWith("/")) {
                        childZipEntry = parentZipFile.getEntry(childPath);
                    } else {
                        childZipEntry = parentZipFile.getEntry(childPath + "/");
                        if (childZipEntry == null) {
                            childZipEntry = parentZipFile.getEntry(childPath);
                        }
                    }
                    if (childZipEntry == null) {
                        if (log != null) {
                            log.log(nestedJarPath, "Child path component " + childPath + " does not exist in jarfile " + parentJarFile);
                        }
                        Map.Entry<File, Set<String>> entry = null;
                        return entry;
                    }
                    if (childZipEntry.isDirectory()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Child path component " + childPath + " in jarfile " + parentJarFile + " is a directory, not a file -- using as scanning root");
                        }
                        ((Set)parentJarfileAndRootRelativePaths.getValue()).add(childPath);
                        Map.Entry entry = parentJarfileAndRootRelativePaths;
                        return entry;
                    }
                    File childJarFile = NestedJarHandler.this.unzipToTempFile(parentZipFile, childZipEntry, log);
                    File noHeaderChildJarFile = scanSpec.stripSFXHeader ? NestedJarHandler.this.stripSFXHeader(childJarFile, log) : childJarFile;
                    NestedJarHandler.this.innerJarToOuterJarMap.put(noHeaderChildJarFile, parentJarFile);
                    HashSet rootRelativePaths = new HashSet();
                    AbstractMap.SimpleEntry<File, Set<String>> simpleEntry = new AbstractMap.SimpleEntry<File, Set<String>>(noHeaderChildJarFile, rootRelativePaths);
                    return simpleEntry;
                }
                finally {
                    parentJarRecycler.release(parentZipFile);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                NestedJarHandler.this.close(null);
            }
        });
    }

    public Recycler<ZipFile, IOException> getZipFileRecycler(File zipFile, LogNode log) throws Exception {
        return this.zipFileToRecyclerMap.getOrCreateSingleton(zipFile, log);
    }

    public JarfileMetadataReader getJarfileMetadataReader(File zipFile, String jarfilePackageRoot, LogNode log) throws Exception {
        JarfileMetadataReader jarfileMetadataReader = this.zipFileToJarfileMetadataReaderMap.getOrCreateSingleton(zipFile, log);
        if (!jarfilePackageRoot.isEmpty()) {
            jarfileMetadataReader.addPackageRootPath(jarfilePackageRoot);
        }
        return jarfileMetadataReader;
    }

    public Recycler<ModuleRef.ModuleReaderProxy, IOException> getModuleReaderProxyRecycler(ModuleRef moduleRef, LogNode log) throws Exception {
        return this.moduleReaderProxyToModuleReaderRecyclerMap.getOrCreateSingleton(moduleRef, log);
    }

    public Map.Entry<File, Set<String>> getInnermostNestedJar(String nestedJarPath, LogNode log) throws Exception {
        return this.nestedPathToJarfileAndRootRelativePathsMap.getOrCreateSingleton(nestedJarPath, log);
    }

    public File getOutermostJar(File jarFile) {
        File lastValid = jarFile;
        File curr = jarFile;
        while (curr != null) {
            lastValid = curr;
            curr = this.innerJarToOuterJarMap.get(curr);
        }
        return lastValid;
    }

    private String leafname(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private String parentPath(String filePath) {
        int lastSlash = filePath.lastIndexOf(47);
        if (lastSlash <= 0) {
            return "";
        }
        return filePath.substring(0, lastSlash);
    }

    private String sanitizeFilename(String filename) {
        return filename.replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('&', '_').replace('=', '_').replace('.', '_').replace(' ', '_');
    }

    private File downloadTempFile(String jarURL, LogNode log) {
        LogNode subLog = log == null ? null : log.log(jarURL, "Downloading URL " + jarURL);
        File tempFile = null;
        try {
            String suffix = TEMP_FILENAME_LEAF_SEPARATOR + this.sanitizeFilename(jarURL);
            tempFile = File.createTempFile("FCS--", suffix);
            tempFile.deleteOnExit();
            this.tempFiles.add(tempFile);
            URL url = new URL(jarURL);
            try (InputStream inputStream = url.openStream();){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            if (subLog != null) {
                subLog.addElapsedTime();
            }
        }
        catch (Exception e) {
            if (subLog != null) {
                subLog.log("Could not download " + jarURL, e);
            }
            return null;
        }
        if (subLog != null) {
            subLog.log("Downloaded to temporary file " + tempFile);
            subLog.log("***** Note that it is time-consuming to scan jars at http(s) addresses, they must be downloaded for every scan, and the same jars must also be separately downloaded by the ClassLoader *****");
        }
        return tempFile;
    }

    private File unzipToTempFile(ZipFile zipFile, ZipEntry zipEntry, LogNode log) throws IOException {
        String zipEntryPath = zipEntry.getName();
        if (zipEntryPath.startsWith("/")) {
            zipEntryPath = zipEntryPath.substring(1);
        }
        File tempFile = File.createTempFile("FCS--", TEMP_FILENAME_LEAF_SEPARATOR + this.leafname(zipEntryPath));
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        LogNode subLog = null;
        if (log != null) {
            subLog = log.log(zipFile.getName() + "!/" + zipEntryPath, "Unzipping " + zipFile.getName() + "!/" + zipEntryPath).log("Extracted to temporary file " + tempFile.getPath());
        }
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        return tempFile;
    }

    public File unzipToTempDir(File jarFile, String packageRoot, LogNode log) throws IOException {
        LogNode subLog = log == null ? null : log.log("Unzipping " + jarFile + " from package root " + packageRoot);
        Path tempDirPath = Files.createTempDirectory("FCS--" + this.sanitizeFilename(this.leafname(jarFile.getName())) + "--" + this.sanitizeFilename(packageRoot) + "--", new FileAttribute[0]);
        File tempDir = tempDirPath.toFile();
        tempDir.deleteOnExit();
        this.tempFiles.add(tempDir);
        try (ZipFile zipFile = new ZipFile(jarFile);){
            String pathPrefix = packageRoot + '/';
            int pathPrefixLen = pathPrefix.length();
            HashSet<String> mkDirsPaths = new HashSet<String>();
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                LogNode subSubLog;
                File fileToUnzip;
                Path pathToFileToUnzip;
                block22: {
                    ZipEntry zipEntry = e.nextElement();
                    String entName = zipEntry.getName();
                    if (zipEntry.isDirectory() || entName.endsWith("/")) continue;
                    while (entName.startsWith("/")) {
                        entName = entName.substring(1);
                    }
                    if (!entName.startsWith(pathPrefix)) continue;
                    String pathWithinPackageRoot = entName.substring(pathPrefixLen);
                    pathToFileToUnzip = tempDirPath.resolve(pathWithinPackageRoot);
                    if (!pathToFileToUnzip.startsWith(tempDirPath)) {
                        if (subLog == null) continue;
                        subLog.log("Skipping invalid path " + zipEntry.getName());
                        continue;
                    }
                    fileToUnzip = pathToFileToUnzip.toFile();
                    String parentPathStr = this.parentPath(pathWithinPackageRoot);
                    if (!parentPathStr.isEmpty() && mkDirsPaths.add(parentPathStr)) {
                        File curr = tempDir;
                        for (String part : parentPathStr.split("/")) {
                            File next = new File(curr, part);
                            if (!next.exists()) {
                                boolean created = next.mkdir();
                                if (!created) {
                                    throw new IOException("Could not create dir: " + next);
                                }
                                next.deleteOnExit();
                                this.tempFiles.add(next);
                            } else if (!next.isDirectory()) {
                                throw new IOException("Tried to unzip as both a directory and a file: " + next);
                            }
                            curr = next;
                        }
                    }
                    subSubLog = subLog == null ? null : subLog.log(jarFile.getName() + "!" + entName, "Unzipping " + jarFile.getName() + "!" + entName);
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        Files.copy(inputStream, pathToFileToUnzip, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception ex) {
                        if (subSubLog == null) break block22;
                        subSubLog.log("Could not unzip file: " + ex);
                    }
                }
                fileToUnzip.deleteOnExit();
                this.tempFiles.add(fileToUnzip);
                if (subSubLog == null) continue;
                subSubLog.log("Extracted to temporary file: " + pathToFileToUnzip);
            }
        }
        return tempDir;
    }

    private File stripSFXHeader(File zipfile, LogNode log) throws IOException {
        long sfxHeaderBytes = JarUtils.countBytesBeforePKMarker(zipfile);
        if (sfxHeaderBytes == -1L) {
            throw new IOException("Could not find zipfile \"PK\" marker in file " + zipfile);
        }
        if (sfxHeaderBytes == 0L) {
            return zipfile;
        }
        File bareZipfile = File.createTempFile("FCS--", TEMP_FILENAME_LEAF_SEPARATOR + JarUtils.leafName(zipfile.getName()));
        bareZipfile.deleteOnExit();
        this.tempFiles.add(bareZipfile);
        if (log != null) {
            log.log("Zipfile " + zipfile + " contains a self-extracting executable header of " + sfxHeaderBytes + " bytes. Stripping off header to create bare zipfile " + bareZipfile);
        }
        JarUtils.stripSFXHeader(zipfile, sfxHeaderBytes, bareZipfile);
        return bareZipfile;
    }

    public void close(LogNode log) {
        if (this.interruptionChecker != null) {
            this.interruptionChecker.interrupt();
        }
        if (this.tempFiles != null) {
            LogNode rmLog;
            LogNode logNode = rmLog = this.tempFiles.isEmpty() || log == null ? null : log.log("Removing temporary files");
            while (!this.tempFiles.isEmpty()) {
                File head = this.tempFiles.remove();
                String path = head.getPath();
                boolean success = head.delete();
                if (log == null) continue;
                rmLog.log((success ? "Removed" : "Unable to remove") + " " + path);
            }
        }
        if (this.zipFileToRecyclerMap != null) {
            List<Recycler<ZipFile, IOException>> recyclers = null;
            try {
                recyclers = this.zipFileToRecyclerMap.values();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (recyclers != null) {
                for (Recycler<ZipFile, IOException> recycler : recyclers) {
                    recycler.close();
                }
                this.zipFileToRecyclerMap.clear();
            }
        }
    }
}

