/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunasaw.gbproxy.test.user.client;

import com.alibaba.fastjson2.JSON;
import io.github.lunasaw.gb28181.common.entity.enums.InviteSessionNameEnum;
import io.github.lunasaw.gbproxy.client.transmit.request.invite.InviteProcessorClient;
import io.github.lunasaw.gbproxy.test.user.client.FfmpegCommander;
import io.github.lunasaw.sip.common.entity.Device;
import io.github.lunasaw.sip.common.entity.GbSessionDescription;
import io.github.lunasaw.sip.common.entity.SdpSessionDescription;
import io.github.lunasaw.sip.common.transmit.event.SipSubscribe;
import java.io.FileNotFoundException;
import javax.sdp.SessionDescription;
import javax.sdp.SessionName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
public class DefaultInviteProcessorClient
implements InviteProcessorClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultInviteProcessorClient.class);
    private static String VIDEO_FILE;
    private static String RECORD_VIDEO_FILE;
    @Autowired
    @Qualifier(value="clientFrom")
    private Device fromDevice;
    @Autowired
    private FfmpegCommander ffmpegCommander;

    public void inviteSession(String callId, SdpSessionDescription sessionDescription) {
        GbSessionDescription gbSessionDescription = (GbSessionDescription)sessionDescription;
        SessionDescription descriptionBaseSdb = gbSessionDescription.getBaseSdb();
        SessionName sessionName = descriptionBaseSdb.getSessionName();
        if (InviteSessionNameEnum.PLAY.getType().equals(sessionName.getValue())) {
            log.info("\u70b9\u64ad\u8bf7\u6c42 inviteSession::sessionDescription = {}", (Object)JSON.toJSONString((Object)sessionDescription));
            SipSubscribe.addOkSubscribe((String)callId, eventResult -> {
                this.ffmpegCommander.closeAllStream();
                this.ffmpegCommander.pushStream(eventResult.callId, VIDEO_FILE, gbSessionDescription.getAddress(), gbSessionDescription.getPort());
            });
        } else if (InviteSessionNameEnum.PLAY_BACK.getType().equals(sessionName.getValue())) {
            log.info("\u56de\u653e\u8bf7\u6c42 inviteSession::sessionDescription = {}", (Object)JSON.toJSONString((Object)sessionDescription));
            SipSubscribe.addOkSubscribe((String)callId, eventResult -> {
                this.ffmpegCommander.closeAllStream();
                this.ffmpegCommander.pushStream(eventResult.callId, RECORD_VIDEO_FILE, gbSessionDescription.getAddress(), gbSessionDescription.getPort());
            });
        }
    }

    static {
        try {
            VIDEO_FILE = ResourceUtils.getFile((String)"classpath:file/invite.mp4").getAbsolutePath();
            RECORD_VIDEO_FILE = ResourceUtils.getFile((String)"classpath:file/record.mp4").getAbsolutePath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

