/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunasaw.gbproxy.test.user.client;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FfmpegCommander {
    private static final Logger log = LoggerFactory.getLogger(FfmpegCommander.class);
    private static final String path = "/usr/local/bin/ffmpeg";
    private static final String cmd = "-re -stream_loop -1 -i {filePath} -vcodec h264 -acodec aac -f rtsp -rtsp_transport tcp rtsp://{ip}:{port}/rtsp/live?sign=41db35390ddad33f83944f44b8b75ded";
    private static final Map<String, Process> processMap = new ConcurrentHashMap<String, Process>();
    private final Logger logger = LoggerFactory.getLogger(FfmpegCommander.class);

    public void pushStream(String callId, String filePath, String ip, int port) {
        String command = "/usr/local/bin/ffmpeg " + cmd.replace("{filePath}", filePath).replace("{ip}", ip).replace("{port}", "1554");
        this.logger.info("callId={},\r\n\u63a8\u6d41\u547d\u4ee4={}", (Object)callId, (Object)command);
        Runtime runtime = Runtime.getRuntime();
        try {
            new Thread(() -> {
                int code = 0;
                try {
                    String str;
                    Process process = runtime.exec(command);
                    processMap.put(callId, process);
                    InputStream errorInputStream = process.getErrorStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(errorInputStream));
                    StringBuffer errorStr = new StringBuffer();
                    while ((str = reader.readLine()) != null) {
                        errorStr.append(str);
                        this.logger.debug(str);
                    }
                    code = process.waitFor();
                    this.logger.info("\u63a8\u6d41\u5df2\u7ed3\u675f,callId={}", (Object)callId);
                }
                catch (Exception e) {
                    this.logger.error("ffmpeg\u63a8\u6d41\u5f02\u5e38!", (Throwable)e);
                }
            }).start();
        }
        catch (Exception e) {
            log.error("pushStream::callId = {}, filePath = {}, ip = {}, port = {} ", new Object[]{callId, filePath, ip, port, e});
        }
    }

    public void closeStream(String callId) {
        this.logger.info("\u5173\u95ed\u63a8\u6d41:{}", (Object)callId);
        if (StringUtils.isEmpty((CharSequence)callId)) {
            this.closeAllStream();
        } else if (processMap.containsKey(callId)) {
            processMap.get(callId).destroy();
        } else {
            this.logger.info("\u6ca1\u6709\u63a8\u6d41\u8981\u5173\u95ed!");
        }
    }

    public void closeAllStream() {
        this.logger.info("\u5173\u95ed\u6240\u6709\u63a8\u6d41");
        processMap.forEach((key, value) -> value.destroy());
    }
}

