/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunasaw.gbproxy.test.user.server;

import com.alibaba.fastjson2.JSON;
import io.github.lunasaw.gb28181.common.entity.notify.DeviceAlarmNotify;
import io.github.lunasaw.gb28181.common.entity.notify.DeviceKeepLiveNotify;
import io.github.lunasaw.gb28181.common.entity.notify.MediaStatusNotify;
import io.github.lunasaw.gb28181.common.entity.notify.MobilePositionNotify;
import io.github.lunasaw.gb28181.common.entity.response.DeviceInfo;
import io.github.lunasaw.gb28181.common.entity.response.DeviceRecord;
import io.github.lunasaw.gb28181.common.entity.response.DeviceResponse;
import io.github.lunasaw.gbproxy.server.transimit.request.message.MessageProcessorServer;
import io.github.lunasaw.gbproxy.test.config.DeviceConfig;
import io.github.lunasaw.sip.common.entity.Device;
import io.github.lunasaw.sip.common.entity.RemoteAddressInfo;
import io.github.lunasaw.sip.common.entity.ToDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultMessageProcessorServer
implements MessageProcessorServer {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageProcessorServer.class);
    @Autowired
    @Qualifier(value="serverFrom")
    private Device fromDevice;

    public void keepLiveDevice(DeviceKeepLiveNotify deviceKeepLiveNotify) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u7684\u5fc3\u8df3 keepLiveDevice::deviceKeepLiveNotify = {}", (Object)JSON.toJSONString((Object)deviceKeepLiveNotify));
    }

    public void updateRemoteAddress(String userId, RemoteAddressInfo remoteAddressInfo) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u7684\u5730\u5740\u4fe1\u606f updateRemoteAddress::remoteAddressInfo = {}", (Object)remoteAddressInfo);
        ToDevice device = (ToDevice)DeviceConfig.DEVICE_SERVER_VIEW_MAP.get(userId);
        if (device == null) {
            return;
        }
        device.setIp(remoteAddressInfo.getIp());
        device.setPort(remoteAddressInfo.getPort().intValue());
        DeviceConfig.DEVICE_SERVER_VIEW_MAP.put(userId, (Device)device);
    }

    public void updateDeviceAlarm(DeviceAlarmNotify deviceAlarmNotify) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u7684\u544a\u8b66\u4fe1\u606f updateDeviceAlarm::deviceAlarmNotify = {}", (Object)deviceAlarmNotify);
    }

    public void updateMobilePosition(MobilePositionNotify mobilePositionNotify) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u7684\u4f4d\u7f6e\u4fe1\u606f updateMobilePosition::mobilePositionNotify = {}", (Object)mobilePositionNotify);
    }

    public void updateMediaStatus(MediaStatusNotify mediaStatusNotify) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u7684\u5a92\u4f53\u72b6\u6001\u4fe1\u606f updateMediaStatus::mediaStatusNotify = {}", (Object)mediaStatusNotify);
    }

    public void updateDeviceRecord(String userId, DeviceRecord deviceRecord) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u7684\u5f55\u50cf\u4fe1\u606f updateDeviceRecord::userId = {}, deviceRecord = {}", (Object)userId, (Object)JSON.toJSONString((Object)deviceRecord));
    }

    public void updateDeviceResponse(String userId, DeviceResponse deviceResponse) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u901a\u9053\u4fe1\u606f updateDeviceResponse::userId = {}, deviceResponse = {}", (Object)userId, (Object)JSON.toJSONString((Object)deviceResponse));
    }

    public void updateDeviceInfo(String userId, DeviceInfo deviceInfo) {
        log.info("\u63a5\u6536\u5230\u8bbe\u5907\u4fe1\u606f updateDeviceInfo::userId = {}, deviceInfo = {}", (Object)userId, (Object)JSON.toJSONString((Object)deviceInfo));
    }
}

