/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunasaw.gbproxy.test.user.server;

import com.alibaba.fastjson2.JSON;
import io.github.lunasaw.gbproxy.server.transimit.request.register.RegisterInfo;
import io.github.lunasaw.gbproxy.server.transimit.request.register.RegisterProcessorServer;
import io.github.lunasaw.gbproxy.test.config.DeviceConfig;
import io.github.lunasaw.sip.common.entity.Device;
import io.github.lunasaw.sip.common.entity.SipTransaction;
import io.github.lunasaw.sip.common.entity.ToDevice;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultRegisterProcessorServer
implements RegisterProcessorServer {
    private static final Logger log = LoggerFactory.getLogger(DefaultRegisterProcessorServer.class);
    public static Map<String, SipTransaction> sipTransactionMap = new ConcurrentHashMap<String, SipTransaction>();
    public static Map<String, Device> deviceMap = new ConcurrentHashMap<String, Device>();
    @Autowired
    @Qualifier(value="serverFrom")
    private Device fromDevice;

    public void responseUnauthorized(String userId) {
        log.info("responseUnauthorized::userId = {}", (Object)userId);
    }

    public SipTransaction getTransaction(String userId) {
        return sipTransactionMap.get(userId);
    }

    public void updateRegisterInfo(String userId, RegisterInfo registerInfo) {
        ToDevice instance = ToDevice.getInstance((String)userId, (String)registerInfo.getRemoteIp(), (int)registerInfo.getRemotePort());
        instance.setTransport(registerInfo.getTransport());
        instance.setLocalIp(registerInfo.getLocalIp());
        DeviceConfig.DEVICE_SERVER_VIEW_MAP.put(userId, (Device)instance);
        log.info("\u8bbe\u5907\u6ce8\u518c\u66f4\u65b0::userId = {}, registerInfo = {}", (Object)userId, (Object)JSON.toJSONString((Object)registerInfo));
    }

    public void updateSipTransaction(String userId, SipTransaction sipTransaction) {
        log.info("\u8bbe\u5907\u6ce8\u518c::userId = {}, sipTransaction = {}", (Object)userId, (Object)sipTransaction);
        sipTransactionMap.put(userId, sipTransaction);
    }

    public void deviceOffLine(String userId, RegisterInfo registerInfo, SipTransaction sipTransaction) {
        log.info("\u8bbe\u5907\u6ce8\u9500::userId = {}, sipTransaction = {}", (Object)userId, (Object)sipTransaction);
        DeviceConfig.DEVICE_SERVER_VIEW_MAP.remove(userId);
        sipTransactionMap.remove(userId);
    }
}

