/*
 * Decompiled with CFR 0.152.
 */
package com.robot.transform;

import com.robot.transform.TranslatorAspect;
import com.robot.transform.annotation.Transform;
import com.robot.transform.annotation.TransformDict;
import com.robot.transform.util.LambdaUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@ComponentScan(value={"com.**.transformer"})
@Import(value={TranslatorAspect.class})
public class TransformAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent> {
    public void onApplicationEvent(ContextRefreshedEvent event) {
        String dictTransformerBeanName;
        ApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext.containsBean(dictTransformerBeanName = "dictTransformer")) {
            Transform annotation = TransformDict.class.getAnnotation(Transform.class);
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
            Field field = LambdaUtil.sure(() -> invocationHandler.getClass().getDeclaredField("memberValues"));
            field.setAccessible(true);
            Map memberValues = (Map)LambdaUtil.sure(() -> field.get(invocationHandler));
            memberValues.put("transformer", applicationContext.getBean(dictTransformerBeanName).getClass());
            field.setAccessible(false);
        }
    }
}

